/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports;

import com.lowagie.text.DocumentException;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.ReportWriter;

public class XlsReportWriter
implements ReportWriter {
    private Workbook iWorkbook;
    private OutputStream iOutput;
    private Sheet iSheet;
    private int iPageNo = -1;
    private int iLineNo = 0;
    private int iNrColumns = 0;
    private int iMaxColumns = 0;
    private boolean iHeaderPrinted = false;
    private boolean iEmpty = true;
    private String iFooter = null;
    private String iPageName = null;
    private Map<String, CellStyle> iStyles = new HashMap<String, CellStyle>();
    private Map<String, Font> iFonts = new HashMap<String, Font>();
    private Map<String, Short> iColors = new HashMap<String, Short>();
    private AbstractReport.Line[] iHeaderLine = null;

    public XlsReportWriter(OutputStream out, String title, String title2, String subject, String session) throws DocumentException, IOException {
        if (out != null) {
            this.open(out);
        }
    }

    @Override
    public void setFooter(String footer) {
        this.iFooter = footer;
        if (this.iWorkbook != null) {
            try {
                this.iWorkbook.setSheetName(this.iPageNo, footer.replaceAll("/", "-").replaceAll(":", ""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setHeader(AbstractReport.Line ... line) {
        if (this.iHeaderPrinted) {
            try {
                this.printSeparator(null);
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
        this.iHeaderLine = line;
        this.iNrColumns = 0;
        if (line != null) {
            for (AbstractReport.Line l : line) {
                int cols;
                if (l.isEmpty() || (cols = this.countColumns(l)) <= this.iNrColumns) continue;
                this.iNrColumns = cols;
            }
        }
        if (this.iMaxColumns < this.iNrColumns) {
            this.iMaxColumns = this.iNrColumns;
        }
        this.iHeaderPrinted = false;
    }

    @Override
    public AbstractReport.Line[] getHeader() {
        return this.iHeaderLine;
    }

    @Override
    public void printLine(AbstractReport.Line line) throws DocumentException {
        this.render(line, this.iSheet.createRow(this.iLineNo++), false, 0);
        this.iEmpty = false;
    }

    @Override
    public void close() throws IOException, DocumentException {
        this.lastPage();
        this.iWorkbook.write(this.iOutput);
        this.iWorkbook.close();
    }

    @Override
    public void open(OutputStream out) throws DocumentException, IOException {
        this.iOutput = out;
        this.iWorkbook = new HSSFWorkbook();
        this.createSheet();
    }

    protected void createSheet() {
        this.iSheet = this.iWorkbook.createSheet();
        this.iSheet.setPrintGridlines(false);
        this.iSheet.setFitToPage(true);
        this.iSheet.setHorizontallyCenter(true);
        PrintSetup printSetup = this.iSheet.getPrintSetup();
        printSetup.setLandscape(true);
        this.iSheet.setAutobreaks(true);
        printSetup.setFitHeight((short)1);
        printSetup.setFitWidth((short)1);
        ++this.iPageNo;
        this.iLineNo = 0;
        this.iMaxColumns = 0;
        this.iEmpty = true;
        this.iFooter = null;
        this.iPageName = null;
        if (this.iHeaderLine != null && this.iHeaderLine.length > 0) {
            try {
                this.printHeader(false);
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
            this.iMaxColumns = this.iNrColumns;
        }
    }

    protected Font getFont(boolean bold, boolean italic, boolean underline, Color c) {
        String fontId;
        Font font;
        String colorId;
        Short color = null;
        if (c == null) {
            c = Color.BLACK;
        }
        if (c != null && (color = this.iColors.get(colorId = Integer.toHexString(c.getRGB()))) == null) {
            HSSFPalette palette = ((HSSFWorkbook)this.iWorkbook).getCustomPalette();
            HSSFColor clr = palette.findSimilarColor(c.getRed(), c.getGreen(), c.getBlue());
            color = clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndex();
            this.iColors.put(colorId, color);
        }
        if ((font = this.iFonts.get(fontId = (bold ? "b" : "") + (italic ? "i" : "") + (underline ? "u" : "") + String.valueOf(color == null ? "" : color))) == null) {
            font = this.iWorkbook.createFont();
            font.setBold(bold);
            font.setItalic(italic);
            font.setUnderline(underline ? (byte)1 : 0);
            font.setColor(color.shortValue());
            font.setFontHeightInPoints((short)10);
            font.setFontName("Arial");
            this.iFonts.put(fontId, font);
        }
        return font;
    }

    protected CellStyle getStyle(boolean header, AbstractReport.Alignment a) {
        String styleId = (header ? "H" : "") + a.name().charAt(0);
        CellStyle style = this.iStyles.get(styleId);
        if (style == null) {
            style = this.iWorkbook.createCellStyle();
            style.setAlignment(a == AbstractReport.Alignment.Left ? HorizontalAlignment.LEFT : (a == AbstractReport.Alignment.Right ? HorizontalAlignment.RIGHT : HorizontalAlignment.CENTER));
            style.setVerticalAlignment(VerticalAlignment.TOP);
            style.setFont(this.getFont(header, false, false, Color.BLACK));
            style.setWrapText(true);
            if (header) {
                style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            this.iStyles.put(styleId, style);
        }
        return style;
    }

    protected CellStyle cloneStyle(CellStyle style, String name) {
        CellStyle clone = this.iStyles.get(name);
        if (clone != null) {
            return clone;
        }
        clone = this.iWorkbook.createCellStyle();
        clone.setFont(this.iWorkbook.getFontAt(style.getFontIndex()));
        clone.setVerticalAlignment(VerticalAlignment.TOP);
        clone.setAlignment(style.getAlignment());
        clone.setBorderBottom(style.getBorderBottom());
        clone.setBorderTop(style.getBorderTop());
        clone.setBorderLeft(style.getBorderLeft());
        clone.setBorderRight(style.getBorderRight());
        clone.setBottomBorderColor(style.getBottomBorderColor());
        clone.setTopBorderColor(style.getTopBorderColor());
        clone.setLeftBorderColor(style.getLeftBorderColor());
        clone.setRightBorderColor(style.getRightBorderColor());
        clone.setWrapText(true);
        clone.setFillForegroundColor(style.getFillForegroundColor());
        clone.setFillPattern(style.getFillPattern());
        this.iStyles.put(name, clone);
        return clone;
    }

    protected String getStyleName(CellStyle style) {
        for (Map.Entry<String, CellStyle> e : this.iStyles.entrySet()) {
            if (e.getValue().getIndex() != style.getIndex()) continue;
            return e.getKey();
        }
        return null;
    }

    protected CellStyle addBottomRow(CellStyle style) {
        if (style.getBorderBottom() == BorderStyle.THIN) {
            return style;
        }
        String name = this.getStyleName(style);
        if (name == null) {
            return style;
        }
        CellStyle clone = this.cloneStyle(style, name + "|B");
        clone.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        clone.setBorderBottom(BorderStyle.THIN);
        return clone;
    }

    protected CellStyle addTopRow(CellStyle style) {
        if (style.getBorderTop() == BorderStyle.THIN) {
            return style;
        }
        String name = this.getStyleName(style);
        if (name == null) {
            return style;
        }
        CellStyle clone = this.cloneStyle(style, name + "|T");
        clone.setTopBorderColor(IndexedColors.BLACK.getIndex());
        clone.setBorderTop(BorderStyle.THIN);
        return clone;
    }

    protected CellStyle addLeftRow(CellStyle style) {
        if (style.getBorderLeft() == BorderStyle.THIN) {
            return style;
        }
        String name = this.getStyleName(style);
        if (name == null) {
            return style;
        }
        CellStyle clone = this.cloneStyle(style, name + "|L");
        clone.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        clone.setBorderLeft(BorderStyle.THIN);
        return clone;
    }

    protected CellStyle addRightRow(CellStyle style) {
        if (style.getBorderRight() == BorderStyle.THIN) {
            return style;
        }
        String name = this.getStyleName(style);
        if (name == null) {
            return style;
        }
        CellStyle clone = this.cloneStyle(style, name + "|R");
        clone.setRightBorderColor(IndexedColors.BLACK.getIndex());
        clone.setBorderRight(BorderStyle.THIN);
        return clone;
    }

    @Override
    public void setPageName(String pageName) {
        this.iPageName = pageName;
    }

    @Override
    public void setCont(String cont) {
    }

    @Override
    public void printHeader(boolean newPage) throws DocumentException {
        if (!this.iEmpty && newPage) {
            this.newPage();
        }
        if (this.iHeaderLine != null) {
            this.iHeaderPrinted = true;
            boolean first = true;
            for (AbstractReport.Line line : this.iHeaderLine) {
                if (line.isEmpty()) continue;
                Row row = this.iSheet.createRow(this.iLineNo++);
                this.render(line, row, true, 0);
                this.iEmpty = false;
                if (!first) continue;
                for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
                    row.getCell(c).setCellStyle(this.addTopRow(row.getCell(c).getCellStyle()));
                }
                first = false;
            }
            this.printSeparator(null);
        }
    }

    @Override
    public void newPage() throws DocumentException {
        this.lastPage();
        this.createSheet();
    }

    @Override
    public void lastPage() throws DocumentException {
        for (int col = 0; col < this.iMaxColumns; col = (int)((short)(col + 1))) {
            if (this.iSheet.getColumnWidth(col) != 256 * this.iSheet.getDefaultColumnWidth()) continue;
            this.iSheet.autoSizeColumn(col);
        }
        if (this.iPageName != null && this.iFooter == null) {
            try {
                this.iWorkbook.setSheetName(this.iPageNo, this.iPageName.replaceAll("/", "-").replaceAll(":", ""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.printSeparator(null);
    }

    @Override
    public int getLineNumber() {
        return this.iLineNo;
    }

    @Override
    public int getNrLinesPerPage() {
        return 0;
    }

    @Override
    public int getNrCharsPerLine() {
        return 1000;
    }

    @Override
    public void printSeparator(AbstractReport.Line line) throws DocumentException {
        Row row;
        if (this.iLineNo > 0 && (row = this.iSheet.getRow(this.iLineNo - 1)) != null) {
            for (int c = 0; c < this.iNrColumns; ++c) {
                Cell cell = row.getCell(c);
                if (cell != null) {
                    if (cell.getCellStyle() != null) {
                        cell.setCellStyle(this.addBottomRow(cell.getCellStyle()));
                        continue;
                    }
                    cell.setCellStyle(this.addBottomRow(this.getStyle(false, AbstractReport.Alignment.Left)));
                    continue;
                }
                cell = row.createCell(c);
                cell.setCellStyle(this.addBottomRow(this.getStyle(false, AbstractReport.Alignment.Left)));
            }
        }
    }

    @Override
    public int getSeparatorNrLines() {
        return 0;
    }

    private String render(AbstractReport.Cell cell) {
        StringBuffer ret = new StringBuffer();
        if (cell.getText() != null) {
            if (cell.getPadding() != ' ' && cell.getText().length() < cell.getLength()) {
                ret.append(cell.render());
            } else {
                ret.append(cell.getText());
            }
        }
        if (cell.getCells() != null) {
            if (cell.getText() != null) {
                if (cell.getCellSeparator().isEmpty()) {
                    ret.append(" ");
                } else {
                    ret.append(cell.getCellSeparator());
                }
            }
            for (int i = 0; i < cell.getCells().length; ++i) {
                if (i > 0) {
                    if (cell.getCells()[i - 1].getCellSeparator().isEmpty()) {
                        ret.append(" ");
                    } else {
                        ret.append(cell.getCells()[i - 1].getCellSeparator());
                    }
                }
                ret.append(this.render(cell.getCells()[i]));
            }
        }
        return ret.toString();
    }

    private int render(AbstractReport.Line line, Row row, boolean header, int col) {
        if (line == null) {
            return col;
        }
        if (line.getLines() != null) {
            for (int i = 0; i < line.getLines().length; ++i) {
                col = this.render(line.getLines()[i], row, header, col);
            }
        }
        if (line.getCells() != null) {
            String leftOver = null;
            for (AbstractReport.Cell cell : line.getCells()) {
                if (cell.getColSpan() == 0) {
                    leftOver = ((String)(leftOver == null || leftOver.isEmpty() ? "" : leftOver + " ") + this.render(cell)).trim();
                    continue;
                }
                Cell c = row.createCell(col);
                CellStyle style = this.getStyle(header, cell.getAlignment());
                c.setCellStyle(style);
                c.setCellValue((String)(leftOver == null || leftOver.isEmpty() ? "" : leftOver + " ") + this.render(cell));
                Cell last = c;
                if (cell.getColSpan() > 1) {
                    for (int x = 1; x < cell.getColSpan(); ++x) {
                        Cell d = row.createCell(col + x);
                        d.setCellStyle(style);
                        last = d;
                    }
                    this.iSheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), col, col + cell.getColSpan() - 1));
                }
                if (cell.getCellSeparator().trim().equals("|")) {
                    last.setCellStyle(this.addRightRow(style));
                }
                col += cell.getColSpan();
                leftOver = null;
            }
            if (row.getLastCellNum() < 0 && this.iNrColumns > 0) {
                for (int i = 0; i < this.iNrColumns; ++i) {
                    Cell c = row.createCell(i);
                    c.setCellStyle(this.getStyle(header, AbstractReport.Alignment.Left));
                }
                this.iSheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, this.iNrColumns - 1));
            }
            if (this.iHeaderPrinted) {
                row.getCell((int)row.getFirstCellNum()).setCellStyle(this.addLeftRow(row.getCell(0).getCellStyle()));
                row.getCell(row.getLastCellNum() - 1).setCellStyle(this.addRightRow(row.getCell(row.getLastCellNum() - 1).getCellStyle()));
            }
        }
        return col;
    }

    private int countColumns(AbstractReport.Line line) {
        if (line == null) {
            return 0;
        }
        int cols = 0;
        if (line.getLines() != null) {
            for (AbstractReport.Line l : line.getLines()) {
                cols += this.countColumns(l);
            }
        }
        if (line.getCells() != null) {
            for (AbstractReport.Cell cell : line.getCells()) {
                cols += cell.getColSpan();
            }
        }
        return cols;
    }

    @Override
    public void setListener(ReportWriter.Listener listener) {
    }

    @Override
    public boolean isSkipRepeating() {
        return true;
    }
}

