/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.specreg;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class SpecialRegistrationRetrieveGradeModes
implements OnlineSectioningAction<SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private SpecialRegistrationInterface.RetrieveAvailableGradeModesRequest iRequest;

    public SpecialRegistrationRetrieveGradeModes withRequest(SpecialRegistrationInterface.RetrieveAvailableGradeModesRequest request) {
        this.iRequest = request;
        return this;
    }

    public SpecialRegistrationInterface.RetrieveAvailableGradeModesRequest getRequest() {
        return this.iRequest;
    }

    public Long getStudentId() {
        return this.iRequest.getStudentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse response;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            XStudent student = server.getStudent(this.getStudentId());
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse retrieveAvailableGradeModesResponse = response = CustomSpecialRegistrationHolder.getProvider().retrieveAvailableGradeModes(server, helper, student);
            return retrieveAvailableGradeModesResponse;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "get-grade-modes";
    }
}

