/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Roles;

@MappedSuperclass
public abstract class BaseDepartmentalInstructor
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iExternalUniqueId;
    private String iCareerAcct;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iAcademicTitle;
    private String iNote;
    private String iEmail;
    private Boolean iIgnoreToFar;
    private Float iMaxLoad;
    private String iUnavailableDays;
    private Integer iUnavailableOffset;
    private PositionType iPositionType;
    private Department iDepartment;
    private Roles iRole;
    private PreferenceLevel iTeachingPreference;
    private Set<ClassInstructor> iClasses;
    private Set<Exam> iExams;
    private Set<Assignment> iAssignments;
    private Set<OfferingCoordinator> iOfferingCoordinators;
    private Set<InstructorAttribute> iAttributes;

    public BaseDepartmentalInstructor() {
    }

    public BaseDepartmentalInstructor(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="career_acct", nullable=true, length=20)
    public String getCareerAcct() {
        return this.iCareerAcct;
    }

    public void setCareerAcct(String careerAcct) {
        this.iCareerAcct = careerAcct;
    }

    @Column(name="fname", nullable=true, length=100)
    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    @Column(name="mname", nullable=true, length=100)
    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    @Column(name="lname", nullable=false, length=100)
    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    @Column(name="acad_title", nullable=true, length=50)
    public String getAcademicTitle() {
        return this.iAcademicTitle;
    }

    public void setAcademicTitle(String academicTitle) {
        this.iAcademicTitle = academicTitle;
    }

    @Column(name="note", nullable=true, length=2048)
    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    @Column(name="email", nullable=true, length=200)
    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    @Column(name="ignore_too_far", nullable=false)
    public Boolean isIgnoreToFar() {
        return this.iIgnoreToFar;
    }

    @Transient
    public Boolean getIgnoreToFar() {
        return this.iIgnoreToFar;
    }

    public void setIgnoreToFar(Boolean ignoreToFar) {
        this.iIgnoreToFar = ignoreToFar;
    }

    @Column(name="max_load", nullable=true)
    public Float getMaxLoad() {
        return this.iMaxLoad;
    }

    public void setMaxLoad(Float maxLoad) {
        this.iMaxLoad = maxLoad;
    }

    @Column(name="unavailable_days", nullable=true, length=366)
    public String getUnavailableDays() {
        return this.iUnavailableDays;
    }

    public void setUnavailableDays(String unavailableDays) {
        this.iUnavailableDays = unavailableDays;
    }

    @Column(name="unavailable_offset", nullable=true)
    public Integer getUnavailableOffset() {
        return this.iUnavailableOffset;
    }

    public void setUnavailableOffset(Integer unavailableOffset) {
        this.iUnavailableOffset = unavailableOffset;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="pos_code_type", nullable=true)
    public PositionType getPositionType() {
        return this.iPositionType;
    }

    public void setPositionType(PositionType positionType) {
        this.iPositionType = positionType;
    }

    @Override
    @ManyToOne(optional=false)
    @JoinColumn(name="department_uniqueid", nullable=false)
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="role_id", nullable=true)
    public Roles getRole() {
        return this.iRole;
    }

    public void setRole(Roles role) {
        this.iRole = role;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="teaching_pref_id", nullable=true)
    public PreferenceLevel getTeachingPreference() {
        return this.iTeachingPreference;
    }

    public void setTeachingPreference(PreferenceLevel teachingPreference) {
        this.iTeachingPreference = teachingPreference;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="instructor", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ClassInstructor> getClasses() {
        return this.iClasses;
    }

    public void setClasses(Set<ClassInstructor> classes) {
        this.iClasses = classes;
    }

    public void addToClasses(ClassInstructor classInstructor) {
        if (this.iClasses == null) {
            this.iClasses = new HashSet<ClassInstructor>();
        }
        this.iClasses.add(classInstructor);
    }

    @Deprecated
    public void addToclasses(ClassInstructor classInstructor) {
        this.addToClasses(classInstructor);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="exam_instructor", joinColumns={@JoinColumn(name="instructor_id")}, inverseJoinColumns={@JoinColumn(name="exam_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Exam> getExams() {
        return this.iExams;
    }

    public void setExams(Set<Exam> exams) {
        this.iExams = exams;
    }

    public void addToExams(Exam exam) {
        if (this.iExams == null) {
            this.iExams = new HashSet<Exam>();
        }
        this.iExams.add(exam);
    }

    @Deprecated
    public void addToexams(Exam exam) {
        this.addToExams(exam);
    }

    @ManyToMany(mappedBy="instructors")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Assignment> getAssignments() {
        return this.iAssignments;
    }

    public void setAssignments(Set<Assignment> assignments) {
        this.iAssignments = assignments;
    }

    public void addToAssignments(Assignment assignment) {
        if (this.iAssignments == null) {
            this.iAssignments = new HashSet<Assignment>();
        }
        this.iAssignments.add(assignment);
    }

    @Deprecated
    public void addToassignments(Assignment assignment) {
        this.addToAssignments(assignment);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="instructor")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<OfferingCoordinator> getOfferingCoordinators() {
        return this.iOfferingCoordinators;
    }

    public void setOfferingCoordinators(Set<OfferingCoordinator> offeringCoordinators) {
        this.iOfferingCoordinators = offeringCoordinators;
    }

    public void addToOfferingCoordinators(OfferingCoordinator offeringCoordinator) {
        if (this.iOfferingCoordinators == null) {
            this.iOfferingCoordinators = new HashSet<OfferingCoordinator>();
        }
        this.iOfferingCoordinators.add(offeringCoordinator);
    }

    @Deprecated
    public void addToofferingCoordinators(OfferingCoordinator offeringCoordinator) {
        this.addToOfferingCoordinators(offeringCoordinator);
    }

    @ManyToMany
    @JoinTable(name="instructor_attributes", joinColumns={@JoinColumn(name="instructor_id")}, inverseJoinColumns={@JoinColumn(name="attribute_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<InstructorAttribute> getAttributes() {
        return this.iAttributes;
    }

    public void setAttributes(Set<InstructorAttribute> attributes) {
        this.iAttributes = attributes;
    }

    public void addToAttributes(InstructorAttribute instructorAttribute) {
        if (this.iAttributes == null) {
            this.iAttributes = new HashSet<InstructorAttribute>();
        }
        this.iAttributes.add(instructorAttribute);
    }

    @Deprecated
    public void addToattributes(InstructorAttribute instructorAttribute) {
        this.addToAttributes(instructorAttribute);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DepartmentalInstructor)) {
            return false;
        }
        if (this.getUniqueId() == null || ((DepartmentalInstructor)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((DepartmentalInstructor)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "DepartmentalInstructor[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "DepartmentalInstructor[\n\tAcademicTitle: " + this.getAcademicTitle() + "\n\tCareerAcct: " + this.getCareerAcct() + "\n\tDepartment: " + String.valueOf(this.getDepartment()) + "\n\tEmail: " + this.getEmail() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFirstName: " + this.getFirstName() + "\n\tIgnoreToFar: " + this.getIgnoreToFar() + "\n\tLastName: " + this.getLastName() + "\n\tMaxLoad: " + this.getMaxLoad() + "\n\tMiddleName: " + this.getMiddleName() + "\n\tNote: " + this.getNote() + "\n\tPositionType: " + String.valueOf(this.getPositionType()) + "\n\tRole: " + String.valueOf(this.getRole()) + "\n\tTeachingPreference: " + String.valueOf(this.getTeachingPreference()) + "\n\tUnavailableDays: " + this.getUnavailableDays() + "\n\tUnavailableOffset: " + this.getUnavailableOffset() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

