/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver.suggestions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.solver.suggestions.AssignmentTable;
import org.unitime.timetable.gwt.client.solver.suggestions.SuggestionsPageContext;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;

public class SelectedSuggestion
extends SimpleForm
implements TakesValue<SuggestionsInterface.Suggestion> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private SuggestionsPageContext iContext;
    private SuggestionsInterface.Suggestion iSuggestion;
    private UniTimeHeaderPanel iFooter = null;

    public SelectedSuggestion(SuggestionsPageContext context) {
        this.iContext = context;
        this.removeStyleName("unitime-NotPrintableBottomLine");
        this.iFooter = new UniTimeHeaderPanel();
        this.iFooter.addButton("assign", MESSAGES.buttonAssign(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SelectedSuggestion.this.iContext.assign(SelectedSuggestion.this.iSuggestion.getAssignment(true), SelectedSuggestion.this.iFooter);
            }
        });
    }

    public UniTimeHeaderPanel getFooter() {
        return this.iFooter;
    }

    public void setValue(SuggestionsInterface.Suggestion suggestion) {
        AssignmentTable at;
        this.iSuggestion = suggestion;
        this.clear();
        if (suggestion == null || !suggestion.hasDifferentAssignments()) {
            return;
        }
        if (suggestion.hasDifferentAssignments()) {
            at = new AssignmentTable(this.iContext.getProperties(), false, true){

                @Override
                protected void onRemove(SuggestionsInterface.ClassAssignmentDetails details) {
                    SelectedSuggestion.this.iContext.remove(details.getClazz());
                }
            };
            for (SuggestionsInterface.ClassAssignmentDetails d : suggestion.getDifferentAssignments()) {
                at.addRow(d);
                if (!d.hasConflict()) continue;
                at.setColumnVisible(at.getCellIndex(AssignmentTable.AssignmentColumn.CONSTRAINT), true);
            }
            this.addHeaderRow(MESSAGES.headerSelectedAssignment());
            this.addRow((Widget)at);
            at.addMouseClickListener(new UniTimeTable.MouseClickListener<SuggestionsInterface.ClassAssignmentDetails>(){

                @Override
                public void onMouseClick(UniTimeTable.TableEvent<SuggestionsInterface.ClassAssignmentDetails> event) {
                    if (event.getData() != null) {
                        SelectedSuggestion.this.iContext.select(event.getData().getClazz());
                    }
                }
            });
        }
        if (suggestion.hasUnresolvedConflicts()) {
            at = new AssignmentTable(this.iContext.getProperties(), true, false);
            for (SuggestionsInterface.ClassAssignmentDetails d : suggestion.getUnresolvedConflicts()) {
                at.addRow(d);
                if (!d.hasConflict()) continue;
                at.setColumnVisible(at.getCellIndex(AssignmentTable.AssignmentColumn.CONSTRAINT), true);
            }
            this.addHeaderRow(MESSAGES.headerConflictingAssignments());
            this.addRow((Widget)at);
            at.addMouseClickListener(new UniTimeTable.MouseClickListener<SuggestionsInterface.ClassAssignmentDetails>(){

                @Override
                public void onMouseClick(UniTimeTable.TableEvent<SuggestionsInterface.ClassAssignmentDetails> event) {
                    if (event.getData() != null) {
                        SelectedSuggestion.this.iContext.select(event.getData().getClazz());
                    }
                }
            });
        }
        if (suggestion.getUnassignedVariables() != suggestion.getBaseUnassignedVariables()) {
            this.addRow(MESSAGES.propNotAssignedClasses(), (Widget)new HTML(SuggestionsPageContext.dispNumber(suggestion.getUnassignedVariables(), suggestion.getBaseUnassignedVariables()), false));
        }
        for (String criterion : new TreeSet<String>(suggestion.getCriteria().keySet())) {
            double base;
            double value = suggestion.getCriterion(criterion);
            if (value == (base = suggestion.getBaseCriterion(criterion))) continue;
            this.addRow(criterion + ":", (Widget)new HTML(SuggestionsPageContext.dispNumber(value, base), false));
        }
        this.addRow(MESSAGES.propOverallSolutionValue(), (Widget)new HTML(SuggestionsPageContext.dispNumber(suggestion.getValue(), suggestion.getBaseValue()), false));
        if (suggestion.hasStudentConflicts()) {
            this.addRow(MESSAGES.propStudentConflicts(), (Widget)this.iContext.createStudentConflicts(suggestion.getStudentConflicts()));
        }
        if (suggestion.hasViolatedDistributionConflicts() || suggestion.hasBtbInstructorConflicts()) {
            this.addRow(MESSAGES.propViolatedConstraints(), (Widget)this.iContext.createViolatedConstraints(suggestion.getDistributionConflicts(), suggestion.getBtbInstructorConflicts()));
        }
        this.iFooter.setEnabled("assign", this.iSuggestion.isCanAssign());
        this.iFooter.clearMessage();
        this.addBottomRow((Widget)this.iFooter);
    }

    public SuggestionsInterface.Suggestion getValue() {
        return this.iSuggestion;
    }
}

