/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;

public class ManagerSettingsForm
implements UniTimeForm {
    private static final long serialVersionUID = -5955499033542263250L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String op;
    private String key;
    private String name;
    private String value;
    private String defaultValue;
    private List<String> allowedValues;
    private Map<String, String> labels;

    @Override
    public void validate(UniTimeAction action) {
        if (this.value == null || this.value.isEmpty()) {
            action.addFieldError("form.value", MSG.errorRequiredField(MSG.columnManagerSettingValue()));
        }
    }

    @Override
    public void reset() {
        this.op = null;
        this.key = "";
        this.name = "";
        this.value = "";
        this.defaultValue = "";
        this.allowedValues = null;
        this.labels = null;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List<String> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public void setAllowedValues(String allowedValues) {
        this.allowedValues = new ArrayList<String>();
        this.labels = new HashMap<String, String>();
        StringTokenizer strTok = new StringTokenizer(allowedValues, ",");
        while (strTok.hasMoreTokens()) {
            String value = strTok.nextToken().trim();
            if (value.indexOf(58) >= 0) {
                this.labels.put(value.substring(0, value.indexOf(58)), value.substring(value.indexOf(58) + 1));
                value = value.substring(0, value.indexOf(58));
            }
            this.allowedValues.add(value);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getLabel(String value) {
        if (this.labels == null) {
            return value;
        }
        String label = this.labels.get(value);
        if (label != null && !label.isEmpty()) {
            return label;
        }
        return value;
    }
}

