/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseDepartmentRoomFeature;
import org.unitime.timetable.model.base.BaseDistributionObject;
import org.unitime.timetable.util.Constants;

public class PreferencesImport
extends BaseImport {
    protected Session iSession;
    protected SimpleDateFormat iDateFormat;
    protected SimpleDateFormat iTimeFormat;
    protected DateFormat iHHmm = new SimpleDateFormat("HHmm", Locale.US);
    private List<Department> iDepartments = null;
    private List<DepartmentalInstructor> iInstructors = null;
    private Map<String, DatePattern> iDatePatterns = null;
    private List<SchedulingSubpart> iSubparts = null;
    private List<Class_> iClasses = null;
    private Map<String, TimePattern> iTimePatterns = null;
    private Map<String, Building> iBuildings = null;
    private Map<String, Room> iRooms = null;
    private Map<String, Location> iLocations = null;
    private Map<String, RoomGroup> iRoomGroups = null;
    private Map<String, RoomFeature> iRoomFeatures = null;
    private Map<String, DistributionType> iDistributionTypes = null;
    private Map<String, CourseOffering> iCourseOfferings = null;
    private Map<String, InstructorAttribute> iInstructorAttributes = null;
    private Map<String, ExamPeriod> iExamPeriods = null;

    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("preferences")) {
            throw new Exception("Given XML file is not reservations load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            String created = root.attributeValue("created");
            this.iDateFormat = new SimpleDateFormat(root.attributeValue("dateFormat", "yyyy/M/d"), Locale.US);
            String timeFormat = root.attributeValue("timeFormat", "HHmm");
            if (!"HHmm".equals(timeFormat)) {
                this.iTimeFormat = new SimpleDateFormat(timeFormat, Locale.US);
            }
            this.iSession = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (this.iSession == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            if (created != null) {
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.iSession, this.iSession, created, ChangeLog.Source.DATA_IMPORT_PREFERENCES, ChangeLog.Operation.UPDATE, null, null);
            }
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                PreferenceGroup group = this.lookupPrefGroup(element);
                if (group == null) continue;
                group.getPreferences().clear();
                Iterator j = element.elementIterator();
                while (j.hasNext()) {
                    Element prefElement = (Element)j.next();
                    Preference preference = this.createPreference(prefElement, group);
                    if (preference == null) continue;
                    if (preference instanceof DistributionPref) {
                        DistributionPref dp = (DistributionPref)preference;
                        if (group instanceof Class_) {
                            for (DistributionObject o : dp.getDistributionObjects()) {
                                o.setSequenceNumber(o.getSequenceNumber() + 1);
                            }
                            obj = new DistributionObject();
                            ((BaseDistributionObject)obj).setDistributionPref(dp);
                            ((BaseDistributionObject)obj).setPrefGroup(group);
                            ((BaseDistributionObject)obj).setSequenceNumber(1);
                            dp.getDistributionObjects().add((DistributionObject)obj);
                            group = ((Class_)group).getManagingDept();
                        } else if (group instanceof SchedulingSubpart) {
                            for (DistributionObject o : dp.getDistributionObjects()) {
                                o.setSequenceNumber(o.getSequenceNumber() + 1);
                            }
                            obj = new DistributionObject();
                            ((BaseDistributionObject)obj).setDistributionPref(dp);
                            ((BaseDistributionObject)obj).setPrefGroup(group);
                            ((BaseDistributionObject)obj).setSequenceNumber(1);
                            dp.getDistributionObjects().add((DistributionObject)obj);
                            group = ((SchedulingSubpart)group).getManagingDept();
                        }
                    }
                    preference.setOwner(group);
                    group.getPreferences().add(preference);
                }
                this.getHibSession().merge((Object)group);
            }
            this.info("All done.");
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    protected Department lookupDepartment(Element element) {
        if (this.iDepartments == null) {
            this.iDepartments = this.getHibSession().createQuery("select distinct d from Department d left join fetch d.preferences p where d.session.uniqueId = :sessionId", Department.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list();
        }
        String deptCode = element.attributeValue("code", "not-set");
        for (Department department : this.iDepartments) {
            if (!deptCode.equals(department.getDeptCode())) continue;
            return department;
        }
        this.warn("Department " + deptCode + " does not exist.");
        return null;
    }

    protected DepartmentalInstructor lookupInstructor(Element element) {
        if (this.iInstructors == null) {
            this.iInstructors = this.getHibSession().createQuery("select distinct i from DepartmentalInstructor i left join fetch i.preferences p where i.department.session.uniqueId = :sessionId", DepartmentalInstructor.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list();
        }
        String externalId = element.attributeValue("externalId");
        String deptCode = element.attributeValue("department", "not-set");
        if (externalId != null) {
            for (DepartmentalInstructor instructor : this.iInstructors) {
                if (!externalId.equals(instructor.getExternalUniqueId()) || !deptCode.equals(instructor.getDepartment().getDeptCode())) continue;
                return instructor;
            }
            this.warn("Instructor " + externalId + " does not exist (department " + deptCode + ").");
            return null;
        }
        String fname = element.attributeValue("firstName");
        String mname = element.attributeValue("middleName");
        String lname = element.attributeValue("lastName");
        if (lname != null) {
            for (DepartmentalInstructor instructor : this.iInstructors) {
                if (!lname.equals(instructor.getLastName()) || fname != null && !fname.equals(instructor.getFirstName()) || mname != null && !mname.equals(instructor.getMiddleName()) || !deptCode.equals(instructor.getDepartment().getDeptCode())) continue;
                return instructor;
            }
            this.warn("Instructor " + (String)(fname == null ? "" : fname + " ") + (String)(mname == null ? "" : mname + " ") + lname + " does not exist (department " + deptCode + ").");
            return null;
        }
        return null;
    }

    protected DepartmentalInstructor lookupInstructor(String externalId, String deptCode) {
        if (this.iInstructors == null) {
            this.iInstructors = this.getHibSession().createQuery("select distinct i from DepartmentalInstructor i left join fetch i.preferences p where i.department.session.uniqueId = :sessionId", DepartmentalInstructor.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list();
        }
        for (DepartmentalInstructor instructor : this.iInstructors) {
            if (externalId.equals(instructor.getExternalUniqueId()) && deptCode.equals(instructor.getDepartment().getDeptCode())) {
                return instructor;
            }
            if (instructor.getExternalUniqueId() != null || !externalId.equals(instructor.getName("first-middle-last")) || !deptCode.equals(instructor.getDepartment().getDeptCode())) continue;
            return instructor;
        }
        this.warn("Instructor " + externalId + " does not exist (department " + deptCode + ").");
        return null;
    }

    protected DatePattern lookupDatePattern(String name) {
        if (this.iDatePatterns == null) {
            this.iDatePatterns = new HashMap<String, DatePattern>();
            for (DatePattern pattern : this.getHibSession().createQuery("from DatePattern where session.uniqueId = :sessionId", DatePattern.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                this.iDatePatterns.put(pattern.getName(), pattern);
            }
        }
        return this.iDatePatterns.get(name);
    }

    protected SchedulingSubpart lookupSubpart(Element element) {
        if (this.iSubparts == null) {
            this.iSubparts = this.getHibSession().createQuery("select distinct ss from SchedulingSubpart ss left join fetch ss.instrOfferingConfig as ioc left join fetch ioc.instructionalOffering as io left join fetch io.courseOfferings as co left join fetch ss.classes c left join fetch ss.preferences sp left join fetch c.preferences cp where ss.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId and co.isControl = true", SchedulingSubpart.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list();
            this.iClasses = new ArrayList<Class_>();
            for (SchedulingSubpart subpart : this.iSubparts) {
                this.iClasses.addAll(subpart.getClasses());
            }
        }
        String subject = element.attributeValue("subject", "not-set");
        String course = element.attributeValue("course", "not-set");
        String type = element.attributeValue("type", "not-set");
        String config = element.attributeValue("config");
        String suffix = element.attributeValue("suffix");
        for (SchedulingSubpart subpart : this.iSubparts) {
            if (!type.equals(subpart.getItypeDesc().trim()) || suffix == null && !subpart.getSchedulingSubpartSuffix().isEmpty() || suffix != null && !suffix.equals(subpart.getSchedulingSubpartSuffix()) || config != null && !config.equals(subpart.getInstrOfferingConfig().getName())) continue;
            for (CourseOffering co : subpart.getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                if (!subject.equals(co.getSubjectAreaAbbv()) || !course.equals(co.getCourseNbr())) continue;
                return subpart;
            }
        }
        this.warn("Scheduling subpart " + subject + " " + course + " " + type + (String)(suffix == null ? "" : " " + suffix) + (String)(config == null ? " (" + config + ")" : "") + " not found.");
        return null;
    }

    protected Class_ lookupClass(Element element) {
        if (this.iClasses == null) {
            this.iSubparts = this.getHibSession().createQuery("select distinct ss from SchedulingSubpart ss left join fetch ss.instrOfferingConfig as ioc left join fetch ioc.instructionalOffering as io left join fetch io.courseOfferings as co left join fetch ss.classes c left join fetch ss.preferences sp left join fetch c.preferences cp where ss.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId and co.isControl = true", SchedulingSubpart.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list();
            this.iClasses = new ArrayList<Class_>();
            for (SchedulingSubpart subpart : this.iSubparts) {
                this.iClasses.addAll(subpart.getClasses());
            }
        }
        String subject = element.attributeValue("subject");
        String course = element.attributeValue("course");
        String type = element.attributeValue("type");
        String suffix = element.attributeValue("suffix");
        String externalId = element.attributeValue("externalId");
        for (Class_ clazz : this.iClasses) {
            if (type != null && !type.equals(clazz.getSchedulingSubpart().getItypeDesc().trim()) || suffix != null && !suffix.equals(this.getClassSuffix(clazz))) continue;
            for (CourseOffering co : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                if (externalId != null && !externalId.equals(clazz.getExternalId(co)) || subject != null && !subject.equals(co.getSubjectAreaAbbv()) || course != null && !course.equals(co.getCourseNbr())) continue;
                return clazz;
            }
        }
        this.warn("Class " + (String)(subject == null ? "" : subject + " ") + (String)(course == null ? "" : course + " ") + (String)(type == null ? "" : type + " ") + (String)(suffix == null ? "" : suffix + " ") + (String)(externalId == null ? "" : externalId + " ") + " not found.");
        return null;
    }

    protected PreferenceGroup lookupPrefGroup(Element element) {
        if ("class".equals(element.getName())) {
            Class_ clazz = this.lookupClass(element);
            if (clazz == null) {
                return null;
            }
            String pattern = element.attributeValue("pattern");
            clazz.setDatePattern(this.lookupDatePattern(pattern));
            return clazz;
        }
        if ("subpart".equals(element.getName())) {
            SchedulingSubpart subpart = this.lookupSubpart(element);
            if (subpart == null) {
                return null;
            }
            String pattern = element.attributeValue("pattern");
            subpart.setDatePattern(this.lookupDatePattern(pattern));
            return subpart;
        }
        if ("department".equals(element.getName())) {
            return this.lookupDepartment(element);
        }
        if ("instructor".equals(element.getName())) {
            DepartmentalInstructor instructor = this.lookupInstructor(element);
            if (instructor == null) {
                return null;
            }
            Element tp = element.element("teachingPref");
            instructor.setMaxLoad(tp == null ? null : Float.valueOf(Float.parseFloat(tp.attributeValue("maxLoad", "0.0"))));
            instructor.setTeachingPreference(tp == null ? null : PreferenceLevel.getPreferenceLevel(tp.attributeValue("level", PreferenceLevel.sProhibited)));
            return instructor;
        }
        return null;
    }

    protected TimePattern lookupTimePattern(String name) {
        TimePattern tp;
        if (this.iTimePatterns == null) {
            this.iTimePatterns = new HashMap<String, TimePattern>();
            for (TimePattern pattern : this.getHibSession().createQuery("from TimePattern where session.uniqueId = :sessionId", TimePattern.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                this.iTimePatterns.put(pattern.getName(), pattern);
            }
        }
        if ((tp = this.iTimePatterns.get(name)) == null) {
            this.warn("Time pattern " + name + " does not exist.");
        }
        return tp;
    }

    protected Building lookupBuilding(String abbv) {
        Building b;
        if (this.iBuildings == null) {
            this.iBuildings = new HashMap<String, Building>();
            for (Building building : this.getHibSession().createQuery("from Building where session.uniqueId = :sessionId", Building.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                this.iBuildings.put(building.getAbbreviation(), building);
            }
        }
        if ((b = this.iBuildings.get(abbv)) == null) {
            this.warn("Building " + abbv + " does not exist.");
        }
        return b;
    }

    protected Room lookupRoom(String buildingAbbv, String roomNbr) {
        Room r;
        if (this.iRooms == null) {
            this.iRooms = new HashMap<String, Room>();
            for (Room room : this.getHibSession().createQuery("from Room where session.uniqueId = :sessionId", Room.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                this.iRooms.put(room.getBuildingAbbv() + " " + room.getRoomNumber(), room);
            }
        }
        if ((r = this.iRooms.get(buildingAbbv + " " + roomNbr)) == null) {
            this.warn("Room " + buildingAbbv + " " + roomNbr + " does not exist.");
        }
        return r;
    }

    protected Location lookupLocation(String label, String deptCode) {
        Location l;
        if (this.iLocations == null) {
            this.iLocations = new HashMap<String, Location>();
            for (Location location : this.getHibSession().createQuery("from NonUniversityLocation where session.uniqueId = :sessionId", Location.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                for (RoomDept rd : location.getRoomDepts()) {
                    this.iLocations.put(location.getLabel() + "|" + rd.getDepartment().getDeptCode(), location);
                }
            }
        }
        if ((l = this.iLocations.get(label + "|" + deptCode)) == null) {
            this.warn("Location " + label + " (" + deptCode + ") does not exist.");
        }
        return l;
    }

    protected RoomGroup lookupRoomGroup(String name, String deptCode) {
        RoomGroup g;
        if (this.iRoomGroups == null) {
            this.iRoomGroups = new HashMap<String, RoomGroup>();
            for (RoomGroup group : this.getHibSession().createQuery("from RoomGroup where session.uniqueId = :sessionId", RoomGroup.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                if (group.isGlobal().booleanValue()) {
                    this.iRoomGroups.put(group.getAbbv(), group);
                    continue;
                }
                this.iRoomGroups.put(group.getAbbv() + "|" + group.getDepartment().getDeptCode(), group);
            }
        }
        if ((g = this.iRoomGroups.get(name)) == null) {
            g = this.iRoomGroups.get(name + "|" + deptCode);
        }
        if (g == null) {
            this.warn("Room Group " + name + " (" + deptCode + ") does not exist.");
        }
        return g;
    }

    protected RoomFeature lookupRoomFeature(String name, String deptCode) {
        RoomFeature f;
        if (this.iRoomFeatures == null) {
            this.iRoomFeatures = new HashMap<String, RoomFeature>();
            for (RoomFeature feature : this.getHibSession().createQuery("from GlobalRoomFeature where session.uniqueId = :sessionId", GlobalRoomFeature.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                this.iRoomFeatures.put(feature.getAbbv(), feature);
            }
            for (RoomFeature feature : this.getHibSession().createQuery("from DepartmentRoomFeature where department.session.uniqueId = :sessionId", DepartmentRoomFeature.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                this.iRoomFeatures.put(feature.getAbbv() + "|" + ((BaseDepartmentRoomFeature)feature).getDepartment().getDeptCode(), feature);
            }
        }
        if ((f = this.iRoomFeatures.get(name)) == null) {
            f = this.iRoomFeatures.get(name + "|" + deptCode);
        }
        if (f == null) {
            this.warn("Room Feature " + name + " (" + deptCode + ") does not exist.");
        }
        return f;
    }

    protected DistributionType lookupDistributionType(String name) {
        DistributionType type;
        if (this.iDistributionTypes == null) {
            this.iDistributionTypes = new HashMap<String, DistributionType>();
            for (DistributionType type2 : this.getHibSession().createQuery("from DistributionType", DistributionType.class).list()) {
                this.iDistributionTypes.put(type2.getReference(), type2);
            }
        }
        if ((type = this.iDistributionTypes.get(name)) == null) {
            this.warn("Distribution Type " + name + " does not exist.");
        }
        return type;
    }

    protected CourseOffering lookupCourse(String subjectAbbv, String courseNbr) {
        CourseOffering course;
        if (this.iCourseOfferings == null) {
            this.iCourseOfferings = new HashMap<String, CourseOffering>();
            for (CourseOffering course2 : this.getHibSession().createQuery("from CourseOffering co where co.instructionalOffering.session.uniqueId = :sessionId", CourseOffering.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                this.iCourseOfferings.put(course2.getSubjectAreaAbbv() + "|" + course2.getCourseNbr(), course2);
            }
        }
        if ((course = this.iCourseOfferings.get(subjectAbbv + "|" + courseNbr)) == null) {
            this.warn("Course Offering " + subjectAbbv + " " + courseNbr + " does not exist.");
        }
        return course;
    }

    protected InstructorAttribute lookupAttribute(String name, String deptCode) {
        InstructorAttribute attribute;
        if (this.iInstructorAttributes == null) {
            this.iInstructorAttributes = new HashMap<String, InstructorAttribute>();
            for (InstructorAttribute attribute2 : this.getHibSession().createQuery("from InstructorAttribute where session.uniqueId = :sessionId", InstructorAttribute.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                if (attribute2.getDepartment() == null) {
                    this.iInstructorAttributes.put(attribute2.getCode(), attribute2);
                    continue;
                }
                this.iInstructorAttributes.put(attribute2.getCode() + "|" + attribute2.getDepartment().getDeptCode(), attribute2);
            }
        }
        if ((attribute = this.iInstructorAttributes.get(name)) == null) {
            attribute = this.iInstructorAttributes.get(name + "|" + deptCode);
        }
        if (attribute == null) {
            this.warn("Instructor Attribute " + name + " (" + deptCode + ") does not exist.");
        }
        return attribute;
    }

    protected ExamPeriod lookupExamPeriod(String date, String start, String type) {
        ExamPeriod period;
        if (this.iExamPeriods == null) {
            this.iExamPeriods = new HashMap<String, ExamPeriod>();
            for (ExamPeriod period2 : this.getHibSession().createQuery("from ExamPeriod where session.uniqueId = :sessionId", ExamPeriod.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).list()) {
                this.iExamPeriods.put(this.iDateFormat.format(period2.getStartDate()) + "|" + this.iTimeFormat.format(period2.getStartTime()), period2);
                this.iExamPeriods.put(this.iDateFormat.format(period2.getStartDate()) + "|" + this.iTimeFormat.format(period2.getStartTime()) + "|" + period2.getExamType().getReference(), period2);
            }
        }
        if ((period = this.iExamPeriods.get(date + "|" + start + "|" + type)) == null) {
            period = this.iExamPeriods.get(date + "|" + start);
        }
        if (period == null) {
            this.warn("Examination Period " + date + " " + start + " (" + type + ") does not exist.");
        }
        return period;
    }

    protected Integer parseTime(String timeString) throws NumberFormatException, ParseException {
        if (timeString == null || timeString.isEmpty()) {
            return 0;
        }
        int time = Integer.parseInt(this.iTimeFormat == null ? timeString : this.iHHmm.format(this.iTimeFormat.parse(timeString)));
        int hour = time / 100;
        int min = time % 100;
        return (60 * hour + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
    }

    protected Preference createPreference(Element element, PreferenceGroup group) throws NumberFormatException, ParseException {
        Department ctrDept;
        Department mngDept = ctrDept = group.getDepartment();
        mngDept = group instanceof Class_ ? ((Class_)group).getManagingDept() : (group instanceof SchedulingSubpart ? ((SchedulingSubpart)group).getManagingDept() : group.getDepartment());
        if ("datePref".equals(element.getName())) {
            DatePattern pattern = this.lookupDatePattern(element.attributeValue("pattern", "not-set"));
            if (pattern == null) {
                this.warn("Date pattern " + element.attributeValue("pattern", "not-set") + " does not exist.");
                return null;
            }
            DatePatternPref pref = new DatePatternPref();
            pref.setDatePattern(pattern);
            pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
            pref.setNote(this.getNote(element));
            return pref;
        }
        if ("timePref".equals(element.getName())) {
            TimePref pref = new TimePref();
            pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
            String pattern = element.attributeValue("pattern");
            if (pattern != null) {
                TimePattern tp = this.lookupTimePattern(pattern);
                if (tp == null) {
                    return null;
                }
                pref.setTimePattern(tp);
            }
            TimePatternModel model = pref.getTimePatternModel();
            Iterator j = element.elementIterator("pref");
            while (j.hasNext()) {
                Element pe = (Element)j.next();
                int dayCode = DayCode.toInt(DayCode.toDayCodes(pe.attributeValue("days", pe.attributeValue("day", ""))));
                int startSlot = this.parseTime(pe.attributeValue("time", pe.attributeValue("start")));
                String level = pe.attributeValue("level", PreferenceLevel.sNeutral);
                if (model.isExactTime()) {
                    model.setExactDays(dayCode);
                    model.setExactStartSlot(startSlot);
                    break;
                }
                int endSlot = startSlot + model.getSlotsPerMtg();
                if (startSlot == 0) {
                    endSlot = 288;
                }
                if (pe.attributeValue("stop") != null) {
                    endSlot = this.parseTime(pe.attributeValue("stop"));
                }
                if (pe.attributeValue("end") != null) {
                    endSlot = this.parseTime(pe.attributeValue("end"));
                }
                for (int d = 0; d < model.getNrDays(); ++d) {
                    if (model.getDayCode(d) != dayCode && (model.getDayCode(d) & dayCode) != model.getDayCode(d)) continue;
                    for (int t = 0; t < model.getNrTimes(); ++t) {
                        if (model.getStartSlot(t) < startSlot || model.getStartSlot(t) + model.getSlotsPerMtg() > endSlot) continue;
                        model.setPreference(d, t, level);
                    }
                }
            }
            pref.setPreference(model.getPreferences());
            pref.setNote(this.getNote(element));
            return pref;
        }
        if ("buildingPref".equals(element.getName())) {
            Building building = this.lookupBuilding(element.attributeValue("building", "not-set"));
            if (building == null) {
                return null;
            }
            BuildingPref pref = new BuildingPref();
            pref.setBuilding(building);
            pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
            pref.setNote(this.getNote(element));
            return pref;
        }
        if ("roomPref".equals(element.getName())) {
            String buildingAbbv = element.attributeValue("building");
            String roomNbr = element.attributeValue("room");
            String label = element.attributeValue("location");
            if (buildingAbbv != null && roomNbr != null) {
                Room room = this.lookupRoom(buildingAbbv, roomNbr);
                if (room == null) {
                    return null;
                }
                RoomPref pref = new RoomPref();
                pref.setRoom(room);
                pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
                pref.setNote(this.getNote(element));
                return pref;
            }
            if (label != null) {
                Location location = this.lookupLocation(label, element.attributeValue("department", mngDept == null ? null : mngDept.getDeptCode()));
                if (location == null) {
                    return null;
                }
                RoomPref pref = new RoomPref();
                pref.setRoom(location);
                pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
                pref.setNote(this.getNote(element));
                return pref;
            }
            return null;
        }
        if ("groupPref".equals(element.getName())) {
            RoomGroup rg = this.lookupRoomGroup(element.attributeValue("group", "not-set"), element.attributeValue("department", mngDept == null ? null : mngDept.getDeptCode()));
            if (rg == null) {
                return null;
            }
            RoomGroupPref pref = new RoomGroupPref();
            pref.setRoomGroup(rg);
            pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
            pref.setNote(this.getNote(element));
            return pref;
        }
        if ("featurePref".equals(element.getName())) {
            RoomFeature feature = this.lookupRoomFeature(element.attributeValue("feature", "not-set"), element.attributeValue("department", mngDept == null ? null : mngDept.getDeptCode()));
            if (feature == null) {
                return null;
            }
            RoomFeaturePref pref = new RoomFeaturePref();
            pref.setRoomFeature(feature);
            pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
            pref.setNote(this.getNote(element));
            return pref;
        }
        if ("distributionPref".equals(element.getName())) {
            DistributionType type = this.lookupDistributionType(element.attributeValue("type", "not-set"));
            if (type == null) {
                return null;
            }
            DistributionPref pref = new DistributionPref();
            pref.setDistributionType(type);
            pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
            pref.setStructure(DistributionPref.Structure.valueOf(element.attributeValue("structure", DistributionPref.Structure.values()[Integer.parseInt(element.attributeValue("grouping", "0"))].name())));
            pref.setDistributionObjects(new HashSet<DistributionObject>());
            Iterator j = element.elementIterator();
            while (j.hasNext()) {
                Class_ clazz;
                DistributionObject obj;
                Element de = (Element)j.next();
                if ("subpart".equals(de.getName())) {
                    SchedulingSubpart subpart = this.lookupSubpart(de);
                    if (subpart == null) continue;
                    obj = new DistributionObject();
                    obj.setDistributionPref(pref);
                    obj.setPrefGroup(subpart);
                    obj.setSequenceNumber(1 + pref.getDistributionObjects().size());
                    pref.getDistributionObjects().add(obj);
                    continue;
                }
                if (!"class".equals(de.getName()) || (clazz = this.lookupClass(de)) == null) continue;
                obj = new DistributionObject();
                obj.setDistributionPref(pref);
                obj.setPrefGroup(clazz);
                obj.setSequenceNumber(1 + pref.getDistributionObjects().size());
                pref.getDistributionObjects().add(obj);
            }
            pref.setNote(this.getNote(element));
            return pref;
        }
        if ("instructorPref".equals(element.getName())) {
            DepartmentalInstructor instructor = this.lookupInstructor(element.attributeValue("instructor", "not-set"), element.attributeValue("department", ctrDept == null ? null : ctrDept.getDeptCode()));
            if (instructor == null) {
                return null;
            }
            InstructorPref pref = new InstructorPref();
            pref.setInstructor(instructor);
            pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
            pref.setNote(this.getNote(element));
            return pref;
        }
        if ("coursePref".equals(element.getName())) {
            CourseOffering course = this.lookupCourse(element.attributeValue("subject", "not-set"), element.attributeValue("course", "not-set"));
            if (course == null) {
                return null;
            }
            InstructorCoursePref pref = new InstructorCoursePref();
            pref.setCourse(course);
            pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
            pref.setNote(this.getNote(element));
            return pref;
        }
        if ("attributePref".equals(element.getName())) {
            InstructorAttribute attribute = this.lookupAttribute(element.attributeValue("attribute", "not-set"), element.attributeValue("department", ctrDept == null ? null : ctrDept.getDeptCode()));
            if (attribute == null) {
                return null;
            }
            InstructorAttributePref pref = new InstructorAttributePref();
            pref.setAttribute(attribute);
            pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
            pref.setNote(this.getNote(element));
            return pref;
        }
        if ("periodPref".equals(element.getName())) {
            ExamPeriod period = this.lookupExamPeriod(element.attributeValue("date", "not-set"), element.attributeValue("start", "not-set"), element.attributeValue("type", "not-set"));
            if (period == null) {
                return null;
            }
            ExamPeriodPref pref = new ExamPeriodPref();
            pref.setExamPeriod(period);
            pref.setPrefLevel(PreferenceLevel.getPreferenceLevel(element.attributeValue("level", PreferenceLevel.sRequired)));
            pref.setNote(this.getNote(element));
            return pref;
        }
        return null;
    }

    protected String getNote(Element parent) {
        Element noteEl = parent.element("note");
        return noteEl == null ? null : noteEl.getText();
    }
}

