/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.web;

import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.cpsolver.ifs.util.CSVFile;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.commons.ToolBox;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.security.SessionContext;

public class WebTable {
    protected static String IMG_DEC = "images/listdir_top_to_bot.gif";
    protected static String IMG_ASC = "images/listdir_bot_to_top.gif";
    protected int iColumns;
    protected Vector iLines;
    protected String iName;
    protected String[] iHeaders;
    protected String[] iAlign;
    protected boolean[] iAsc;
    protected String iRef;
    protected String iRowStyle = null;
    protected boolean suppressRowHighlight = false;
    private Hashtable iColumnFilter = null;
    private String[] iColumnFilterKeys = null;
    protected boolean iBlankWhenSame = false;
    protected WebTableTweakStyle iWebTableTweakStyle = null;
    protected WebTableCellStyle iWebTableCellStyle = null;

    public WebTable(int columns, String name, String[] headers, String[] align, boolean[] asc) {
        this(columns, name, null, headers, align, asc);
    }

    public WebTable(int columns, String name, String ref, String[] headers, String[] align, boolean[] asc) {
        this.iName = name;
        this.iColumns = columns;
        this.iName = name;
        this.iHeaders = headers;
        this.iAlign = align;
        this.iAsc = asc;
        this.iRef = ref;
        this.iLines = new Vector();
    }

    public void setColumnFilter(Hashtable filter, String[] keys) {
        this.iColumnFilter = filter;
        this.iColumnFilterKeys = keys;
    }

    public void setWebTableTweakStyle(WebTableTweakStyle style) {
        this.iWebTableTweakStyle = style;
    }

    public void setCellStyle(WebTableCellStyle style) {
        this.iWebTableCellStyle = style;
    }

    public String getStyle(WebTableLine line, WebTableLine next, int order) {
        String style = (String)(this.iRowStyle == null ? "" : this.iRowStyle + ";") + (this.iWebTableTweakStyle == null ? "" : this.iWebTableTweakStyle.getStyleHtml(line, next, order));
        return style == null || style.length() == 0 ? "" : "style=\"" + style + "\"";
    }

    public String getCellStyle(WebTableLine line, int column, String defaultStyle) {
        String style = this.iWebTableCellStyle == null ? null : this.iWebTableCellStyle.getCellStyleHtml(line, column);
        return style == null ? defaultStyle : "style=\"" + style + "\"";
    }

    public void setRowStyle(String style) {
        this.iRowStyle = (String)(this.iRowStyle == null ? "" : this.iRowStyle + ";") + style;
    }

    public void setSuppressRowHighlight(boolean suppress) {
        this.suppressRowHighlight = suppress;
    }

    public void enableHR() {
        this.setRowStyle("border-bottom: rgb(81,81,81) 1px solid");
    }

    public void enableHR(String colorCode) {
        this.setRowStyle("border-bottom: 1px dashed " + colorCode);
    }

    public WebTableLine addLine(String[] line, Comparable[] orderby) {
        WebTableLine wtline = new WebTableLine(null, line, orderby);
        this.iLines.addElement(wtline);
        return wtline;
    }

    public WebTableLine addLine(String onClick, String[] line, Comparable[] orderby, String uniqueId) {
        WebTableLine wtline = new WebTableLine(onClick, line, orderby, uniqueId);
        this.iLines.addElement(wtline);
        return wtline;
    }

    public WebTableLine addLine(String onClick, String[] line, Comparable[] orderby) {
        return this.addLine(onClick, line, orderby, null);
    }

    public WebTableLine replaceLine(int index, String onClick, String[] line, Comparable[] orderby) {
        return this.replaceLine(index, onClick, line, null, null);
    }

    public WebTableLine replaceLine(int index, String onClick, String[] line, Comparable[] orderby, String uniqueId) {
        if (index >= 0 && index < this.iLines.size()) {
            this.iLines.remove(index);
            WebTableLine wtline = new WebTableLine(onClick, line, orderby, uniqueId);
            this.iLines.add(index, wtline);
            return wtline;
        }
        return null;
    }

    public int indexOfLine(String uniqueId) {
        int indx = 0;
        boolean found = false;
        for (indx = 0; indx < this.iLines.size() && !found; ++indx) {
            WebTableLine wtLine = (WebTableLine)this.iLines.get(indx);
            if (!wtLine.getUniqueId().equals(uniqueId)) continue;
            found = true;
        }
        if (found) {
            return --indx;
        }
        return -1;
    }

    public WebTableLine findLine(String uniqueId) {
        int indx = this.indexOfLine(uniqueId);
        if (indx >= 0) {
            return (WebTableLine)this.iLines.get(indx);
        }
        return null;
    }

    public String nextUniqueId(String uniqueId) {
        int indx = this.indexOfLine(uniqueId);
        if (indx < 0 || indx >= this.iLines.size() - 1) {
            return null;
        }
        return ((WebTableLine)this.iLines.get(indx + 1)).getUniqueId();
    }

    public String previousUniqueId(String uniqueId) {
        int indx = this.indexOfLine(uniqueId);
        if (indx <= 0) {
            return null;
        }
        return ((WebTableLine)this.iLines.get(indx - 1)).getUniqueId();
    }

    public String printTable() {
        return this.printTable(0);
    }

    protected boolean isFiltered(int col) {
        if (this.iColumnFilter == null) {
            return false;
        }
        String name = this.iColumnFilterKeys[col];
        return this.iColumnFilter.containsKey(name) ? (Boolean)this.iColumnFilter.get(name) : false;
    }

    public int getNrFilteredColumns() {
        if (this.iColumnFilter == null) {
            return 0;
        }
        int ret = 0;
        Enumeration e = this.iColumnFilter.keys();
        while (e.hasMoreElements()) {
            if (!Boolean.TRUE.equals(e.nextElement())) continue;
            ++ret;
        }
        return ret;
    }

    protected static String align(String alignment, boolean rtl) {
        if (rtl && "left".equalsIgnoreCase(alignment)) {
            return "right";
        }
        return alignment;
    }

    public String printTable(int ordCol) {
        boolean asc;
        String[] lastLine = new String[Math.max(this.iColumns, this.iHeaders == null ? 0 : this.iHeaders.length)];
        StringBuffer sb = new StringBuffer();
        boolean rtl = Localization.isRTL();
        if (this.iName != null && this.iName.trim().length() > 0) {
            sb.append("<tr><td colspan=" + this.iColumns + "><div class=WelcomeRowHead>" + this.iName + "</div></td></tr>");
        }
        sb.append("<tr><td colspan='" + this.iColumns + "'><div class='unitime-LegacyWebTable'><table width='100%' border='0' cellspacing='0' cellpadding='3'>");
        boolean bl = asc = ordCol == 0 || this.iAsc == null || this.iAsc.length <= Math.abs(ordCol) - 1 ? true : this.iAsc[Math.abs(ordCol) - 1];
        if (ordCol < 0) {
            boolean bl2 = asc = !asc;
        }
        if (this.iHeaders != null) {
            sb.append("<tr valign='top'>");
            int last = this.iColumns - this.iHeaders.length + 1;
            for (int i = 0; i < this.iHeaders.length; ++i) {
                if (this.isFiltered(i)) continue;
                if (this.iHeaders[i] != null) {
                    String header = ToolBox.replace((String)(this.iRef == null || this.iLines.size() == 0 || ((WebTableLine)this.iLines.elementAt(0)).getOrderBy() == null || ((WebTableLine)this.iLines.elementAt(0)).getOrderBy()[i] == null ? this.iHeaders[i] : "<A title=\"Order by this column.\" href=\"" + this.iRef + "\" class=\"sortHeader\">" + (i == Math.abs(ordCol) - 1 ? (asc ? "&uarr;" : "&darr;") : "") + this.iHeaders[i] + "</A>"), "%%", String.valueOf(i == Math.abs(ordCol) - 1 ? -ordCol : i + 1));
                    sb.append("<td align=\"" + (this.iAlign != null ? WebTable.align(this.iAlign[i], rtl) : (rtl ? "right" : "left")) + "\"" + (String)(i == this.iHeaders.length - 1 ? " colspan=" + last + " " : "") + " class=\"WebTableHeader\">" + header + "</td>");
                    continue;
                }
                sb.append("<td class=\"WebTableHeader\" " + (String)(i == this.iHeaders.length - 1 ? " colspan=" + last + " " : "") + ">&nbsp;</td>");
            }
            sb.append("</tr>");
        }
        if (ordCol != 0) {
            Collections.sort(this.iLines, new WebTableComparator(Math.abs(ordCol) - 1, asc));
        }
        for (int el = 0; el < this.iLines.size(); ++el) {
            WebTableLine wtline = (WebTableLine)this.iLines.elementAt(el);
            String[] line = wtline.getLine();
            String onClick = wtline.getOnClick();
            Object lineStyle = wtline.getStyle();
            String bgColor = wtline.getBgColor();
            if (bgColor != null) {
                lineStyle = lineStyle == null ? "background-color:" + bgColor + ";" : (String)lineStyle + "background-color:" + bgColor + ";";
            }
            String title = wtline.getTitle();
            String style = this.getStyle(wtline, el + 1 < this.iLines.size() ? (WebTableLine)this.iLines.elementAt(el + 1) : null, ordCol);
            int last = this.iColumns - line.length + 1;
            boolean anchor = onClick != null && onClick.startsWith("<");
            sb.append("\n");
            sb.append((anchor ? onClick : "") + "<tr valign='top' " + (onClick == null || anchor ? "" : onClick) + (String)(lineStyle == null ? "" : " style='" + (String)lineStyle + "'") + (!this.suppressRowHighlight ? " onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';" : "") + "this.style.cursor='" + (onClick == null ? "default" : "hand") + (onClick != null ? "';this.style.cursor='pointer" : "") + "';\"" + (String)(!this.suppressRowHighlight ? "onmouseout=\"this.style.backgroundColor='" + (bgColor == null ? "transparent" : bgColor) + "';\"" : "") + (String)(title == null ? "" : " title='" + title + "'") + ">");
            boolean blank = this.iBlankWhenSame;
            for (int i = 0; i < line.length; ++i) {
                if (this.isFiltered(i)) continue;
                if (blank && line[i] != null && !line[i].equals(lastLine[i])) {
                    blank = false;
                }
                if (!blank && line[i] != null) {
                    sb.append("<td " + this.getCellStyle(wtline, i, style) + " align=\"" + (this.iAlign != null ? WebTable.align(this.iAlign[i], rtl) : (rtl ? "right" : "left")) + "\"" + (String)(i == line.length - 1 ? " colspan=" + last + " " : "") + ">" + (String)(i == 0 && wtline.getUniqueId() != null ? "<A name=\"" + wtline.iUniqueId + "\" ></A>" : "") + line[i] + "</td>");
                } else {
                    sb.append("<td " + this.getCellStyle(wtline, i, style) + " " + (String)(i == line.length - 1 ? " colspan=" + last + " " : "") + ">&nbsp;</td>");
                }
                if (i >= lastLine.length) continue;
                lastLine[i] = line[i];
            }
            sb.append("</tr>" + (anchor ? "</a>" : ""));
        }
        sb.append("</table></div></td></tr>");
        return sb.toString();
    }

    public CSVFile toCSVFile(int ordCol) {
        boolean asc;
        CSVFile file = new CSVFile();
        if (this.iHeaders != null) {
            Vector<CSVFile.CSVField> header = new Vector<CSVFile.CSVField>();
            for (int i = 0; i < this.iHeaders.length; ++i) {
                if (this.isFiltered(i)) continue;
                header.add(new CSVFile.CSVField((Object)(this.iHeaders[i] == null ? "" : this.iHeaders[i])));
            }
            file.setHeader(header);
        }
        boolean bl = asc = ordCol == 0 || this.iAsc == null || this.iAsc.length <= Math.abs(ordCol) - 1 ? true : this.iAsc[Math.abs(ordCol) - 1];
        if (ordCol < 0) {
            boolean bl2 = asc = !asc;
        }
        if (ordCol != 0) {
            Collections.sort(this.iLines, new WebTableComparator(Math.abs(ordCol) - 1, asc));
        }
        String[] lastLine = new String[Math.max(this.iColumns, this.iHeaders == null ? 0 : this.iHeaders.length)];
        Enumeration el = this.iLines.elements();
        while (el.hasMoreElements()) {
            WebTableLine wtline = (WebTableLine)el.nextElement();
            String[] line = wtline.getLine();
            Vector<CSVFile.CSVField> cline = new Vector<CSVFile.CSVField>();
            boolean blank = this.iBlankWhenSame;
            for (int i = 0; i < line.length; ++i) {
                if (this.isFiltered(i)) continue;
                if (blank && line[i] != null && !line[i].equals(lastLine[i])) {
                    blank = false;
                }
                cline.add(new CSVFile.CSVField((Object)(blank || line[i] == null ? "" : line[i])));
                lastLine[i] = line[i];
            }
            file.addLine(cline);
        }
        return file;
    }

    public int getNrColumns() {
        return this.iColumns - this.getNrFilteredColumns();
    }

    public String[] getHeader() {
        return this.iHeaders;
    }

    public boolean isBlankWhenSame() {
        return this.iBlankWhenSame;
    }

    public void setBlankWhenSame(boolean blankWhenSame) {
        this.iBlankWhenSame = blankWhenSame;
    }

    public static int getOrder(SessionContext context, String code) {
        Hashtable orderInfo = (Hashtable)context.getAttribute(SessionAttribute.TableOrder);
        if (orderInfo == null) {
            orderInfo = new Hashtable();
            context.setAttribute(SessionAttribute.TableOrder, orderInfo);
        }
        return orderInfo.containsKey(code) ? (Integer)orderInfo.get(code) : 0;
    }

    public static void setOrder(SessionContext context, String code, String order, int defOrder) {
        Hashtable<String, Integer> orderInfo = (Hashtable<String, Integer>)context.getAttribute(SessionAttribute.TableOrder);
        if (orderInfo == null) {
            orderInfo = new Hashtable<String, Integer>();
            context.setAttribute(SessionAttribute.TableOrder, orderInfo);
        }
        if (order != null) {
            orderInfo.put(code, Integer.valueOf(order));
        } else if (!orderInfo.containsKey(code)) {
            orderInfo.put(code, defOrder);
        }
    }

    public static void setOrder(HttpSession session, String code, String order) {
        if (order == null) {
            return;
        }
        Hashtable<String, Integer> orderInfo = (Hashtable<String, Integer>)session.getAttribute("OrderInfo");
        if (orderInfo == null) {
            orderInfo = new Hashtable<String, Integer>();
            session.setAttribute("OrderInfo", orderInfo);
        }
        orderInfo.put(code, Integer.valueOf(order));
    }

    public Vector getLines() {
        return this.iLines;
    }

    public void setRef(String ref) {
        this.iRef = ref;
    }

    public void setName(String name) {
        this.iName = name;
    }

    protected CSVFile.CSVField csvField(String text) {
        if (text == null) {
            return new CSVFile.CSVField((Object)"");
        }
        if (text.indexOf("@@") < 0) {
            return new CSVFile.CSVField((Object)text);
        }
        Object cell = "";
        boolean first = true;
        StringTokenizer s = new StringTokenizer(text, "\n");
        while (s.hasMoreTokens()) {
            String line = s.nextToken();
            int pos = 0;
            while (true) {
                String hex;
                int idx;
                if ((idx = line.indexOf("@@", pos)) < 0) break;
                cell = (String)cell + (!first && pos == 0 ? "\n" : "") + line.substring(pos, idx);
                pos = idx;
                String cmd = line.substring(pos += 2, line.indexOf(32, pos));
                pos += cmd.length() + 1;
                if ("COLOR".equals(cmd)) {
                    hex = line.substring(pos, line.indexOf(32, pos));
                    pos += hex.length() + 1;
                    if (hex.startsWith("#")) {
                        hex = hex.substring(1);
                    }
                }
                if ("BGCOLOR".equals(cmd)) {
                    hex = line.substring(pos, line.indexOf(32, pos));
                    pos += hex.length() + 1;
                    if (hex.startsWith("#")) {
                        hex = hex.substring(1);
                    }
                }
                if ("IMAGE".equals(cmd)) {
                    String name = line.substring(pos, line.indexOf(32, pos));
                    pos += name.length() + 1;
                }
                if (!"BORDER_ALL".equals(cmd) && !"BORDER_TOP".equals(cmd) && !"BORDER_BOTTOM".equals(cmd) && !"BORDER_LEFT".equals(cmd) && !"BORDER_RIGHT".equals(cmd)) continue;
                hex = line.substring(pos, line.indexOf(32, pos));
                pos += hex.length() + 1;
                if (!hex.startsWith("#")) continue;
                hex = hex.substring(1);
            }
            cell = (String)cell + (!first && pos == 0 ? "\n" : "") + line.substring(pos);
            first = false;
        }
        return new CSVFile.CSVField(cell);
    }

    public CSVFile printCsvTable(int ordCol) {
        boolean asc;
        CSVFile csv = new CSVFile();
        boolean bl = asc = ordCol == 0 || this.iAsc == null || this.iAsc.length <= Math.abs(ordCol) - 1 ? true : this.iAsc[Math.abs(ordCol) - 1];
        if (ordCol < 0) {
            asc = !asc;
        }
        String[] lastLine = new String[Math.max(this.iColumns, this.iHeaders == null ? 0 : this.iHeaders.length)];
        if (this.iHeaders != null) {
            ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
            for (int i = 0; i < this.iColumns; ++i) {
                if (this.isFiltered(i)) continue;
                line.add(this.csvField(this.iHeaders[i]));
            }
            csv.addLine(line);
        }
        if (ordCol != 0) {
            Collections.sort(this.iLines, new WebTableComparator(Math.abs(ordCol) - 1, asc));
        }
        for (int el = 0; el < this.iLines.size(); ++el) {
            WebTableLine wtline = (WebTableLine)this.iLines.elementAt(el);
            ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
            boolean blank = this.iBlankWhenSame;
            for (int i = 0; i < this.iColumns; ++i) {
                if (this.isFiltered(i)) continue;
                if (blank && wtline.getLine()[i] != null && !wtline.getLine()[i].equals(lastLine[i])) {
                    blank = false;
                }
                line.add(this.csvField(wtline.getLine()[i]));
                lastLine[i] = wtline.getLine()[i];
            }
            csv.addLine(line);
        }
        return csv;
    }

    public static interface WebTableTweakStyle {
        public String getStyleHtml(WebTableLine var1, WebTableLine var2, int var3);
    }

    public static interface WebTableCellStyle {
        public String getCellStyleHtml(WebTableLine var1, int var2);
    }

    public class WebTableLine {
        private String[] iLine = null;
        private Comparable[] iOrderBy = null;
        private String iOnClick = null;
        private String iUniqueId = null;
        private String iBgColor = null;
        private String iStyle = null;
        private String iTitle = null;

        WebTableLine(String onClick, String[] line, Comparable[] orderby) {
            this.iOnClick = onClick;
            this.iLine = line;
            this.iOrderBy = orderby;
        }

        WebTableLine(String onClick, String[] line, Comparable[] orderby, String uniqueId) {
            this(onClick, line, orderby);
            this.iUniqueId = uniqueId;
        }

        public String getOnClick() {
            return this.iOnClick;
        }

        public String[] getLine() {
            return this.iLine;
        }

        public Comparable[] getOrderBy() {
            return this.iOrderBy;
        }

        public int compareTo(WebTableLine another, int column, boolean asc) {
            int ret;
            if (column < 0 || this.iOrderBy == null || this.iOrderBy.length <= column) {
                return 0;
            }
            if (another.getOrderBy() == null || another.getOrderBy().length <= column) {
                return 0;
            }
            NaturalOrderComparator noc = new NaturalOrderComparator();
            Comparable a = this.iOrderBy[column];
            Comparable b = another.getOrderBy()[column];
            int n = a == null ? (b == null ? 0 : -1) : (b == null ? 1 : (a instanceof String && b instanceof String ? (asc ? 1 : -1) * noc.compare((String)((Object)a), (String)((Object)b)) : (ret = (asc ? 1 : -1) * a.compareTo(b))));
            if (ret != 0) {
                return ret;
            }
            for (int i = 0; i < this.iOrderBy.length; ++i) {
                a = this.iOrderBy[i];
                b = another.getOrderBy()[i];
                int n2 = a == null ? (b == null ? 0 : -1) : (b == null ? 1 : (a instanceof String && b instanceof String ? (asc ? 1 : -1) * noc.compare((String)((Object)a), (String)((Object)b)) : (ret = (asc ? 1 : -1) * a.compareTo(b))));
                if (ret == 0) continue;
                return ret;
            }
            return ret;
        }

        public String getUniqueId() {
            return this.iUniqueId;
        }

        public void setUniqueId(String uniqueId) {
            this.iUniqueId = uniqueId;
        }

        public void setBgColor(String bgColor) {
            this.iBgColor = bgColor;
        }

        public String getBgColor() {
            return this.iBgColor;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setStyle(String style) {
            this.iStyle = style;
        }

        public String getStyle() {
            return this.iStyle;
        }
    }

    public static class WebTableComparator
    implements Comparator {
        private int iColumn = 1;
        private boolean iAsc = true;

        public WebTableComparator(int column, boolean asc) {
            this.iColumn = column;
            this.iAsc = asc;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null || !(o1 instanceof WebTableLine) || !(o2 instanceof WebTableLine)) {
                return 0;
            }
            WebTableLine w1 = (WebTableLine)o1;
            WebTableLine w2 = (WebTableLine)o2;
            return w1.compareTo(w2, this.iColumn, this.iAsc);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof WebTableComparator)) {
                return false;
            }
            WebTableComparator wtc = (WebTableComparator)obj;
            return wtc.iAsc == this.iAsc && wtc.iColumn == this.iColumn;
        }
    }
}

