/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseFreeTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private Integer iDayCode;
    private Integer iStartSlot;
    private Integer iLength;
    private Integer iCategory;
    private Session iSession;

    public BaseFreeTime() {
    }

    public BaseFreeTime(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=50)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="day_code", nullable=false, length=10)
    public Integer getDayCode() {
        return this.iDayCode;
    }

    public void setDayCode(Integer dayCode) {
        this.iDayCode = dayCode;
    }

    @Column(name="start_slot", nullable=false, length=10)
    public Integer getStartSlot() {
        return this.iStartSlot;
    }

    public void setStartSlot(Integer startSlot) {
        this.iStartSlot = startSlot;
    }

    @Column(name="length", nullable=false, length=10)
    public Integer getLength() {
        return this.iLength;
    }

    public void setLength(Integer length) {
        this.iLength = length;
    }

    @Column(name="category", nullable=false, length=10)
    public Integer getCategory() {
        return this.iCategory;
    }

    public void setCategory(Integer category) {
        this.iCategory = category;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FreeTime)) {
            return false;
        }
        if (this.getUniqueId() == null || ((FreeTime)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((FreeTime)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "FreeTime[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "FreeTime[\n\tCategory: " + this.getCategory() + "\n\tDayCode: " + this.getDayCode() + "\n\tLength: " + this.getLength() + "\n\tName: " + this.getName() + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tStartSlot: " + this.getStartSlot() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

