/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.RoomFilterBox;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomDepartmentsEdit
extends Composite {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private SimpleForm iForm = new SimpleForm();
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private RoomInterface.RoomPropertiesInterface iProperties;
    private RoomInterface.DepartmentInterface iDepartment = null;
    private RoomInterface.ExamTypeInterface iExamType = null;
    private RoomsTable iRooms = null;
    private int iLastScrollTop;
    private int iLastScrollLeft;

    public RoomDepartmentsEdit() {
        this.iForm.addStyleName("unitime-RoomDepartmentsEdit");
        this.iHeader = new UniTimeHeaderPanel();
        this.iHeader.addButton("update", MESSAGES.buttonUpdate(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomInterface.UpdateRoomDepartmentsRequest request = new RoomInterface.UpdateRoomDepartmentsRequest();
                request.setSessionId(RoomDepartmentsEdit.this.iProperties.getAcademicSessionId());
                request.setDepartment(RoomDepartmentsEdit.this.iDepartment);
                request.setExamType(RoomDepartmentsEdit.this.iExamType);
                for (int i = 1; i < RoomDepartmentsEdit.this.iRooms.getRowCount(); ++i) {
                    RoomInterface.RoomDetailInterface room = (RoomInterface.RoomDetailInterface)RoomDepartmentsEdit.this.iRooms.getData(i);
                    boolean wasSelected = false;
                    if (RoomDepartmentsEdit.this.iDepartment != null) {
                        wasSelected = room.getDepartment(RoomDepartmentsEdit.this.iDepartment.getId()) != null;
                    } else if (RoomDepartmentsEdit.this.iExamType != null) {
                        wasSelected = room.getExamType(RoomDepartmentsEdit.this.iExamType.getId()) != null;
                    }
                    boolean selected = RoomDepartmentsEdit.this.iRooms.isRoomSelected(i);
                    if (selected == wasSelected) continue;
                    if (selected) {
                        request.addLocation(room.getUniqueId());
                        continue;
                    }
                    request.dropLocation(room.getUniqueId());
                }
                if (!request.hasAddLocations() && !request.hasDropLocations()) {
                    RoomDepartmentsEdit.this.hide(false);
                    return;
                }
                LoadingWidget.getInstance().show(MESSAGES.waitUpdatingRoomDepartments());
                RPC.execute(request, new AsyncCallback<GwtRpcResponseNull>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        RoomDepartmentsEdit.this.iHeader.setErrorMessage(MESSAGES.errorFailedToUpdateRoomDepartments(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.errorFailedToUpdateRoomDepartments(caught.getMessage()));
                    }

                    public void onSuccess(GwtRpcResponseNull result) {
                        LoadingWidget.getInstance().hide();
                        RoomDepartmentsEdit.this.hide(true);
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomDepartmentsEdit.this.hide(false);
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iRooms = new RoomsTable(RoomInterface.RoomsPageMode.COURSES, true);
        this.iForm.addRow((Widget)this.iRooms);
        this.iRooms.addMouseClickListener(new UniTimeTable.MouseClickListener<RoomInterface.RoomDetailInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RoomInterface.RoomDetailInterface> event) {
                RoomDepartmentsEdit.this.iHeader.clearMessage();
            }
        });
        this.iFooter = this.iHeader.clonePanel();
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.initWidget((Widget)this.iForm);
    }

    public void setProperties(RoomInterface.RoomPropertiesInterface properties) {
        this.iProperties = properties;
        this.iRooms.setProperties(this.iProperties);
    }

    private void hide(boolean refresh) {
        this.setVisible(false);
        this.onHide(refresh);
        Window.scrollTo((int)this.iLastScrollLeft, (int)this.iLastScrollTop);
    }

    public void hide() {
        this.hide(true);
    }

    protected void onHide(boolean refresh) {
    }

    protected void onShow() {
    }

    public void show() {
        UniTimePageLabel.getInstance().setPageName(MESSAGES.pageEditRoomsDepartments());
        this.setVisible(true);
        this.iLastScrollLeft = Window.getScrollLeft();
        this.iLastScrollTop = Window.getScrollTop();
        this.onShow();
        Window.scrollTo((int)0, (int)0);
    }

    public boolean setDepartmentOrExamType(String code) {
        if (this.iProperties == null) {
            return false;
        }
        this.iDepartment = null;
        this.iExamType = null;
        for (RoomInterface.ExamTypeInterface type : this.iProperties.getExamTypes()) {
            if (!type.getReference().equals(code)) continue;
            this.iHeader.setHeaderTitle(MESSAGES.examinationRooms(type.getLabel()));
            this.iExamType = type;
            return true;
        }
        for (RoomInterface.DepartmentInterface department : this.iProperties.getDepartments()) {
            if (!department.getDeptCode().equals(code)) continue;
            this.iHeader.setHeaderTitle(department.getExtAbbreviationWhenExist() + " - " + department.getExtLabelWhenExist());
            this.iDepartment = department;
            return true;
        }
        return false;
    }

    public boolean canEdit() {
        if (this.iDepartment != null) {
            return this.iDepartment.isCanEditRoomSharing();
        }
        if (this.iExamType != null) {
            return this.iProperties.isCanEditRoomExams();
        }
        return false;
    }

    public boolean setDepartmentOrExamType(RoomFilterBox filter) {
        FilterBox.Chip dept = filter.getChip("department");
        if (dept != null) {
            this.iRooms.setDepartment(dept.getValue());
            return this.setDepartmentOrExamType(dept.getValue());
        }
        return false;
    }

    public void setRooms(List<EventInterface.FilterRpcResponse.Entity> rooms, Integer sortBy) {
        this.iRooms.clearTable(1);
        this.iHeader.clearMessage();
        ValueChangeHandler<Boolean> clearErrorMessage = new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RoomDepartmentsEdit.this.iHeader.clearMessage();
            }
        };
        for (EventInterface.FilterRpcResponse.Entity e : rooms) {
            RoomInterface.RoomDetailInterface room = (RoomInterface.RoomDetailInterface)e;
            int row = this.iRooms.addRoom(room);
            boolean selected = false;
            if (this.iDepartment != null) {
                selected = room.getDepartment(this.iDepartment.getId()) != null;
            } else if (this.iExamType != null) {
                selected = room.getExamType(this.iExamType.getId()) != null;
            }
            this.iRooms.selectRoom(row, selected);
            this.iRooms.setSelected(row, selected);
            this.iRooms.getRoomSelection(row).addValueChangeHandler((ValueChangeHandler)clearErrorMessage);
        }
        if (sortBy != null) {
            this.iRooms.setSortBy(sortBy);
        }
    }
}

