/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.InstructionalOfferingListForm;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.PdfWorksheet;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.WebInstructionalOfferingTableBuilder;
import org.unitime.timetable.webutil.csv.CsvInstructionalOfferingTableBuilder;
import org.unitime.timetable.webutil.pdf.PdfInstructionalOfferingTableBuilder;

@Action(value="instructionalOfferingSearch", results={@Result(name={"showInstructionalOfferingSearch"}, type="tiles", location="instructionalOfferingList.tiles"), @Result(name={"showInstructionalOfferingDetail"}, type="redirect", location="/instructionalOfferingDetail.action", params={"op", "${op}", "io", "${io}"}), @Result(name={"showCourseOfferingEdit"}, type="redirect", location="/courseOfferingEdit.action", params={"op", "${op}", "subjAreaId", "${form.subjectAreaIds[0]}", "courseNbr", "${form.courseNbr}"})})
@TilesDefinition(name="instructionalOfferingList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Instructional Offerings"), @TilesPutAttribute(name="body", value="/user/instructionalOfferingSearch.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="showSolverWarnings", value="assignment")})
public class InstructionalOfferingSearchAction
extends UniTimeAction<InstructionalOfferingListForm> {
    private static final long serialVersionUID = 121359338070354596L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private Long io;
    private String doit;
    private String[] subjectAreaIds;
    private String courseNbr;
    private String loadInstrFilter;
    private boolean showTable = false;

    public Long getIo() {
        return this.io;
    }

    public void setIo(Long io) {
        this.io = io;
    }

    public String getDoit() {
        return this.doit;
    }

    public void setDoit(String doit) {
        this.doit = doit;
    }

    public String[] getSubjectAreaIds() {
        return this.subjectAreaIds;
    }

    public void setSubjectAreaIds(String[] subjectAreaIds) {
        this.subjectAreaIds = subjectAreaIds;
    }

    public String getCourseNbr() {
        return this.courseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        this.courseNbr = courseNbr;
    }

    public String getLoadInstrFilter() {
        return this.loadInstrFilter;
    }

    public void setLoadInstrFilter(String loadInstrFilter) {
        this.loadInstrFilter = loadInstrFilter;
    }

    public boolean isShowTable() {
        return this.showTable;
    }

    public void setShowTable(boolean showTable) {
        this.showTable = showTable;
    }

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new InstructionalOfferingListForm();
        }
        this.sessionContext.checkPermission(Right.InstructionalOfferings);
        if (this.getSubjectAreaIds() != null) {
            if (this.getSubjectAreaIds().length == 1 && this.getSubjectAreaIds()[0] != null && this.getSubjectAreaIds()[0].indexOf(44) >= 0) {
                ((InstructionalOfferingListForm)this.form).setSubjectAreaIds(this.getSubjectAreaIds()[0].split(","));
            } else {
                ((InstructionalOfferingListForm)this.form).setSubjectAreaIds(this.getSubjectAreaIds());
            }
        }
        if (this.getCourseNbr() != null) {
            ((InstructionalOfferingListForm)this.form).setCourseNbr(this.getCourseNbr());
        }
        if ("1".equals(this.getLoadInstrFilter())) {
            InstructionalOfferingSearchAction.setupInstrOffrListSpecificFormFilters(this.sessionContext, (InstructionalOfferingListForm)this.form);
        }
        if (MSG.actionSearchInstructionalOfferings().equals(this.doit) || "Search".equals(this.doit)) {
            return this.searchInstructionalOfferings();
        }
        if (MSG.actionExportPdf().equals(this.doit)) {
            return this.exportPdf();
        }
        if (MSG.actionExportCsv().equals(this.doit)) {
            return this.exportCsv();
        }
        if (MSG.actionWorksheetPdf().equals(this.doit)) {
            return this.worksheetPdf();
        }
        if (MSG.actionAddNewInstructionalOffering().equals(this.doit)) {
            return this.addInstructionalOfferings();
        }
        BackTracker.markForBack(this.request, null, null, false, true);
        Object sa = this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
        Object cn = this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber);
        if (Constants.ALL_OPTION_VALUE.equals(sa)) {
            sa = null;
        }
        if ((sa == null || sa.toString().trim().isEmpty()) && (cn == null || cn.toString().trim().isEmpty())) {
            String saStr;
            sa = this.sessionContext.getAttribute(SessionAttribute.ClassesSubjectAreas);
            cn = this.sessionContext.getAttribute(SessionAttribute.ClassesCourseNumber);
            if (sa != null && (saStr = sa.toString()).indexOf(",") > 0) {
                sa = saStr.substring(0, saStr.indexOf(","));
            }
        }
        InstructionalOfferingSearchAction.setupInstrOffrListSpecificFormFilters(this.sessionContext, (InstructionalOfferingListForm)this.form);
        if (!this.sessionContext.hasPermission(Right.Examinations)) {
            ((InstructionalOfferingListForm)this.form).setExams(null);
        }
        Integer maxSubjectsToSearch = ApplicationProperty.MaxSubjectsToSearchAutomatically.intValue();
        if (sa != null) {
            try {
                StringBuffer ids = new StringBuffer();
                StringBuffer names = new StringBuffer();
                StringBuffer subjIds = new StringBuffer();
                for (String id : sa.toString().split(",")) {
                    if ("-1".equals(id)) continue;
                    if (names.length() > 0) {
                        names.append(",");
                        subjIds.append(",");
                    }
                    ids.append("&subjectAreaIds=" + id);
                    subjIds.append(id);
                    names.append(((SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(id))).getSubjectAreaAbbreviation());
                }
                String courseNbr = "";
                if (cn != null && !cn.toString().isEmpty()) {
                    courseNbr = cn.toString();
                }
                Debug.debug("Subject Areas: " + String.valueOf(subjIds));
                Debug.debug("Course Number: " + courseNbr);
                ((InstructionalOfferingListForm)this.form).setSubjectAreaIds(sa.toString().split(","));
                ((InstructionalOfferingListForm)this.form).setCourseNbr(courseNbr);
                if (maxSubjectsToSearch != null && maxSubjectsToSearch >= 0 && ((InstructionalOfferingListForm)this.form).getSubjectAreaIds().length > maxSubjectsToSearch) {
                    ((InstructionalOfferingListForm)this.form).setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
                    ((InstructionalOfferingListForm)this.form).setInstructionalOfferings(null);
                    this.setShowTable(false);
                    return "showInstructionalOfferingSearch";
                }
                if (this.doSearch()) {
                    BackTracker.markForBack(this.request, "instructionalOfferingSearch.action?doit=Search&loadInstrFilter=1" + String.valueOf(ids) + "&courseNbr=" + (((InstructionalOfferingListForm)this.form).getCourseNbr() == null ? "" : URLEncoder.encode(((InstructionalOfferingListForm)this.form).getCourseNbr(), "utf-8")), "Instructional Offerings (" + String.valueOf(names) + (String)(((InstructionalOfferingListForm)this.form).getCourseNbr() == null || ((InstructionalOfferingListForm)this.form).getCourseNbr().length() == 0 ? "" : " " + ((InstructionalOfferingListForm)this.form).getCourseNbr()) + ")", true, true);
                    this.setShowTable(true);
                    return "showInstructionalOfferingSearch";
                }
            }
            catch (NumberFormatException nfe) {
                Debug.error("Subject Area Id session attribute is corrupted. Resetting ... ");
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsSubjectArea);
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsCourseNumber);
            }
        } else {
            ((InstructionalOfferingListForm)this.form).setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
            ((InstructionalOfferingListForm)this.form).setInstructionalOfferings(null);
            Set s = (Set)((InstructionalOfferingListForm)this.form).getSubjectAreas();
            if (s.size() == 1 && (maxSubjectsToSearch == null || maxSubjectsToSearch != 0)) {
                Debug.debug("Exactly 1 subject area found ... ");
                ((InstructionalOfferingListForm)this.form).setSubjectAreaIds(new String[]{((SubjectArea)s.iterator().next()).getUniqueId().toString()});
                if (this.doSearch()) {
                    BackTracker.markForBack(this.request, "instructionalOfferingSearch.action?doit=Search&loadInstrFilter=1&subjectAreaIds=" + ((InstructionalOfferingListForm)this.form).getSubjectAreaIds()[0] + "&courseNbr=" + (((InstructionalOfferingListForm)this.form).getCourseNbr() == null ? "" : URLEncoder.encode(((InstructionalOfferingListForm)this.form).getCourseNbr(), "utf-8")), "Instructional Offerings (" + (((InstructionalOfferingListForm)this.form).getSubjectAreaAbbv() == null ? ((SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(((InstructionalOfferingListForm)this.form).getSubjectAreaIds()[0]))).getSubjectAreaAbbreviation() : ((InstructionalOfferingListForm)this.form).getSubjectAreaAbbv()) + (String)(((InstructionalOfferingListForm)this.form).getCourseNbr() == null || ((InstructionalOfferingListForm)this.form).getCourseNbr().length() == 0 ? "" : " " + ((InstructionalOfferingListForm)this.form).getCourseNbr()) + ")", true, true);
                    this.setShowTable(true);
                    return "showInstructionalOfferingSearch";
                }
            }
        }
        this.setShowTable(false);
        return "showInstructionalOfferingSearch";
    }

    private boolean doSearch() throws Exception {
        ((InstructionalOfferingListForm)this.form).setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
        ((InstructionalOfferingListForm)this.form).setInstructionalOfferings(InstructionalOfferingSearchAction.getInstructionalOfferings(this.sessionContext.getUser().getCurrentAcademicSessionId(), this.getClassAssignmentService().getAssignment(), (InstructionalOfferingListForm)this.form));
        return !((InstructionalOfferingListForm)this.form).getInstructionalOfferings().isEmpty();
    }

    public String searchInstructionalOfferings() throws Exception {
        InstructionalOffering io;
        TreeSet<InstructionalOffering> offerings;
        this.sessionContext.checkPermission(Right.InstructionalOfferings);
        ((InstructionalOfferingListForm)this.form).validate(this);
        if (this.hasFieldErrors()) {
            ((InstructionalOfferingListForm)this.form).setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
            ((InstructionalOfferingListForm)this.form).setInstructionalOfferings(null);
            this.setShowTable(false);
            return "showInstructionalOfferingSearch";
        }
        StringBuffer ids = new StringBuffer();
        StringBuffer names = new StringBuffer();
        StringBuffer subjIds = new StringBuffer();
        for (int i = 0; i < ((InstructionalOfferingListForm)this.form).getSubjectAreaIds().length; ++i) {
            if (i > 0) {
                names.append(",");
                subjIds.append(",");
            }
            ids.append("&subjectAreaIds=" + ((InstructionalOfferingListForm)this.form).getSubjectAreaIds()[i]);
            subjIds.append(((InstructionalOfferingListForm)this.form).getSubjectAreaIds()[i]);
            names.append(((SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(((InstructionalOfferingListForm)this.form).getSubjectAreaIds()[i]))).getSubjectAreaAbbreviation());
        }
        this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjIds.toString());
        this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)((InstructionalOfferingListForm)this.form).getCourseNbr());
        if (!"1".equals(this.getLoadInstrFilter())) {
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.divSec", ((InstructionalOfferingListForm)this.form).getDivSec() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.demand", ((InstructionalOfferingListForm)this.form).getDemand() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.projectedDemand", ((InstructionalOfferingListForm)this.form).getProjectedDemand() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.minPerWk", ((InstructionalOfferingListForm)this.form).getMinPerWk() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.limit", ((InstructionalOfferingListForm)this.form).getLimit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.snapshotLimit", ((InstructionalOfferingListForm)this.form).getSnapshotLimit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.roomLimit", ((InstructionalOfferingListForm)this.form).getRoomLimit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.manager", ((InstructionalOfferingListForm)this.form).getManager() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.datePattern", ((InstructionalOfferingListForm)this.form).getDatePattern() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.timePattern", ((InstructionalOfferingListForm)this.form).getTimePattern() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.instructor", ((InstructionalOfferingListForm)this.form).getInstructor() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.preferences", ((InstructionalOfferingListForm)this.form).getPreferences() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.timetable", ((InstructionalOfferingListForm)this.form).getTimetable() == null ? "0" : (((InstructionalOfferingListForm)this.form).getTimetable() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.credit", ((InstructionalOfferingListForm)this.form).getCredit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.subpartCredit", ((InstructionalOfferingListForm)this.form).getSubpartCredit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.schedulePrintNote", ((InstructionalOfferingListForm)this.form).getSchedulePrintNote() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.note", ((InstructionalOfferingListForm)this.form).getNote() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.title", ((InstructionalOfferingListForm)this.form).getTitle() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.exams", ((InstructionalOfferingListForm)this.form).getExams() == null ? "0" : (((InstructionalOfferingListForm)this.form).getExams() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.instructorAssignment", ((InstructionalOfferingListForm)this.form).getInstructorAssignment() == null ? "0" : (((InstructionalOfferingListForm)this.form).getInstructorAssignment() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.lms", ((InstructionalOfferingListForm)this.form).getLms() == null ? null : (((InstructionalOfferingListForm)this.form).getLms() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.waitlist", ((InstructionalOfferingListForm)this.form).getWaitlist() == null ? null : ((InstructionalOfferingListForm)this.form).getWaitlist());
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.consent", ((InstructionalOfferingListForm)this.form).getConsent() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.sortBy", ((InstructionalOfferingListForm)this.form).getSortBy());
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.fundingDepartment", ((InstructionalOfferingListForm)this.form).getFundingDepartment() == null ? "0" : (((InstructionalOfferingListForm)this.form).getFundingDepartment() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("InstructionalOfferingList.waitlistMode", ((InstructionalOfferingListForm)this.form).getWaitlistMode() == null ? null : (((InstructionalOfferingListForm)this.form).getWaitlistMode() != false ? "1" : "0"));
        }
        if (!this.sessionContext.hasPermission(Right.Examinations)) {
            ((InstructionalOfferingListForm)this.form).setExams(null);
        }
        Map<Long, TreeSet<InstructionalOffering>> instrOfferings = InstructionalOfferingSearchAction.getInstructionalOfferings(this.sessionContext.getUser().getCurrentAcademicSessionId(), this.getClassAssignmentService().getAssignment(), (InstructionalOfferingListForm)this.form);
        ((InstructionalOfferingListForm)this.form).setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
        ((InstructionalOfferingListForm)this.form).setInstructionalOfferings(instrOfferings);
        if (instrOfferings.isEmpty()) {
            this.addFieldError("searchResult", MSG.errorNoRecords());
            return "showInstructionalOfferingSearch";
        }
        BackTracker.markForBack(this.request, "instructionalOfferingSearch.action?op=Back&doit=Search&loadInstrFilter=1" + String.valueOf(ids) + "&courseNbr=" + URLEncoder.encode(((InstructionalOfferingListForm)this.form).getCourseNbr(), "utf-8"), MSG.labelInstructionalOfferings() + " (" + String.valueOf(names) + (String)(((InstructionalOfferingListForm)this.form).getCourseNbr() == null || ((InstructionalOfferingListForm)this.form).getCourseNbr().length() == 0 ? "" : " " + ((InstructionalOfferingListForm)this.form).getCourseNbr()) + ")", true, true);
        if (!"Back".equals(this.op) && ((InstructionalOfferingListForm)this.form).getSubjectAreaIds().length == 1 && (offerings = ((InstructionalOfferingListForm)this.form).getInstructionalOfferings(Long.valueOf(((InstructionalOfferingListForm)this.form).getSubjectAreaIds()[0]))) != null && offerings.size() == 1 && this.sessionContext.hasPermission(io = offerings.first(), Right.InstructionalOfferingDetail)) {
            this.setOp("view");
            this.setIo(io.getUniqueId());
            return "showInstructionalOfferingDetail";
        }
        this.setShowTable(true);
        return "showInstructionalOfferingSearch";
    }

    public String exportPdf() throws Exception {
        String fwd = this.searchInstructionalOfferings();
        if (!this.hasFieldErrors()) {
            OutputStream out = ExportUtils.getPdfOutputStream(this.response, "offerings");
            new PdfInstructionalOfferingTableBuilder().pdfTableForInstructionalOfferings(out, WebSolver.getClassAssignmentProxy(this.request.getSession()), WebSolver.getExamSolver(this.request.getSession()), (InstructionalOfferingListForm)this.form, ((InstructionalOfferingListForm)this.form).getSubjectAreaIds(), this.sessionContext, true, ((InstructionalOfferingListForm)this.form).areAllCoursesGiven());
            out.flush();
            out.close();
            return null;
        }
        return fwd;
    }

    public String exportCsv() throws Exception {
        String fwd = this.searchInstructionalOfferings();
        if (!this.hasFieldErrors()) {
            PrintWriter out = ExportUtils.getCsvWriter(this.response, "offerings");
            new CsvInstructionalOfferingTableBuilder().csvTableForInstructionalOfferings(out, WebSolver.getClassAssignmentProxy(this.request.getSession()), WebSolver.getExamSolver(this.request.getSession()), (InstructionalOfferingListForm)this.form, ((InstructionalOfferingListForm)this.form).getSubjectAreaIds(), this.sessionContext, true, ((InstructionalOfferingListForm)this.form).areAllCoursesGiven());
            out.flush();
            out.close();
            return null;
        }
        return fwd;
    }

    public static void setupInstrOffrListSpecificFormFilters(SessionContext sessionContext, InstructionalOfferingListForm form) {
        form.setDivSec("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.divSec", "0")));
        form.setDemand("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.demand", "1")));
        form.setProjectedDemand("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.projectedDemand", "1")));
        form.setMinPerWk("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.minPerWk", "1")));
        form.setLimit("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.limit", "1")));
        form.setSnapshotLimit("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.snapshotLimit", "1")));
        form.setRoomLimit("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.roomLimit", "1")));
        form.setManager("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.manager", "1")));
        form.setDatePattern("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.datePattern", "1")));
        form.setTimePattern("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.timePattern", "1")));
        form.setInstructor("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.instructor", "1")));
        form.setPreferences("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.preferences", "1")));
        form.setTimetable("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.timetable", "1")));
        form.setCredit("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.credit", "0")));
        form.setSubpartCredit("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.subpartCredit", "0")));
        form.setSchedulePrintNote("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.schedulePrintNote", "1")));
        form.setNote("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.note", "0")));
        form.setTitle("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.title", "0")));
        form.setConsent("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.consent", "0")));
        form.setSortBy(sessionContext.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)));
        form.setExams("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.exams", "0")));
        form.setInstructorAssignment("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.instructorAssignment", "0")));
        if (LearningManagementSystemInfo.isLmsInfoDefinedForSession(sessionContext.getUser().getCurrentAcademicSessionId())) {
            form.setLms("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.lms", "0")));
        } else {
            form.setLms(null);
        }
        if (ApplicationProperty.OfferingWaitListShowFilter.isTrue()) {
            form.setWaitlist(sessionContext.getUser().getProperty("InstructionalOfferingList.waitlist", "A"));
            form.setWaitlistMode("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.waitlistMode", "0")));
        } else {
            form.setWaitlist(null);
            form.setWaitlistMode(null);
        }
        form.setFundingDepartment("1".equals(sessionContext.getUser().getProperty("InstructionalOfferingList.fundingDepartment", "0")));
    }

    public String worksheetPdf() throws Exception {
        String fwd = this.searchInstructionalOfferings();
        if (!this.hasFieldErrors()) {
            ArrayList<SubjectArea> subjectAreas = new ArrayList<SubjectArea>();
            for (String subjectAreaId : ((InstructionalOfferingListForm)this.form).getSubjectAreaIds()) {
                SubjectArea subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(subjectAreaId));
                if (subjectArea == null) continue;
                subjectAreas.add(subjectArea);
            }
            if (subjectAreas.isEmpty()) {
                return fwd;
            }
            OutputStream out = ExportUtils.getPdfOutputStream(this.response, "worksheet");
            PdfWorksheet.print(out, subjectAreas, ((InstructionalOfferingListForm)this.form).getCourseNbr(), ((InstructionalOfferingListForm)this.form).getWaitlist());
            out.flush();
            out.close();
            return null;
        }
        return fwd;
    }

    public static Map<Long, TreeSet<InstructionalOffering>> getInstructionalOfferings(Long sessionId, ClassAssignmentProxy classAssignmentProxy, InstructionalOfferingListForm form) {
        boolean fetchStructure = true;
        boolean fetchCredits = false;
        boolean fetchInstructors = false;
        boolean fetchPreferences = false;
        boolean fetchAssignments = false;
        boolean fetchReservations = false;
        Hashtable<Long, TreeSet<InstructionalOffering>> map = new Hashtable<Long, TreeSet<InstructionalOffering>>();
        for (String subjectAreaId : form.getSubjectAreaIds()) {
            TreeSet<InstructionalOffering> ts = InstructionalOffering.search(sessionId, Long.valueOf(subjectAreaId), form.getCourseNbr(), fetchStructure, fetchCredits, fetchInstructors, fetchPreferences, fetchAssignments, fetchReservations, form.getWaitlist());
            if (ts.isEmpty()) continue;
            map.put(Long.valueOf(subjectAreaId), ts);
        }
        return map;
    }

    public String addInstructionalOfferings() throws Exception {
        CourseOffering course;
        Long subjAreaId = ((InstructionalOfferingListForm)this.form).getSubjectAreaIds() == null || ((InstructionalOfferingListForm)this.form).getSubjectAreaIds().length < 1 ? null : Long.valueOf(((InstructionalOfferingListForm)this.form).getSubjectAreaIds()[0]);
        String courseNbr = ((InstructionalOfferingListForm)this.form).getCourseNbr().trim();
        if (this.hasFieldErrors()) {
            ((InstructionalOfferingListForm)this.form).setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
            if (((InstructionalOfferingListForm)this.form).getInstructionalOfferings() == null || ((InstructionalOfferingListForm)this.form).getInstructionalOfferings().isEmpty()) {
                this.setShowTable(false);
                return "showInstructionalOfferingSearch";
            }
            this.setShowTable(true);
            return "showInstructionalOfferingList";
        }
        if (subjAreaId != null) {
            this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjAreaId.toString());
            this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)courseNbr);
        }
        if (subjAreaId != null && !courseNbr.isEmpty() && ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue() && (course = CourseOffering.findBySessionSubjAreaIdCourseNbr(this.sessionContext.getUser().getCurrentAcademicSessionId(), subjAreaId, courseNbr)) != null) {
            this.setOp("view");
            this.setIo(course.getInstructionalOffering().getUniqueId());
            return "showInstructionalOfferingDetail";
        }
        if (ApplicationProperty.LegacyCourseEdit.isTrue()) {
            this.setOp(MSG.actionAddCourseOffering());
            return "showCourseOfferingEdit";
        }
        this.response.sendRedirect("courseOffering?subjArea=" + String.valueOf(subjAreaId == null ? "" : subjAreaId) + "&courseNbr=" + courseNbr + "&op=addCourseOffering");
        return null;
    }

    public static void setLastInstructionalOffering(SessionContext sessionContext, InstructionalOffering offering) {
        if (offering == null) {
            return;
        }
        String subjectAreaIds = (String)sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
        String subjectAreaId = offering.getControllingCourseOffering().getSubjectArea().getUniqueId().toString();
        if (subjectAreaIds == null) {
            sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjectAreaId);
        } else {
            boolean contain = false;
            for (String s : subjectAreaIds.split(",")) {
                if (!s.equals(subjectAreaId)) continue;
                contain = true;
                break;
            }
            if (!contain && sessionContext.hasPermission(offering.getControllingCourseOffering().getDepartment(), Right.InstructionalOfferings)) {
                sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjectAreaId);
            }
        }
        if (sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber) != null && !sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber).toString().isEmpty()) {
            sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)offering.getControllingCourseOffering().getCourseNbr());
        }
    }

    protected void createTable() throws Exception {
        StringWriter out = new StringWriter();
        new WebInstructionalOfferingTableBuilder().htmlTableForInstructionalOfferings(this.sessionContext, this.getClassAssignmentService().getAssignment(), (ExamAssignmentProxy)this.getExaminationSolverService().getSolver(), (InstructionalOfferingListForm)this.form, ((InstructionalOfferingListForm)this.form).getSubjectAreaIds(), true, ((InstructionalOfferingListForm)this.form).areAllCoursesGiven(), (Writer)out, this.request.getParameter("backType"), this.request.getParameter("backId"));
        out.flush();
        out.close();
        this.request.setAttribute("table", (Object)out.toString());
    }

    public String printTable() throws Exception {
        new WebInstructionalOfferingTableBuilder().htmlTableForInstructionalOfferings(this.sessionContext, this.getClassAssignmentService().getAssignment(), (ExamAssignmentProxy)this.getExaminationSolverService().getSolver(), (InstructionalOfferingListForm)this.form, ((InstructionalOfferingListForm)this.form).getSubjectAreaIds(), true, ((InstructionalOfferingListForm)this.form).areAllCoursesGiven(), (Writer)this.getPageContext().getOut(), this.request.getParameter("backType"), this.request.getParameter("backId"));
        return "";
    }
}

