/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms.neighbourhoods;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.cpsolver.ifs.algorithms.neighbourhoods.RandomSwapMove;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.constant.ConstantModel;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.ToolBox;

public class SuggestionMove<V extends Variable<V, T>, T extends Value<V, T>>
extends RandomSwapMove<V, T> {
    protected int iSuggestionDepth = 3;
    protected int iTimeLimit = 200;

    public SuggestionMove(DataProperties config) throws Exception {
        super(config);
        this.iMaxAttempts = config.getPropertyInt("SuggestionMove.MaxAttempts", this.iMaxAttempts);
        this.iSuggestionDepth = config.getPropertyInt("SuggestionMove.Depth", this.iSuggestionDepth);
        this.iTimeLimit = config.getPropertyInt("SuggestionMove.TimeLimit", this.iTimeLimit);
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        Lock lock = solution.getLock().writeLock();
        lock.lock();
        try {
            Variable variable = null;
            variable = solution.getModel().nrUnassignedVariables(solution.getAssignment()) > 0 ? (Variable)ToolBox.random(solution.getModel().unassignedVariables(solution.getAssignment())) : (Variable)ToolBox.random(solution.getModel().variables());
            RandomSwapMove.SwapNeighbour swapNeighbour = this.backtrack(solution, solution.getModel().getTotalValue(solution.getAssignment()), solution.getModel().nrUnassignedVariables(solution.getAssignment()), JProf.currentTimeMillis(), variable, new HashMap(), new HashMap(), this.iSuggestionDepth);
            return swapNeighbour;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean containsCommited(Solution<V, T> solution, Collection<T> values) {
        ConstantModel model;
        if (solution.getModel() instanceof ConstantModel && (model = (ConstantModel)solution.getModel()).hasConstantVariables()) {
            for (Value value : values) {
                if (!model.isConstant(value.variable())) continue;
                return true;
            }
        }
        return false;
    }

    private RandomSwapMove.SwapNeighbour backtrack(Solution<V, T> solution, double total, int un, long startTime, V initial, Map<V, T> resolvedVariables, HashMap<V, T> conflictsToResolve, int depth) {
        List<T> values;
        Model<V, T> model = solution.getModel();
        Assignment<V, Value> assignment = solution.getAssignment();
        int nrUnassigned = conflictsToResolve.size();
        if (initial == null && nrUnassigned == 0) {
            if (model.nrUnassignedVariables(assignment) > un) {
                return null;
            }
            double value = model.getTotalValue(assignment) - total;
            if (!this.iHC || value <= 0.0) {
                return new RandomSwapMove.SwapNeighbour(new ArrayList<T>(resolvedVariables.values()), un > model.nrUnassignedVariables(assignment) ? -1.0 : value);
            }
            return null;
        }
        if (depth <= 0) {
            return null;
        }
        Object variable = initial;
        if (variable == null) {
            for (Variable l : conflictsToResolve.keySet()) {
                if (resolvedVariables.containsKey(l)) continue;
                variable = l;
                break;
            }
            if (variable == null) {
                return null;
            }
        } else if (resolvedVariables.containsKey(variable)) {
            return null;
        }
        if ((values = ((Variable)variable).values(solution.getAssignment())).isEmpty()) {
            return null;
        }
        int idx = ToolBox.random(values.size());
        int nrAttempts = 0;
        block1: for (int i = 0; i < values.size() && nrAttempts < this.iMaxAttempts && !this.isTimeLimitReached(startTime); ++i) {
            Set<Value> conflicts;
            T cur;
            Value value = (Value)values.get((i + idx) % values.size());
            if (value.equals(cur = assignment.getValue(variable)) || nrUnassigned + (conflicts = model.conflictValues(assignment, value)).size() > depth || conflicts.contains(value) || this.containsCommited(solution, conflicts)) continue;
            for (Value c : conflicts) {
                if (!resolvedVariables.containsKey(c.variable())) continue;
                continue block1;
            }
            for (Value c : conflicts) {
                assignment.unassign(solution.getIteration(), c.variable());
            }
            if (cur != null) {
                assignment.unassign(solution.getIteration(), variable);
            }
            assignment.assign(solution.getIteration(), value);
            for (Value c : conflicts) {
                conflictsToResolve.put((Value)c.variable(), (T)c);
            }
            Value resolvedConf = (Value)conflictsToResolve.remove(variable);
            resolvedVariables.put((Value)variable, (T)value);
            RandomSwapMove.SwapNeighbour n = this.backtrack(solution, total, un, startTime, null, resolvedVariables, conflictsToResolve, depth - 1);
            ++nrAttempts;
            resolvedVariables.remove(variable);
            if (cur == null) {
                assignment.unassign(solution.getIteration(), variable);
            } else {
                assignment.assign(solution.getIteration(), (Value)cur);
            }
            for (Value c : conflicts) {
                assignment.assign(solution.getIteration(), c);
                conflictsToResolve.remove(c.variable());
            }
            if (resolvedConf != null) {
                conflictsToResolve.put((Value)variable, (T)resolvedConf);
            }
            if (n == null) continue;
            return n;
        }
        return null;
    }
}

