/*
 * Decompiled with CFR 0.152.
 */
package biweekly;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum Messages {
    INSTANCE;

    private final transient ResourceBundle messages = ResourceBundle.getBundle("biweekly/messages");

    public String getValidationWarning(int code, Object ... args) {
        return this.getMessage("validate." + code, args);
    }

    public String getParseMessage(int code, Object ... args) {
        return this.getMessage("parse." + code, args);
    }

    public String getExceptionMessage(int code, Object ... args) {
        return this.getMessage("exception." + code, args);
    }

    public IllegalArgumentException getIllegalArgumentException(int code, Object ... args) {
        String message = this.getExceptionMessage(code, args);
        return message == null ? null : new IllegalArgumentException(message);
    }

    public String getMessage(String key, Object ... args) {
        try {
            String message = this.messages.getString(key);
            return MessageFormat.format(message, args);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

