/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.datepicker.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.annotations.IsSafeHtml;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.MonthSelector;
import java.util.Date;

public final class DefaultMonthSelector
extends MonthSelector {
    private PushButton monthBackwards;
    private PushButton monthForwards;
    private FlexTable grid;
    private PushButton yearBackwards;
    private PushButton yearForwards;
    private ListBox monthSelect;
    private ListBox yearSelect;
    private int monthColumn;

    public Element getBackwardButtonElement() {
        return this.monthBackwards.getElement();
    }

    public Element getForwardButtonElement() {
        return this.monthForwards.getElement();
    }

    public Element getYearBackwardButtonElement() {
        return this.yearBackwards.getElement();
    }

    public Element getYearForwardButtonElement() {
        return this.yearForwards.getElement();
    }

    public ListBox getMonthSelectListBox() {
        return this.monthSelect;
    }

    public ListBox getYearSelectListBox() {
        return this.yearSelect;
    }

    @Override
    protected void refresh() {
        if (this.isDatePickerConfigChanged()) {
            this.setupGrid();
        }
        this.setDate(this.getModel().getCurrentMonth());
    }

    @Override
    protected void setup() {
        this.monthBackwards = this.createNavigationButton("&lsaquo;", -1, this.css().previousButton());
        this.monthForwards = this.createNavigationButton("&rsaquo;", 1, this.css().nextButton());
        this.yearBackwards = this.createNavigationButton("&laquo;", -12, this.css().previousYearButton());
        this.yearForwards = this.createNavigationButton("&raquo;", 12, this.css().nextYearButton());
        this.monthSelect = this.createMonthSelect();
        this.yearSelect = this.createYearSelect();
        this.grid = new FlexTable();
        this.grid.setStyleName(this.css().monthSelector());
        this.setupGrid();
        this.initWidget(this.grid);
    }

    private PushButton createNavigationButton(@IsSafeHtml String label, final int noOfMonths, String styleName) {
        PushButton button = new PushButton();
        button.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {
                DefaultMonthSelector.this.addMonths(noOfMonths);
            }
        });
        button.getUpFace().setHTML(label);
        button.setStyleName(styleName);
        return button;
    }

    private ListBox createMonthSelect() {
        final ListBox monthListBox = new ListBox();
        for (int i = 0; i < 12; ++i) {
            monthListBox.addItem(this.getModel().formatMonth(i));
        }
        monthListBox.addChangeHandler(new ChangeHandler(){

            @Override
            public void onChange(ChangeEvent event) {
                int previousMonth = DefaultMonthSelector.this.getModel().getCurrentMonth().getMonth();
                int newMonth = monthListBox.getSelectedIndex();
                int delta = newMonth - previousMonth;
                DefaultMonthSelector.this.addMonths(delta);
            }
        });
        return monthListBox;
    }

    private ListBox createYearSelect() {
        final ListBox yearListBox = new ListBox();
        yearListBox.addChangeHandler(new ChangeHandler(){

            @Override
            public void onChange(ChangeEvent event) {
                int deltaYears = yearListBox.getSelectedIndex() - DefaultMonthSelector.this.getNoOfYearsToDisplayBefore();
                DefaultMonthSelector.this.addMonths(deltaYears * 12);
            }
        });
        return yearListBox;
    }

    private boolean isDatePickerConfigChanged() {
        boolean isMonthCurrentlySelectable = this.monthSelect.getParent() != null;
        boolean isYearNavigationCurrentlyEnabled = this.yearBackwards.getParent() != null;
        return this.getDatePicker().isYearAndMonthDropdownVisible() != isMonthCurrentlySelectable || this.getDatePicker().isYearArrowsVisible() != isYearNavigationCurrentlyEnabled;
    }

    private void setDate(Date date) {
        if (this.getDatePicker().isYearAndMonthDropdownVisible()) {
            int month = date.getMonth();
            this.monthSelect.setSelectedIndex(month);
            this.yearSelect.clear();
            int year = date.getYear();
            int startYear = year - this.getNoOfYearsToDisplayBefore();
            int endYear = year + this.getNoOfYearsToDisplayAfter();
            Date newDate = new Date();
            for (int i = startYear; i <= endYear; ++i) {
                newDate.setYear(i);
                this.yearSelect.addItem(this.getModel().getYearFormatter().format(newDate));
            }
            this.yearSelect.setSelectedIndex(year - startYear);
        } else {
            this.grid.setText(0, this.monthColumn, this.getModel().formatCurrentMonthAndYear());
        }
    }

    private int getNoOfYearsToDisplayBefore() {
        return (this.getDatePicker().getVisibleYearCount() - 1) / 2;
    }

    private int getNoOfYearsToDisplayAfter() {
        return this.getDatePicker().getVisibleYearCount() / 2;
    }

    private void setupGrid() {
        this.grid.removeAllRows();
        this.grid.insertRow(0);
        if (this.getDatePicker().isYearArrowsVisible()) {
            this.addCell(this.yearBackwards, "1");
        }
        this.addCell(this.monthBackwards, "1");
        if (this.getDatePicker().isYearAndMonthDropdownVisible()) {
            if (this.getModel().isMonthBeforeYear()) {
                this.addCell(this.monthSelect, "50%", this.css().month());
                this.addCell(this.yearSelect, "50%", this.css().year());
            } else {
                this.addCell(this.yearSelect, "50%", this.css().year());
                this.addCell(this.monthSelect, "50%", this.css().month());
            }
        } else {
            this.monthColumn = this.addCell(null, "100%", this.css().month());
        }
        this.addCell(this.monthForwards, "1");
        if (this.getDatePicker().isYearArrowsVisible()) {
            this.addCell(this.yearForwards, "1");
        }
    }

    private int addCell(Widget widget, String width) {
        return this.addCell(widget, width, null);
    }

    private int addCell(Widget widget, String width, String className) {
        int cell = this.grid.getCellCount(0);
        this.grid.setWidget(0, cell, widget);
        this.grid.getCellFormatter().setWidth(0, cell, width);
        if (className != null) {
            this.grid.getCellFormatter().setStyleName(0, cell, className);
        }
        return cell;
    }
}

