/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.reservation;

import java.util.Collection;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.reservation.GroupReservation;

public class LearningCommunityReservation
extends GroupReservation {
    private Course iCourse;
    public static final int DEFAULT_PRIORITY = 250;
    public static final boolean DEFAULT_MUST_BE_USED = true;
    public static final boolean DEFAULT_CAN_ASSIGN_OVER_LIMIT = false;
    public static final boolean DEFAULT_ALLOW_OVERLAP = false;

    public LearningCommunityReservation(long id, double limit, Course course, Long ... studentIds) {
        super(id, limit, course.getOffering(), 250, true, false, false, studentIds);
        this.iCourse = course;
    }

    public LearningCommunityReservation(long id, double limit, Course course, Collection<Long> studentIds) {
        super(id, limit, course.getOffering(), 250, true, false, false, studentIds);
        this.iCourse = course;
    }

    @Override
    public double getReservationLimit() {
        if (super.getReservationLimit() < 0.0) {
            return this.iCourse.getLimit();
        }
        if ((double)this.iCourse.getLimit() < 0.0) {
            return super.getReservationLimit();
        }
        return Math.min(super.getReservationLimit(), (double)this.iCourse.getLimit());
    }

    public Course getCourse() {
        return this.iCourse;
    }

    @Override
    public boolean isApplicable(Student student) {
        if (!super.isApplicable(student)) {
            return false;
        }
        for (Request r : student.getRequests()) {
            if (!(r instanceof CourseRequest)) continue;
            for (Course course : ((CourseRequest)r).getCourses()) {
                if (!course.equals(this.getCourse())) continue;
                return true;
            }
        }
        return false;
    }
}

