/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcTimeJavaType
extends AbstractTemporalJavaType<java.util.Date> {
    public static final JdbcTimeJavaType INSTANCE = new JdbcTimeJavaType();
    public static final String TIME_FORMAT = "HH:mm:ss.SSS";
    public static final DateTimeFormatter LITERAL_FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;
    public static final DateTimeFormatter LOGGABLE_FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;
    private static final DateTimeFormatter ENCODED_FORMATTER = new DateTimeFormatterBuilder().optionalStart().append(DateTimeFormatter.ISO_DATE).appendLiteral('T').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

    public JdbcTimeJavaType() {
        super(Time.class, TimeMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIME;
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof java.util.Date && !(value instanceof Date);
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        int hashCode = 1;
        hashCode = 31 * hashCode + calendar.get(11);
        hashCode = 31 * hashCode + calendar.get(12);
        hashCode = 31 * hashCode + calendar.get(13);
        hashCode = 31 * hashCode + calendar.get(14);
        return hashCode;
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        if (one.getTime() == another.getTime()) {
            return true;
        }
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(one);
        calendar2.setTime(another);
        return calendar1.get(11) == calendar2.get(11) && calendar1.get(12) == calendar2.get(12) && calendar1.get(13) == calendar2.get(13) && calendar1.get(14) == calendar2.get(14);
    }

    @Override
    public java.util.Date coerce(Object value, JavaType.CoercionContext coercionContext) {
        return this.wrap(value, (WrapperOptions)null);
    }

    @Override
    public Object unwrap(java.util.Date value, Class type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (LocalTime.class.isAssignableFrom(type)) {
            Time time = value instanceof Time ? (Time)value : new Time(value.getTime() % 86400000L);
            LocalTime localTime = time.toLocalTime();
            long millis = time.getTime() % 1000L;
            if (millis == 0L) {
                return localTime;
            }
            if (millis < 0L) {
                millis += 1000L;
            }
            return localTime.with(ChronoField.NANO_OF_SECOND, millis * 1000000L);
        }
        if (Time.class.isAssignableFrom(type)) {
            return value instanceof Time ? value : new Time(value.getTime() % 86400000L);
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return value;
        }
        if (Long.class.isAssignableFrom(type)) {
            return value.getTime();
        }
        if (String.class.isAssignableFrom(type)) {
            return this.toString(value);
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(value.getTime());
            return cal;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return new Timestamp(value.getTime());
        }
        if (Date.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Illegal attempt to treat `java.sql.Time` as `java.sql.Date`");
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public java.util.Date wrap(Object value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return (java.util.Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Time(((java.util.Date)value).getTime() % 86400000L);
        }
        if (value instanceof LocalTime) {
            LocalTime localTime = (LocalTime)value;
            Time time = Time.valueOf(localTime);
            if (localTime.getNano() == 0) {
                return time;
            }
            return new Time(time.getTime() + DateTimeUtils.roundToPrecision(localTime.getNano(), 3) / 1000000L);
        }
        if (value instanceof Long) {
            return new Time((Long)value);
        }
        if (value instanceof Calendar) {
            return new Time(((Calendar)value).getTimeInMillis() % 86400000L);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public String toString(java.util.Date value) {
        if (value instanceof Time) {
            return LITERAL_FORMATTER.format(((Time)value).toLocalTime());
        }
        return LITERAL_FORMATTER.format(LocalTime.ofInstant(value.toInstant(), ZoneOffset.systemDefault()));
    }

    @Override
    public java.util.Date fromString(CharSequence string) {
        try {
            TemporalAccessor accessor = LITERAL_FORMATTER.parse(string);
            LocalTime localTime = LocalTime.from(accessor);
            Time time = Time.valueOf(localTime);
            time.setTime(time.getTime() + (long)(localTime.getNano() / 1000000));
            return time;
        }
        catch (DateTimeParseException pe) {
            throw new HibernateException("could not parse time string " + String.valueOf(string), pe);
        }
    }

    @Override
    public java.util.Date fromEncodedString(CharSequence charSequence, int start, int end) {
        try {
            TemporalAccessor accessor = ENCODED_FORMATTER.parse(CharSequenceHelper.subSequence(charSequence, start, end));
            return Time.valueOf(accessor.query(LocalTime::from));
        }
        catch (DateTimeParseException pe) {
            throw new HibernateException("could not parse time string " + String.valueOf(charSequence), pe);
        }
    }

    @Override
    public void appendEncodedString(SqlAppender sb, java.util.Date value) {
        if (value instanceof Time) {
            LITERAL_FORMATTER.formatTo(((Time)value).toLocalTime(), sb);
        } else {
            LITERAL_FORMATTER.formatTo(LocalTime.ofInstant(value.toInstant(), ZoneOffset.systemDefault()), sb);
        }
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getJdbcType(92);
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultTimestampPrecision();
    }

    @Override
    protected <X> TemporalJavaType<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    public static class TimeMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final TimeMutabilityPlan INSTANCE = new TimeMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            return new Time(value.getTime());
        }
    }
}

