/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.internal.QueryLiteralHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmLiteral<T>
extends AbstractSqmExpression<T> {
    private final T value;

    public SqmLiteral(T value, SqmExpressible<? super T> inherentType, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        assert (value != null && (inherentType == null || inherentType.getExpressibleJavaType().isInstance(value)));
        this.value = value;
    }

    protected SqmLiteral(SqmExpressible<T> inherentType, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        this.value = null;
    }

    @Override
    public SqmLiteral<T> copy(SqmCopyContext context) {
        SqmLiteral existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmLiteral<T> expression = context.registerCopy(this, new SqmLiteral<T>(this.getLiteralValue(), this.getNodeType(), this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    public T getLiteralValue() {
        return this.value;
    }

    public <R> R accept(SemanticQueryWalker<R> walker) {
        return walker.visitLiteral(this);
    }

    @Override
    public String asLoggableText() {
        return "Literal( " + String.valueOf(this.getLiteralValue()) + ")";
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        SqmLiteral.appendHqlString(sb, this.getJavaTypeDescriptor(), this.getLiteralValue());
    }

    public static <T> void appendHqlString(StringBuilder sb, JavaType<T> javaType, @Nullable T value) {
        if (value == null) {
            sb.append("null");
        } else {
            String string = javaType.toString(value);
            if (javaType.getJavaTypeClass() == String.class) {
                QueryLiteralHelper.appendStringLiteral(sb, string);
            } else {
                sb.append(string);
            }
        }
    }
}

