/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgroups.util.LongTuple;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SeqnoList;

public abstract class Buffer<T>
implements Iterable<T>,
Closeable {
    protected final Lock lock = new ReentrantLock();
    protected final AtomicInteger adders = new AtomicInteger(0);
    protected long offset;
    protected long low;
    protected long hd;
    protected long high;
    protected int size;

    public Lock lock() {
        return this.lock;
    }

    public AtomicInteger getAdders() {
        return this.adders;
    }

    public long offset() {
        return this.offset;
    }

    public long low() {
        return this.low;
    }

    public long highestDelivered() {
        return this.hd;
    }

    public long hd() {
        return this.hd;
    }

    public long high() {
        return this.high;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public abstract int capacity();

    public void resetStats() {
    }

    public void open(boolean b) {
    }

    @Override
    public void close() {
        this.open(false);
    }

    public boolean add(long seqno, T element) {
        return this.add(seqno, element, null);
    }

    public abstract boolean add(long var1, T var3, Predicate<T> var4);

    public abstract boolean add(MessageBatch var1, Function<T, Long> var2, boolean var3, T var4);

    public abstract boolean add(List<LongTuple<T>> var1, boolean var2, T var3);

    public abstract T get(long var1);

    public abstract T _get(long var1);

    public T remove() {
        return this.remove(true);
    }

    public abstract T remove(boolean var1);

    public List<T> removeMany(boolean nullify, int max_results) {
        return this.removeMany(nullify, max_results, null);
    }

    public abstract List<T> removeMany(boolean var1, int var2, Predicate<T> var3);

    public abstract <R> R removeMany(boolean var1, int var2, Predicate<T> var3, Supplier<R> var4, BiConsumer<R, T> var5);

    public int purge(long seqno) {
        return this.purge(seqno, false);
    }

    public abstract int purge(long var1, boolean var3);

    public void forEach(Visitor<T> visitor, boolean nullify) {
        this.forEach(this.highestDelivered() + 1L, this.high(), visitor, nullify);
    }

    public abstract void forEach(long var1, long var3, Visitor<T> var5, boolean var6);

    public abstract Iterator<T> iterator(long var1, long var3);

    public abstract Stream<T> stream();

    public abstract Stream<T> stream(long var1, long var3);

    public int computeSize() {
        return (int)this.stream().filter(Objects::nonNull).count();
    }

    public int numMissing() {
        this.lock.lock();
        try {
            int n = (int)(this.high - this.hd - (long)this.size);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SeqnoList getMissing() {
        return this.getMissing(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeqnoList getMissing(int max_msgs) {
        this.lock.lock();
        try {
            int max_size;
            if (this.isEmpty()) {
                SeqnoList seqnoList = null;
                return seqnoList;
            }
            long start_seqno = this.getHighestDeliverable() + 1L;
            int capacity = (int)(this.high - start_seqno);
            int n = max_size = max_msgs > 0 ? Math.min(max_msgs, capacity) : capacity;
            if (max_size <= 0) {
                SeqnoList seqnoList = null;
                return seqnoList;
            }
            Missing missing = new Missing(start_seqno, max_size);
            long to = max_size > 0 ? Math.min(start_seqno + (long)max_size - 1L, this.high - 1L) : this.high - 1L;
            this.forEach(start_seqno, to, missing, false);
            SeqnoList seqnoList = missing.getMissingElements();
            return seqnoList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getNumDeliverable() {
        NumDeliverable visitor = new NumDeliverable();
        this.lock.lock();
        try {
            this.forEach(visitor, false);
            int n = visitor.getResult();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestDeliverable() {
        HighestDeliverable visitor = new HighestDeliverable();
        this.lock.lock();
        try {
            this.forEach(visitor, false);
            long retval = visitor.getResult();
            long l = retval == -1L ? this.highestDelivered() : retval;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long[] getDigest() {
        this.lock.lock();
        try {
            long[] lArray = new long[]{this.hd, this.high};
            return lArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer<T> highestDelivered(long seqno) {
        this.lock.lock();
        try {
            this.hd = seqno;
            Buffer buffer = this;
            return buffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String dump() {
        this.lock.lock();
        try {
            String string = this.stream(this.low(), this.high()).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(", "));
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return String.format("[%,d | %,d | %,d] (size: %,d, missing: %,d)", this.low, this.hd, this.high, this.size, this.numMissing());
    }

    protected class Missing
    implements Visitor<T> {
        protected final SeqnoList missing_elements;
        protected final int max_num_msgs;
        protected int num_msgs;

        protected Missing(long start, int max_number_of_msgs) {
            this.missing_elements = new SeqnoList(max_number_of_msgs, start);
            this.max_num_msgs = max_number_of_msgs;
        }

        protected SeqnoList getMissingElements() {
            return this.missing_elements;
        }

        @Override
        public boolean visit(long seqno, T element) {
            if (element == null) {
                if (++this.num_msgs > this.max_num_msgs) {
                    return false;
                }
                this.missing_elements.add(seqno);
            }
            return true;
        }
    }

    protected class HighestDeliverable
    implements Visitor<T> {
        protected long highest_deliverable = -1L;

        protected HighestDeliverable() {
        }

        public long getResult() {
            return this.highest_deliverable;
        }

        @Override
        public boolean visit(long seqno, T element) {
            if (element == null) {
                return false;
            }
            this.highest_deliverable = seqno;
            return true;
        }
    }

    protected class NumDeliverable
    implements Visitor<T> {
        protected int num_deliverable = 0;

        protected NumDeliverable() {
        }

        public int getResult() {
            return this.num_deliverable;
        }

        @Override
        public boolean visit(long seqno, T element) {
            if (element == null) {
                return false;
            }
            ++this.num_deliverable;
            return true;
        }
    }

    protected class Remover<R>
    implements Visitor<T> {
        protected final int max_results;
        protected int num_results;
        protected final Predicate<T> filter;
        protected R result;
        protected Supplier<R> result_creator;
        protected BiConsumer<R, T> result_accumulator;

        public Remover(int max_results, Predicate<T> filter, Supplier<R> creator, BiConsumer<R, T> accumulator) {
            this.max_results = max_results;
            this.filter = filter;
            this.result_creator = creator;
            this.result_accumulator = accumulator;
        }

        public R getResult() {
            return this.result;
        }

        @Override
        public boolean visit(long seqno, T element) {
            if (element == null) {
                return false;
            }
            if (this.filter == null || this.filter.test(element)) {
                if (this.result == null) {
                    this.result = this.result_creator.get();
                }
                this.result_accumulator.accept(this.result, element);
                ++this.num_results;
            }
            Buffer.this.size = Math.max(Buffer.this.size - 1, 0);
            if (seqno - Buffer.this.hd > 0L) {
                Buffer.this.hd = seqno;
            }
            return this.max_results == 0 || this.num_results < this.max_results;
        }
    }

    public static interface Visitor<T> {
        public boolean visit(long var1, T var3);
    }
}

