/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=OfferingsInterface.OfferingsFilterRequest.class)
public class OfferingsFilterBackend
implements GwtRpcImplementation<OfferingsInterface.OfferingsFilterRequest, OfferingsInterface.OfferingsFilterResponse> {
    protected static CourseMessages MESSAGES = Localization.create(CourseMessages.class);

    @Override
    public OfferingsInterface.OfferingsFilterResponse execute(OfferingsInterface.OfferingsFilterRequest request, SessionContext context) {
        context.checkPermission(Right.InstructionalOfferings);
        OfferingsInterface.OfferingsFilterResponse filter = new OfferingsInterface.OfferingsFilterResponse();
        filter.addParameter(this.createToggle(context, "divSec", MESSAGES.columnExternalId(), false));
        filter.addParameter(this.createToggle(context, "enrollmentInformation", MESSAGES.columnEnrollmentInformation(), null));
        filter.addParameter(this.createToggle(context, "demand", MESSAGES.columnDemand(), true, "enrollmentInformation"));
        filter.addParameter(this.createToggle(context, "projectedDemand", MESSAGES.columnProjectedDemand(), true, "enrollmentInformation"));
        filter.addParameter(this.createToggle(context, "limit", MESSAGES.columnLimit(), true, "enrollmentInformation"));
        filter.addParameter(this.createToggle(context, "snapshotLimit", MESSAGES.columnSnapshotLimit(), false, "enrollmentInformation"));
        filter.addParameter(this.createToggle(context, "roomLimit", MESSAGES.columnRoomRatio(), true, "enrollmentInformation"));
        this.setParentDefault(filter, "enrollmentInformation");
        filter.addParameter(this.createToggle(context, "manager", MESSAGES.columnManager(), true));
        if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
            filter.addParameter(this.createToggle(context, "fundingDepartment", MESSAGES.columnFundingDepartment(), false));
        }
        filter.addParameter(this.createToggle(context, "dateTimeInformation", MESSAGES.columnDateTimeInformation(), null));
        filter.addParameter(this.createToggle(context, "datePattern", MESSAGES.columnDatePattern(), true, "datePattern"));
        filter.addParameter(this.createToggle(context, "minPerWk", MESSAGES.columnMinPerWk(), true, "datePattern"));
        filter.addParameter(this.createToggle(context, "timePattern", MESSAGES.columnTimePattern(), true, "datePattern"));
        this.setParentDefault(filter, "dateTimeInformation");
        filter.addParameter(this.createToggle(context, "preferences", MESSAGES.columnPreferences(), true));
        filter.addParameter(this.createToggle(context, "instructorAssignment", MESSAGES.includeInstructorScheduling(), false));
        filter.addParameter(this.createToggle(context, "instructor", MESSAGES.columnInstructor(), true));
        filter.addParameter(this.createToggle(context, "timetable", MESSAGES.columnTimetable(), true));
        filter.addParameter(this.createToggle(context, "catalogInformation", MESSAGES.columnCatalogInformation(), false));
        filter.addParameter(this.createToggle(context, "title", MESSAGES.columnTitle(), false, "catalogInformation"));
        filter.addParameter(this.createToggle(context, "credit", MESSAGES.columnOfferingCredit(), false, "catalogInformation"));
        filter.addParameter(this.createToggle(context, "subpartCredit", MESSAGES.columnSubpartCredit(), false, "catalogInformation"));
        filter.addParameter(this.createToggle(context, "consent", MESSAGES.columnConsent(), false, "catalogInformation"));
        filter.addParameter(this.createToggle(context, "schedulePrintNote", MESSAGES.columnSchedulePrintNote(), true, "catalogInformation"));
        this.setParentDefault(filter, "catalogInformation");
        if (LearningManagementSystemInfo.isLmsInfoDefinedForSession(context.getUser().getCurrentAcademicSessionId())) {
            filter.addParameter(this.createToggle(context, "lms", MESSAGES.columnLms(), false));
        }
        filter.addParameter(this.createToggle(context, "note", MESSAGES.columnNote(), false));
        if (context.hasPermission(Right.Examinations)) {
            filter.addParameter(this.createToggle(context, "exams", MESSAGES.columnExams(), false));
        }
        if (ApplicationProperty.OfferingWaitListShowFilter.isTrue()) {
            filter.addParameter(this.createToggle(context, "waitlistMode", MESSAGES.columnWaitlistMode(), false));
        }
        FilterInterface.FilterParameterInterface sortBy = new FilterInterface.FilterParameterInterface();
        sortBy.setName("sortBy");
        sortBy.setLabel(MESSAGES.filterSortBy());
        sortBy.setType("list");
        for (String name : ClassCourseComparator.getNames()) {
            sortBy.addOption(name, name);
        }
        sortBy.setDefaultValue(context.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)));
        filter.addParameter(sortBy);
        if (ApplicationProperty.OfferingWaitListShowFilter.isTrue()) {
            FilterInterface.FilterParameterInterface waitlist = new FilterInterface.FilterParameterInterface();
            waitlist.setName("waitlist");
            waitlist.setLabel(MESSAGES.filterWaitlist());
            waitlist.setType("list");
            waitlist.setDefaultValue(context.getUser().getProperty("InstructionalOfferingList.waitlist", "A"));
            waitlist.addOption("A", MESSAGES.itemWaitListAllCourses());
            waitlist.addOption("W", MESSAGES.itemWaitListWaitListed());
            waitlist.addOption("N", MESSAGES.itemWaitListNotWaitListed());
            waitlist.addOption("R", MESSAGES.itemWaitListReschedule());
            waitlist.addOption("Z", MESSAGES.itemWaitListNotWaitListedReschedule());
            waitlist.addOption("X", MESSAGES.itemWaitListNotReschedule());
            waitlist.setCollapsible(false);
            filter.addParameter(waitlist);
        }
        FilterInterface.FilterParameterInterface subjectArea = new FilterInterface.FilterParameterInterface();
        subjectArea.setName("subjectArea");
        subjectArea.setType("list");
        subjectArea.setMultiSelect(true);
        subjectArea.setCollapsible(false);
        subjectArea.setLabel(MESSAGES.filterSubject());
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser())) {
            subjectArea.addOption(subject.getUniqueId().toString(), subject.getLabel());
        }
        subjectArea.setDefaultValue((String)context.getAttribute(SessionAttribute.OfferingsSubjectArea));
        subjectArea.setEnterToSubmit(true);
        filter.addParameter(subjectArea);
        FilterInterface.FilterParameterInterface courseNbr = new FilterInterface.FilterParameterInterface();
        courseNbr.setName("courseNbr");
        courseNbr.setLabel(MESSAGES.filterCourseNumber());
        courseNbr.setType("courseNumber");
        courseNbr.setDefaultValue((String)context.getAttribute(SessionAttribute.OfferingsCourseNumber));
        courseNbr.setCollapsible(false);
        courseNbr.setConfig("subjectId=${subjectArea};notOffered=include;waitlist=${waitlist}");
        courseNbr.setEnterToSubmit(true);
        filter.addParameter(courseNbr);
        if (subjectArea.getDefaultValue() == null && courseNbr.getDefaultValue() == null) {
            subjectArea.setDefaultValue((String)context.getAttribute(SessionAttribute.ClassesSubjectAreas));
            courseNbr.setDefaultValue((String)context.getAttribute(SessionAttribute.ClassesCourseNumber));
        }
        filter.setSticky(CommonValues.Yes.eq(UserProperty.StickyTables.get(context.getUser())));
        filter.setMaxSubjectsToSearchAutomatically(ApplicationProperty.MaxSubjectsToSearchAutomatically.intValue());
        filter.setCanAdd(context.hasPermission(Right.AddCourseOffering));
        filter.setCanExport(context.hasPermission(Right.InstructionalOfferingsExportPDF));
        filter.setCanWorksheet(context.hasPermission(Right.InstructionalOfferingsWorksheetPDF));
        filter.setSessionId(context.getUser().getCurrentAcademicSessionId());
        BackTracker.markForBack(context, null, null, false, true);
        return filter;
    }

    protected FilterInterface.FilterParameterInterface createToggle(SessionContext context, String name, String label, Boolean defaultValue) {
        return this.createToggle(context, name, label, defaultValue, null);
    }

    protected FilterInterface.FilterParameterInterface createToggle(SessionContext context, String name, String label, Boolean defaultValue, String parent) {
        FilterInterface.FilterParameterInterface toggle = new FilterInterface.FilterParameterInterface();
        toggle.setName(name);
        toggle.setLabel(MESSAGES.filterOptionalColumns());
        toggle.setType("boolean");
        toggle.setSuffix(label);
        toggle.setDefaultValue(context.getUser().getProperty("InstructionalOfferingList." + name, defaultValue == null ? null : (defaultValue != false ? "1" : "0")));
        if (parent != null) {
            toggle.setParent(parent);
        }
        return toggle;
    }

    protected void setParentDefault(FilterInterface filter, String parent) {
        FilterInterface.FilterParameterInterface toggle = null;
        int checked = 0;
        for (FilterInterface.FilterParameterInterface p : filter.getParameters()) {
            if (parent.equals(p.getName())) {
                toggle = p;
                continue;
            }
            if (!parent.equals(p.getParent()) || !"1".equals(p.getDefaultValue())) continue;
            ++checked;
        }
        if (toggle != null) {
            toggle.setDefaultValue(checked > 0 ? "1" : "0");
        }
    }
}

