/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.commons.Email;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseUrlProvider;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.updates.ReloadOfferingAction;
import org.unitime.timetable.onlinesectioning.updates.StudentEmail;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

public class InstructorEmail
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = -6796065761126518698L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static GwtMessages GWT = Localization.create(GwtMessages.class);
    private static Formats.Format<Date> sTimeStampFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    private Date iTimeStamp = new Date();
    private InstructorChange iChange;
    private CourseUrlProvider iCourseUrlProvider = null;

    public InstructorEmail forChange(InstructorChange ic) {
        this.iChange = ic;
        return this;
    }

    public InstructorChange getInstructorChange() {
        return this.iChange;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningLog.Enrollment.Builder enrollment;
        try {
            String providerClass = ApplicationProperty.CustomizationCourseLink.value();
            if (providerClass != null) {
                this.iCourseUrlProvider = (CourseUrlProvider)Class.forName(providerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception providerClass) {
            // empty catch block
        }
        XInstructor instructor = this.getInstructorChange().getInstructor();
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setExternalId(instructor.getExternalId()).setName(helper.getInstructorNameFormat().format(instructor)));
        if (this.getInstructorChange().getOldOffering() != null) {
            enrollment = OnlineSectioningLog.Enrollment.newBuilder();
            enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
            for (XSection section : this.getInstructorChange().getOldSections()) {
                enrollment.addSection(OnlineSectioningHelper.toProto(section, null));
            }
        }
        if (this.getInstructorChange().getNewOffering() != null) {
            enrollment = OnlineSectioningLog.Enrollment.newBuilder();
            enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
            for (XSection section : this.getInstructorChange().getNewSections()) {
                enrollment.addSection(OnlineSectioningHelper.toProto(section, null));
            }
        }
        try {
            TimetableManager manager;
            Email email = Email.createEmail();
            email.addRecipient(instructor.getEmail(), helper.getInstructorNameFormat().format(instructor));
            helper.logOption("recipient", instructor.getEmail());
            String subject = MSG.emailInstructorChangeSubject().replace("%session%", server.getAcademicSession().toString());
            email.setSubject(subject);
            helper.logOption("subject", subject);
            if (helper.getUser() != null && (manager = (TimetableManager)helper.getHibSession().createQuery("from TimetableManager where externalUniqueId = :id", TimetableManager.class).setParameter("id", (Object)helper.getUser().getExternalId()).uniqueResult()) != null && manager.getEmailAddress() != null) {
                email.setReplyTo(manager.getEmailAddress(), helper.getInstructorNameFormat().format(manager));
                helper.logOption("reply-to", helper.getInstructorNameFormat().format(manager) + " <" + manager.getEmailAddress() + ">");
            }
            String html = this.generateMessage(server, helper);
            email.setHTML(html);
            helper.logOption("email", html);
            email.send();
            return true;
        }
        catch (Exception e) {
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(e.getMessage(), e);
        }
    }

    protected String generateMessage(OnlineSectioningServer server, OnlineSectioningHelper helper) throws IOException, TemplateException {
        XSection parent;
        String requires;
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
        cfg.setClassForTemplateLoading(StudentEmail.class, "/");
        cfg.setLocale(Localization.getJavaLocale());
        cfg.setOutputEncoding("utf-8");
        Template template = cfg.getTemplate(ApplicationProperty.NotificationsInstructorChangeEmailTemplate.value());
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("msg", MSG);
        input.put("instructor", this.getInstructorChange().getInstructor());
        input.put("course", this.getInstructorChange().getCourse());
        input.put("name", helper.getInstructorNameFormat().format(this.getInstructorChange().getInstructor()));
        input.put("server", server);
        input.put("helper", helper);
        boolean checkAssignment = ApplicationProperty.NotificationsInstructorChangesCheckShare.isTrue();
        input.put("showAssignmentColumn", checkAssignment);
        StudentEmail.Table listOfChanges = new StudentEmail.Table();
        ArrayList<XSection> remaining = new ArrayList<XSection>(this.getInstructorChange().getNewSections());
        String instructorId = this.getInstructorChange().getInstructor().getExternalId();
        block0: for (XSection oldSection : this.getInstructorChange().getOldSections()) {
            Iterator i = remaining.iterator();
            while (i.hasNext()) {
                XSection parent2;
                XSection parentOld;
                XSection newSection = (XSection)i.next();
                if (!newSection.getSectionId().equals(oldSection.getSectionId())) continue;
                String requiresOld = null;
                XSection xSection = parentOld = oldSection.getParentId() == null ? null : this.getInstructorChange().getOldOffering().getSection(oldSection.getParentId());
                if (parentOld != null) {
                    requiresOld = parentOld.getName(this.getInstructorChange().getOldOffering().getControllingCourse().getCourseId());
                }
                String requires2 = null;
                XSection xSection2 = parent2 = newSection.getParentId() == null ? null : this.getInstructorChange().getNewOffering().getSection(newSection.getParentId());
                if (parent2 != null) {
                    requires2 = parent2.getName(this.getInstructorChange().getNewOffering().getControllingCourse().getCourseId());
                }
                i.remove();
                if (oldSection.isCancelled() && newSection.isCancelled()) continue block0;
                listOfChanges.add(new InstructorTableSectionModifiedLine(this.getInstructorChange().getCourse(), instructorId, this.getInstructorChange().getOldOffering().getSubpart(oldSection.getSubpartId()), this.getInstructorChange().getNewOffering().getSubpart(newSection.getSubpartId()), oldSection, newSection, requiresOld, requires2, this.getCourseUrl(server.getAcademicSession(), this.getInstructorChange().getCourse())));
                continue block0;
            }
            requires = null;
            XSection xSection = parent = oldSection.getParentId() == null ? null : this.getInstructorChange().getOldOffering().getSection(oldSection.getParentId());
            if (parent != null) {
                requires = parent.getName(this.getInstructorChange().getOldOffering().getControllingCourse().getCourseId());
            }
            listOfChanges.add(new InstructorTableSectionDeletedLine(instructorId, this.getInstructorChange().getCourse(), this.getInstructorChange().getOldOffering().getSubpart(oldSection.getSubpartId()), oldSection, requires, this.getCourseUrl(server.getAcademicSession(), this.getInstructorChange().getCourse())));
        }
        for (XSection newSection : remaining) {
            requires = null;
            XSection xSection = parent = newSection.getParentId() == null ? null : this.getInstructorChange().getNewOffering().getSection(newSection.getParentId());
            if (parent != null) {
                requires = parent.getName(this.getInstructorChange().getNewOffering().getControllingCourse().getCourseId());
            }
            listOfChanges.add(new InstructorTableSectionAddedLine(instructorId, this.getInstructorChange().getCourse(), this.getInstructorChange().getNewOffering().getSubpart(newSection.getSubpartId()), newSection, requires, this.getCourseUrl(server.getAcademicSession(), this.getInstructorChange().getCourse())));
        }
        input.put("changes", listOfChanges);
        input.put("subject", MSG.emailInstructorChangeSubject().replace("%session%", server.getAcademicSession().toString()));
        if (ApplicationProperty.NotificationsInstructorChangesIncludeSchedule.isTrue()) {
            StudentEmail.Table classes = new StudentEmail.Table();
            Collection<Long> offerings = server.getInstructedOfferings(instructorId);
            if (offerings != null) {
                for (Long offeringId : offerings) {
                    XOffering offering = server.getOffering(offeringId);
                    if (offering == null) continue;
                    for (XConfig config : offering.getConfigs()) {
                        for (XSubpart subpart : config.getSubparts()) {
                            for (XSection section : subpart.getSections()) {
                                if (section.isCancelled()) continue;
                                for (XInstructor instructor : section.getAllInstructors()) {
                                    XSection parent3;
                                    if (!instructorId.equals(instructor.getExternalId())) continue;
                                    String requires3 = null;
                                    XSection xSection = parent3 = section.getParentId() == null ? null : offering.getSection(section.getParentId());
                                    if (parent3 != null) {
                                        requires3 = parent3.getName(offering.getControllingCourse().getCourseId());
                                    }
                                    classes.add(new InstructorTableSectionLine(instructorId, offering.getControllingCourse(), subpart, section, requires3, this.getCourseUrl(server.getAcademicSession(), this.getInstructorChange().getCourse())));
                                }
                            }
                        }
                    }
                }
            }
            input.put("classes", classes);
        }
        input.put("version", GWT.pageVersion(Constants.getVersion(), Constants.getReleaseDate()));
        input.put("copyright", GWT.pageCopyright());
        input.put("ts", sTimeStampFormat.format(this.getTimeStamp()));
        if (ApplicationProperty.NotificationsInstructorChangesIncludeLink.isTrue()) {
            input.put("link", ApplicationProperty.UniTimeUrl.value());
        }
        StringWriter s = new StringWriter();
        template.process(input, (Writer)new PrintWriter(s));
        s.flush();
        s.close();
        return s.toString();
    }

    protected URL getCourseUrl(AcademicSessionInfo session, XCourse course) {
        if (this.iCourseUrlProvider == null) {
            return null;
        }
        return this.iCourseUrlProvider.getCourseUrl(session, course.getSubjectArea(), course.getCourseNumber());
    }

    @Override
    public String name() {
        return "instructor-email";
    }

    public static boolean sameTime(boolean checkTime, XSection oldSection, XSection newSection) {
        if (!checkTime) {
            return true;
        }
        return ReloadOfferingAction.sameTime(newSection, oldSection.getTime());
    }

    public static boolean sameRoom(boolean checkRoom, XSection oldSection, XSection newSection) {
        if (!checkRoom) {
            return true;
        }
        return ReloadOfferingAction.sameRooms(newSection, oldSection.getRooms());
    }

    public static boolean sameShare(boolean checkShare, XInstructor i1, XInstructor i2) {
        if (!checkShare) {
            return true;
        }
        return ToolBox.equals((Object)i1.getPercentShare(), (Object)i2.getPercentShare()) && ToolBox.equals((Object)i1.getResponsibility(), (Object)i2.getResponsibility()) && i1.isAllowOverlap() == i2.isAllowOverlap();
    }

    public static boolean sameCancellation(boolean checkCancellations, XSection oldSection, XSection newSection) {
        if (!checkCancellations) {
            return true;
        }
        return newSection.isCancelled() == oldSection.isCancelled();
    }

    public static class InstructorChange
    implements Serializable {
        private static final long serialVersionUID = -4307771609804985028L;
        XInstructor iOldInstructor;
        XInstructor iNewInstructor;
        XOffering iOldOffering;
        XOffering iNewOffering;
        List<XSection> iOldSections = new ArrayList<XSection>();
        List<XSection> iNewSections = new ArrayList<XSection>();

        InstructorChange() {
        }

        public void setOldInstructor(XInstructor instructor) {
            this.iOldInstructor = instructor;
        }

        public XInstructor getOldInstructor() {
            return this.iOldInstructor;
        }

        public void setNewInstructor(XInstructor instructor) {
            this.iNewInstructor = instructor;
        }

        public XInstructor getNewInstructor() {
            return this.iNewInstructor;
        }

        public XInstructor getInstructor() {
            return this.iNewInstructor != null ? this.iNewInstructor : this.iOldInstructor;
        }

        public void setOldOffering(XOffering offering) {
            this.iOldOffering = offering;
        }

        public XOffering getOldOffering() {
            return this.iOldOffering;
        }

        public void setNewOffering(XOffering offering) {
            this.iNewOffering = offering;
        }

        public XOffering getNewOffering() {
            return this.iNewOffering;
        }

        public XOffering getOffering() {
            return this.iNewOffering != null ? this.iNewOffering : this.iOldOffering;
        }

        public XCourse getCourse() {
            return this.getOffering().getControllingCourse();
        }

        public void addOldSection(XSection section) {
            this.iOldSections.add(section);
        }

        public List<XSection> getOldSections() {
            return this.iOldSections;
        }

        public void addNewSection(XSection section) {
            this.iNewSections.add(section);
        }

        public List<XSection> getNewSections() {
            return this.iNewSections;
        }

        public boolean hasEmail() {
            XInstructor instructor = this.getInstructor();
            return instructor.getEmail() != null && !instructor.getEmail().isEmpty();
        }

        public boolean hasChange(boolean checkTime, boolean checkRoom, boolean checkAssignment, boolean checkCancellations, boolean checkShare) {
            if (checkAssignment) {
                if (this.iOldSections.size() != this.iNewSections.size()) {
                    return true;
                }
                XCourse course = this.getCourse();
                block0: for (XSection oldSection : this.iOldSections) {
                    for (XSection newSection : this.iNewSections) {
                        if (!ReloadOfferingAction.sameName(course.getCourseId(), newSection, oldSection) || !InstructorEmail.sameTime(checkTime, newSection, oldSection) || !InstructorEmail.sameRoom(checkRoom, newSection, oldSection) || !InstructorEmail.sameShare(checkShare, oldSection.getInstructor(this.iOldInstructor.getExternalId()), newSection.getInstructor(this.iNewInstructor.getExternalId())) || !InstructorEmail.sameCancellation(checkCancellations, oldSection, newSection)) continue;
                        continue block0;
                    }
                    return true;
                }
                return false;
            }
            for (XSection oldSection : this.iOldSections) {
                for (XSection newSection : this.iNewSections) {
                    if (!newSection.equals(oldSection) || InstructorEmail.sameTime(checkTime, newSection, oldSection) && InstructorEmail.sameRoom(checkRoom, newSection, oldSection) && InstructorEmail.sameShare(checkShare, oldSection.getInstructor(this.iOldInstructor.getExternalId()), newSection.getInstructor(this.iNewInstructor.getExternalId())) && InstructorEmail.sameCancellation(checkCancellations, oldSection, newSection)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class InstructorTableSectionModifiedLine
    extends StudentEmail.TableSectionModifiedLine {
        protected String iInstructorId;

        public InstructorTableSectionModifiedLine(XCourse course, String instructorId, XSubpart oldSubpart, XSubpart subpart, XSection oldSection, XSection section, String oldRequires, String requires, URL url) {
            super(null, course, oldSubpart, subpart, oldSection, section, oldRequires, requires, url, false);
            this.iInstructorId = instructorId;
        }

        @Override
        public String getInstructors() {
            XInstructor instructor = this.iInstructorId == null ? null : this.iSection.getInstructor(this.iInstructorId);
            XInstructor oldInstructor = this.iInstructorId == null ? null : this.iOldSection.getInstructor(this.iInstructorId);
            Object oldass = "";
            if (oldInstructor != null) {
                oldass = oldInstructor.isAllowOverlap() ? "<i>" + (String)(oldInstructor.getResponsibility() == null ? "" : oldInstructor.getResponsibility() + " ") + oldInstructor.getPercentShare() + "%</i>" : (String)(oldInstructor.getResponsibility() == null ? "" : oldInstructor.getResponsibility() + " ") + oldInstructor.getPercentShare() + "%";
            }
            Object newass = "";
            if (instructor != null) {
                newass = instructor.isAllowOverlap() ? "<i>" + (String)(instructor.getResponsibility() == null ? "" : instructor.getResponsibility() + " ") + instructor.getPercentShare() + "%</i>" : (String)(instructor.getResponsibility() == null ? "" : instructor.getResponsibility() + " ") + instructor.getPercentShare() + "%";
            }
            return this.diff((String)oldass, (String)newass);
        }

        @Override
        public String getNote() {
            if (this.iSection.isCancelled()) {
                return MSG.emailClassCancelled();
            }
            if (!this.iSection.isCancelled() && this.iOldSection.isCancelled()) {
                return MSG.emailClassReopened();
            }
            return this.diff(this.iOldSection.getNote(), this.iSection.getNote());
        }
    }

    public static class InstructorTableSectionDeletedLine
    extends InstructorTableSectionLine {
        public InstructorTableSectionDeletedLine(String externalId, XCourse course, XSubpart subpart, XSection section, String requires, URL url) {
            super(externalId, course, subpart, section, requires, url);
        }

        @Override
        public String getCourseNote() {
            return null;
        }

        @Override
        public String getNote() {
            return MSG.emailClassUnassigned();
        }
    }

    public static class InstructorTableSectionAddedLine
    extends InstructorTableSectionLine {
        public InstructorTableSectionAddedLine(String externalId, XCourse course, XSubpart subpart, XSection section, String requires, URL url) {
            super(externalId, course, subpart, section, requires, url);
        }

        @Override
        public String getNote() {
            if (super.getNote() == null || super.getNote().isEmpty()) {
                return MSG.emailClassAssigned();
            }
            return MSG.emailClassAssigned() + " " + super.getNote();
        }
    }

    public static class InstructorTableSectionLine
    extends StudentEmail.TableSectionLine {
        protected String iInstructorId;

        public InstructorTableSectionLine(String externalId, XCourse course, XSubpart subpart, XSection section, String requires, URL url) {
            super(null, course, subpart, section, requires, url, false);
            this.iInstructorId = externalId;
        }

        @Override
        public String getInstructors() {
            XInstructor instructor;
            XInstructor xInstructor = instructor = this.iInstructorId == null ? null : this.iSection.getInstructor(this.iInstructorId);
            if (instructor == null) {
                return "";
            }
            if (instructor.isAllowOverlap()) {
                return "<i>" + (String)(instructor.getResponsibility() == null ? "" : instructor.getResponsibility() + " ") + instructor.getPercentShare() + "%</i>";
            }
            return (String)(instructor.getResponsibility() == null ? "" : instructor.getResponsibility() + " ") + instructor.getPercentShare() + "%";
        }
    }
}

