/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.User;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.RequiredTimeTableModel;

public class TimePatternModel
implements RequiredTimeTableModel {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private TimePattern iTimePattern = null;
    private int iDefaultSelection = 0;
    protected String[] iDays = null;
    protected int[] iDayCodes = null;
    protected int[] iMinutes = null;
    protected String[][] iPreferences;
    protected String iPref = null;
    protected boolean iAllowHard = true;
    protected int iBreakTime = 0;
    protected TimeLocation iAssignment = null;
    private List<RoomInterface.RoomSharingDisplayMode> iModes = new ArrayList<RoomInterface.RoomSharingDisplayMode>();
    private static String xChars = "0123456789abcdefghijklmnopqrstuvwxyz -";
    public static double sDefaultDecreaseFactor = 0.77;
    public static final int sMixAlgAverage = 0;
    public static final int sMixAlgSum = 1;
    public static final int sMixAlgMinMax = 2;
    public static final int sMixAlgMaxUse = 3;
    public static final int sMixAlgFullCover = 4;
    public static final String[] sMixAlgs = new String[]{"Average", "Sum", "Min-Max", "MaxUsed", "FullCover"};

    protected TimePatternModel(TimePattern pattern, TimeLocation assignment, boolean allowHard) {
        this.iTimePattern = pattern;
        this.iAssignment = assignment;
        this.iAllowHard = allowHard;
        int n = this.iBreakTime = pattern == null ? 0 : pattern.getBreakTime();
        if (this.iTimePattern == null || this.iTimePattern.getUniqueId() == null || this.iTimePattern.getUniqueId() < 0L) {
            int i;
            this.iTimePattern = null;
            this.iDays = new String[Constants.NR_DAYS];
            this.iDayCodes = new int[Constants.NR_DAYS];
            for (i = 0; i < Constants.NR_DAYS; ++i) {
                this.iDayCodes[i] = Constants.DAY_CODES[i];
                this.iDays[i] = CONSTANTS.days()[i];
            }
            this.iMinutes = new int[288];
            for (i = 0; i < 288; ++i) {
                this.iMinutes[i] = Constants.FIRST_SLOT_TIME_MIN + Constants.SLOT_LENGTH_MIN * i;
            }
            this.iPreferences = new String[Constants.NR_DAYS][288];
            for (i = 0; i < this.iPreferences.length; ++i) {
                for (int j = 0; j < this.iPreferences[i].length; ++j) {
                    this.iPreferences[i][j] = PreferenceLevel.sNeutral;
                }
            }
        } else {
            Vector<TimePatternDays> days = new Vector<TimePatternDays>(pattern.getDays());
            Collections.sort(days);
            this.iDays = new String[days.size()];
            this.iDayCodes = new int[days.size()];
            int idx = 0;
            Integer firstDayOfWeek = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
            Enumeration<TimePatternDays> e = days.elements();
            while (e.hasMoreElements()) {
                int dayCode;
                this.iDayCodes[idx] = dayCode = e.nextElement().getDayCode().intValue();
                this.iDays[idx] = "";
                for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                    int j;
                    int n2 = j = firstDayOfWeek == null ? i : (i + firstDayOfWeek) % 7;
                    if ((Constants.DAY_CODES[j] & dayCode) == 0) continue;
                    if (pattern.getNrMeetings() <= 1) {
                        int n3 = idx;
                        this.iDays[n3] = this.iDays[n3] + CONSTANTS.days()[j];
                        continue;
                    }
                    int n4 = idx;
                    this.iDays[n4] = this.iDays[n4] + CONSTANTS.shortDays()[j];
                }
                ++idx;
            }
            Vector<TimePatternTime> times = new Vector<TimePatternTime>(pattern.getTimes());
            Collections.sort(times);
            this.iMinutes = new int[times.size()];
            idx = 0;
            Enumeration<TimePatternTime> e2 = times.elements();
            while (e2.hasMoreElements()) {
                int startSlot = e2.nextElement().getStartSlot();
                this.iMinutes[idx] = Constants.FIRST_SLOT_TIME_MIN + Constants.SLOT_LENGTH_MIN * startSlot;
                ++idx;
            }
            this.iPreferences = new String[days.size()][times.size()];
            for (int i = 0; i < this.iPreferences.length; ++i) {
                for (int j = 0; j < this.iPreferences[i].length; ++j) {
                    this.iPreferences[i][j] = PreferenceLevel.sNeutral;
                }
            }
        }
        if (this.iTimePattern == null) {
            String mode;
            int i = 0;
            while ((mode = ApplicationProperty.RoomSharingMode.value(String.valueOf(1 + i), i < CONSTANTS.roomSharingModes().length ? CONSTANTS.roomSharingModes()[i] : null)) != null && !mode.isEmpty()) {
                this.iModes.add(new RoomInterface.RoomSharingDisplayMode(mode));
                ++i;
            }
        }
    }

    public void setMode(String mode) {
        RoomInterface.RoomSharingDisplayMode m = new RoomInterface.RoomSharingDisplayMode(mode);
        this.iModes.add(m);
        this.iDefaultSelection = this.iModes.size() - 1;
    }

    protected TimePatternModel() {
        this(null, null, true);
    }

    public TimePattern getTimePattern() {
        return this.iTimePattern;
    }

    public int getNrMeetings() {
        return this.iTimePattern == null ? Constants.NR_DAYS : this.iTimePattern.getNrMeetings();
    }

    public int getSlotsPerMtg() {
        return this.iTimePattern == null ? 1 : this.iTimePattern.getSlotsPerMtg();
    }

    public int getMinPerMtg() {
        return this.iTimePattern == null ? Constants.SLOT_LENGTH_MIN : this.iTimePattern.getMinPerMtg();
    }

    public int getType() {
        return this.iTimePattern == null ? TimePattern.TimePatternType.Standard.ordinal() : this.iTimePattern.getType().intValue();
    }

    public TimePattern.TimePatternType getTimePatternType() {
        if (this.iTimePattern == null) {
            return null;
        }
        return this.iTimePattern.getTimePatternType();
    }

    @Override
    public String getName() {
        return this.iTimePattern == null ? null : this.iTimePattern.getName();
    }

    public int getDayCode(int day) {
        return this.iDayCodes[day];
    }

    @Override
    public String getDayHeader(int day) {
        return this.iDays[day];
    }

    public int getHour(int time) {
        return this.iMinutes[time] / 60;
    }

    public int getMinute(int time) {
        return this.iMinutes[time] % 60;
    }

    public int getSlot(int time) {
        return this.iMinutes[time];
    }

    @Override
    public int getNrDays() {
        return this.iDays.length;
    }

    @Override
    public int getNrTimes() {
        return this.iMinutes.length;
    }

    @Override
    public String getPreference(int day, int time) {
        return this.iPreferences[day][time];
    }

    @Override
    public String getStartTime(int time) {
        return Constants.toTime(this.iMinutes[time]);
    }

    @Override
    public String getEndTime(int time) {
        return Constants.toTime(this.iMinutes[time] + this.getSlotsPerMtg() * Constants.SLOT_LENGTH_MIN - this.iBreakTime);
    }

    public String getTimeHeaderShort(int time) {
        return Constants.toTime(this.iMinutes[time]);
    }

    public static int slot2min(int slot) {
        return (slot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) % 60;
    }

    public static int slot2hour(int slot) {
        return (slot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60;
    }

    public static int time2slot(int hour, int min) {
        return (hour * 60 + min) / Constants.SLOT_LENGTH_MIN - Constants.FIRST_SLOT_TIME_MIN;
    }

    public void setDefaults(User user) throws Exception {
        long startMin = 450L;
        long endMin = this.getMinPerMtg() <= 90 ? 990 : (this.getMinPerMtg() <= 120 ? 930 : 900);
        for (int i = 0; i < this.iDays.length; ++i) {
            for (int j = 0; j < this.iMinutes.length; ++j) {
                this.iPreferences[i][j] = (long)this.iMinutes[j] <= startMin ? PreferenceLevel.sStronglyDiscouraged : ((long)this.iMinutes[j] >= endMin ? PreferenceLevel.sDiscouraged : PreferenceLevel.sNeutral);
            }
        }
    }

    public boolean setPreferenceUsingDayCodeStartSlot(int dayCode, int startSlot, String pref) {
        int i;
        if (this.isExactTime()) {
            this.iPref = Integer.toString(dayCode) + "," + Integer.toString(startSlot);
            return true;
        }
        int day = -1;
        int time = -1;
        for (i = 0; i < this.iDayCodes.length; ++i) {
            if (this.iDayCodes[i] != dayCode) continue;
            day = i;
            break;
        }
        for (i = 0; i < this.iMinutes.length; ++i) {
            if (Constants.FIRST_SLOT_TIME_MIN + Constants.SLOT_LENGTH_MIN * startSlot != this.iMinutes[i]) continue;
            time = i;
            break;
        }
        if (time < 0 || day < 0) {
            return false;
        }
        this.setPreference(day, time, pref);
        return true;
    }

    public void setPreference(int day, int time, PreferenceLevel pref) {
        this.iPreferences[day][time] = pref.getPrefProlog();
    }

    @Override
    public void setPreference(int day, int time, String prefProlog) {
        this.iPreferences[day][time] = prefProlog;
    }

    public void clear() {
        for (int i = 0; i < this.iDays.length; ++i) {
            for (int j = 0; j < this.iMinutes.length; ++j) {
                this.iPreferences[i][j] = PreferenceLevel.sNeutral;
            }
        }
    }

    public Vector getSlots(int day, int time) {
        Vector<Integer> slots = new Vector<Integer>();
        int dayCode = this.iDayCodes[day];
        int slot = this.getStartSlot(time);
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
            int s = slot + i * 288;
            for (int j = 0; j < this.getSlotsPerMtg(); ++j) {
                slots.addElement(s + j);
            }
        }
        return slots;
    }

    public int getStartSlot(int time) {
        return TimePatternModel.time2slot(0, this.iMinutes[time]);
    }

    public Collection getStartSlots(int day, int time) {
        Vector<Integer> slots = new Vector<Integer>();
        int dayCode = this.iDayCodes[day];
        int slot = this.getStartSlot(time);
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
            slots.addElement(slot + i * 288);
        }
        return slots;
    }

    public String getText(int day, int time) {
        return this.getDayHeader(day) + " " + this.getTimeHeaderShort(time);
    }

    @Override
    public String getPreferences() {
        if (this.isExactTime()) {
            return this.iPref;
        }
        StringBuffer pref = new StringBuffer();
        for (int i = 0; i < this.iDays.length; ++i) {
            for (int j = 0; j < this.iMinutes.length; ++j) {
                pref.append(PreferenceLevel.prolog2char(this.iPreferences[i][j]));
            }
        }
        return pref.toString();
    }

    public String getPreferencesHex() {
        if (this.isExactTime()) {
            return this.iPref;
        }
        int[] limit = this.getSelectionLimits(this.getDefaultSelection());
        BigInteger idn = new BigInteger("0");
        List<PreferenceLevel> prefs = PreferenceLevel.getPreferenceLevelList();
        BigInteger mx = new BigInteger(String.valueOf(prefs.size()));
        for (int d = limit[2]; d <= limit[3]; ++d) {
            for (int t = limit[0]; t <= limit[1]; ++t) {
                BigInteger add = new BigInteger(String.valueOf(prefs.indexOf(PreferenceLevel.getPreferenceLevel(this.getPreference(d, t)))));
                idn = idn.multiply(mx).add(add);
            }
        }
        StringBuffer s = new StringBuffer();
        BigInteger radix = new BigInteger(String.valueOf(xChars.length()));
        while (idn.bitLength() > 0) {
            int x = idn.mod(radix).intValue();
            idn = idn.divide(radix);
            s.append(xChars.charAt(x));
        }
        return s.toString();
    }

    @Override
    public void setPreferences(String pref) {
        block10: {
            try {
                if (this.isExactTime()) {
                    this.iPref = pref;
                }
                if (pref != null && pref.length() <= 336 && this.iDays.length * this.iMinutes.length == 2016) {
                    boolean req = pref.indexOf(82) >= 0;
                    for (int i = 0; i < this.iDays.length; ++i) {
                        for (int j = 0; j < this.iMinutes.length; ++j) {
                            int ch = 50;
                            try {
                                ch = pref.charAt(48 * i + j / 6);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                            this.iPreferences[i][j] = PreferenceLevel.char2prolog((char)(req ? (ch == 82 ? 50 : 80) : ch));
                        }
                    }
                    break block10;
                }
                int idx = 0;
                for (int i = 0; i < this.iDays.length; ++i) {
                    for (int j = 0; j < this.iMinutes.length; ++j) {
                        this.iPreferences[i][j] = pref == null ? PreferenceLevel.sNeutral : PreferenceLevel.char2prolog(pref.charAt(idx++));
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getFieldText(int day, int time) {
        return String.valueOf(Math.round(this.getNormalizedPreference(day, time, sDefaultDecreaseFactor)));
    }

    public double getNormalizedPreference(int day, int time, double decreaseFactor) {
        if (this.iPreferences[day][time].equalsIgnoreCase(PreferenceLevel.sRequired)) {
            return 0.0;
        }
        if (this.iPreferences[day][time].equalsIgnoreCase(PreferenceLevel.sNotAvailable)) {
            return 100.0;
        }
        if (this.iPreferences[day][time].equalsIgnoreCase(PreferenceLevel.sProhibited)) {
            return 100.0;
        }
        int pref = Integer.parseInt(this.iPreferences[day][time]);
        if (pref == 0) {
            return 0.0;
        }
        double nrOfPreferences = 0.0;
        double increment = this.getMinPerMtg() <= 30 ? 0.5 : 1.0;
        for (int i = 0; i < this.iDays.length; ++i) {
            double nrOfPreferencesThisDay = 0.0;
            for (int j = 0; j < this.iMinutes.length; ++j) {
                String p = this.iPreferences[i][j];
                if (PreferenceLevel.sRequired.equalsIgnoreCase(p) || PreferenceLevel.sNotAvailable.equalsIgnoreCase(p) || !PreferenceLevel.sProhibited.equalsIgnoreCase(p) && Integer.parseInt(p) == 0) continue;
                nrOfPreferencesThisDay += increment;
            }
            nrOfPreferences = Math.max(nrOfPreferences, nrOfPreferencesThisDay);
        }
        double norm = Math.max(1.0, (double)Math.round(10.0 * Math.pow(decreaseFactor, Math.max(0.0, nrOfPreferences - 1.0))));
        double sign = pref < 0 ? -1.0 : 1.0;
        double mux = Math.abs(pref) == 1 ? 1.0 : 4.0;
        return sign * norm * mux;
    }

    public int countPreferences(String prologPref) {
        int ret = 0;
        for (int i = 0; i < this.iDays.length; ++i) {
            for (int j = 0; j < this.iMinutes.length; ++j) {
                if (!this.iPreferences[i][j].equals(prologPref)) continue;
                ++ret;
            }
        }
        return ret;
    }

    public boolean isDefault() {
        for (int i = 0; i < this.iDays.length; ++i) {
            for (int j = 0; j < this.iMinutes.length; ++j) {
                if (this.iPreferences[i][j].equals(this.getDefaultPreference())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean contains(Assignment assignment) {
        if (assignment == null) {
            return false;
        }
        int[] startSlots = assignment.getStartSlots();
        for (int day = 0; day < this.iDays.length; ++day) {
            for (int time = 0; time < this.iMinutes.length; ++time) {
                int slot = this.getStartSlot(time);
                int j = 0;
                boolean equal = true;
                for (int i = 0; equal && i < Constants.DAY_CODES.length; ++i) {
                    if ((this.iDayCodes[day] & Constants.DAY_CODES[i]) != Constants.DAY_CODES[i]) continue;
                    int s = slot + i * 288;
                    if (startSlots[j] != s) {
                        equal = false;
                        break;
                    }
                    ++j;
                }
                if (!equal) continue;
                return true;
            }
        }
        return false;
    }

    public long getTime(int time) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(11, this.iMinutes[time] / 60);
        cal.set(12, this.iMinutes[time] % 60);
        return cal.getTimeInMillis();
    }

    public void setInOldFormat(String inDays, Date startTime, Date endTime, PreferenceLevel pref) {
        int days = Integer.parseInt(inDays, 2);
        for (int i = 0; i < this.iDays.length; ++i) {
            if ((days & this.iDayCodes[i]) != this.iDayCodes[i]) continue;
            for (int j = 0; j < this.iMinutes.length; ++j) {
                if ((endTime != null || startTime.getTime() != this.getTime(j)) && (endTime == null || startTime.getTime() > this.getTime(j) || endTime.getTime() < this.getTime(j))) continue;
                this.iPreferences[i][j] = pref.getPrefProlog();
            }
        }
    }

    public String toString() {
        int j;
        int i;
        Integer firstDayOfWeek = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
        if (this.isExactTime()) {
            if (this.iPref == null) {
                return "not set";
            }
            int days = this.getExactDays();
            int startSlot = this.getExactStartSlot();
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < Constants.DAY_CODES.length; ++i2) {
                int j2;
                int n = j2 = firstDayOfWeek == null ? i2 : (i2 + firstDayOfWeek) % 7;
                if ((Constants.DAY_CODES[j2] & days) == 0) continue;
                sb.append(CONSTANTS.shortDays()[j2]);
            }
            sb.append(" ");
            sb.append(Constants.toTime(startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN));
            return sb.toString();
        }
        boolean canMergeDays = true;
        int i3 = 0;
        while (canMergeDays && i3 + 1 < this.iDays.length) {
            for (int j3 = i3 + 1; canMergeDays && j3 < this.iDays.length; ++j3) {
                if ((this.iDayCodes[i3] & this.iDayCodes[j3]) == 0) continue;
                canMergeDays = false;
            }
            ++i3;
        }
        StringBuffer sb = new StringBuffer();
        boolean[][] out = new boolean[this.iDays.length][this.iMinutes.length];
        for (i = 0; i < this.iDays.length; ++i) {
            for (j = 0; j < this.iMinutes.length; ++j) {
                out[i][j] = false;
            }
        }
        for (i = 0; i < this.iDays.length; ++i) {
            for (j = 0; j < this.iMinutes.length; ++j) {
                int x;
                boolean same;
                if (out[i][j]) continue;
                out[i][j] = true;
                if (PreferenceLevel.sNeutral.equals(this.iPreferences[i][j])) continue;
                int endDay = i;
                int endTime = j;
                while (endTime + 1 < this.iMinutes.length && !out[i][endTime + 1] && this.iPreferences[i][endTime + 1].equals(this.iPreferences[i][j])) {
                    ++endTime;
                }
                if (i == 0) {
                    same = true;
                    int k = i;
                    while (k + 1 < this.iDays.length) {
                        for (int x2 = j; x2 <= endTime; ++x2) {
                            if (!out[k + 1][x2] && !this.iPreferences[i][x2].equals(this.iPreferences[k + 1][x2])) {
                                same = false;
                                break;
                            }
                            if (!same) break;
                        }
                        if (!same) break;
                        ++k;
                    }
                    if (same) {
                        endDay = this.iDays.length - 1;
                    }
                }
                while (canMergeDays && endDay + 1 < this.iDays.length) {
                    same = true;
                    for (x = j; x <= endTime; ++x) {
                        if (out[endDay + 1][x] || this.iPreferences[i][x].equals(this.iPreferences[endDay + 1][x])) continue;
                        same = false;
                        break;
                    }
                    if (!same) break;
                    ++endDay;
                }
                for (int a = i; a <= endDay; ++a) {
                    for (int b = j; b <= endTime; ++b) {
                        out[a][b] = true;
                    }
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(PreferenceLevel.prolog2abbv(this.iPreferences[i][j]) + " ");
                int nrDays = 0;
                for (x = 0; x < Constants.DAY_CODES.length; ++x) {
                    boolean thisDay = false;
                    for (int a = i; a <= endDay; ++a) {
                        if ((this.iDayCodes[a] & Constants.DAY_CODES[x]) == 0) continue;
                        thisDay = true;
                    }
                    if (!thisDay) continue;
                    ++nrDays;
                }
                for (x = 0; x < Constants.DAY_CODES.length; ++x) {
                    int y = firstDayOfWeek == null ? x : (x + firstDayOfWeek) % 7;
                    boolean thisDay = false;
                    for (int a = i; a <= endDay; ++a) {
                        if ((this.iDayCodes[a] & Constants.DAY_CODES[y]) == 0) continue;
                        thisDay = true;
                    }
                    if (!thisDay) continue;
                    sb.append(nrDays == 1 ? CONSTANTS.days()[y] : CONSTANTS.shortDays()[y]);
                }
                Object d1 = " ";
                Object d2 = " ";
                for (int x3 = 0; x3 < 7; ++x3) {
                    int y;
                    int n = y = firstDayOfWeek == null ? x3 : (x3 + firstDayOfWeek) % 7;
                    if (x3 < 5) {
                        d1 = (String)d1 + CONSTANTS.shortDays()[y];
                    }
                    d2 = (String)d2 + CONSTANTS.shortDays()[y];
                }
                if (this.iTimePattern != null && sb.toString().endsWith((String)d1)) {
                    sb.delete(sb.length() - ((String)d1).length(), sb.length());
                }
                if (this.iTimePattern == null && sb.toString().endsWith((String)d2)) {
                    sb.delete(sb.length() - ((String)d2).length(), sb.length());
                }
                if (j == 0 && endTime + 1 == this.iMinutes.length) continue;
                sb.append(" ");
                sb.append(Constants.toTime(this.iMinutes[j]));
                sb.append(" - ");
                sb.append(Constants.toTime(this.iMinutes[endTime] + this.getSlotsPerMtg() * Constants.SLOT_LENGTH_MIN - this.iBreakTime));
            }
        }
        return sb.toString();
    }

    @Override
    public TableInterface.CellInterface toCell() {
        int j;
        int i;
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        Integer firstDayOfWeek = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
        if (this.isExactTime()) {
            if (this.iPref == null) {
                cell.add("not set");
                return cell;
            }
            int days = this.getExactDays();
            int startSlot = this.getExactStartSlot();
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < Constants.DAY_CODES.length; ++i2) {
                int j2;
                int n = j2 = firstDayOfWeek == null ? i2 : (i2 + firstDayOfWeek) % 7;
                if ((Constants.DAY_CODES[j2] & days) == 0) continue;
                sb.append(CONSTANTS.shortDays()[j2]);
            }
            sb.append(" ");
            sb.append(Constants.toTime(startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN));
            cell.add(sb.toString()).setColor(PreferenceLevel.prolog2color("R"));
            return cell;
        }
        boolean canMergeDays = true;
        int i3 = 0;
        while (canMergeDays && i3 + 1 < this.iDays.length) {
            for (int j3 = i3 + 1; canMergeDays && j3 < this.iDays.length; ++j3) {
                if ((this.iDayCodes[i3] & this.iDayCodes[j3]) == 0) continue;
                canMergeDays = false;
            }
            ++i3;
        }
        StringBuffer sb = new StringBuffer();
        String pref = null;
        boolean[][] out = new boolean[this.iDays.length][this.iMinutes.length];
        for (i = 0; i < this.iDays.length; ++i) {
            for (j = 0; j < this.iMinutes.length; ++j) {
                out[i][j] = false;
            }
        }
        for (i = 0; i < this.iDays.length; ++i) {
            for (j = 0; j < this.iMinutes.length; ++j) {
                int x;
                boolean same;
                if (out[i][j]) continue;
                out[i][j] = true;
                if (PreferenceLevel.sNeutral.equals(this.iPreferences[i][j])) continue;
                int endDay = i;
                int endTime = j;
                while (endTime + 1 < this.iMinutes.length && !out[i][endTime + 1] && this.iPreferences[i][endTime + 1].equals(this.iPreferences[i][j])) {
                    ++endTime;
                }
                if (i == 0) {
                    same = true;
                    int k = i;
                    while (k + 1 < this.iDays.length) {
                        for (int x2 = j; x2 <= endTime; ++x2) {
                            if (!out[k + 1][x2] && !this.iPreferences[i][x2].equals(this.iPreferences[k + 1][x2])) {
                                same = false;
                                break;
                            }
                            if (!same) break;
                        }
                        if (!same) break;
                        ++k;
                    }
                    if (same) {
                        endDay = this.iDays.length - 1;
                    }
                }
                while (canMergeDays && endDay + 1 < this.iDays.length) {
                    same = true;
                    for (x = j; x <= endTime; ++x) {
                        if (out[endDay + 1][x] || this.iPreferences[i][x].equals(this.iPreferences[endDay + 1][x])) continue;
                        same = false;
                        break;
                    }
                    if (!same) break;
                    ++endDay;
                }
                for (int a = i; a <= endDay; ++a) {
                    for (int b = j; b <= endTime; ++b) {
                        out[a][b] = true;
                    }
                }
                if (sb.length() > 0) {
                    cell.add(sb.toString()).setColor(PreferenceLevel.prolog2color(pref)).setAria(PreferenceLevel.prolog2abbv(pref) + " " + String.valueOf(sb)).setInline(false);
                    sb = new StringBuffer();
                    pref = null;
                }
                pref = this.iPreferences[i][j];
                int nrDays = 0;
                for (x = 0; x < Constants.DAY_CODES.length; ++x) {
                    boolean thisDay = false;
                    for (int a = i; a <= endDay; ++a) {
                        if ((this.iDayCodes[a] & Constants.DAY_CODES[x]) == 0) continue;
                        thisDay = true;
                    }
                    if (!thisDay) continue;
                    ++nrDays;
                }
                for (x = 0; x < Constants.DAY_CODES.length; ++x) {
                    int y = firstDayOfWeek == null ? x : (x + firstDayOfWeek) % 7;
                    boolean thisDay = false;
                    for (int a = i; a <= endDay; ++a) {
                        if ((this.iDayCodes[a] & Constants.DAY_CODES[y]) == 0) continue;
                        thisDay = true;
                    }
                    if (!thisDay) continue;
                    sb.append(nrDays == 1 ? CONSTANTS.days()[y] : CONSTANTS.shortDays()[y]);
                }
                Object d1 = " ";
                Object d2 = " ";
                for (int x3 = 0; x3 < 7; ++x3) {
                    int y;
                    int n = y = firstDayOfWeek == null ? x3 : (x3 + firstDayOfWeek) % 7;
                    if (x3 < 5) {
                        d1 = (String)d1 + CONSTANTS.shortDays()[y];
                    }
                    d2 = (String)d2 + CONSTANTS.shortDays()[y];
                }
                if (this.iTimePattern != null && sb.toString().endsWith((String)d1)) {
                    sb.delete(sb.length() - ((String)d1).length(), sb.length());
                }
                if (this.iTimePattern == null && sb.toString().endsWith((String)d2)) {
                    sb.delete(sb.length() - ((String)d2).length(), sb.length());
                }
                if (j == 0 && endTime + 1 == this.iMinutes.length) continue;
                sb.append(" ");
                sb.append(Constants.toTime(this.iMinutes[j]));
                sb.append(" - ");
                sb.append(Constants.toTime(this.iMinutes[endTime] + this.getSlotsPerMtg() * Constants.SLOT_LENGTH_MIN - this.iBreakTime));
            }
        }
        if (sb.length() > 0) {
            cell.add(sb.toString()).setColor(PreferenceLevel.prolog2color(pref)).setAria(PreferenceLevel.prolog2abbv(pref) + " " + String.valueOf(sb)).setInline(false);
        }
        return cell;
    }

    @Override
    public boolean isExactTime() {
        return this.getType() == TimePattern.TimePatternType.ExactTime.ordinal();
    }

    @Override
    public int getExactDays() {
        if (this.iPref == null || this.iPref.indexOf(44) < 0) {
            return 0;
        }
        return Integer.parseInt(this.iPref.substring(0, this.iPref.indexOf(44)));
    }

    @Override
    public int getExactStartSlot() {
        if (this.iPref == null || this.iPref.indexOf(44) < 0) {
            return -1;
        }
        return Integer.parseInt(this.iPref.substring(this.iPref.indexOf(44) + 1));
    }

    @Override
    public void setExactDays(int days) {
        this.iPref = days + "," + this.getExactStartSlot();
    }

    @Override
    public void setExactStartSlot(int slot) {
        this.iPref = this.getExactDays() + "," + slot;
    }

    public boolean hasRequiredPreferences() {
        for (int d = 0; d < this.getNrDays(); ++d) {
            for (int t = 0; t < this.getNrTimes(); ++t) {
                if (!PreferenceLevel.sRequired.equals(this.iPreferences[d][t])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNotAvailablePreference() {
        for (int d = 0; d < this.getNrDays(); ++d) {
            for (int t = 0; t < this.getNrTimes(); ++t) {
                if (!PreferenceLevel.sNotAvailable.equals(this.iPreferences[d][t])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasProgibitedPreferences() {
        for (int d = 0; d < this.getNrDays(); ++d) {
            for (int t = 0; t < this.getNrTimes(); ++t) {
                if (!PreferenceLevel.sProhibited.equals(this.iPreferences[d][t])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean changeRequired2Prohibited() {
        int t;
        int d;
        if (this.isExactTime()) {
            return false;
        }
        boolean hasReq = false;
        block0: for (d = 0; d < this.getNrDays(); ++d) {
            for (t = 0; t < this.getNrTimes(); ++t) {
                if (!PreferenceLevel.sRequired.equals(this.iPreferences[d][t])) continue;
                hasReq = true;
                continue block0;
            }
        }
        if (!hasReq) {
            return false;
        }
        for (d = 0; d < this.getNrDays(); ++d) {
            for (t = 0; t < this.getNrTimes(); ++t) {
                this.iPreferences[d][t] = PreferenceLevel.sRequired.equals(this.iPreferences[d][t]) ? PreferenceLevel.sNeutral : PreferenceLevel.sProhibited;
            }
        }
        return true;
    }

    public boolean changeProhibited2Required() {
        int t;
        int d;
        if (this.isExactTime()) {
            return false;
        }
        boolean hasNeutral = false;
        boolean hasProhibited = false;
        for (d = 0; d < this.getNrDays(); ++d) {
            for (t = 0; t < this.getNrTimes(); ++t) {
                if (PreferenceLevel.sNeutral.equals(this.iPreferences[d][t])) {
                    hasNeutral = true;
                    continue;
                }
                if (PreferenceLevel.sProhibited.equals(this.iPreferences[d][t])) {
                    hasProhibited = true;
                    continue;
                }
                return false;
            }
        }
        if (!hasNeutral || !hasProhibited) {
            return false;
        }
        for (d = 0; d < this.getNrDays(); ++d) {
            for (t = 0; t < this.getNrTimes(); ++t) {
                this.iPreferences[d][t] = PreferenceLevel.sProhibited.equals(this.iPreferences[d][t]) ? PreferenceLevel.sNeutral : PreferenceLevel.sRequired;
            }
        }
        return true;
    }

    public static int getNrSharedSlots(int dayCode1, int slot1, int nrSlots1, int dayCode2, int slot2, int nrSlots2) {
        int end;
        int start = Math.max(slot1, slot2);
        if (start >= (end = Math.min(slot1 + nrSlots1, slot2 + nrSlots2))) {
            return 0;
        }
        int sharedTimes = end - start;
        int sharedDays = 0;
        for (int i = 0; i < Constants.NR_DAYS; ++i) {
            int dayCode = Constants.DAY_CODES[i];
            if ((dayCode1 & dayCode) == 0 || (dayCode2 & dayCode) == 0) continue;
            ++sharedDays;
        }
        return sharedDays * sharedTimes;
    }

    public String getCombinedPreference(int givenDayCode, int givenSlot, int givenNrSlots, int alg) {
        PrefMix mix = TimePatternModel.getMixAlg(alg);
        for (int i = 0; i < this.iDayCodes.length; ++i) {
            int dayCode = this.iDayCodes[i];
            for (int j = 0; j < this.iMinutes.length; ++j) {
                int min = this.iMinutes[j];
                int slot = (min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                int share = TimePatternModel.getNrSharedSlots(dayCode, slot, this.getSlotsPerMtg(), givenDayCode, givenSlot, givenNrSlots);
                if (share <= 0) continue;
                mix.addPref(this.iPreferences[i][j], share);
            }
        }
        return mix.getPref();
    }

    public void combineWith(TimePatternModel model, boolean clear) {
        this.combineWith(model, clear, 2);
    }

    public void combineWith(TimePatternModel model, boolean clear, int alg) {
        boolean changed = false;
        if (clear) {
            this.clear();
        } else {
            changed = this.changeRequired2Prohibited();
        }
        changed = model.changeRequired2Prohibited() || changed;
        for (int i = 0; i < this.iDayCodes.length; ++i) {
            int dayCode = this.iDayCodes[i];
            for (int j = 0; j < this.iMinutes.length; ++j) {
                int min = this.iMinutes[j];
                int slot = (min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                String pref = model.getCombinedPreference(dayCode, slot, this.getSlotsPerMtg(), alg);
                if (clear) {
                    this.iPreferences[i][j] = pref;
                    continue;
                }
                MinMaxPreferenceCombination com = new MinMaxPreferenceCombination();
                com.addPreferenceProlog(this.iPreferences[i][j] == null ? PreferenceLevel.sNeutral : this.iPreferences[i][j]);
                com.addPreferenceProlog(pref);
                this.iPreferences[i][j] = com.getPreferenceProlog();
            }
        }
        if (changed) {
            this.changeProhibited2Required();
        }
    }

    public void combineMatching(TimePatternModel model) {
        this.combineMatching(model, true, 4);
    }

    public void combineMatching(TimePatternModel model, boolean clear, int alg) {
        for (int t1 = 0; t1 < this.getNrTimes(); ++t1) {
            for (int d1 = 0; d1 < this.getNrDays(); ++d1) {
                int t2 = -1;
                int d2 = -1;
                block2: for (int t = 0; t < model.getNrTimes(); ++t) {
                    for (int d = 0; d < model.getNrDays(); ++d) {
                        if (this.getTime(t1) != model.getTime(t) || this.getDayCode(d1) != model.getDayCode(d)) continue;
                        t2 = t;
                        d2 = d;
                        continue block2;
                    }
                }
                if (t2 >= 0 && d2 >= 0) {
                    if (clear) {
                        this.setPreference(d1, t1, model.getPreference(d2, t2));
                        continue;
                    }
                    MinMaxPreferenceCombination com = new MinMaxPreferenceCombination();
                    com.addPreferenceProlog(this.getPreference(d1, t1) == null ? PreferenceLevel.sNeutral : this.getPreference(d1, t1));
                    com.addPreferenceProlog(model.getPreference(d2, t2) == null ? PreferenceLevel.sNeutral : this.getPreference(d2, t2));
                    this.setPreference(d1, t1, com.getPreferenceProlog());
                    continue;
                }
                String pref = model.getCombinedPreference(this.getDayCode(d1), this.getStartSlot(t1), this.getSlotsPerMtg(), alg);
                if (clear) {
                    this.setPreference(d1, t1, pref);
                    continue;
                }
                MinMaxPreferenceCombination com = new MinMaxPreferenceCombination();
                com.addPreferenceProlog(this.getPreference(d1, t1) == null ? PreferenceLevel.sNeutral : this.getPreference(d1, t1));
                com.addPreferenceProlog(pref);
                this.setPreference(d1, t1, com.getPreferenceProlog());
            }
        }
    }

    public void weakenHardPreferences() {
        for (int d = 0; d < this.getNrDays(); ++d) {
            for (int t = 0; t < this.getNrTimes(); ++t) {
                String p = this.iPreferences[d][t];
                if (PreferenceLevel.sRequired.equals(p)) {
                    this.iPreferences[d][t] = PreferenceLevel.sStronglyPreferred;
                    continue;
                }
                if (!PreferenceLevel.sProhibited.equals(p)) continue;
                this.iPreferences[d][t] = PreferenceLevel.sStronglyDiscouraged;
            }
        }
    }

    public static PrefMix getMixAlg(int algNum) {
        switch (algNum) {
            case 0: {
                return new AvgPrefMix();
            }
            case 1: {
                return new SumPrefMix();
            }
            case 3: {
                return new MaxUsagePrefMix();
            }
            case 2: {
                return new MinMaxPrefMix();
            }
            case 4: {
                return new FullCoverPrefMix();
            }
        }
        return new AvgPrefMix();
    }

    @Override
    public String getDefaultPreference() {
        return PreferenceLevel.sNeutral;
    }

    public String getFileName() {
        StringBuffer fileName = new StringBuffer();
        if (this.getTimePattern() != null && this.getTimePattern().getUniqueId() != null) {
            fileName.append(Integer.toHexString(this.getTimePattern().getUniqueId().intValue()));
        } else {
            fileName.append(this.getNrMeetings() + "x" + this.getSlotsPerMtg());
        }
        fileName.append("_");
        fileName.append(this.getPreferencesHex());
        if (this.getAssignment() != null) {
            fileName.append("_" + Integer.toHexString(this.getAssignment().getStartSlot() * 256 + this.getAssignment().getDayCode()));
        }
        return fileName.toString();
    }

    public TimeLocation getAssignment() {
        return this.iAssignment;
    }

    @Override
    public Color getBorder(int day, int time) {
        if (this.iAssignment != null && this.iAssignment.getStartSlot() == this.getStartSlot(time) && this.iAssignment.getDayCode() == this.getDayCode(day)) {
            return new Color(0, 0, 242);
        }
        return null;
    }

    @Override
    public String[] getPreferenceNames() {
        List<PreferenceLevel> prefs = PreferenceLevel.getPreferenceLevelList();
        if (!this.iAllowHard) {
            boolean hasRequired = false;
            boolean hasProhibited = false;
            for (int d = 0; d < this.getNrDays(); ++d) {
                for (int t = 0; t < this.getNrTimes(); ++t) {
                    if (PreferenceLevel.sRequired.equals(this.iPreferences[d][t])) {
                        hasRequired = true;
                    }
                    if (!PreferenceLevel.sProhibited.equals(this.iPreferences[d][t])) continue;
                    hasProhibited = true;
                }
            }
            if (!hasRequired) {
                prefs.remove(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
            }
            if (!hasProhibited) {
                prefs.remove(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sProhibited));
            }
        }
        if (this.hasNotAvailablePreference()) {
            prefs.add(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNotAvailable));
        }
        String[] ret = new String[prefs.size()];
        int idx = 0;
        for (PreferenceLevel p : prefs) {
            ret[idx++] = p.getPrefProlog();
        }
        return ret;
    }

    @Override
    public Color getPreferenceColor(String pref) {
        return PreferenceLevel.prolog2awtColor(pref);
    }

    @Override
    public String getPreferenceText(String pref) {
        return PreferenceLevel.prolog2string(pref);
    }

    @Override
    public int getNrSelections() {
        return this.iTimePattern == null ? this.iModes.size() : 0;
    }

    @Override
    public String getSelectionName(int idx) {
        return this.iModes.get(idx).getName();
    }

    @Override
    public int[] getSelectionLimits(int idx) {
        if (this.iTimePattern != null) {
            return new int[]{0, this.getNrTimes() - 1, 0, this.getNrDays() - 1};
        }
        RoomInterface.RoomSharingDisplayMode mode = this.iModes.get(idx);
        return new int[]{mode.getFirstSlot(), mode.getLastSlot() - 1, mode.getFirstDay(), mode.getLastDay(), mode.getStep()};
    }

    @Override
    public void setDefaultSelection(int selection) {
        this.iDefaultSelection = selection;
    }

    @Override
    public void setDefaultSelection(String selection) {
        this.iDefaultSelection = 0;
        if (selection == null) {
            return;
        }
        for (int i = 0; i < this.getNrSelections(); ++i) {
            if (!selection.equals(this.iModes.get(i).toHex()) && !selection.equalsIgnoreCase(this.getSelectionName(i).replaceAll("&times;", "x").replaceAll("\u00d7", "x"))) continue;
            this.iDefaultSelection = i;
            break;
        }
    }

    @Override
    public int getDefaultSelection() {
        return this.iTimePattern == null ? this.iDefaultSelection : -1;
    }

    @Override
    public boolean isEditable(int day, int time) {
        return true;
    }

    @Override
    public String getPreferenceCheck() {
        return null;
    }

    public boolean getAllowHard() {
        return this.iAllowHard;
    }

    public void setAllowHard(boolean allowHard) {
        this.iAllowHard = allowHard;
    }

    @Override
    public boolean isPreferenceEnabled(String pref) {
        return this.iAllowHard || !PreferenceLevel.getPreferenceLevel(pref).isHard();
    }

    public int getBreakTime() {
        return this.iBreakTime;
    }

    public static interface PrefMix {
        public void addPref(String var1, int var2);

        public String getPref();
    }

    public static class AvgPrefMix
    implements PrefMix {
        int iPref = 0;
        int iCnt = 0;

        @Override
        public void addPref(String prologPref, int count) {
            int pref = PreferenceLevel.prolog2int(prologPref);
            this.iPref += pref * count;
            this.iCnt += count;
        }

        @Override
        public String getPref() {
            if (this.iCnt == 0) {
                return PreferenceLevel.sNeutral;
            }
            return PreferenceLevel.int2prolog(Math.round((float)this.iPref / (float)this.iCnt));
        }
    }

    public static class SumPrefMix
    implements PrefMix {
        int iPref = 0;
        int iCnt = 0;

        @Override
        public void addPref(String prologPref, int count) {
            int pref = PreferenceLevel.prolog2int(prologPref);
            this.iPref += pref * count;
            this.iCnt += count;
        }

        @Override
        public String getPref() {
            if (this.iCnt == 0) {
                return PreferenceLevel.sNeutral;
            }
            return PreferenceLevel.int2prolog(this.iPref / 4);
        }
    }

    public static class MaxUsagePrefMix
    implements PrefMix {
        Hashtable iUsage = new Hashtable();
        int iCnt = 0;

        @Override
        public void addPref(String prologPref, int count) {
            Integer use = (Integer)this.iUsage.get(prologPref);
            use = (use == null ? 0 : use) + count;
            this.iUsage.put(prologPref, use);
            this.iCnt += count;
        }

        @Override
        public String getPref() {
            if (this.iCnt == 0) {
                return PreferenceLevel.sNeutral;
            }
            int bestUse = 0;
            String bestPref = null;
            for (Map.Entry entry : this.iUsage.entrySet()) {
                String pref = (String)entry.getKey();
                int use = (Integer)entry.getValue();
                if (bestPref == null || bestUse < use) {
                    bestPref = pref;
                    bestUse = use;
                    continue;
                }
                if (bestUse != use) continue;
                if (Math.abs(PreferenceLevel.prolog2int(pref)) > Math.abs(PreferenceLevel.prolog2int(bestPref))) {
                    bestPref = pref;
                    continue;
                }
                if (Math.abs(PreferenceLevel.prolog2int(pref)) != Math.abs(PreferenceLevel.prolog2int(bestPref)) || PreferenceLevel.prolog2int(pref) <= 0) continue;
                bestPref = pref;
            }
            return bestPref;
        }
    }

    public static class MinMaxPrefMix
    implements PrefMix {
        int iMin = Integer.MAX_VALUE;
        int iMax = Integer.MIN_VALUE;
        int iCnt = 0;

        @Override
        public void addPref(String prologPref, int count) {
            int pref = PreferenceLevel.prolog2int(prologPref);
            this.iMin = Math.min(this.iMin, pref);
            this.iMax = Math.max(this.iMax, pref);
            this.iCnt += count;
        }

        @Override
        public String getPref() {
            if (this.iCnt == 0) {
                return PreferenceLevel.sNeutral;
            }
            if (Math.abs(this.iMin) > Math.abs(this.iMax)) {
                return PreferenceLevel.int2prolog(this.iMin);
            }
            return PreferenceLevel.int2prolog(this.iMax);
        }
    }

    public static class FullCoverPrefMix
    implements PrefMix {
        String iPref = null;
        boolean iFullCover = true;

        @Override
        public void addPref(String prologPref, int count) {
            if (this.iPref == null) {
                this.iPref = prologPref;
            } else if (!this.iPref.equals(prologPref)) {
                this.iFullCover = false;
            }
        }

        @Override
        public String getPref() {
            if (this.iPref == null || !this.iFullCover) {
                return PreferenceLevel.sNeutral;
            }
            return this.iPref;
        }
    }
}

