/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.base.BaseDistributionObject;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="distribution_object")
public class DistributionObject
extends BaseDistributionObject
implements Comparable {
    private static final long serialVersionUID = 1L;

    public DistributionObject() {
    }

    public DistributionObject(Long uniqueId) {
        super(uniqueId);
    }

    public String preferenceText(boolean includeSuffix) {
        PreferenceGroup prefGroup = this.getPrefGroup();
        if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart ss = (SchedulingSubpart)prefGroup;
            return ss.getSchedulingSubpartLabel();
        }
        if (prefGroup instanceof Class_) {
            Class_ c = (Class_)prefGroup;
            return c.getClassLabel(includeSuffix);
        }
        if (prefGroup instanceof Exam) {
            Exam x = (Exam)prefGroup;
            return x.getLabel();
        }
        return " unknown " + prefGroup.getClass().getName();
    }

    public String preferenceText() {
        return this.preferenceText(false);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof DistributionObject)) {
            return -1;
        }
        DistributionObject d = (DistributionObject)o;
        if (this.getSequenceNumber() != null && d.getSequenceNumber() != null) {
            return this.getSequenceNumber().compareTo(d.getSequenceNumber());
        }
        if (this.getPrefGroup() instanceof Comparable && d.getPrefGroup() instanceof Comparable) {
            return ((Comparable)((Object)this.getPrefGroup())).compareTo(d.getPrefGroup());
        }
        return this.getPrefGroup().toString().compareTo(d.getPrefGroup().toString());
    }
}

