/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.server.CalendarServlet;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.security.rights.Right;

public class UploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAX_SIZE = 0x400000;
    public static final String SESSION_LAST_FILE = SessionAttribute.LastUploadedFile.key();

    protected SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.getServletContext());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CalendarServlet.Params params = null;
        String q = request.getParameter("q");
        params = q != null ? new CalendarServlet.QParams(q) : new CalendarServlet.HttpParams(request);
        if (params.getParameter("event") != null) {
            Long noteId;
            Long eventId = Long.parseLong(params.getParameter("event"));
            String fileName = params.getParameter("name");
            Long l = noteId = params.getParameter("note") == null ? null : Long.valueOf(params.getParameter("note"));
            if (q == null) {
                this.getSessionContext().checkPermissionAnyAuthority(eventId, "Event", Right.EventDetail, new Qualifiable[0]);
            }
            Event event = (Event)EventDAO.getInstance().get(eventId);
            TreeSet<EventNote> notes = new TreeSet<EventNote>();
            if (event != null) {
                for (EventNote note : event.getNotes()) {
                    if (note.getAttachedName() == null || note.getAttachedName().isEmpty()) continue;
                    if (fileName != null) {
                        if (!fileName.equals(note.getAttachedName()) || noteId != null && !noteId.equals(note.getUniqueId())) continue;
                        notes.add(note);
                        continue;
                    }
                    if (noteId != null) {
                        if (!noteId.equals(note.getUniqueId())) continue;
                        notes.add(note);
                        continue;
                    }
                    notes.add(note);
                }
            }
            if (!notes.isEmpty()) {
                EventNote note = (EventNote)notes.last();
                response.setContentType(note.getAttachedContentType());
                response.setHeader("Content-Disposition", "attachment; filename=\"" + note.getAttachedName() + "\"");
                ServletOutputStream out = response.getOutputStream();
                out.write(note.getAttachedFile());
                out.flush();
                out.close();
                return;
            }
        }
        throw new ServletException("Nothing to download.");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String maxSizeProperty = ApplicationProperty.MaxUploadSize.value();
            int maxSize = maxSizeProperty == null ? 0x400000 : Integer.parseInt(maxSizeProperty);
            DiskFileItemFactory diskFileItemFactory = ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setBufferSize(maxSize)).setPath(ApplicationProperties.getTempFolder().toPath())).get();
            JakartaServletFileUpload upload = new JakartaServletFileUpload((FileItemFactory)diskFileItemFactory);
            upload.setSizeMax((long)maxSize);
            List files = upload.parseRequest(request);
            Object message = null;
            if (files.size() == 1) {
                FileItem file = (FileItem)files.get(0);
                if (file.getSize() <= 0L) {
                    request.getSession().removeAttribute(SESSION_LAST_FILE);
                    message = "No file is selected.";
                } else {
                    request.getSession().setAttribute(SESSION_LAST_FILE, (Object)file);
                    message = "File " + file.getName() + " (" + file.getSize() + " bytes) selected.";
                }
            } else {
                request.getSession().removeAttribute(SESSION_LAST_FILE);
                message = "No file is selected.";
            }
            response.setContentType("text/html; charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            PrintWriter out = response.getWriter();
            out.print((String)message);
            out.flush();
            out.close();
        }
        catch (FileUploadException e) {
            response.setContentType("text/html; charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            PrintWriter out = response.getWriter();
            out.print("ERROR:Upload failed: " + e.getMessage());
            out.flush();
            out.close();
        }
    }
}

