/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor.survey;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.curricula.CourseFinderCurricula;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.CourseFinderClasses;
import org.unitime.timetable.gwt.client.widgets.CourseFinderCourses;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDetails;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDialog;
import org.unitime.timetable.gwt.client.widgets.CourseFinderFactory;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionEvent;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionHandler;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionSuggestBox;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

public class CourseSelectionBox
extends CourseSelectionSuggestBox {
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private Long iSessionId;
    private Label iTitle;

    protected CourseSelectionBox(Long sessionId) {
        this.iSessionId = sessionId;
        this.iTitle = new Label();
        this.iTitle.addStyleName("course-title");
        this.iTitle.setVisible(false);
        this.add((Widget)this.iTitle);
        this.addCourseSelectionHandler(new CourseSelectionHandler(){

            @Override
            public void onCourseSelection(CourseSelectionEvent event) {
                CourseSelectionBox.this.setTitle(event.getValue() == null ? null : event.getValue().getCourseTitle());
            }
        });
        this.setCourseFinderFactory(new CourseFinderFactory(){

            @Override
            public CourseFinder createCourseFinder() {
                CourseFinderDialog finder = new CourseFinderDialog();
                CourseFinderCourses courses = new CourseFinderCourses();
                courses.setDataProvider(new DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>>(){

                    @Override
                    public void getData(String source, final AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>> callback) {
                        RPC.execute(new InstructorSurveyInterface.ListCourseOfferings(CourseSelectionBox.this.iSessionId, source, null), new AsyncCallback<GwtRpcResponseList<ClassAssignmentInterface.CourseAssignment>>(){

                            public void onFailure(Throwable caught) {
                                callback.onFailure(caught);
                            }

                            public void onSuccess(GwtRpcResponseList<ClassAssignmentInterface.CourseAssignment> result) {
                                callback.onSuccess(result);
                            }
                        });
                    }
                });
                CourseFinderDetails details = new CourseFinderDetails();
                details.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, String>(){

                    @Override
                    public void getData(ClassAssignmentInterface.CourseAssignment source, final AsyncCallback<String> callback) {
                        RPC.execute(new InstructorSurveyInterface.RetrieveCourseDetail(CourseSelectionBox.this.iSessionId, source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), source.getCourseId()), new AsyncCallback<InstructorSurveyInterface.CourseDetail>(){

                            public void onFailure(Throwable caught) {
                                callback.onFailure(caught);
                            }

                            public void onSuccess(InstructorSurveyInterface.CourseDetail result) {
                                callback.onSuccess((Object)result.getDetail());
                            }
                        });
                    }
                });
                CourseFinderClasses classes = new CourseFinderClasses(false);
                classes.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>>(){

                    @Override
                    public void getData(ClassAssignmentInterface.CourseAssignment source, final AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>> callback) {
                        RPC.execute(new InstructorSurveyInterface.ListClasses(CourseSelectionBox.this.iSessionId, source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), source.getCourseId()), new AsyncCallback<GwtRpcResponseList<ClassAssignmentInterface.ClassAssignment>>(){

                            public void onFailure(Throwable caught) {
                                callback.onFailure(caught);
                            }

                            public void onSuccess(GwtRpcResponseList<ClassAssignmentInterface.ClassAssignment> result) {
                                callback.onSuccess(result);
                            }
                        });
                    }
                });
                CourseFinderCurricula curricula = new CourseFinderCurricula(){

                    @Override
                    protected void ensureInitialized(final AsyncCallback<Boolean> callback) {
                        if (this.iClassifications != null) {
                            callback.onSuccess((Object)true);
                        }
                        RPC.execute(new InstructorSurveyInterface.ListAcademicClassifications(CourseSelectionBox.this.iSessionId), new AsyncCallback<GwtRpcResponseList<CurriculumInterface.AcademicClassificationInterface>>(){

                            public void onSuccess(GwtRpcResponseList<CurriculumInterface.AcademicClassificationInterface> result) {
                                iClassifications = new TreeSet<CurriculumInterface.AcademicClassificationInterface>(result);
                                if (callback != null) {
                                    callback.onSuccess((Object)true);
                                }
                            }

                            public void onFailure(Throwable caught) {
                                iHeader.setErrorMessage(MESSAGES.failedToLoadClassifications(caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedToLoadClassifications(caught.getMessage()), caught);
                                if (callback != null) {
                                    callback.onFailure(caught);
                                }
                            }
                        });
                    }
                };
                curricula.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, TreeSet<CurriculumInterface>>(){

                    @Override
                    public void getData(ClassAssignmentInterface.CourseAssignment source, final AsyncCallback<TreeSet<CurriculumInterface>> callback) {
                        RPC.execute(new InstructorSurveyInterface.ListCurricula(CourseSelectionBox.this.iSessionId, source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), source.getCourseId()), new AsyncCallback<GwtRpcResponseList<CurriculumInterface>>(){

                            public void onFailure(Throwable caught) {
                                callback.onFailure(caught);
                            }

                            public void onSuccess(GwtRpcResponseList<CurriculumInterface> result) {
                                if (result == null) {
                                    callback.onSuccess(null);
                                } else {
                                    callback.onSuccess(new TreeSet<CurriculumInterface>(result));
                                }
                            }
                        });
                    }
                });
                courses.setCourseDetails(details, classes, curricula);
                finder.setTabs(courses);
                return finder;
            }
        });
        this.setSuggestions(new DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>>(){

            @Override
            public void getData(String source, final AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>> callback) {
                RPC.execute(new InstructorSurveyInterface.ListCourseOfferings(CourseSelectionBox.this.iSessionId, source, 20), new AsyncCallback<GwtRpcResponseList<ClassAssignmentInterface.CourseAssignment>>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(GwtRpcResponseList<ClassAssignmentInterface.CourseAssignment> result) {
                        callback.onSuccess(result);
                    }
                });
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.iFinderButton.setTabIndex(0);
            this.iFinderButton.setVisible(true);
            this.iSuggest.getElement().getStyle().clearBackgroundColor();
            this.iSuggest.getElement().getStyle().clearBorderColor();
        } else {
            this.iFinderButton.setTabIndex(-1);
            this.iFinderButton.setVisible(false);
            this.iSuggest.getElement().getStyle().setBorderColor("transparent");
            this.iSuggest.getElement().getStyle().setBackgroundColor("transparent");
        }
    }

    public void setTitle(String title) {
        if (title == null || title.isEmpty()) {
            this.iTitle.setText("");
            this.iTitle.setVisible(false);
        } else {
            this.iTitle.setText(title);
            this.iTitle.setVisible(true);
        }
    }

    public void setValue(InstructorSurveyInterface.Course course, boolean fireEvents) {
        CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
        rc.setCourseId(course.getId());
        rc.setCourseName(course.getCourseName());
        rc.setCourseTitle(course.getCourseTitle());
        super.setValue(rc, fireEvents);
        this.setTitle(course.getCourseTitle());
    }

    public void setValue(InstructorSurveyInterface.Course course) {
        this.setValue(course, false);
    }
}

