/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class LoggingConnectionProvider
implements ConnectionProvider,
Stoppable,
Configurable {
    private static final long serialVersionUID = 1L;
    private List<Lease> iLeases = new ArrayList<Lease>();
    private LeasedConnectionsLogger iLogger = null;
    private ConnectionProvider iConnectionProvider;

    public LoggingConnectionProvider(ConnectionProvider provider) {
        this.iConnectionProvider = provider;
        this.iLogger = new LeasedConnectionsLogger();
        this.iLogger.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Connection connection = this.iConnectionProvider.getConnection();
        List<Lease> list = this.iLeases;
        synchronized (list) {
            this.iLeases.add(new Lease(connection));
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection connection) throws SQLException {
        List<Lease> list = this.iLeases;
        synchronized (list) {
            Iterator<Lease> i = this.iLeases.iterator();
            while (i.hasNext()) {
                Lease lease = i.next();
                if (!lease.getConnection().equals(connection)) continue;
                i.remove();
            }
        }
        this.iConnectionProvider.closeConnection(connection);
    }

    public boolean supportsAggressiveRelease() {
        return this.iConnectionProvider.supportsAggressiveRelease();
    }

    public boolean isUnwrappableAs(Class clazz) {
        return this.iConnectionProvider.isUnwrappableAs(clazz);
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.iConnectionProvider.unwrap(clazz);
    }

    public void stop() {
        this.iLogger.interrupt();
        if (this.iConnectionProvider instanceof Stoppable) {
            ((Stoppable)this.iConnectionProvider).stop();
        }
    }

    public void configure(Map properties) {
        if (this.iConnectionProvider instanceof Configurable) {
            ((Configurable)this.iConnectionProvider).configure(properties);
        }
    }

    public class LeasedConnectionsLogger
    extends Thread {
        private Log iLog;
        private boolean iActive;

        public LeasedConnectionsLogger() {
            super("LeasedConnectionsLogger");
            this.iLog = LogFactory.getLog(LeasedConnectionsLogger.class);
            this.iActive = true;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.iLog.info((Object)"Database connection pool logging is enabled.");
            while (this.iActive) {
                try {
                    try {
                        LeasedConnectionsLogger.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    List<Lease> list = LoggingConnectionProvider.this.iLeases;
                    synchronized (list) {
                        ArrayList<Lease> suspicious = new ArrayList<Lease>();
                        for (Lease lease : LoggingConnectionProvider.this.iLeases) {
                            if (!(lease.getLeaseTime() > 60.0) && lease.getState() != Thread.State.TERMINATED) continue;
                            suspicious.add(lease);
                        }
                        if (!suspicious.isEmpty()) {
                            this.iLog.warn((Object)("Suspicious leases:" + ToolBox.col2string(LoggingConnectionProvider.this.iLeases, (int)2)));
                        }
                        for (Lease lease : suspicious) {
                            if (lease.getState() != Thread.State.TERMINATED) continue;
                            this.iLog.fatal((Object)("Releasing connection of a terminated thread " + lease.getName() + "." + lease.getStackTrace()));
                            LoggingConnectionProvider.this.closeConnection(lease.getConnection());
                        }
                    }
                }
                catch (Exception e) {
                    this.iLog.warn((Object)("Logging failed: " + e.getMessage()), (Throwable)e);
                }
            }
            this.iLog.info((Object)"Database connection pool logging has stopped.");
        }

        @Override
        public void interrupt() {
            this.iActive = false;
            super.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class Lease {
        private static final DecimalFormat sDF = new DecimalFormat("#,##0.00");
        private Connection iConnection;
        private Thread iThread;
        private StackTraceElement[] iTrace;
        private long iTimeStamp;

        public Lease(Connection connection) {
            this.iConnection = connection;
            this.iThread = Thread.currentThread();
            this.iTrace = Thread.currentThread().getStackTrace();
            this.iTimeStamp = System.currentTimeMillis();
        }

        public Connection getConnection() {
            return this.iConnection;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Connection) {
                return this.getConnection().equals(o);
            }
            if (o instanceof Lease) {
                return this.getConnection().equals(((Lease)o).getConnection());
            }
            return false;
        }

        public double getLeaseTime() {
            return (double)(System.currentTimeMillis() - this.iTimeStamp) / 1000.0;
        }

        public Thread.State getState() {
            return this.iThread.getState();
        }

        public String getName() {
            return this.iThread.getName();
        }

        public String getStackTrace() {
            int first = 0;
            for (int i = 3; i < this.iTrace.length; ++i) {
                if (!this.iTrace[i].getClassName().startsWith("org.unitime.")) continue;
                first = i;
                break;
            }
            StringBuffer ret = new StringBuffer();
            for (int i = first; i < this.iTrace.length; ++i) {
                ret.append("\n  " + String.valueOf(this.iTrace[i]));
            }
            return ret.toString();
        }

        public String toString() {
            StackTraceElement trace = null;
            for (int i = 3; i < this.iTrace.length; ++i) {
                if (!this.iTrace[i].getClassName().startsWith("org.unitime.") || this.iTrace[i].getClassName().endsWith(".HibernateUtil") || this.iTrace[i].getClassName().endsWith("._RootDAO") || this.iTrace[i].getClassName().endsWith(".OnlineSectioningHelper") || this.iTrace[i].getClassName().endsWith(".UniTimePermissionCheck")) continue;
                trace = this.iTrace[i];
                break;
            }
            return sDF.format(this.getLeaseTime()) + " " + String.valueOf((Object)this.getState()) + " " + this.getName() + " " + String.valueOf(trace);
        }
    }
}

