/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.AbstractMultiIdEntityLoader;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ManagedResultConsumer;

public class MultiIdEntityLoaderArrayParam<E>
extends AbstractMultiIdEntityLoader<E>
implements SqlArrayMultiKeyLoader {
    private final JdbcMapping arrayJdbcMapping;
    private final JdbcParameter jdbcParameter;

    public MultiIdEntityLoaderArrayParam(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        Class<?> arrayClass = this.createTypedArray(0).getClass();
        this.arrayJdbcMapping = MultiKeyLoadHelper.resolveArrayJdbcMapping(this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(arrayClass), this.getIdentifierMapping().getJdbcMapping(), arrayClass, this.getSessionFactory());
        this.jdbcParameter = new JdbcParameterImpl(this.arrayJdbcMapping);
    }

    @Override
    public BasicEntityIdentifierMapping getIdentifierMapping() {
        return (BasicEntityIdentifierMapping)super.getIdentifierMapping();
    }

    @Override
    protected <K> List<E> performOrderedMultiLoad(K[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("MultiIdEntityLoaderArrayParam#performOrderedMultiLoad - %s", (Object)this.getLoadable().getEntityName());
        }
        boolean coerce = !this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
        LockOptions lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        ArrayList result = CollectionHelper.arrayList(ids.length);
        ArrayList<K> idsToLoadFromDatabase = null;
        ArrayList<Integer> idsToLoadFromDatabaseResultIndexes = null;
        for (int i = 0; i < ids.length; ++i) {
            Object id = coerce ? this.getLoadable().getIdentifierMapping().getJavaType().coerce(ids[i], session) : ids[i];
            EntityKey entityKey = new EntityKey(id, this.getLoadable().getEntityPersister());
            if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
                CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry;
                LoadEvent loadEvent = new LoadEvent(id, this.getLoadable().getJavaType().getJavaTypeClass().getName(), lockOptions, session, LoaderHelper.getReadOnlyFromLoadQueryInfluencers(session));
                Object managedEntity = null;
                if (loadOptions.isSessionCheckingEnabled() && (managedEntity = (persistenceContextEntry = CacheEntityLoaderHelper.loadFromSessionCacheStatic(loadEvent, entityKey, LoadEventListener.GET)).getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                    result.add(i, null);
                    continue;
                }
                if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                    managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.getLoadable().getEntityPersister(), entityKey);
                }
                if (managedEntity != null) {
                    result.add(i, managedEntity);
                    continue;
                }
            }
            if (idsToLoadFromDatabase == null) {
                idsToLoadFromDatabase = new ArrayList<K>();
                idsToLoadFromDatabaseResultIndexes = new ArrayList<Integer>();
            }
            result.add(i, entityKey);
            idsToLoadFromDatabase.add(id);
            idsToLoadFromDatabaseResultIndexes.add(i);
        }
        if (idsToLoadFromDatabase == null) {
            return result;
        }
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), this.getIdentifierMapping(), session.getLoadQueryInfluencers(), lockOptions, this.jdbcParameter, this.getSessionFactory());
        JdbcOperationQuerySelect jdbcSelectOperation = this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(1);
        jdbcParameterBindings.addBinding(this.jdbcParameter, new JdbcParameterBindingImpl(this.arrayJdbcMapping, idsToLoadFromDatabase.toArray(this.createTypedArray(0))));
        PersistenceContext persistenceContext = session.getPersistenceContext();
        BatchFetchQueue batchFetchQueue = persistenceContext.getBatchFetchQueue();
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler(batchFetchQueue, sqlAst, JdbcParametersList.singleton(this.jdbcParameter), jdbcParameterBindings);
        session.getJdbcServices().getJdbcSelectExecutor().executeQuery(jdbcSelectOperation, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new ExecutionContextWithSubselectFetchHandler(session, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), null, idsToLoadFromDatabase.size(), ManagedResultConsumer.INSTANCE);
        for (int i = 0; i < idsToLoadFromDatabaseResultIndexes.size(); ++i) {
            EntityEntry entry;
            Integer resultIndex = (Integer)idsToLoadFromDatabaseResultIndexes.get(i);
            EntityKey entityKey = (EntityKey)result.get(resultIndex);
            BatchFetchQueueHelper.removeBatchLoadableEntityKey(entityKey, session);
            Object entity = persistenceContext.getEntity(entityKey);
            if (entity != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && (entry = persistenceContext.getEntry(entity)).getStatus().isDeletedOrGone()) {
                entity = null;
            }
            result.set(resultIndex, entity);
        }
        return result;
    }

    @Override
    protected <K> List<E> performUnorderedMultiLoad(K[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        LockOptions lockOptions;
        ArrayList result;
        K[] idsToLoadFromDatabase;
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("MultiIdEntityLoaderArrayParam#performUnorderedMultiLoad - %s", (Object)this.getLoadable().getEntityName());
        }
        if ((idsToLoadFromDatabase = this.processResolvableEntities(ids, (arg_0, arg_1, arg_2) -> MultiIdEntityLoaderArrayParam.lambda$performUnorderedMultiLoad$0(result = CollectionHelper.arrayList(ids.length), arg_0, arg_1, arg_2), loadOptions, lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions(), session)) == null) {
            return result;
        }
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), this.getIdentifierMapping(), session.getLoadQueryInfluencers(), lockOptions, this.jdbcParameter, this.getSessionFactory());
        JdbcOperationQuerySelect jdbcSelectOperation = this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
        List databaseResults = LoaderHelper.loadByArrayParameter(idsToLoadFromDatabase, sqlAst, jdbcSelectOperation, this.jdbcParameter, this.arrayJdbcMapping, null, null, null, lockOptions, session.isDefaultReadOnly(), session);
        result.addAll(databaseResults);
        for (int i = 0; i < idsToLoadFromDatabase.length; ++i) {
            K id = idsToLoadFromDatabase[i];
            if (id == null) continue;
            BatchFetchQueueHelper.removeBatchLoadableEntityKey(id, this.getLoadable(), (SharedSessionContractImplementor)session);
        }
        return result;
    }

    protected final <R, K> K[] processResolvableEntities(K[] ids, ResolutionConsumer<R> resolutionConsumer, @NonNull MultiIdLoadOptions loadOptions, @NonNull LockOptions lockOptions, EventSource session) {
        if (!loadOptions.isSessionCheckingEnabled() && !loadOptions.isSecondLevelCacheCheckingEnabled()) {
            return ids;
        }
        boolean coerce = !this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
        boolean foundAnyResolvedEntities = false;
        ArrayList<K> nonResolvedIds = null;
        for (int i = 0; i < ids.length; ++i) {
            Object id = coerce ? this.getLoadable().getIdentifierMapping().getJavaType().coerce(ids[i], session) : ids[i];
            EntityKey entityKey = new EntityKey(id, this.getLoadable().getEntityPersister());
            LoadEvent loadEvent = new LoadEvent(id, this.getLoadable().getJavaType().getJavaTypeClass().getName(), lockOptions, session, LoaderHelper.getReadOnlyFromLoadQueryInfluencers(session));
            Object resolvedEntity = null;
            CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry = CacheEntityLoaderHelper.loadFromSessionCacheStatic(loadEvent, entityKey, LoadEventListener.GET);
            if (loadOptions.isSessionCheckingEnabled() && (resolvedEntity = persistenceContextEntry.getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                foundAnyResolvedEntities = true;
                resolutionConsumer.consume(i, entityKey, null);
                continue;
            }
            if (resolvedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                resolvedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.getLoadable().getEntityPersister(), entityKey);
            }
            if (resolvedEntity != null) {
                foundAnyResolvedEntities = true;
                resolutionConsumer.consume(i, entityKey, resolvedEntity);
                continue;
            }
            if (nonResolvedIds == null) {
                nonResolvedIds = new ArrayList<K>();
            }
            nonResolvedIds.add(id);
        }
        if (foundAnyResolvedEntities) {
            if (CollectionHelper.isEmpty(nonResolvedIds)) {
                return null;
            }
            return nonResolvedIds.toArray(this.createTypedArray(0));
        }
        return ids;
    }

    private <X> X[] createTypedArray(int length) {
        return (Object[])Array.newInstance(this.getIdentifierMapping().getJavaType().getJavaTypeClass(), length);
    }

    private static /* synthetic */ void lambda$performUnorderedMultiLoad$0(List result, int index, EntityKey entityKey, Object resolvedEntity) {
        result.add(resolvedEntity);
    }

    public static interface ResolutionConsumer<T> {
        public void consume(int var1, EntityKey var2, T var3);
    }
}

