/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.DefaultFetchProfile;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.profile.internal.FetchProfileAffectee;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.RuntimeMetamodels;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;

public class FetchProfileHelper {
    public static Map<String, FetchProfile> getFetchProfiles(MetadataImplementor bootMetamodel, RuntimeMetamodels runtimeMetamodels) {
        HashMap<String, FetchProfile> fetchProfiles = new HashMap<String, FetchProfile>();
        for (org.hibernate.mapping.FetchProfile mappingProfile : bootMetamodel.getFetchProfiles()) {
            FetchProfile fetchProfile = FetchProfileHelper.createFetchProfile(runtimeMetamodels.getMappingMetamodel(), mappingProfile);
            fetchProfiles.put(fetchProfile.getName(), fetchProfile);
        }
        fetchProfiles.put("org.hibernate.defaultProfile", new DefaultFetchProfile(runtimeMetamodels));
        return fetchProfiles;
    }

    private static FetchProfile createFetchProfile(MappingMetamodel mappingMetamodel, org.hibernate.mapping.FetchProfile mappingProfile) {
        String profileName = mappingProfile.getName();
        FetchProfile fetchProfile = new FetchProfile(profileName);
        for (FetchProfile.Fetch mappingFetch : mappingProfile.getFetches()) {
            EntityPersister owner = FetchProfileHelper.getEntityPersister(mappingMetamodel, fetchProfile, mappingFetch);
            ((FetchProfileAffectee)((Object)owner)).registerAffectingFetchProfile(profileName);
            Association association = new Association(owner, mappingFetch.getAssociation());
            FetchStyle fetchStyle = Fetch.Style.forMethod(mappingFetch.getMethod()).toFetchStyle();
            FetchTiming fetchTiming = FetchTiming.forType(mappingFetch.getType());
            ModelPart fetchablePart = owner.findByPath(association.getAssociationPath());
            FetchProfileHelper.validateFetchablePart(fetchablePart, profileName, association);
            if (fetchablePart instanceof FetchProfileAffectee) {
                ((FetchProfileAffectee)((Object)fetchablePart)).registerAffectingFetchProfile(profileName);
            }
            fetchProfile.addFetch(new Fetch(association, fetchStyle, fetchTiming));
        }
        return fetchProfile;
    }

    private static void validateFetchablePart(ModelPart fetchablePart, String profileName, Association association) {
        if (fetchablePart == null) {
            throw new HibernateException(String.format("Fetch profile [%s] specified an association that does not exist - %s", profileName, association.getRole()));
        }
        if (!FetchProfileHelper.isAssociation(fetchablePart)) {
            throw new HibernateException(String.format("Fetch profile [%s] specified an association that is not an association - %s", profileName, association.getRole()));
        }
    }

    private static boolean isAssociation(ModelPart fetchablePart) {
        return fetchablePart instanceof EntityValuedModelPart || fetchablePart instanceof PluralAttributeMapping;
    }

    private static EntityPersister getEntityPersister(MappingMetamodel mappingMetamodel, FetchProfile fetchProfile, FetchProfile.Fetch mappingFetch) {
        EntityPersister persister;
        String entityName = mappingMetamodel.getImportedName(mappingFetch.getEntity());
        if (entityName != null && (persister = mappingMetamodel.getEntityDescriptor(entityName)) != null) {
            return persister;
        }
        throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile.getName() + "]");
    }
}

