/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.security.User;
import org.restlet.security.Verifier;

public abstract class SecretVerifier
implements Verifier {
    public static boolean compare(char[] secret1, char[] secret2) {
        boolean result = false;
        if (secret1 != null && secret2 != null && secret1.length == secret2.length) {
            boolean equals = true;
            for (int i = 0; i < secret1.length && equals; ++i) {
                equals = secret1[i] == secret2[i];
            }
            result = equals;
        }
        return result;
    }

    protected User createUser(String identifier, Request request, Response response) {
        return new User(identifier);
    }

    protected String getIdentifier(Request request, Response response) {
        return request.getChallengeResponse().getIdentifier();
    }

    protected char[] getSecret(Request request, Response response) {
        return request.getChallengeResponse().getSecret();
    }

    @Override
    public int verify(Request request, Response response) {
        int result = 4;
        if (request.getChallengeResponse() == null) {
            result = 0;
        } else {
            char[] secret;
            String identifier = this.getIdentifier(request, response);
            result = this.verify(identifier, secret = this.getSecret(request, response));
            if (result == 4) {
                request.getClientInfo().setUser(this.createUser(identifier, request, response));
            }
        }
        return result;
    }

    public abstract int verify(String var1, char[] var2);
}

