/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.util.HtmlUtils;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BasePreference;
import org.unitime.timetable.model.base.BaseRoomFeaturePref;
import org.unitime.timetable.model.base.BaseRoomPref;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassEditBackend;
import org.unitime.timetable.server.courses.ClassesTableBuilder;
import org.unitime.timetable.server.courses.DistributionsTableBuilder;
import org.unitime.timetable.server.courses.ExaminationsTableBuilder;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.JavascriptFunctions;

@GwtRpcImplements(value=OfferingsInterface.SubpartDetailRequest.class)
public class SubpartDetailBackend
implements GwtRpcImplementation<OfferingsInterface.SubpartDetailRequest, OfferingsInterface.SubpartDetailReponse> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final GwtMessages GWT = Localization.create(GwtMessages.class);
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public OfferingsInterface.SubpartDetailReponse execute(OfferingsInterface.SubpartDetailRequest request, SessionContext context) {
        CourseCreditUnitConfig credit;
        Session hibSession = SchedulingSubpartDAO.getInstance().getSession();
        SchedulingSubpart ss = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(request.getSubpartgId(), hibSession);
        context.checkPermission(ss, Right.SchedulingSubpartDetail);
        if (request.getAction() == null) {
            BackTracker.markForBack(context, "subpart?id=" + request.getSubpartgId(), MSG.backSubpart(ss.getSchedulingSubpartLabel()), true, false);
        } else {
            switch (request.getAction()) {
                case ClearPrefs: {
                    for (Class_ c : ss.getClasses()) {
                        c.getPreferences().clear();
                        hibSession.merge((Object)c);
                    }
                    ChangeLog.addChange(null, context, ss, ChangeLog.Source.SCHEDULING_SUBPART_EDIT, ChangeLog.Operation.CLEAR_ALL_PREF, ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), ss.getManagingDept());
                    hibSession.flush();
                }
            }
        }
        OfferingsInterface.SubpartDetailReponse response = new OfferingsInterface.SubpartDetailReponse();
        response.setConfirms(JavascriptFunctions.isJsConfirm(context));
        InstrOfferingConfig ioc = ss.getInstrOfferingConfig();
        InstructionalOffering io = ioc.getInstructionalOffering();
        response.setSubpartId(ss.getUniqueId());
        Object label = ss.getItype().getAbbv();
        for (SchedulingSubpart parent = ss.getParentSubpart(); parent != null; parent = parent.getParentSubpart()) {
            label = parent.getItype().getAbbv() + " - " + (String)label;
        }
        if (io.hasMultipleConfigurations()) {
            label = (String)label + " [" + ioc.getName() + "]";
        }
        response.setSubparName((String)label);
        response.setOfferingId(ss.getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
        response.setCourseName(ss.getCourseNameWithTitle());
        SchedulingSubpart next = ss.getNextSchedulingSubpart(context, Right.SchedulingSubpartDetail);
        response.setNextId(next == null ? null : next.getUniqueId());
        SchedulingSubpart previous = ss.getPreviousSchedulingSubpart(context, Right.SchedulingSubpartDetail);
        response.setPreviousId(previous == null ? null : previous.getUniqueId());
        response.addProperty(MSG.filterManager()).add(ss.getManagingDept().getManagingDeptLabel());
        if (ss.getParentSubpart() != null) {
            TableInterface.CellInterface c = response.addProperty(MSG.propertyParentSchedulingSubpart()).setText(ss.getParentSubpart().getSchedulingSubpartLabel());
            if (context.hasPermission(ss.getParentSubpart(), Right.SchedulingSubpartDetail)) {
                c.setUrl("subpart?id=" + ss.getParentSubpart().getUniqueId());
                c.setClassName("link");
            }
        }
        response.addProperty(MSG.filterInstructionalType()).add(ss.getItype().getDesc());
        DatePattern dp = ss.getDatePattern();
        if (dp != null) {
            c = response.addProperty(MSG.propertyDatePattern()).add(dp.getName()).add("");
            if (dp.getDatePatternType() != DatePattern.DatePatternType.PatternSet) {
                c.addClick().setTitle(MSG.sectPreviewOfDatePattern(dp.getName())).addWidget().setId("UniTimeGWT:DatePattern").setContent(dp.getPatternText());
                c.setImage().setSource("images/calendar.png").addStyle("cursor: pointer; padding-left: 5px; vertical-align: bottom;");
            }
        } else {
            dp = ss.effectiveDatePattern();
            if (dp != null) {
                c = response.addProperty(MSG.propertyDatePattern()).add(MSG.dropDefaultDatePattern() + " (" + dp.getName() + ")").add("");
                if (dp.getDatePatternType() != DatePattern.DatePatternType.PatternSet) {
                    c.addClick().setTitle(MSG.sectPreviewOfDatePattern(dp.getName())).addWidget().setId("UniTimeGWT:DatePattern").setContent(dp.getPatternText());
                    c.setImage().setSource("images/calendar.png").addStyle("cursor: pointer; padding-left: 5px; vertical-align: bottom;");
                }
            }
        }
        if (Boolean.FALSE.equals(ss.isAutoSpreadInTime())) {
            response.addProperty(MSG.propertyAutomaticSpreadInTime()).add(MSG.classDetailNoSpread(), true);
        }
        if (Boolean.TRUE.equals(ss.isStudentAllowOverlap())) {
            response.addProperty(MSG.propertyStudentOverlaps()).add(MSG.classDetailAllowOverlap(), true);
        }
        if (!(ss.getParentSubpart() != null && ss.getItype().equals(ss.getParentSubpart().getItype()) || (credit = ss.getCredit()) == null)) {
            response.addProperty(MSG.propertySubpartCredit()).add(credit.creditText());
        }
        if (CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.DisplayLastChanges))) {
            ChangeLog cl = ChangeLog.findLastChange(ss);
            if (cl != null) {
                response.addProperty(GWT.propLastChange()).add(cl.getShortLabel());
            } else {
                response.addProperty(GWT.propLastChange()).add(GWT.notApplicable()).addStyle("font-style: italic;");
            }
        }
        response.setPreferences(SubpartDetailBackend.getPreferenceTable(context, ss, Preference.Type.DATE, Preference.Type.TIME, Preference.Type.ROOM_GROUP, Preference.Type.ROOM, Preference.Type.BUILDING, Preference.Type.ROOM_FEATURE));
        ClassesTableBuilder builder = new ClassesTableBuilder(context, null, null);
        response.setClasses(builder.generateTableForSubpart(this.classAssignmentService.getAssignment(), ss));
        ExaminationsTableBuilder examBuilder = new ExaminationsTableBuilder(context, null, null);
        response.setExaminations(examBuilder.createExamsTable("SchedulingSubpart", ss.getUniqueId(), this.examinationSolverService.getSolver()));
        DistributionsTableBuilder distBuilder = new DistributionsTableBuilder(context, null, null);
        response.setDistributions(distBuilder.getDistPrefsTableForSchedulingSupart(ss));
        BackTracker.BackItem back = BackTracker.getBackItem(context, 2);
        if (back != null) {
            response.addOperation("back");
            response.setBackTitle(back.getTitle());
            response.setBackUrl(back.getUrl() + (back.getUrl().indexOf(63) >= 0 ? "&" : "?") + "backId=" + ss.getUniqueId() + "&backType=PreferenceGroup");
        }
        if (response.getPreviousId() != null && context.hasPermission(response.getPreviousId(), "SchedulingSubpart", Right.SchedulingSubpartDetail)) {
            response.addOperation("previous");
        }
        if (response.getNextId() != null && context.hasPermission(response.getNextId(), "SchedulingSubpart", Right.SchedulingSubpartDetail)) {
            response.addOperation("next");
        }
        if (context.hasPermission(Right.ExaminationAdd)) {
            response.addOperation("add-exam");
        }
        if (context.hasPermission(Right.DistributionPreferenceAdd) && context.hasPermission(ss, Right.DistributionPreferenceSubpart)) {
            if (ApplicationProperty.LegacyDistributions.isTrue()) {
                response.addOperation("add-distribution-legacy");
            } else {
                response.addOperation("add-distribution");
            }
        }
        if (context.hasPermission(ss, Right.SchedulingSubpartEdit)) {
            response.addOperation("edit");
        }
        if (context.hasPermission(ss, Right.SchedulingSubpartDetailClearClassPreferences)) {
            response.addOperation("clear-prefs");
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public static TableInterface getPreferenceTable(SessionContext context, PreferenceGroup pg, Preference.Type ... types) {
        TableInterface table = new TableInterface();
        boolean hasNotAvailable = false;
        boolean multipleRooms = false;
        boolean excap = pg instanceof Exam && ((Exam)pg).getSeatingType() == 1;
        DurationModel dm = null;
        int minutes = 0;
        if (pg instanceof Class_) {
            Class_ clazz = (Class_)pg;
            if (clazz.getNbrRooms() > 1) {
                multipleRooms = true;
            }
            dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            minutes = clazz.getSchedulingSubpart().getMinutesPerWk();
        } else if (pg instanceof SchedulingSubpart) {
            SchedulingSubpart subpart = (SchedulingSubpart)pg;
            int maxRooms = subpart.getMaxRooms();
            if (maxRooms > 1) {
                multipleRooms = true;
            }
            dm = subpart.getInstrOfferingConfig().getDurationModel();
            minutes = subpart.getMinutesPerWk();
        }
        DatePattern dp = pg.effectiveDatePattern();
        block10: for (Preference.Type type : types) {
            switch (type) {
                case TIME: {
                    Set<TimePref> timePrefs = pg.effectivePreferences(TimePref.class, null, false);
                    if (timePrefs.isEmpty()) continue block10;
                    TableInterface.CellInterface tpCell = table.addProperty(MSG.propertyTime());
                    for (TimePref tp : timePrefs) {
                        if (tp.getTimePattern() != null && tp.getTimePattern().isExactTime()) {
                            tpCell.add(tp.getTimePatternModel().toString()).setInline(false);
                            continue;
                        }
                        PrefGroupEditInterface.TimePatternModel timePatternModel = ClassEditBackend.createTimePatternModel(tp, context);
                        tpCell.add(null).setTimePreference(timePatternModel);
                        if (dm == null || dp != null && dm.isValidCombination(minutes, dp, tp.getTimePattern())) continue;
                        timePatternModel.setValid(false);
                    }
                    continue block10;
                }
                case DATE: {
                    TableInterface.CellInterface cell;
                    if (dp.getDatePatternType() != DatePattern.DatePatternType.PatternSet || dp.getChildren().isEmpty()) continue block10;
                    Set<DatePatternPref> datePrefs = pg.effectivePreferences(DatePatternPref.class);
                    boolean req = false;
                    Object rpCell = new TableInterface.CellInterface();
                    for (DatePattern child : new TreeSet<DatePattern>(dp.getChildren())) {
                        void var20_31;
                        PreferenceLevel preferenceLevel = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral);
                        for (DatePatternPref p : datePrefs) {
                            if (!p.getDatePattern().equals(child)) continue;
                            PreferenceLevel preferenceLevel2 = p.getPrefLevel();
                            break;
                        }
                        if (var20_31.getPrefProlog().equals(PreferenceLevel.sRequired)) {
                            if (!req && ((TableInterface.CellInterface)rpCell).hasItems()) {
                                ((TableInterface.CellInterface)rpCell).getItems().clear();
                            }
                            req = true;
                        } else if (req) continue;
                        cell = ((TableInterface.CellInterface)rpCell).add(null).setInline(false);
                        if (!var20_31.getPrefProlog().equals(PreferenceLevel.sNeutral)) {
                            cell.setColor(PreferenceLevel.prolog2color(var20_31.getPrefProlog()));
                        }
                        cell.setAria(var20_31.getPrefAbbv() + " " + child.getName());
                        if (child.getDatePatternType() != DatePattern.DatePatternType.Alternate) {
                            Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
                            Date first = child.getStartDate();
                            Date last = child.getEndDate();
                            cell.setText(child.getName() + " (" + dpf.format(first) + (String)(first.equals(last) ? "" : " - " + dpf.format(last)) + ")");
                        } else {
                            cell.setText(child.getName());
                        }
                        cell.addStyle("cursor: pointer;");
                        cell.addClick().setTitle(MSG.sectPreviewOfDatePattern(child.getName())).addWidget().setId("UniTimeGWT:DatePattern").setContent(child.getPatternText());
                    }
                    if (!((TableInterface.CellInterface)rpCell).hasItems()) continue block10;
                    table.addProperty(new TableInterface.PropertyInterface().setName(MSG.propertyDatePatterns()).setCell((TableInterface.CellInterface)rpCell));
                    continue block10;
                }
                case ROOM_GROUP: {
                    Set<RoomGroupPref> roomGrouPrefs = pg.effectivePreferences(RoomGroupPref.class);
                    if (roomGrouPrefs.isEmpty()) continue block10;
                    TableInterface.CellInterface rpCell = table.addProperty(MSG.propertyRoomGroups());
                    for (RoomGroupPref roomGroupPref : roomGrouPrefs) {
                        TableInterface.CellInterface cell = rpCell.add(null).setInline(false);
                        if (roomGroupPref.getPrefLevel().getPrefId() != 4) {
                            cell.setColor(PreferenceLevel.prolog2color(roomGroupPref.getPrefLevel().getPrefProlog()));
                        }
                        cell.setText(roomGroupPref.getRoomGroup().getNameWithTitle() + (String)(multipleRooms ? (roomGroupPref.getRoomIndex() == null ? " (" + MSG.itemAllRooms() + ")" : " (" + MSG.itemOnlyRoom(roomGroupPref.getRoomIndex() + 1) + ")") : ""));
                        String string = HtmlUtils.htmlEscape((String)MSG.prefTitleRoomGroup(roomGroupPref.getPrefLevel().getPrefName(), cell.getText()));
                        cell.setAria(MSG.prefTitleRoomGroup(roomGroupPref.getPrefLevel().getPrefName(), cell.getText()));
                        cell.setMouseOver("$wnd.showGwtHint($wnd.lastMouseOverElement, '" + string + "');");
                        cell.setMouseOut("$wnd.hideGwtHint();");
                    }
                    continue block10;
                }
                case ROOM: {
                    Set<RoomPref> roomPrefs = pg.effectivePreferences(RoomPref.class);
                    if (roomPrefs.isEmpty()) continue block10;
                    Object rpCell = table.addProperty(MSG.propertyRooms());
                    for (Object rp2 : roomPrefs) {
                        TableInterface.CellInterface cellInterface = ((TableInterface.CellInterface)rpCell).add(null).setInline(false);
                        if (((BasePreference)rp2).getPrefLevel().getPrefId() != 4) {
                            cellInterface.setColor(PreferenceLevel.prolog2color(((BasePreference)rp2).getPrefLevel().getPrefProlog()));
                        }
                        cellInterface.setText((excap ? ((BaseRoomPref)rp2).getRoom().getLabelWithExamCapacity() : ((BaseRoomPref)rp2).getRoom().getLabelWithCapacity()) + (String)(multipleRooms ? (((BaseRoomPref)rp2).getRoomIndex() == null ? " (" + MSG.itemAllRooms() + ")" : " (" + MSG.itemOnlyRoom(((BaseRoomPref)rp2).getRoomIndex() + 1) + ")") : ""));
                        cellInterface.setAria(MSG.prefTitleRoom(((BasePreference)rp2).getPrefLevel().getPrefName(), cellInterface.getText()));
                        cellInterface.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + ((BaseRoomPref)rp2).getRoom().getUniqueId() + "', '" + ((BasePreference)rp2).getPrefLevel().getPrefName() + " " + MSG.prefRoom() + " {0} ({1})');");
                        cellInterface.setMouseOut("$wnd.hideGwtRoomHint();");
                    }
                    continue block10;
                }
                case BUILDING: {
                    Object rp2;
                    TableInterface.CellInterface cell;
                    Set<BuildingPref> buildingPrefs = pg.effectivePreferences(BuildingPref.class);
                    if (buildingPrefs.isEmpty()) continue block10;
                    TableInterface.CellInterface cellInterface = table.addProperty(MSG.propertyBuildings());
                    rp2 = buildingPrefs.iterator();
                    while (rp2.hasNext()) {
                        BuildingPref buildingPref = rp2.next();
                        cell = cellInterface.add(null).setInline(false);
                        if (buildingPref.getPrefLevel().getPrefId() != 4) {
                            cell.setColor(PreferenceLevel.prolog2color(buildingPref.getPrefLevel().getPrefProlog()));
                        }
                        cell.setText(buildingPref.getBuilding().getAbbrName() + (String)(multipleRooms ? (buildingPref.getRoomIndex() == null ? " (" + MSG.itemAllRooms() + ")" : " (" + MSG.itemOnlyRoom(buildingPref.getRoomIndex() + 1) + ")") : ""));
                        cell.setAria(MSG.prefTitleBuilding(buildingPref.getPrefLevel().getPrefName(), cell.getText()));
                        cell.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '-" + buildingPref.getBuilding().getUniqueId() + "', '" + buildingPref.getPrefLevel().getPrefName() + " " + MSG.prefBuilding() + " {0}');");
                        cell.setMouseOut("$wnd.hideGwtRoomHint();");
                    }
                    continue block10;
                }
                case ROOM_FEATURE: {
                    Set<RoomFeaturePref> set = pg.effectivePreferences(RoomFeaturePref.class);
                    if (set.isEmpty()) continue block10;
                    TableInterface.CellInterface rpCell = table.addProperty(MSG.propertyRoomFeatures());
                    for (Object rp3 : set) {
                        TableInterface.CellInterface cell = rpCell.add(null).setInline(false);
                        if (((BasePreference)rp3).getPrefLevel().getPrefId() != 4) {
                            cell.setColor(PreferenceLevel.prolog2color(((BasePreference)rp3).getPrefLevel().getPrefProlog()));
                        }
                        cell.setText(((BaseRoomFeaturePref)rp3).getRoomFeature().getLabelWithType() + (String)(multipleRooms ? (((BaseRoomFeaturePref)rp3).getRoomIndex() == null ? " (" + MSG.itemAllRooms() + ")" : " (" + MSG.itemOnlyRoom(((BaseRoomFeaturePref)rp3).getRoomIndex() + 1) + ")") : ""));
                        cell.setAria(MSG.prefTitleRoomFeature(((BasePreference)rp3).getPrefLevel().getPrefName(), cell.getText()));
                        String hint = HtmlUtils.htmlEscape((String)MSG.prefTitleRoomFeature(((BasePreference)rp3).getPrefLevel().getPrefName(), cell.getText()));
                        cell.setMouseOver("$wnd.showGwtHint($wnd.lastMouseOverElement, '" + hint + "');");
                        cell.setMouseOut("$wnd.hideGwtHint();");
                    }
                    continue block10;
                }
                case COURSE: {
                    Object rp3;
                    Set<InstructorCoursePref> coursePrefs = pg.effectivePreferences(InstructorCoursePref.class);
                    if (coursePrefs.isEmpty()) continue block10;
                    TableInterface.CellInterface cellInterface = table.addProperty(MSG.propertyCoursePrefs());
                    rp3 = coursePrefs.iterator();
                    while (rp3.hasNext()) {
                        InstructorCoursePref rp = rp3.next();
                        TableInterface.CellInterface cell = cellInterface.add(null).setInline(false);
                        if (rp.getPrefLevel().getPrefId() != 4) {
                            cell.setColor(PreferenceLevel.prolog2color(rp.getPrefLevel().getPrefProlog()));
                        }
                        cell.setText(rp.getCourse().getCourseNameWithTitle());
                        cell.setAria(MSG.prefTitleRoomFeature(rp.getPrefLevel().getPrefName(), cell.getText()));
                        String hint = HtmlUtils.htmlEscape((String)MSG.prefTitleCourse(rp.getPrefLevel().getPrefName(), cell.getText()));
                        cell.setMouseOver("$wnd.showGwtHint($wnd.lastMouseOverElement, '" + hint + "');");
                        cell.setMouseOut("$wnd.hideGwtHint();");
                        cell.setUrl("offering?id=" + rp.getCourse().getInstructionalOffering().getUniqueId());
                    }
                    continue block10;
                }
                case DISTRIBUTION: {
                    Set<DistributionPref> set = pg.effectivePreferences(DistributionPref.class);
                    if (set.isEmpty()) continue block10;
                    TableInterface.CellInterface rpCell = table.addProperty(MSG.propertyDistribution());
                    for (DistributionPref rp : set) {
                        TableInterface.CellInterface cell = rpCell.add(null).setInline(false);
                        if (rp.getPrefLevel().getPrefId() != 4) {
                            cell.setColor(PreferenceLevel.prolog2color(rp.getPrefLevel().getPrefProlog()));
                        }
                        cell.setText(rp.getDistributionType().getLabel());
                        cell.setAria(MSG.prefTitleDistribution(rp.getPrefLevel().getPrefName(), cell.getText()));
                        String hint = HtmlUtils.htmlEscape((String)rp.getDistributionType().getDescr());
                        cell.setMouseOver("$wnd.showGwtHint($wnd.lastMouseOverElement, '" + hint + "');");
                        cell.setMouseOut("$wnd.hideGwtHint();");
                    }
                    continue block10;
                }
            }
        }
        if (!table.hasProperties()) {
            return null;
        }
        table.addProperty(SubpartDetailBackend.getLegend(hasNotAvailable));
        return table;
    }

    public static TableInterface.PropertyInterface getLegend(boolean hasNotAvailable) {
        TableInterface.PropertyInterface legend = new TableInterface.PropertyInterface();
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        legend.setCell(cell);
        for (PreferenceLevel pref : PreferenceLevelDAO.getInstance().getSession().createQuery("from PreferenceLevel order by prefId", PreferenceLevel.class).setCacheable(true).list()) {
            if (!hasNotAvailable && pref.getPrefProlog().equals(PreferenceLevel.sNotAvailable)) continue;
            TableInterface.CellInterface c = cell.add(null).setNoWrap(false);
            c.addImage().setSource("images/pref" + pref.getPrefId() + ".png").addStyle("padding-top: 1px;");
            c.add(pref.getPrefName()).addStyle("padding-left: 10px;");
            c.addStyle("padding-right: 20px;");
        }
        legend.addStyle("text-align: center;");
        legend.addStyle("border-top: 1px dashed #9CB0CE;");
        return legend;
    }
}

