/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.model.XSection;

public class XWaitListedSection
extends XSection {
    private static final long serialVersionUID = 1L;
    private Long iWaitListId = null;
    private Date iTimeStamp = null;
    private ClassWaitList.Type iType = null;

    public XWaitListedSection() {
    }

    public XWaitListedSection(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XWaitListedSection(ClassWaitList clw, OnlineSectioningHelper helper) {
        super(clw.getClazz(), helper);
        this.iWaitListId = clw.getUniqueId();
        this.iTimeStamp = clw.getTimestamp();
        this.iType = ClassWaitList.Type.values()[clw.getType()];
    }

    public Long getWaitListId() {
        return this.iWaitListId;
    }

    public ClassWaitList.Type getType() {
        return this.iType;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iWaitListId = in.readLong();
        if (this.iWaitListId < 0L) {
            this.iWaitListId = null;
        }
        this.iTimeStamp = in.readBoolean() ? new Date(in.readLong()) : null;
        this.iType = ClassWaitList.Type.values()[in.readInt()];
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.iWaitListId == null ? -1L : this.iWaitListId);
        out.writeBoolean(this.iTimeStamp != null);
        if (this.iTimeStamp != null) {
            out.writeLong(this.iTimeStamp.getTime());
        }
        out.writeInt(this.iType.ordinal());
    }
}

