/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.util.Comparator;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.WaitListComparatorProvider;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequestComparator;

public class TimeStampOnlyWaitListComparatorProvider
implements WaitListComparatorProvider {
    @Override
    public Comparator<SectioningRequest> getComparator(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        return new TimeStampOnlyWaitListComparator();
    }

    public static class TimeStampOnlyWaitListComparator
    extends SectioningRequestComparator {
        @Override
        protected int compareBothAssignedOrNotAssigned(SectioningRequest s, SectioningRequest r) {
            return 0;
        }

        @Override
        protected int compareBothNotAssigned(SectioningRequest s, SectioningRequest r) {
            if (s.getRequest().getWaitListedTimeStamp() != null) {
                if (r.getRequest().getWaitListedTimeStamp() != null) {
                    return s.getRequest().getWaitListedTimeStamp().compareTo(r.getRequest().getWaitListedTimeStamp());
                }
                return 1;
            }
            if (r.getRequest().getWaitListedTimeStamp() != null) {
                return -1;
            }
            return 0;
        }
    }
}

