/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.RelatedCourseInfo;

@MappedSuperclass
public abstract class BaseRelatedCourseInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Long iOwnerId;
    private Integer iOwnerType;
    private CourseEvent iEvent;
    private CourseOffering iCourse;

    public BaseRelatedCourseInfo() {
    }

    public BaseRelatedCourseInfo(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="owner_id", nullable=false, length=20)
    public Long getOwnerId() {
        return this.iOwnerId;
    }

    public void setOwnerId(Long ownerId) {
        this.iOwnerId = ownerId;
    }

    @Column(name="owner_type", nullable=false, length=10)
    public Integer getOwnerType() {
        return this.iOwnerType;
    }

    public void setOwnerType(Integer ownerType) {
        this.iOwnerType = ownerType;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="event_id", nullable=false)
    public CourseEvent getEvent() {
        return this.iEvent;
    }

    public void setEvent(CourseEvent event) {
        this.iEvent = event;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="course_id", nullable=false)
    public CourseOffering getCourse() {
        return this.iCourse;
    }

    public void setCourse(CourseOffering course) {
        this.iCourse = course;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RelatedCourseInfo)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RelatedCourseInfo)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RelatedCourseInfo)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "RelatedCourseInfo[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "RelatedCourseInfo[\n\tCourse: " + String.valueOf(this.getCourse()) + "\n\tEvent: " + String.valueOf(this.getEvent()) + "\n\tOwnerId: " + this.getOwnerId() + "\n\tOwnerType: " + this.getOwnerType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

