/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseCatalog;
import org.unitime.timetable.model.CourseSubpartCredit;

@MappedSuperclass
public abstract class BaseCourseSubpartCredit
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iSubpartId;
    private String iCreditType;
    private String iCreditUnitType;
    private String iCreditFormat;
    private Float iFixedMinimumCredit;
    private Float iMaximumCredit;
    private Boolean iFractionalCreditAllowed;
    private CourseCatalog iCourseCatalog;

    public BaseCourseSubpartCredit() {
    }

    public BaseCourseSubpartCredit(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="subpart_id", nullable=false, length=10)
    public String getSubpartId() {
        return this.iSubpartId;
    }

    public void setSubpartId(String subpartId) {
        this.iSubpartId = subpartId;
    }

    @Column(name="credit_type", nullable=false, length=20)
    public String getCreditType() {
        return this.iCreditType;
    }

    public void setCreditType(String creditType) {
        this.iCreditType = creditType;
    }

    @Column(name="credit_unit_type", nullable=false, length=20)
    public String getCreditUnitType() {
        return this.iCreditUnitType;
    }

    public void setCreditUnitType(String creditUnitType) {
        this.iCreditUnitType = creditUnitType;
    }

    @Column(name="credit_format", nullable=false, length=20)
    public String getCreditFormat() {
        return this.iCreditFormat;
    }

    public void setCreditFormat(String creditFormat) {
        this.iCreditFormat = creditFormat;
    }

    @Column(name="fixed_min_credit", nullable=false, length=10)
    public Float getFixedMinimumCredit() {
        return this.iFixedMinimumCredit;
    }

    public void setFixedMinimumCredit(Float fixedMinimumCredit) {
        this.iFixedMinimumCredit = fixedMinimumCredit;
    }

    @Column(name="max_credit", nullable=true, length=10)
    public Float getMaximumCredit() {
        return this.iMaximumCredit;
    }

    public void setMaximumCredit(Float maximumCredit) {
        this.iMaximumCredit = maximumCredit;
    }

    @Column(name="frac_credit_allowed", nullable=true, length=10)
    public Boolean isFractionalCreditAllowed() {
        return this.iFractionalCreditAllowed;
    }

    @Transient
    public Boolean getFractionalCreditAllowed() {
        return this.iFractionalCreditAllowed;
    }

    public void setFractionalCreditAllowed(Boolean fractionalCreditAllowed) {
        this.iFractionalCreditAllowed = fractionalCreditAllowed;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="course_catalog_id", nullable=false)
    public CourseCatalog getCourseCatalog() {
        return this.iCourseCatalog;
    }

    public void setCourseCatalog(CourseCatalog courseCatalog) {
        this.iCourseCatalog = courseCatalog;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CourseSubpartCredit)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CourseSubpartCredit)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CourseSubpartCredit)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CourseSubpartCredit[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "CourseSubpartCredit[\n\tCourseCatalog: " + String.valueOf(this.getCourseCatalog()) + "\n\tCreditFormat: " + this.getCreditFormat() + "\n\tCreditType: " + this.getCreditType() + "\n\tCreditUnitType: " + this.getCreditUnitType() + "\n\tFixedMinimumCredit: " + this.getFixedMinimumCredit() + "\n\tFractionalCreditAllowed: " + this.getFractionalCreditAllowed() + "\n\tMaximumCredit: " + this.getMaximumCredit() + "\n\tSubpartId: " + this.getSubpartId() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

