/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver.suggestions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.solver.suggestions.SuggestionsPageContext;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

public class ConflictTable
extends UniTimeTable<SuggestionsInterface.ClassAssignmentDetails>
implements TakesValue<Collection<SuggestionsInterface.ClassAssignmentDetails>> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private SuggestionsPageContext iContext;
    private ConflictColum iSortBy = null;
    private boolean iAsc = true;

    public ConflictTable(SuggestionsPageContext context) {
        this.addStyleName("unitime-ClassAssignmentTable");
        this.addStyleName("unitime-ClassAssignmentTableConflicts");
        this.iContext = context;
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final ConflictColum column : ConflictColum.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column, idx), this.getColumnAlignment(column, idx));
                header.add(h);
            }
        }
        for (final ConflictColum column : ConflictColum.values()) {
            if (ConflictsComparator.isApplicable(column) && this.getNbrCells(column) > 0) {
                final UniTimeTableHeader h = (UniTimeTableHeader)header.get(this.getCellIndex(column));
                SortOperation op = new SortOperation(){

                    public void execute() {
                        ConflictTable.this.doSort(column);
                    }

                    @Override
                    public boolean isApplicable() {
                        return ConflictTable.this.getRowCount() > 1 && h.isVisible();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opSortBy(this.getColumnName());
                    }

                    @Override
                    public String getColumnName() {
                        return h.getHTML().replace("<br>", " ");
                    }
                };
                h.addOperation(op);
            }
            if (column != ConflictColum.STUDENT_CONFLICTS && column != ConflictColum.DISTRIBUTION_CONFLICTS) continue;
            final int index = this.getCellIndex(column);
            UniTimeTableHeader h = (UniTimeTableHeader)header.get(index);
            h.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    if (column == ConflictColum.STUDENT_CONFLICTS) {
                        SolverCookie.getInstance().setShowAllStudentConflicts(true);
                    } else {
                        SolverCookie.getInstance().setShowAllDistributionConflicts(true);
                    }
                    for (int row = 1; row < ConflictTable.this.getRowCount(); ++row) {
                        Widget w = ConflictTable.this.getWidget(row, index);
                        if (!(w instanceof ConflictCell)) continue;
                        ((ConflictCell)w).showList();
                    }
                }

                @Override
                public boolean isApplicable() {
                    return true;
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opShowAllConflicts();
                }
            });
            h.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    if (column == ConflictColum.STUDENT_CONFLICTS) {
                        SolverCookie.getInstance().setShowAllStudentConflicts(false);
                    } else {
                        SolverCookie.getInstance().setShowAllDistributionConflicts(false);
                    }
                    for (int row = 1; row < ConflictTable.this.getRowCount(); ++row) {
                        Widget w = ConflictTable.this.getWidget(row, index);
                        if (!(w instanceof ConflictCell)) continue;
                        ((ConflictCell)w).showNumber();
                    }
                }

                @Override
                public boolean isApplicable() {
                    return true;
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opHideAllConflicts();
                }
            });
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(SolverCookie.getInstance().getConflictsSort());
    }

    protected void doSort(ConflictColum column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        SolverCookie.getInstance().setConflictsSort(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = ConflictColum.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = ConflictColum.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        if (this.getNbrCells(this.iSortBy) == 0) {
            this.iSortBy = ConflictColum.TIME;
        }
        UniTimeTableHeader header = this.getHeader(this.getCellIndex(this.iSortBy));
        this.sort(header, new ConflictsComparator(this.iContext.getProperties().getFirstDay(), this.iSortBy, true), this.iAsc);
    }

    protected int getNbrCells(ConflictColum column) {
        switch (column) {
            default: 
        }
        return 1;
    }

    public String getColumnName(ConflictColum column, int idx) {
        switch (column) {
            case DATE: {
                return MESSAGES.colDate();
            }
            case TIME: {
                return MESSAGES.colTime();
            }
            case STUDENT_CONFLICTS: {
                return MESSAGES.colStudentConflicts();
            }
            case DISTRIBUTION_CONFLICTS: {
                return MESSAGES.colDistributionConflicts();
            }
        }
        return column.name();
    }

    protected HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(ConflictColum column, int idx) {
        switch (column) {
            default: 
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    protected int getCellIndex(ConflictColum column) {
        int ret = 0;
        for (ConflictColum c : ConflictColum.values()) {
            if (c.ordinal() >= column.ordinal()) continue;
            ret += this.getNbrCells(c);
        }
        return ret;
    }

    protected Widget getCell(SuggestionsInterface.ClassAssignmentDetails conflict, ConflictColum column, int idx) {
        switch (column) {
            case DATE: {
                return this.iContext.createDateLabel(conflict.getTime().getDatePattern());
            }
            case TIME: {
                return this.iContext.createTimeLabel(conflict.getTime(), conflict.getClazz().getClassId(), true);
            }
            case STUDENT_CONFLICTS: {
                if (conflict.hasStudentConflicts()) {
                    return new ConflictCell(SuggestionsPageContext.dispNumber(conflict.countStudentConflicts()), this.iContext.createStudentConflicts(conflict.getStudentConflicts()), SolverCookie.getInstance().isShowAllStudentConflicts());
                }
                return null;
            }
            case DISTRIBUTION_CONFLICTS: {
                if (conflict.hasDistributionConflicts()) {
                    return new ConflictCell(SuggestionsPageContext.dispNumber(conflict.countDistributionConflicts()), this.iContext.createViolatedConstraints(conflict.getDistributionConflicts(), null), SolverCookie.getInstance().isShowAllDistributionConflicts());
                }
                return null;
            }
        }
        return null;
    }

    public int addRow(SuggestionsInterface.ClassAssignmentDetails suggestion) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (ConflictColum column : ConflictColum.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                Object cell = this.getCell(suggestion, column, idx);
                if (cell == null) {
                    cell = new P(new String[0]);
                }
                widgets.add((Widget)cell);
            }
        }
        int row = this.addRow(suggestion, widgets);
        this.getRowFormatter().setStyleName(row, "row");
        for (int col = 0; col < this.getCellCount(row); ++col) {
            this.getCellFormatter().setStyleName(row, col, "cell");
        }
        return row;
    }

    public Collection<SuggestionsInterface.ClassAssignmentDetails> getValue() {
        return this.getData();
    }

    public void setValue(Collection<SuggestionsInterface.ClassAssignmentDetails> value) {
        this.clearTable(1);
        boolean hasStudentConflicts = false;
        boolean hasDistributionConflicts = false;
        if (value != null) {
            for (SuggestionsInterface.ClassAssignmentDetails suggestion : value) {
                if (suggestion.hasStudentConflicts()) {
                    hasStudentConflicts = true;
                }
                if (suggestion.hasDistributionConflicts()) {
                    hasDistributionConflicts = true;
                }
                this.addRow(suggestion);
            }
        }
        this.sort();
        this.setColumnVisible(this.getCellIndex(ConflictColum.STUDENT_CONFLICTS), hasStudentConflicts);
        this.setColumnVisible(this.getCellIndex(ConflictColum.DISTRIBUTION_CONFLICTS), hasDistributionConflicts);
    }

    public static enum ConflictColum {
        DATE,
        TIME,
        STUDENT_CONFLICTS,
        DISTRIBUTION_CONFLICTS;

    }

    public static class ConflictsComparator
    implements Comparator<SuggestionsInterface.ClassAssignmentDetails> {
        private Integer iFirstDay;
        private ConflictColum iColumn;
        private boolean iAsc;

        public ConflictsComparator(Integer firstDay, ConflictColum column, boolean asc) {
            this.iFirstDay = firstDay;
            this.iColumn = column;
            this.iAsc = asc;
        }

        public int compareByDate(SuggestionsInterface.ClassAssignmentDetails s1, SuggestionsInterface.ClassAssignmentDetails s2) {
            SuggestionsInterface.TimeInfo t1 = s1.getTime();
            SuggestionsInterface.TimeInfo t2 = s2.getTime();
            return this.compare(t1 == null ? null : t1.getDatePatternName(), t2 == null ? null : t2.getDatePatternName());
        }

        public int compareByTime(SuggestionsInterface.ClassAssignmentDetails s1, SuggestionsInterface.ClassAssignmentDetails s2) {
            SuggestionsInterface.TimeInfo t1 = s1.getTime();
            SuggestionsInterface.TimeInfo t2 = s2.getTime();
            int cmp = this.compare(t1 == null ? 0 : t1.getDaysOrder(this.iFirstDay), t2 == null ? 0 : t2.getDaysOrder(this.iFirstDay));
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compare(t1 == null ? null : Integer.valueOf(t1.getStartSlot()), t2 == null ? null : Integer.valueOf(t2.getStartSlot()));
            if (cmp != 0) {
                return cmp;
            }
            return this.compare(t1 == null ? null : t1.getName(this.iFirstDay, false, CONSTANTS), t2 == null ? null : t2.getName(this.iFirstDay, false, CONSTANTS));
        }

        public int compareByDateTime(SuggestionsInterface.ClassAssignmentDetails s1, SuggestionsInterface.ClassAssignmentDetails s2) {
            SuggestionsInterface.TimeInfo t2;
            SuggestionsInterface.TimeInfo t1 = s1.getTime();
            int cmp = this.compare(t1 == null ? null : t1.getDatePatternName(), (t2 = s2.getTime()) == null ? null : t2.getDatePatternName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compare(t1 == null ? 0 : t1.getDaysOrder(this.iFirstDay), t2 == null ? 0 : t2.getDaysOrder(this.iFirstDay));
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compare(t1 == null ? null : Integer.valueOf(t1.getStartSlot()), t2 == null ? null : Integer.valueOf(t2.getStartSlot()));
            if (cmp != 0) {
                return cmp;
            }
            return this.compare(t1 == null ? null : t1.getName(this.iFirstDay, false, CONSTANTS), t2 == null ? null : t2.getName(this.iFirstDay, false, CONSTANTS));
        }

        public int compareByStudentConflicts(SuggestionsInterface.ClassAssignmentDetails s1, SuggestionsInterface.ClassAssignmentDetails s2) {
            return this.compare(s1.countStudentConflicts(), s2.countStudentConflicts());
        }

        public int compareByDistributionConflicts(SuggestionsInterface.ClassAssignmentDetails s1, SuggestionsInterface.ClassAssignmentDetails s2) {
            return this.compare(s1.countDistributionConflicts(), s2.countDistributionConflicts());
        }

        protected int compareByColumn(SuggestionsInterface.ClassAssignmentDetails c1, SuggestionsInterface.ClassAssignmentDetails c2) {
            switch (this.iColumn) {
                case DATE: {
                    return this.compareByDateTime(c1, c2);
                }
                case TIME: {
                    return this.compareByTime(c1, c2);
                }
                case STUDENT_CONFLICTS: {
                    return this.compareByStudentConflicts(c1, c2);
                }
                case DISTRIBUTION_CONFLICTS: {
                    return this.compareByDistributionConflicts(c1, c2);
                }
            }
            return this.compareByTime(c1, c2);
        }

        public static boolean isApplicable(ConflictColum column) {
            switch (column) {
                case DATE: 
                case TIME: 
                case STUDENT_CONFLICTS: 
                case DISTRIBUTION_CONFLICTS: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compare(SuggestionsInterface.ClassAssignmentDetails c1, SuggestionsInterface.ClassAssignmentDetails c2) {
            int cmp = this.compareByColumn(c1, c2);
            if (cmp != 0) {
                return this.iAsc ? cmp : -cmp;
            }
            cmp = this.compareByDate(c1, c2);
            if (cmp == 0) {
                cmp = this.compareByTime(c1, c2);
            }
            return this.iAsc ? cmp : -cmp;
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : TableInterface.NaturalOrderComparator.compare(s1, s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }

        @Override
        protected int compare(Boolean b1, Boolean b2) {
            return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
        }
    }

    public static class ConflictCell
    extends P {
        P iN = new P("number");
        P iD;
        P iL;

        public ConflictCell(String number, P conflicts, boolean visible) {
            super("conflicts");
            this.iN.setHTML(number);
            this.add((Widget)this.iN);
            this.iD = new P("dots");
            this.iD.setHTML(CONSTANTS.selectionMore());
            this.add((Widget)this.iD);
            this.iL = new P("list");
            this.add((Widget)this.iL);
            this.iL.add((Widget)conflicts);
            if (visible) {
                this.showList();
            } else {
                this.showNumber();
            }
            this.iD.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    this.showList();
                    event.preventDefault();
                    event.stopPropagation();
                }
            });
            this.iN.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (iL.isVisible()) {
                        this.showNumber();
                    } else {
                        this.showList();
                    }
                    event.preventDefault();
                    event.stopPropagation();
                }
            });
        }

        public void showNumber() {
            this.iD.setVisible(true);
            this.iL.setVisible(false);
        }

        public void showList() {
            this.iD.setVisible(false);
            this.iL.setVisible(true);
        }
    }

    public static interface SortOperation
    extends UniTimeTableHeader.Operation,
    UniTimeTableHeader.HasColumnName {
    }
}

