/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.util.ComboBoxLookup;

public class ClassesForm
implements UniTimeForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = -2473101585994845220L;
    private String iOp = null;
    private Long iSession = null;
    private String iSubjectArea = null;
    private String iCourseNumber = null;
    private Collection<ComboBoxLookup> iSubjectAreas = null;
    private List<ComboBoxLookup> iSessions = null;
    private String iTable = null;
    private int iNrColumns;
    private int iNrRows;
    private String iMessage;
    private String iUser;
    private String iPassword;

    @Override
    public void validate(UniTimeAction action) {
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iTable = null;
        this.iNrColumns = 0;
        this.iNrRows = 0;
        this.iSession = null;
        this.iUser = null;
        this.iPassword = null;
        this.iMessage = null;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getSubjectArea() {
        return this.iSubjectArea;
    }

    public void setSubjectArea(String subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    public Collection<ComboBoxLookup> getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public String getCourseNumber() {
        return this.iCourseNumber;
    }

    public void setCourseNumber(String courseNumber) {
        this.iCourseNumber = courseNumber;
    }

    public Long getSession() {
        return this.iSession;
    }

    public void setSession(Long session) {
        this.iSession = session;
    }

    public Collection<ComboBoxLookup> getSessions() {
        return this.iSessions;
    }

    public Boolean canDisplayAllSubjectsAtOnce() {
        Boolean displayAll = false;
        if (this.iSession != null) {
            String queryStr = "select count(io) from InstructionalOffering io where io.session.uniqueId = :sessionId";
            int count = ((Number)SessionDAO.getInstance().getSession().createQuery(queryStr, Number.class).setParameter("sessionId", (Object)this.iSession).setCacheable(true).uniqueResult()).intValue();
            if (count <= 300) {
                displayAll = true;
            }
        }
        return displayAll;
    }

    public void load(HttpSession session) {
        this.setSubjectArea(session.getAttribute("Classes.subjectArea") == null ? null : (String)session.getAttribute("Classes.subjectArea"));
        this.setCourseNumber(session.getAttribute("Classes.courseNumber") == null ? null : (String)session.getAttribute("Classes.courseNumber"));
        this.iSessions = new ArrayList<ComboBoxLookup>();
        this.setSession(session.getAttribute("Classes.session") == null ? null : (Long)session.getAttribute("Classes.session"));
        Long lastSessionId = null;
        boolean hasSession = false;
        for (Session s : Session.getAllSessions()) {
            if (s.getStatusType() == null || !s.getStatusType().canNoRoleReportClass() || !Solution.hasTimetable(s.getUniqueId())) continue;
            if (s.getUniqueId().equals(this.getSession())) {
                hasSession = true;
            }
            lastSessionId = s.getUniqueId();
            this.iSessions.add(new ComboBoxLookup(s.getLabel(), s.getUniqueId().toString()));
        }
        if (!hasSession) {
            this.setSession(null);
            this.setSubjectArea(null);
        }
        if (this.getSession() == null && lastSessionId != null) {
            this.setSession(lastSessionId);
        }
        this.iSubjectAreas = new ArrayList<ComboBoxLookup>();
        if (this.canDisplayAllSubjectsAtOnce().booleanValue()) {
            this.iSubjectAreas.add(new ComboBoxLookup(MSG.allSubjects(), "--ALL--"));
        } else if ("--ALL--".equals(this.iSubjectArea)) {
            this.iSubjectArea = null;
        }
        boolean hasSubject = false;
        if (this.iSession != null) {
            for (SubjectArea subject : SubjectArea.getAllSubjectAreas(this.iSession)) {
                if (subject.getSubjectAreaAbbreviation().equals(this.iSubjectArea)) {
                    hasSubject = true;
                }
                this.iSubjectAreas.add(new ComboBoxLookup(subject.getSubjectAreaAbbreviation(), subject.getSubjectAreaAbbreviation()));
            }
        }
        if (!hasSubject && !"--ALL--".equals(this.iSubjectArea)) {
            this.iSubjectArea = null;
        }
    }

    public void save(HttpSession session) {
        if (this.getSubjectArea() == null) {
            session.removeAttribute("Classes.subjectArea");
        } else {
            session.setAttribute("Classes.subjectArea", (Object)this.getSubjectArea());
        }
        if (this.getCourseNumber() == null) {
            session.removeAttribute("Classes.courseNumber");
        } else {
            session.setAttribute("Classes.courseNumber", (Object)this.getCourseNumber());
        }
        if (this.getSession() == null) {
            session.removeAttribute("Classes.session");
        } else {
            session.setAttribute("Classes.session", (Object)this.getSession());
        }
    }

    public void setTable(String table, int cols, int rows) {
        this.iTable = table;
        this.iNrColumns = cols;
        this.iNrRows = rows;
    }

    public String getTable() {
        return this.iTable;
    }

    public int getNrRows() {
        return this.iNrRows;
    }

    public int getNrColumns() {
        return this.iNrColumns;
    }

    public String getUsername() {
        return this.iUser;
    }

    public void setUsername(String user) {
        this.iUser = user;
    }

    public String getPassword() {
        return this.iPassword;
    }

    public void setPassword(String password) {
        this.iPassword = password;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getSessionLabel() {
        if (this.iSessions == null) {
            return "";
        }
        for (ComboBoxLookup s : this.iSessions) {
            if (!Long.valueOf(s.getValue()).equals(this.getSession())) continue;
            return s.getLabel();
        }
        return "";
    }

    public String getEmptyMessage() {
        if (this.getSession() == null) {
            return MSG.infoNoClassesAvailable();
        }
        if (this.getSubjectArea() == null || this.getSubjectArea().isEmpty()) {
            if (MSG.buttonApply().equals(this.iOp)) {
                return MSG.infoNoSubjectAreaSelected();
            }
            return null;
        }
        if ("--ALL--".equals(this.getSubjectArea())) {
            return MSG.infoNoClassesAvailableForSession(this.getSessionLabel());
        }
        if (this.getCourseNumber() != null && !this.getCourseNumber().isEmpty()) {
            return MSG.infoNoClassesAvailableForCourse(this.getSubjectArea(), this.getCourseNumber());
        }
        return MSG.infoNoClassesAvailableForSubject(this.getSubjectArea());
    }
}

