/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UserDefinedObjectType;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.internal.EmbeddableHelper;
import org.hibernate.type.spi.TypeConfiguration;

public class AggregateComponentSecondPass
implements SecondPass {
    private final PropertyHolder propertyHolder;
    private final Component component;
    private final XClass componentXClass;
    private final String propertyName;
    private final MetadataBuildingContext context;

    public AggregateComponentSecondPass(PropertyHolder propertyHolder, Component component, XClass componentXClass, String propertyName, MetadataBuildingContext context) {
        this.propertyHolder = propertyHolder;
        this.component = component;
        this.componentXClass = componentXClass;
        this.propertyName = propertyName;
        this.context = context;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        boolean addAuxiliaryObjects;
        AggregateComponentSecondPass.validateComponent(this.component, StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName), this.isAggregateArray());
        InFlightMetadataCollector metadataCollector = this.context.getMetadataCollector();
        TypeConfiguration typeConfiguration = metadataCollector.getTypeConfiguration();
        Database database = metadataCollector.getDatabase();
        Dialect dialect = database.getDialect();
        AggregateSupport aggregateSupport = dialect.getAggregateSupport();
        int[] originalOrder = this.component.sortProperties();
        List<Column> aggregatedColumns = this.component.getAggregatedColumns();
        AggregateColumn aggregateColumn = this.component.getAggregateColumn();
        AggregateComponentSecondPass.ensureInitialized(metadataCollector, aggregateColumn);
        this.validateSupportedColumnTypes(this.propertyHolder.getPath(), this.component);
        QualifiedName structName = this.component.getStructName();
        if (structName != null) {
            Namespace namespace = database.locateNamespace(structName.getCatalogName(), structName.getSchemaName());
            UserDefinedObjectType udt = new UserDefinedObjectType("orm", namespace, structName.getObjectName());
            Comment comment = (Comment)this.componentXClass.getAnnotation(Comment.class);
            if (comment != null) {
                udt.setComment(comment.value());
            }
            for (Column aggregatedColumn : aggregatedColumns) {
                udt.addColumn(aggregatedColumn);
            }
            UserDefinedObjectType registeredUdt = namespace.createUserDefinedType(structName.getObjectName(), name -> udt);
            if (registeredUdt == udt) {
                addAuxiliaryObjects = true;
                this.orderColumns(registeredUdt, originalOrder);
            } else {
                addAuxiliaryObjects = this.isAggregateArray() && namespace.locateUserDefinedArrayType(Identifier.toIdentifier(aggregateColumn.getSqlType())) == null;
                this.validateEqual(registeredUdt, udt);
            }
        } else {
            addAuxiliaryObjects = true;
        }
        String aggregateReadTemplate = aggregateColumn.getAggregateReadExpressionTemplate(dialect);
        String aggregateReadExpression = aggregateReadTemplate.replace("$PlaceHolder$.", "");
        String aggregateAssignmentExpression = aggregateColumn.getAggregateAssignmentExpressionTemplate(dialect).replace("$PlaceHolder$.", "");
        if (addAuxiliaryObjects) {
            aggregateSupport.aggregateAuxiliaryDatabaseObjects(database.getDefaultNamespace(), aggregateReadExpression, aggregateColumn, aggregatedColumns).forEach(database::addAuxiliaryDatabaseObject);
        }
        aggregateColumn.setCustomWrite(aggregateSupport.aggregateCustomWriteExpression(aggregateColumn, aggregatedColumns));
        for (Column subColumn : aggregatedColumns) {
            String selectableExpression = subColumn.getText(dialect);
            String assignmentExpression = aggregateSupport.aggregateComponentAssignmentExpression(aggregateAssignmentExpression, selectableExpression, aggregateColumn, subColumn);
            String customReadExpression = subColumn.getCustomReadExpression() == null ? (subColumn.isFormula() ? aggregateSupport.aggregateComponentCustomReadExpression(subColumn.getTemplate(dialect, typeConfiguration, null), "$PlaceHolder$.", aggregateReadTemplate, "", aggregateColumn, subColumn) : aggregateSupport.aggregateComponentCustomReadExpression("", "", aggregateReadTemplate, selectableExpression, aggregateColumn, subColumn)) : aggregateSupport.aggregateComponentCustomReadExpression(subColumn.getCustomReadExpression(), "$PlaceHolder$.", aggregateReadTemplate, "", aggregateColumn, subColumn);
            subColumn.setAssignmentExpression(assignmentExpression);
            subColumn.setCustomRead(customReadExpression);
        }
        this.propertyHolder.getTable().getColumns().removeAll(aggregatedColumns);
    }

    private static void validateComponent(Component component, String basePath, boolean inArray) {
        for (Property property : component.getProperties()) {
            Value value = property.getValue();
            if (value instanceof Component) {
                Component c = (Component)value;
                AggregateComponentSecondPass.validateComponent(c, StringHelper.qualify(basePath, property.getName()), inArray);
                continue;
            }
            if (value instanceof ToOne) {
                ToOne toOne = (ToOne)value;
                if (!inArray || toOne.getReferencedPropertyName() == null) continue;
                throw new AnnotationException("Property '" + StringHelper.qualify(basePath, property.getName()) + "' uses one-to-one mapping with mappedBy '" + toOne.getReferencedPropertyName() + "' in the aggregate component class '" + component.getComponentClassName() + "' within an array property, which is not allowed.");
            }
            if (!(value instanceof Collection)) continue;
            Collection collection = (Collection)value;
            if (inArray && collection.getMappedByProperty() != null) {
                throw new AnnotationException("Property '" + StringHelper.qualify(basePath, property.getName()) + "' uses *-to-many mapping with mappedBy '" + collection.getMappedByProperty() + "' in the aggregate component class '" + component.getComponentClassName() + "' within an array property, which is not allowed.");
            }
            if (!inArray || collection.getCollectionTable() == null) continue;
            throw new AnnotationException("Property '" + StringHelper.qualify(basePath, property.getName()) + "' defines a collection table '" + String.valueOf(collection.getCollectionTable()) + "' in the aggregate component class '" + component.getComponentClassName() + "' within an array property, which is not allowed.");
        }
    }

    private boolean isAggregateArray() {
        switch (this.component.getAggregateColumn().getSqlTypeCode(this.context.getMetadataCollector())) {
            case 2003: 
            case 3016: 
            case 3017: 
            case 3018: 
            case 3019: 
            case 4000: {
                return true;
            }
        }
        return false;
    }

    private void orderColumns(UserDefinedObjectType userDefinedType, int[] originalOrder) {
        Class<?> componentClass = this.component.getComponentClass();
        String[] structColumnNames = this.component.getStructColumnNames();
        if (structColumnNames == null || structColumnNames.length == 0) {
            List<Property> properties;
            int[] propertyMappingIndex;
            if (ReflectHelper.isRecord(componentClass)) {
                if (originalOrder == null) {
                    propertyMappingIndex = null;
                } else {
                    String[] componentNames = ReflectHelper.getRecordComponentNames(componentClass);
                    propertyMappingIndex = EmbeddableHelper.determineMappingIndex(this.component.getPropertyNames(), componentNames);
                }
            } else {
                propertyMappingIndex = this.component.getInstantiatorPropertyNames() != null ? EmbeddableHelper.determineMappingIndex(this.component.getPropertyNames(), this.component.getInstantiatorPropertyNames()) : null;
            }
            ArrayList<Column> orderedColumns = new ArrayList<Column>(userDefinedType.getColumnSpan());
            if (propertyMappingIndex == null) {
                properties = this.component.getProperties();
                for (Property property : properties) {
                    AggregateComponentSecondPass.addColumns(orderedColumns, property.getValue());
                }
                if (this.component.isPolymorphic()) {
                    AggregateComponentSecondPass.addColumns(orderedColumns, this.component.getDiscriminator());
                }
            } else {
                properties = this.component.getProperties();
                for (int propertyIndex : propertyMappingIndex) {
                    AggregateComponentSecondPass.addColumns(orderedColumns, properties.get(propertyIndex).getValue());
                }
            }
            List<Column> reorderedColumn = this.context.getBuildingOptions().getColumnOrderingStrategy().orderUserDefinedTypeColumns(userDefinedType, this.context.getMetadataCollector());
            userDefinedType.reorderColumns(reorderedColumn != null ? reorderedColumn : orderedColumns);
        } else {
            ArrayList<Column> orderedColumns = new ArrayList<Column>(userDefinedType.getColumnSpan());
            for (String structColumnName : structColumnNames) {
                if (AggregateComponentSecondPass.addColumns(orderedColumns, this.component, structColumnName)) continue;
                throw new MappingException("Couldn't find column [" + structColumnName + "] that was defined in @Struct(attributes) in the component [" + this.component.getComponentClassName() + "]");
            }
            userDefinedType.reorderColumns(orderedColumns);
        }
    }

    private static void addColumns(ArrayList<Column> orderedColumns, Value value) {
        if (value instanceof Component) {
            Component subComponent = (Component)value;
            if (subComponent.getAggregateColumn() == null) {
                for (Property property : subComponent.getProperties()) {
                    AggregateComponentSecondPass.addColumns(orderedColumns, property.getValue());
                }
            } else {
                orderedColumns.add(subComponent.getAggregateColumn());
            }
        } else {
            orderedColumns.addAll(value.getColumns());
        }
    }

    private static boolean addColumns(ArrayList<Column> orderedColumns, Component component, String structColumnName) {
        Column column;
        for (Property property : component.getProperties()) {
            Value value = property.getValue();
            if (value instanceof Component) {
                Component subComponent = (Component)value;
                if (subComponent.getAggregateColumn() == null) {
                    if (!AggregateComponentSecondPass.addColumns(orderedColumns, subComponent, structColumnName)) continue;
                    return true;
                }
                if (!structColumnName.equals(subComponent.getAggregateColumn().getName())) continue;
                orderedColumns.add(subComponent.getAggregateColumn());
                return true;
            }
            for (Selectable selectable : value.getSelectables()) {
                if (!(selectable instanceof Column) || !structColumnName.equals(((Column)selectable).getName())) continue;
                orderedColumns.add((Column)selectable);
                return true;
            }
        }
        if (component.isPolymorphic() && structColumnName.equals((column = component.getDiscriminator().getColumns().get(0)).getName())) {
            orderedColumns.add(column);
            return true;
        }
        return false;
    }

    private void validateSupportedColumnTypes(String basePath, Component component) {
        for (Property property : component.getProperties()) {
            Component subComponent;
            Value value = property.getValue();
            if (!(value instanceof Component) || (subComponent = (Component)value).getAggregateColumn() != null) continue;
            this.validateSupportedColumnTypes(StringHelper.qualify(basePath, property.getName()), subComponent);
        }
    }

    private static void ensureInitialized(InFlightMetadataCollector metadataCollector, AggregateColumn aggregateColumn) {
        AggregateComponentSecondPass.ensureParentInitialized(metadataCollector, aggregateColumn);
        AggregateComponentSecondPass.ensureChildrenInitialized(metadataCollector, aggregateColumn);
    }

    private static void ensureChildrenInitialized(InFlightMetadataCollector metadataCollector, AggregateColumn aggregateColumn) {
        for (Column aggregatedColumn : aggregateColumn.getComponent().getAggregatedColumns()) {
            aggregatedColumn.getSqlTypeCode(metadataCollector);
            aggregatedColumn.getSqlType(metadataCollector);
            if (!(aggregatedColumn instanceof AggregateColumn)) continue;
            AggregateComponentSecondPass.ensureChildrenInitialized(metadataCollector, (AggregateColumn)aggregatedColumn);
        }
    }

    private static void ensureParentInitialized(InFlightMetadataCollector metadataCollector, AggregateColumn aggregateColumn) {
        do {
            aggregateColumn.getValue().getType();
            aggregateColumn.getSqlTypeCode(metadataCollector);
            aggregateColumn.getSqlType(metadataCollector);
        } while ((aggregateColumn = aggregateColumn.getComponent().getParentAggregateColumn()) != null);
    }

    private void validateEqual(UserDefinedObjectType udt1, UserDefinedObjectType udt2) {
        if (udt1.getColumnSpan() != udt2.getColumnSpan()) {
            throw new MappingException(String.format("Struct [%s] is defined by multiple components %s with different number of mappings %d and %d", udt1.getName(), this.findComponentClasses(), udt1.getColumnSpan(), udt2.getColumnSpan()));
        }
        ArrayList<Column> missingColumns = new ArrayList<Column>();
        for (Column column1 : udt1.getColumns()) {
            Column column2 = udt2.getColumn(column1);
            if (column2 == null) {
                missingColumns.add(column1);
                continue;
            }
            if (column1.getSqlType().equals(column2.getSqlType())) continue;
            throw new MappingException(String.format("Struct [%s] of class [%s] is defined by multiple components with different mappings [%s] and [%s] for column [%s]", udt1.getName(), this.componentXClass.getName(), column1.getSqlType(), column2.getSqlType(), column1.getCanonicalName()));
        }
        if (!missingColumns.isEmpty()) {
            throw new MappingException(String.format("Struct [%s] is defined by multiple components %s but some columns are missing in [%s]: %s", udt1.getName(), this.findComponentClasses(), this.componentXClass.getName(), missingColumns));
        }
    }

    private TreeSet<String> findComponentClasses() {
        TreeSet<String> componentClasses = new TreeSet<String>();
        this.context.getMetadataCollector().visitRegisteredComponents(c -> {
            if (this.component.getStructName().equals(c.getStructName())) {
                componentClasses.add(c.getComponentClassName());
            }
        });
        return componentClasses;
    }
}

