/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.reservation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.reservation.Reservation;

public class CurriculumReservation
extends Reservation {
    private double iLimit;
    private Set<String> iAcadAreas = new HashSet<String>();
    private Set<String> iClassifications = new HashSet<String>();
    private Set<String> iMajors = new HashSet<String>();
    private Set<String> iMinors = new HashSet<String>();
    private Map<String, Set<String>> iConcentrations = null;
    public static final int DEFAULT_PRIORITY = 500;
    public static final boolean DEFAULT_MUST_BE_USED = false;
    public static final boolean DEFAULT_CAN_ASSIGN_OVER_LIMIT = false;
    public static final boolean DEFAULT_ALLOW_OVERLAP = false;

    public CurriculumReservation(long id, double limit, Offering offering, Collection<String> acadAreas, Collection<String> classifications, Collection<String> majors, Collection<String> minors) {
        super(id, offering, 500, false, false, false);
        this.iLimit = limit;
        if (acadAreas != null) {
            this.iAcadAreas.addAll(acadAreas);
        }
        if (classifications != null) {
            this.iClassifications.addAll(classifications);
        }
        if (majors != null) {
            this.iMajors.addAll(majors);
        }
        if (minors != null) {
            this.iMinors.addAll(minors);
        }
    }

    @Deprecated
    public CurriculumReservation(long id, double limit, Offering offering, String acadArea, Collection<String> classifications, Collection<String> majors) {
        super(id, offering, 500, false, false, false);
        this.iLimit = limit;
        this.iAcadAreas.add(acadArea);
        if (classifications != null) {
            this.iClassifications.addAll(classifications);
        }
        if (majors != null) {
            this.iMajors.addAll(majors);
        }
    }

    protected CurriculumReservation(long id, double limit, Offering offering, Collection<String> acadAreas, Collection<String> classifications, Collection<String> majors, Collection<String> minors, int priority, boolean mustBeUsed, boolean canAssignOverLimit, boolean allowOverlap) {
        super(id, offering, priority, mustBeUsed, canAssignOverLimit, allowOverlap);
        this.iLimit = limit;
        if (acadAreas != null) {
            this.iAcadAreas.addAll(acadAreas);
        }
        if (classifications != null) {
            this.iClassifications.addAll(classifications);
        }
        if (majors != null) {
            this.iMajors.addAll(majors);
        }
        if (minors != null) {
            this.iMinors.addAll(minors);
        }
    }

    @Deprecated
    protected CurriculumReservation(long id, double limit, Offering offering, String acadArea, Collection<String> classifications, Collection<String> majors, int priority, boolean mustBeUsed, boolean canAssignOverLimit, boolean allowOverlap) {
        super(id, offering, priority, mustBeUsed, canAssignOverLimit, allowOverlap);
        this.iLimit = limit;
        this.iAcadAreas.add(acadArea);
        if (classifications != null) {
            this.iClassifications.addAll(classifications);
        }
        if (majors != null) {
            this.iMajors.addAll(majors);
        }
    }

    @Override
    public double getReservationLimit() {
        return this.iLimit;
    }

    public void setReservationLimit(double limit) {
        this.iLimit = limit;
    }

    public Set<String> getAcademicAreas() {
        return this.iAcadAreas;
    }

    @Deprecated
    public String getAcademicArea() {
        if (this.getAcademicAreas().isEmpty()) {
            return "";
        }
        return this.getAcademicAreas().iterator().next();
    }

    public Set<String> getMajors() {
        return this.iMajors;
    }

    public Set<String> getMinors() {
        return this.iMinors;
    }

    public Set<String> getClassifications() {
        return this.iClassifications;
    }

    public Set<String> getConcentrations(String major) {
        return this.iConcentrations == null ? null : this.iConcentrations.get(major);
    }

    public void addConcentration(String major, String concentration) {
        Set<String> concentrations;
        if (this.iConcentrations == null) {
            this.iConcentrations = new HashMap<String, Set<String>>();
        }
        if ((concentrations = this.iConcentrations.get(major)) == null) {
            concentrations = new HashSet<String>();
            this.iConcentrations.put(major, concentrations);
        }
        concentrations.add(concentration);
    }

    @Override
    public boolean isApplicable(Student student, Course course) {
        if (!this.getMajors().isEmpty() || this.getMinors().isEmpty()) {
            for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
                if (!this.getAcademicAreas().contains(acm.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(acm.getClassification()) || !this.getMajors().isEmpty() && !this.getMajors().contains(acm.getMajor())) continue;
                Set<String> conc = this.getConcentrations(acm.getMajor());
                if (conc != null && !conc.isEmpty()) {
                    return acm.getConcentration() != null && conc.contains(acm.getConcentration());
                }
                return true;
            }
        }
        if (!this.getMinors().isEmpty()) {
            for (AreaClassificationMajor acm : student.getAreaClassificationMinors()) {
                if (!this.getAcademicAreas().contains(acm.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(acm.getClassification()) || !this.getMinors().contains(acm.getMajor())) continue;
                return true;
            }
        }
        return false;
    }
}

