/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.base.BaseStudentSchedulingRule;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.model.dao.StudentSchedulingRuleDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XInstructionalMethod;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="std_sched_rules")
public class StudentSchedulingRule
extends BaseStudentSchedulingRule {
    private static final long serialVersionUID = -5483870159301335999L;
    transient Query iQuery = null;

    @Transient
    public Query getStudentQuery() {
        if (this.iQuery == null) {
            this.iQuery = new Query(this.getStudentFilter());
        }
        return this.iQuery;
    }

    public boolean matchSession(String term, String year, String initiative) {
        if (this.getFilterTerm() != null && !this.getFilterTerm().isEmpty() && !term.matches(this.getFilterTerm())) {
            return false;
        }
        if (this.getFilterInitiative() != null && !this.getFilterInitiative().isEmpty() && !initiative.matches(this.getFilterInitiative())) {
            return false;
        }
        if (this.getFirstYear() != null && Integer.parseInt(year) < this.getFirstYear()) {
            return false;
        }
        return this.getLastYear() == null || Integer.parseInt(year) <= this.getLastYear();
    }

    public boolean matchSession(AcademicSessionInfo info) {
        return this.matchSession(info.getTerm(), info.getYear(), info.getCampus());
    }

    public boolean matchSession(Session session) {
        return this.matchSession(session.getAcademicTerm(), session.getAcademicYear(), session.getAcademicInitiative());
    }

    public boolean hasInstructionalMethod() {
        return this.getInstructonalMethod() != null && !this.getInstructonalMethod().isEmpty();
    }

    public boolean matchesInstructionalMethod(String im) {
        if (!this.hasInstructionalMethod()) {
            return true;
        }
        if (this.getInstructonalMethod().startsWith("!")) {
            return im != null && !im.matches(this.getInstructonalMethod().substring(1));
        }
        return im != null && im.matches(this.getInstructonalMethod());
    }

    public boolean matchesInstructionalMethod(InstructionalMethod im) {
        return this.matchesInstructionalMethod(im == null ? null : im.getReference());
    }

    public boolean matchesInstructionalMethod(XInstructionalMethod im) {
        return this.matchesInstructionalMethod(im == null ? null : im.getReference());
    }

    public boolean hasCourseName() {
        return this.getCourseName() != null && !this.getCourseName().isEmpty();
    }

    public boolean matchesCourseName(String cn) {
        if (!this.hasCourseName()) {
            return true;
        }
        if (this.getCourseName().startsWith("!")) {
            return cn != null && !cn.matches(this.getCourseName().substring(1));
        }
        return cn != null && cn.matches(this.getCourseName());
    }

    public boolean hasCourseType() {
        return this.getCourseType() != null && !this.getCourseType().isEmpty();
    }

    public boolean matchesCourseType(String ct) {
        if (!this.hasCourseType()) {
            return true;
        }
        if (this.getCourseType().startsWith("!")) {
            return ct != null && !ct.matches(this.getCourseType().substring(1));
        }
        return ct != null && ct.matches(this.getCourseType());
    }

    public boolean matchesCourseType(CourseType ct) {
        return this.matchesCourseType(ct == null ? null : ct.getReference());
    }

    public boolean matchesCourse(XCourseId course, org.hibernate.Session hibSession) {
        if (this.isDisjunctive().booleanValue()) {
            InstructionalOffering offering;
            if (this.hasCourseName() && this.matchesCourseName(course.getCourseName())) {
                return true;
            }
            if (this.hasCourseType() && this.matchesCourseType(course.getType())) {
                return true;
            }
            if (this.hasInstructionalMethod() && (offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId(), hibSession)) != null) {
                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                    if (!this.matchesInstructionalMethod(config.getEffectiveInstructionalMethod())) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.hasCourseName() && !this.matchesCourseName(course.getCourseName())) {
            return false;
        }
        if (this.hasCourseType() && !this.matchesCourseType(course.getType())) {
            return false;
        }
        if (this.hasInstructionalMethod()) {
            InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId(), hibSession);
            boolean hasMatchingConfig = false;
            if (offering != null) {
                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                    if (!this.matchesInstructionalMethod(config.getEffectiveInstructionalMethod())) continue;
                    hasMatchingConfig = true;
                    break;
                }
            }
            if (!hasMatchingConfig) {
                return false;
            }
        }
        return true;
    }

    public boolean matchesCourse(XCourseId course, OnlineSectioningServer server) {
        if (this.isDisjunctive().booleanValue()) {
            XOffering offering;
            if (this.hasCourseName() && this.matchesCourseName(course.getCourseName())) {
                return true;
            }
            if (this.hasCourseType() && this.matchesCourseType(course.getType())) {
                return true;
            }
            if (this.hasInstructionalMethod() && (offering = server.getOffering(course.getOfferingId())) != null) {
                for (XConfig config : offering.getConfigs()) {
                    if (!this.matchesInstructionalMethod(config.getInstructionalMethod())) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.hasCourseName() && !this.matchesCourseName(course.getCourseName())) {
            return false;
        }
        if (this.hasCourseType() && !this.matchesCourseType(course.getType())) {
            return false;
        }
        if (this.hasInstructionalMethod()) {
            XOffering offering = server.getOffering(course.getOfferingId());
            boolean hasMatchingConfig = false;
            if (offering != null) {
                for (XConfig config : offering.getConfigs()) {
                    if (!this.matchesInstructionalMethod(config.getInstructionalMethod())) continue;
                    hasMatchingConfig = true;
                    break;
                }
            }
            if (!hasMatchingConfig) {
                return false;
            }
        }
        return true;
    }

    public boolean matchesCourse(CourseOffering course) {
        if (this.isDisjunctive().booleanValue()) {
            if (this.hasCourseName() && this.matchesCourseName(course.getCourseName())) {
                return true;
            }
            if (this.hasCourseType() && this.matchesCourseType(course.getCourseType())) {
                return true;
            }
            if (this.hasInstructionalMethod()) {
                for (InstrOfferingConfig config : course.getInstructionalOffering().getInstrOfferingConfigs()) {
                    if (!this.matchesInstructionalMethod(config.getEffectiveInstructionalMethod())) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.hasCourseName() && !this.matchesCourseName(course.getCourseName())) {
            return false;
        }
        if (this.hasCourseType() && !this.matchesCourseType(course.getCourseType())) {
            return false;
        }
        if (this.hasInstructionalMethod()) {
            boolean hasMatchingConfig = false;
            for (InstrOfferingConfig config : course.getInstructionalOffering().getInstrOfferingConfigs()) {
                if (!this.matchesInstructionalMethod(config.getEffectiveInstructionalMethod())) continue;
                hasMatchingConfig = true;
                break;
            }
            if (!hasMatchingConfig) {
                return false;
            }
        }
        return true;
    }

    public static StudentSchedulingRule getRule(Query.TermMatcher studentMatcher, AcademicSessionInfo info, boolean isAdvisor, boolean isAdmin, Mode mode, org.hibernate.Session hibSession) {
        for (StudentSchedulingRule rule : hibSession.createQuery("from StudentSchedulingRule order by ord", StudentSchedulingRule.class).setCacheable(true).list()) {
            if (rule.isAdvisorOverride().booleanValue() && isAdvisor || rule.isAdminOverride().booleanValue() && isAdmin || mode == Mode.Filter && !rule.isAppliesToFilter().booleanValue() || mode == Mode.Online && !rule.isAppliesToOnline().booleanValue() || mode == Mode.Batch && !rule.isAppliesToBatch().booleanValue() || !rule.matchSession(info) || rule.getStudentFilter() != null && !rule.getStudentFilter().isEmpty() && !rule.getStudentQuery().match(studentMatcher)) continue;
            return rule;
        }
        return null;
    }

    public static boolean hasRules(AcademicSessionInfo info, boolean isAdvisor, boolean isAdmin, Mode mode, org.hibernate.Session hibSession) {
        for (StudentSchedulingRule rule : hibSession.createQuery("from StudentSchedulingRule order by ord", StudentSchedulingRule.class).setCacheable(true).list()) {
            if (rule.isAdvisorOverride().booleanValue() && isAdvisor || rule.isAdminOverride().booleanValue() && isAdmin || mode == Mode.Filter && !rule.isAppliesToFilter().booleanValue() || mode == Mode.Online && !rule.isAppliesToOnline().booleanValue() || mode == Mode.Batch && !rule.isAppliesToBatch().booleanValue() || !rule.matchSession(info)) continue;
            return true;
        }
        return false;
    }

    public static StudentSchedulingRule getRule(Long studentId, boolean isAdvisor, boolean isAdmin, Mode mode, org.hibernate.Session hibSession) {
        Student student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
        if (student == null) {
            return null;
        }
        DbFindEnrollmentInfoAction.DbStudentMatcher studentMatcher = new DbFindEnrollmentInfoAction.DbStudentMatcher(student);
        for (StudentSchedulingRule rule : hibSession.createQuery("from StudentSchedulingRule order by ord", StudentSchedulingRule.class).setCacheable(true).list()) {
            if (rule.isAdvisorOverride().booleanValue() && isAdvisor || rule.isAdminOverride().booleanValue() && isAdmin || mode == Mode.Filter && !rule.isAppliesToFilter().booleanValue() || mode == Mode.Online && !rule.isAppliesToOnline().booleanValue() || mode == Mode.Batch && !rule.isAppliesToBatch().booleanValue() || !rule.matchSession(student.getSession()) || rule.getStudentFilter() != null && !rule.getStudentFilter().isEmpty() && !rule.getStudentQuery().match(studentMatcher)) continue;
            return rule;
        }
        return null;
    }

    public static boolean hasFilterRules(OnlineSectioningServer server, SessionContext context) {
        return StudentSchedulingRule.hasRules(server.getAcademicSession(), context.hasPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingAdvisor, new Qualifiable[0]), context.hasPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingAdmin, new Qualifiable[0]), Mode.Filter, StudentSchedulingRuleDAO.getInstance().getSession());
    }

    public static StudentSchedulingRule getRuleFilter(XStudent student, OnlineSectioningServer server, SessionContext context) {
        return StudentSchedulingRule.getRule(new StatusPageSuggestionsAction.StudentMatcher(student, server.getAcademicSession().getDefaultSectioningStatus(), server, false), server.getAcademicSession(), context.hasPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingAdvisor, new Qualifiable[0]), context.hasPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingAdmin, new Qualifiable[0]), Mode.Filter, StudentSchedulingRuleDAO.getInstance().getSession());
    }

    public static StudentSchedulingRule getRuleFilter(Student student, OnlineSectioningServer server, SessionContext context) {
        AcademicSessionInfo session = server == null ? new AcademicSessionInfo(student.getSession()) : server.getAcademicSession();
        return StudentSchedulingRule.getRule(new DbFindEnrollmentInfoAction.DbStudentMatcher(student), session, context.hasPermissionAnySession((Object)session, Right.StudentSchedulingAdvisor, new Qualifiable[0]), context.hasPermissionAnySession((Object)session, Right.StudentSchedulingAdmin, new Qualifiable[0]), Mode.Filter, StudentSchedulingRuleDAO.getInstance().getSession());
    }

    public static StudentSchedulingRule getRuleFilter(Long studentId, OnlineSectioningServer server, SessionContext context) {
        if (server != null && !(server instanceof DatabaseServer)) {
            XStudent student = server.getStudent(studentId);
            if (student == null) {
                return null;
            }
            return StudentSchedulingRule.getRule(new StatusPageSuggestionsAction.StudentMatcher(student, server.getAcademicSession().getDefaultSectioningStatus(), server, false), server.getAcademicSession(), context.hasPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingAdvisor, new Qualifiable[0]), context.hasPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingAdmin, new Qualifiable[0]), Mode.Filter, StudentSchedulingRuleDAO.getInstance().getSession());
        }
        Student student = (Student)StudentDAO.getInstance().get(studentId);
        if (student == null) {
            return null;
        }
        AcademicSessionInfo session = new AcademicSessionInfo(student.getSession());
        return StudentSchedulingRule.getRule(new DbFindEnrollmentInfoAction.DbStudentMatcher(student), session, context.hasPermissionAnySession((Object)session, Right.StudentSchedulingAdvisor, new Qualifiable[0]), context.hasPermissionAnySession((Object)session, Right.StudentSchedulingAdmin, new Qualifiable[0]), Mode.Filter, StudentSchedulingRuleDAO.getInstance().getSession());
    }

    public static StudentSchedulingRule getRuleFilter(XStudent student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        return StudentSchedulingRule.getRule(new StatusPageSuggestionsAction.StudentMatcher(student, server.getAcademicSession().getDefaultSectioningStatus(), server, false), server.getAcademicSession(), helper.hasAvisorPermission(), helper.hasAdminPermission(), Mode.Filter, helper.getHibSession());
    }

    public static StudentSchedulingRule getRuleFilter(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        AcademicSessionInfo session = server == null ? new AcademicSessionInfo(student.getSession()) : server.getAcademicSession();
        return StudentSchedulingRule.getRule(new DbFindEnrollmentInfoAction.DbStudentMatcher(student), session, helper.hasAvisorPermission(), helper.hasAdminPermission(), Mode.Filter, helper.getHibSession());
    }

    public static StudentSchedulingRule getRuleOnline(XStudent student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        return StudentSchedulingRule.getRule(new StatusPageSuggestionsAction.StudentMatcher(student, server.getAcademicSession().getDefaultSectioningStatus(), server, false), server.getAcademicSession(), helper.hasAvisorPermission(), helper.hasAdminPermission(), Mode.Online, helper.getHibSession());
    }

    public static StudentSchedulingRule getRuleOnline(XStudent student, OnlineSectioningServer server, org.hibernate.Session hibSession) {
        return StudentSchedulingRule.getRule(new StatusPageSuggestionsAction.StudentMatcher(student, server.getAcademicSession().getDefaultSectioningStatus(), server, false), server.getAcademicSession(), false, false, Mode.Online, hibSession);
    }

    public static enum Mode {
        Filter,
        Online,
        Batch;

    }
}

