/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.base.BaseSolverParameterGroup;
import org.unitime.timetable.model.dao.SolverParameterGroupDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="solver_parameter_group")
public class SolverParameterGroup
extends BaseSolverParameterGroup {
    private static final long serialVersionUID = 1L;

    public SolverParameterGroup() {
    }

    public SolverParameterGroup(Long uniqueId) {
        super(uniqueId);
    }

    public static SolverParameterGroup findByName(String name) {
        return (SolverParameterGroup)SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterGroup where name = :name", SolverParameterGroup.class).setParameter("name", (Object)name).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    @Transient
    public static String[] getGroupNames() {
        List groups = SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterGroup order by order", SolverParameterGroup.class).setCacheable(true).list();
        String[] ret = new String[groups.size()];
        int idx = 0;
        for (SolverParameterGroup group : groups) {
            ret[idx++] = group.getName();
        }
        return ret;
    }

    @Transient
    public SolverType getSolverType() {
        return this.getType() == null ? null : SolverType.values()[this.getType()];
    }

    public void setSolverType(SolverType type) {
        this.setType(type == null ? null : Integer.valueOf(type.ordinal()));
    }

    @Transient
    public boolean isVisible() {
        for (SolverParameterDef d : this.getParameters()) {
            if (!d.isVisible().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Transient
    public Set<SolverParameterDef> getVisibleParameters() {
        TreeSet<SolverParameterDef> ret = new TreeSet<SolverParameterDef>();
        for (SolverParameterDef d : this.getParameters()) {
            if (!d.isVisible().booleanValue()) continue;
            ret.add(d);
        }
        return ret;
    }

    public static enum SolverType {
        COURSE("crs_"),
        EXAM("exm_"),
        STUDENT("std_"),
        INSTRUCTOR("ins_");

        private String iPrefix;

        private SolverType(String prefix) {
            this.iPrefix = prefix;
        }

        @Transient
        public String getPrefix() {
            return this.iPrefix;
        }
    }
}

