/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseMeeting;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.MeetingDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="meeting")
public class Meeting
extends BaseMeeting
implements Comparable<Meeting> {
    private static final long serialVersionUID = 1L;
    private Location location = null;

    public Meeting() {
    }

    public Meeting(Long uniqueId) {
        super(uniqueId);
    }

    public Object clone() {
        Meeting newMeeting = new Meeting();
        newMeeting.setClassCanOverride(this.isClassCanOverride());
        newMeeting.setLocationPermanentId(this.getLocationPermanentId());
        newMeeting.setMeetingDate(this.getMeetingDate());
        newMeeting.setStartOffset(this.getStartOffset());
        newMeeting.setStartPeriod(this.getStartPeriod());
        newMeeting.setStopOffset(this.getStopOffset());
        newMeeting.setStopPeriod(this.getStopPeriod());
        newMeeting.setStatus(Status.PENDING);
        return newMeeting;
    }

    @Override
    public int compareTo(Meeting other) {
        int cmp = this.getMeetingDate().compareTo(other.getMeetingDate());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getStartPeriod().compareTo(other.getStartPeriod());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getRoomLabel().compareTo(other.getRoomLabel());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(other.getUniqueId() == null ? -1L : other.getUniqueId());
    }

    public void setLocation(Location location) {
        this.location = location;
        if (location == null) {
            this.setLocationPermanentId(null);
        } else {
            this.setLocationPermanentId(location.getPermanentId());
        }
    }

    @Transient
    public Location getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.getLocationPermanentId() == null) {
            return null;
        }
        if (this.getMeetingDate() == null) {
            return null;
        }
        Session session = null;
        if (this.getEvent() != null) {
            session = this.getEvent().getSession();
        }
        if (session != null) {
            this.location = (Location)RoomDAO.getInstance().getSession().createQuery("select r from Room r where r.permanentId = :permId and r.session.uniqueId=:sessionId", Location.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("permId", (Object)this.getLocationPermanentId()).setCacheable(true).uniqueResult();
            if (this.location == null) {
                this.location = (Location)RoomDAO.getInstance().getSession().createQuery("select r from NonUniversityLocation r where r.permanentId = :permId and r.session.uniqueId=:sessionId", Location.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("permId", (Object)this.getLocationPermanentId()).setCacheable(true).uniqueResult();
            }
            return this.location;
        }
        long distance = -1L;
        List locations = LocationDAO.getInstance().getSession().createQuery("from Location where permanentId = :permId", Location.class).setParameter("permId", (Object)this.getLocationPermanentId()).setCacheable(true).list();
        if (!locations.isEmpty()) {
            long dist;
            for (Location loc : locations) {
                if (loc.getSession().getStatusType().isTestSession()) continue;
                dist = loc.getSession().getDistance(this.getMeetingDate());
                if (this.location != null && distance <= dist) continue;
                this.location = loc;
                distance = dist;
            }
            for (Location loc : locations) {
                if (!loc.getSession().getStatusType().isTestSession()) continue;
                dist = loc.getSession().getDistance(this.getMeetingDate());
                if (this.location != null && distance <= dist) continue;
                this.location = loc;
                distance = dist;
            }
        }
        return this.location;
    }

    @Transient
    public List<Meeting> getTimeRoomOverlaps() {
        if (this.getLocationPermanentId() == null) {
            return new ArrayList<Meeting>();
        }
        return MeetingDAO.getInstance().getSession().createQuery("from Meeting m where m.meetingDate=:meetingDate and m.startPeriod < :stopPeriod and m.stopPeriod > :startPeriod and m.locationPermanentId = :locPermId and m.uniqueId != :uniqueId and m.approvalStatus <= 1", Meeting.class).setParameter("meetingDate", (Object)this.getMeetingDate()).setParameter("stopPeriod", (Object)this.getStopPeriod()).setParameter("startPeriod", (Object)this.getStartPeriod()).setParameter("locPermId", (Object)this.getLocationPermanentId()).setParameter("uniqueId", (Object)this.getUniqueId()).list();
    }

    @Transient
    public List<Meeting> getApprovedTimeRoomOverlaps() {
        if (this.getLocationPermanentId() == null) {
            return new ArrayList<Meeting>();
        }
        return MeetingDAO.getInstance().getSession().createQuery("from Meeting m where m.meetingDate=:meetingDate and m.startPeriod < :stopPeriod and m.stopPeriod > :startPeriod and m.locationPermanentId = :locPermId and m.uniqueId != :uniqueId and m.approvalStatus = 1", Meeting.class).setParameter("meetingDate", (Object)this.getMeetingDate()).setParameter("stopPeriod", (Object)this.getStopPeriod()).setParameter("startPeriod", (Object)this.getStartPeriod()).setParameter("locPermId", (Object)this.getLocationPermanentId()).setParameter("uniqueId", (Object)this.getUniqueId()).list();
    }

    public static List<Meeting> findOverlaps(Date meetingDate, int startPeriod, int stopPeriod, Long locationPermId) {
        return MeetingDAO.getInstance().getSession().createQuery("from Meeting m where m.meetingDate=:meetingDate and m.startPeriod < :stopPeriod and m.stopPeriod > :startPeriod and m.locationPermanentId = :locPermId and m.approvalStatus <= 1", Meeting.class).setParameter("meetingDate", (Object)meetingDate).setParameter("stopPeriod", (Object)stopPeriod).setParameter("startPeriod", (Object)startPeriod).setParameter("locPermId", (Object)locationPermId).list();
    }

    public boolean hasTimeRoomOverlaps() {
        return ((Number)MeetingDAO.getInstance().getSession().createQuery("select count(m) from Meeting m where m.meetingDate=:meetingDate and m.startPeriod < :stopPeriod and m.stopPeriod > :startPeriod and m.locationPermanentId = :locPermId and m.uniqueId != :uniqueId and m.approvalStatus <= 1", Number.class).setParameter("meetingDate", (Object)this.getMeetingDate()).setParameter("stopPeriod", (Object)this.getStopPeriod()).setParameter("startPeriod", (Object)this.getStartPeriod()).setParameter("locPermId", (Object)this.getLocationPermanentId()).setParameter("uniqueId", (Object)this.getUniqueId()).uniqueResult()).longValue() > 0L;
    }

    @Override
    public String toString() {
        return DateFormat.getDateInstance(3).format(this.getMeetingDate()) + " " + (String)(this.isAllDay() ? "All Day" : this.startTime() + " - " + this.stopTime()) + (String)(this.getLocation() == null ? "" : ", " + this.getLocation().getLabel());
    }

    @Transient
    public String getTimeLabel() {
        return this.dateStr() + " " + this.startTime() + " - " + this.stopTime();
    }

    @Transient
    public String getRoomLabel() {
        return this.getLocation() == null ? "" : this.getLocation().getLabel();
    }

    private String periodToTime(Integer slot, Integer offset) {
        if (slot == null) {
            return "";
        }
        int min = slot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        if (offset != null) {
            min += offset.intValue();
        }
        return Constants.toTime(min);
    }

    public String startTime() {
        return this.periodToTime(this.getStartPeriod(), this.getStartOffset());
    }

    public String stopTime() {
        return this.periodToTime(this.getStopPeriod(), this.getStopOffset());
    }

    public String startTimeNoOffset() {
        return this.periodToTime(this.getStartPeriod(), 0);
    }

    public String stopTimeNoOffset() {
        return this.periodToTime(this.getStopPeriod(), 0);
    }

    public String dateStr() {
        return Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD).format(this.getMeetingDate());
    }

    @Transient
    public Date getStartTime() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getMeetingDate());
        int min = this.getStartPeriod() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + (this.getStartOffset() == null ? 0 : this.getStartOffset());
        c.set(10, min / 60);
        c.set(12, min % 60);
        return c.getTime();
    }

    @Transient
    public Date getTrueStartTime() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getMeetingDate());
        int min = this.getStartPeriod() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        c.set(10, min / 60);
        c.set(12, min % 60);
        return c.getTime();
    }

    @Transient
    public Date getStopTime() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getMeetingDate());
        int min = this.getStopPeriod() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + (this.getStopOffset() == null ? 0 : this.getStopOffset());
        c.set(10, min / 60);
        c.set(12, min % 60);
        return c.getTime();
    }

    @Transient
    public Date getTrueStopTime() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getMeetingDate());
        int min = this.getStopPeriod() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        c.set(10, min / 60);
        c.set(12, min % 60);
        return c.getTime();
    }

    public Date getTrueStartTime(EventDateMapping.Class2EventDateMap class2eventDateMap) {
        Date meetingDate;
        Calendar c = Calendar.getInstance(Locale.US);
        Date date = meetingDate = class2eventDateMap == null ? this.getMeetingDate() : class2eventDateMap.getClassDate(this.getMeetingDate());
        if (meetingDate == null) {
            return null;
        }
        c.setTime(meetingDate);
        int min = this.getStartPeriod() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        c.set(10, min / 60);
        c.set(12, min % 60);
        return c.getTime();
    }

    public Date getTrueStopTime(EventDateMapping.Class2EventDateMap class2eventDateMap) {
        Date meetingDate;
        Calendar c = Calendar.getInstance(Locale.US);
        Date date = meetingDate = class2eventDateMap == null ? this.getMeetingDate() : class2eventDateMap.getClassDate(this.getMeetingDate());
        if (meetingDate == null) {
            return null;
        }
        c.setTime(meetingDate);
        int min = this.getStopPeriod() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        c.set(10, min / 60);
        c.set(12, min % 60);
        return c.getTime();
    }

    @Transient
    public int getDayOfWeek() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getMeetingDate());
        return c.get(7);
    }

    @Transient
    public boolean isApproved() {
        return this.getApprovalStatus() != null && this.getApprovalStatus().equals(Status.APPROVED.ordinal());
    }

    public boolean overlaps(Meeting meeting) {
        if (this.getMeetingDate().getTime() != meeting.getMeetingDate().getTime()) {
            return false;
        }
        return this.getStartPeriod() < meeting.getStopPeriod() && meeting.getStartPeriod() < this.getStopPeriod();
    }

    @Transient
    public boolean isAllDay() {
        return this.getStartPeriod() == 0 && this.getStopPeriod() == 288;
    }

    public void setStatus(Status status) {
        this.setApprovalStatus(status.ordinal());
    }

    @Transient
    public Status getStatus() {
        return this.getApprovalStatus() == null ? Status.PENDING : Status.values()[this.getApprovalStatus()];
    }

    public static enum Status {
        PENDING,
        APPROVED,
        REJECTED,
        CANCELLED;

    }
}

