/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseBuilding;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="building")
public class Building
extends BaseBuilding
implements Comparable {
    private static final long serialVersionUID = 3256440313428981557L;
    public static String BLDG_LIST_ATTR_NAME = "bldgsList";

    public Building() {
    }

    public Building(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public String getAbbrName() {
        return this.getAbbreviation() + " - " + this.getName();
    }

    public void setAbbrName(String abbrName) {
    }

    @Override
    public String toString() {
        return this.getAbbrName();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Building)) {
            return -1;
        }
        Building b = (Building)o;
        int cmp = this.getAbbreviation().compareTo(b.getAbbreviation());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(b.getUniqueId() == null ? -1L : b.getUniqueId());
    }

    public static Building findByBldgAbbv(String bldgAbbv, Long sessionId) {
        return (Building)BuildingDAO.getInstance().getSession().createQuery("from Building where session.uniqueId = :sessionId and abbreviation=:bldgAbbv", Building.class).setParameter("sessionId", (Object)sessionId).setParameter("bldgAbbv", (Object)bldgAbbv).setMaxResults(1).uniqueResult();
    }

    public static Building findByBldgAbbv(org.hibernate.Session hibSession, Long sessionId, String bldgAbbv) {
        return (Building)(hibSession == null ? BuildingDAO.getInstance().getSession() : hibSession).createQuery("from Building b where session.uniqueId=:sessionId and b.abbreviation=:bldgAbbv", Building.class).setParameter("sessionId", (Object)sessionId).setParameter("bldgAbbv", (Object)bldgAbbv).setMaxResults(1).uniqueResult();
    }

    public static Building findByName(String name, Long sessionId) {
        return (Building)BuildingDAO.getInstance().getSession().createQuery("select b from Building b where b.session.uniqueId=:sessionId and b.name=:name", Building.class).setParameter("sessionId", (Object)sessionId).setParameter("name", (Object)name).uniqueResult();
    }

    public Object clone() {
        Building b = new Building();
        b.setAbbreviation(this.getAbbreviation());
        b.setCoordinateX(this.getCoordinateX());
        b.setCoordinateY(this.getCoordinateY());
        b.setExternalUniqueId(this.getExternalUniqueId());
        b.setName(this.getName());
        b.setSession(this.getSession());
        return b;
    }

    public Building findSameBuildingInSession(Session newSession) {
        if (newSession == null) {
            return null;
        }
        Building newBuilding = Building.findByBldgAbbv(this.getAbbreviation(), newSession.getUniqueId());
        if (newBuilding == null && this.getExternalUniqueId() != null) {
            newBuilding = Building.findByExternalIdAndSession(this.getExternalUniqueId(), newSession);
        }
        return newBuilding;
    }

    public static Building findByExternalIdAndSession(String externalId, Session session) {
        return Building.findByExternalIdAndSession(externalId, session.getUniqueId());
    }

    public static Building findByExternalIdAndSession(String externalId, Long sessionId) {
        if (externalId == null) {
            return null;
        }
        return (Building)BuildingDAO.getInstance().getSession().createQuery("from Building where externalUniqueId = :externalId and session.uniqueId = :sessionId", Building.class).setParameter("externalId", (Object)externalId).setParameter("sessionId", (Object)sessionId).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public static List<Building> findAll(Long sessionId) {
        return BuildingDAO.getInstance().getSession().createQuery("select b from Building b where b.session.uniqueId=:sessionId order by b.abbreviation", Building.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    @Deprecated
    @Transient
    public String getHtmlHint() {
        Object hint = this.getName();
        Object minimap = ApplicationProperty.RoomHintMinimapUrl.value();
        if (minimap != null && this.getCoordinateX() != null && this.getCoordinateY() != null) {
            minimap = ((String)minimap).replace("%x", this.getCoordinateX().toString()).replace("%y", this.getCoordinateY().toString()).replace("%n", this.getAbbreviation()).replace("%i", this.getExternalUniqueId() == null ? "" : this.getExternalUniqueId());
            String apikey = ApplicationProperty.RoomMapStaticApiKey.value();
            if (apikey != null && !apikey.isEmpty()) {
                minimap = (String)minimap + "&key=" + apikey;
                String secret = ApplicationProperty.RoomMapStaticSecret.value();
                if (secret != null && !secret.isEmpty()) {
                    try {
                        minimap = (String)minimap + "&signature=" + new RoomDetailsBackend.UrlSigner(secret).signRequest((String)minimap);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            hint = (String)hint + "<br><img src=\\'" + (String)minimap + "\\' border=\\'0\\' style=\\'border: 1px solid #9CB0CE;\\'/>";
        }
        return hint;
    }
}

