/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class SingleDateSelector
extends UniTimeWidget<AriaTextBox>
implements HasValue<Date>,
HasText,
HasEnabled {
    private static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private RegExp[] iRegExp = new RegExp[]{RegExp.compile((String)"^([0-9]+)[/ ]*([0-9]*)[/ ]*([0-9]*)$"), RegExp.compile((String)"^([0-9]+)\\.?([0-9]*)\\.?([0-9]*)$")};
    private PopupPanel iPopup;
    private SingleMonth iMonth;
    private DateTimeFormat iFormat = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat());
    private DateTimeFormat iDefaultFormat = DateTimeFormat.getFormat((String)"MM/dd/yyyy");
    private AcademicSessionProvider iAcademicSession;
    private static int sFirstDayOfWeekend = (6 + LocaleInfo.getCurrentLocale().getDateTimeFormatInfo().weekendStart()) % 7;
    private static int sLastDayOfWeekend = (6 + LocaleInfo.getCurrentLocale().getDateTimeFormatInfo().weekendEnd()) % 7;
    private static int sStartingDay = (6 + LocaleInfo.getCurrentLocale().getDateTimeFormatInfo().firstDayOfTheWeek()) % 7;
    AriaTextBox iPicker = (AriaTextBox)this.getWidget();
    private boolean iHint;

    public SingleDateSelector() {
        this(new AriaTextBox(), null, true);
    }

    public SingleDateSelector(AcademicSessionProvider session) {
        this(new AriaTextBox(), session, true);
    }

    public SingleDateSelector(AcademicSessionProvider session, boolean hint) {
        this(new AriaTextBox(), session, hint);
    }

    private SingleDateSelector(AriaTextBox text, AcademicSessionProvider session, boolean hint) {
        super(text);
        this.iAcademicSession = session;
        this.iHint = hint;
        if (this.iHint) {
            this.setHint(this.iFormat.getPattern().toUpperCase());
        }
        this.iPicker.setStyleName("gwt-SuggestBox");
        this.iPicker.addStyleName("unitime-DateSelectionBox");
        this.iPicker.setAriaLabel(null);
        this.iMonth = new SingleMonth(new Date()){

            @Override
            protected void init() {
                super.init();
                if (SingleDateSelector.this.iPopup != null && SingleDateSelector.this.iPopup.isShowing() && this.getValue() != null) {
                    AriaStatus.getInstance().setText(ARIA.singleDateCursor(DateTimeFormat.getFormat((String)CONSTANTS.singleDateSelectionFormat()).format(this.getValue())));
                }
            }
        };
        AbsolutePanel panel = new AbsolutePanel();
        panel.setStyleName("unitime-DateSelector");
        panel.add((Widget)this.iMonth);
        this.iPopup = new PopupPanel(true, false);
        this.iPopup.setPreviewingAllNativeEvents(true);
        this.iPopup.setStyleName("unitime-DateSelectionBoxPopup");
        this.iPopup.setWidget((Widget)panel);
        this.iPicker.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                SingleDateSelector.this.iPopup.showRelativeTo((UIObject)SingleDateSelector.this.iPicker);
            }
        });
        this.iPicker.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (SingleDateSelector.this.iPopup.isShowing()) {
                    SingleDateSelector.this.iPopup.hide();
                }
            }
        });
        this.iPicker.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (SingleDateSelector.this.iPopup.isShowing()) {
                    switch (event.getNativeEvent().getKeyCode()) {
                        case 38: {
                            SingleDateSelector.this.iMonth.addDays(-7);
                            event.preventDefault();
                            event.stopPropagation();
                            break;
                        }
                        case 40: {
                            SingleDateSelector.this.iMonth.addDays(7);
                            event.preventDefault();
                            event.stopPropagation();
                            break;
                        }
                        case 39: {
                            if (SingleDateSelector.this.iPicker.getCursorPos() != SingleDateSelector.this.iPicker.getText().length()) break;
                            SingleDateSelector.this.iMonth.addDays(1);
                            event.preventDefault();
                            event.stopPropagation();
                            break;
                        }
                        case 37: {
                            if (SingleDateSelector.this.iPicker.getCursorPos() != 0) break;
                            SingleDateSelector.this.iMonth.addDays(-1);
                            event.preventDefault();
                            event.stopPropagation();
                            break;
                        }
                        case 33: {
                            SingleDateSelector.this.iMonth.addMonths(-1);
                            event.preventDefault();
                            event.stopPropagation();
                            break;
                        }
                        case 34: {
                            SingleDateSelector.this.iMonth.addMonths(1);
                            event.preventDefault();
                            event.stopPropagation();
                            break;
                        }
                        case 27: {
                            event.preventDefault();
                            event.stopPropagation();
                            SingleDateSelector.this.iPopup.hide();
                            break;
                        }
                        case 13: {
                            if (SingleDateSelector.this.iMonth.getValue() != null) {
                                SingleDateSelector.this.iPicker.setText(SingleDateSelector.this.iFormat.format(SingleDateSelector.this.iMonth.getValue()));
                                ValueChangeEvent.fire((HasValueChangeHandlers)SingleDateSelector.this, (Object)SingleDateSelector.this.getValue());
                                AriaStatus.getInstance().setText(ARIA.singleDateSelected(DateTimeFormat.getFormat((String)CONSTANTS.singleDateSelectionFormat()).format(SingleDateSelector.this.getValue())));
                            }
                            event.preventDefault();
                            event.stopPropagation();
                            SingleDateSelector.this.iPopup.hide();
                        }
                    }
                } else if (event.getNativeEvent().getKeyCode() == 40 && (event.getNativeEvent().getAltKey() || SingleDateSelector.this.iPicker.getCursorPos() == SingleDateSelector.this.iPicker.getText().length())) {
                    try {
                        SingleDateSelector.this.iMonth.setValue(SingleDateSelector.this.iFormat.parse(SingleDateSelector.this.iPicker.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SingleDateSelector.this.iPopup.showRelativeTo((UIObject)SingleDateSelector.this.iPicker);
                    if (SingleDateSelector.this.iMonth.getValue() != null) {
                        AriaStatus.getInstance().setText(ARIA.singleDatePopupOpenedDateSelected(ARIA.singleDateCursor(DateTimeFormat.getFormat((String)CONSTANTS.singleDateSelectionFormat()).format(SingleDateSelector.this.iMonth.getValue()))));
                    } else {
                        AriaStatus.getInstance().setText(ARIA.singleDatePopupOpenedNoDateSelected(SingleDateSelector.this.iMonth.getCalendarTitle()));
                    }
                    event.preventDefault();
                    event.stopPropagation();
                }
            }
        });
        this.iMonth.addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                if (event.getValue() != null) {
                    SingleDateSelector.this.iPicker.setText(SingleDateSelector.this.iFormat.format(SingleDateSelector.this.iMonth.getValue()));
                    if (SingleDateSelector.this.iPopup.isShowing()) {
                        SingleDateSelector.this.iPopup.hide();
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)SingleDateSelector.this, (Object)((Date)event.getValue()));
                }
            }
        });
        this.iPicker.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                MatchResult match = SingleDateSelector.this.iRegExp[0].exec(SingleDateSelector.this.iPicker.getText());
                int month = -1;
                int day = -1;
                int year = -1;
                if (match != null) {
                    month = Integer.parseInt(match.getGroup(1));
                    day = match.getGroup(2).isEmpty() ? 1 : Integer.parseInt(match.getGroup(2));
                    year = match.getGroup(3).isEmpty() ? -1 : Integer.parseInt(match.getGroup(3));
                } else {
                    match = SingleDateSelector.this.iRegExp[1].exec(SingleDateSelector.this.iPicker.getText());
                    if (match != null) {
                        day = Integer.parseInt(match.getGroup(1));
                        month = match.getGroup(2).isEmpty() ? -1 : Integer.parseInt(match.getGroup(2));
                        int n = year = match.getGroup(3).isEmpty() ? -1 : Integer.parseInt(match.getGroup(3));
                    }
                }
                if (year <= 99 && month >= 0 && SingleDateSelector.this.iMonth.getMonths() != null) {
                    for (EventInterface.SessionMonth m : SingleDateSelector.this.iMonth.getMonths()) {
                        if (m.getMonth() + 1 != month || year >= 0 && year != m.getYear() + 1900 && year != m.getYear() + 2000) continue;
                        year = m.getYear();
                    }
                }
                if (year < 0) {
                    year = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(new Date()));
                } else if (year <= 99) {
                    year += 2000;
                }
                if (year >= 0 && month >= 1 && month <= 12 && day >= 1) {
                    SingleDateSelector.this.iMonth.setDate(year, month, day);
                    SingleDateSelector.this.setValue(SingleDateSelector.this.iMonth.getValue());
                    ValueChangeEvent.fire((HasValueChangeHandlers)SingleDateSelector.this, (Object)SingleDateSelector.this.getValue());
                    return;
                }
                Date date = null;
                try {
                    date = SingleDateSelector.this.iFormat.parse(SingleDateSelector.this.iPicker.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SingleDateSelector.this.iMonth.setValue(date);
                SingleDateSelector.this.setValue(date == null ? null : SingleDateSelector.this.iMonth.getValue());
                ValueChangeEvent.fire((HasValueChangeHandlers)SingleDateSelector.this, (Object)SingleDateSelector.this.getValue());
            }
        });
        if (this.iAcademicSession != null) {
            this.iAcademicSession.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

                @Override
                public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                    if (event.isChanged()) {
                        SingleDateSelector.this.init(event.getNewAcademicSessionId());
                    }
                }
            });
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    SingleDateSelector.this.init(SingleDateSelector.this.iAcademicSession.getAcademicSessionId());
                }
            });
        }
    }

    public void setFirstDate(Date firstDate) {
        this.iMonth.setFirstDate(firstDate == null ? null : this.iFormat.parse(this.iFormat.format(firstDate)));
    }

    public void setLastDate(Date lastDate) {
        this.iMonth.setLastDate(lastDate == null ? null : this.iFormat.parse(this.iFormat.format(lastDate)));
    }

    public void init(Long sessionId) {
        if (sessionId == null) {
            if (this.iHint) {
                this.setHint(MESSAGES.hintNoSession());
            }
        } else {
            if (this.iHint) {
                if (this.iAcademicSession != null) {
                    this.setHint(MESSAGES.waitLoadingDataForSession(this.iAcademicSession.getAcademicSessionName()));
                } else {
                    this.setHint(MESSAGES.waitLoadingData());
                }
            }
            RPC.execute(new EventInterface.RequestSessionDetails(sessionId), new AsyncCallback<GwtRpcResponseList<EventInterface.SessionMonth>>(){

                public void onFailure(Throwable caught) {
                    SingleDateSelector.this.setErrorHint(caught.getMessage());
                }

                public void onSuccess(GwtRpcResponseList<EventInterface.SessionMonth> result) {
                    if (SingleDateSelector.this.iHint) {
                        SingleDateSelector.this.setHint(SingleDateSelector.this.iFormat.getPattern().toUpperCase());
                    }
                    SingleDateSelector.this.iMonth.setMonths(result);
                }
            });
        }
    }

    public void init(final OnlineSectioningInterface.StudentSectioningContext context) {
        if (context == null || context.getAcademicSessionId() == null) {
            if (this.iHint) {
                this.setHint(MESSAGES.hintNoSession());
            }
        } else if (context.hasSessionDates()) {
            if (this.iHint) {
                this.setHint(this.iFormat.getPattern().toUpperCase());
            }
            this.iMonth.setMonths(context.getSessionDates());
        } else {
            if (this.iHint) {
                if (this.iAcademicSession != null) {
                    this.setHint(MESSAGES.waitLoadingDataForSession(this.iAcademicSession.getAcademicSessionName()));
                } else {
                    this.setHint(MESSAGES.waitLoadingData());
                }
            }
            final Long sessionId = context.getAcademicSessionId();
            RPC.execute(new EventInterface.RequestSessionDetails(sessionId), new AsyncCallback<GwtRpcResponseList<EventInterface.SessionMonth>>(){

                public void onFailure(Throwable caught) {
                    SingleDateSelector.this.setErrorHint(caught.getMessage());
                }

                public void onSuccess(GwtRpcResponseList<EventInterface.SessionMonth> result) {
                    if (sessionId.equals(context.getAcademicSessionId())) {
                        context.setSessionDates(result);
                    }
                    if (SingleDateSelector.this.iHint) {
                        SingleDateSelector.this.setHint(SingleDateSelector.this.iFormat.getPattern().toUpperCase());
                    }
                    SingleDateSelector.this.iMonth.setMonths(result);
                }
            });
        }
    }

    public void init(GwtRpcResponseList<EventInterface.SessionMonth> result) {
        if (this.iHint) {
            this.setHint(this.iFormat.getPattern().toUpperCase());
        }
        this.iMonth.setMonths(result);
    }

    static int startingDayOfWeek() {
        return sStartingDay;
    }

    static boolean isWeekend(int dayOfWeek) {
        return sFirstDayOfWeekend == dayOfWeek || sLastDayOfWeekend == dayOfWeek;
    }

    static Date toDate(int year, int month, int day) {
        return DateTimeFormat.getFormat((String)"yyyy/MM/dd").parse(year + "/" + month + "/" + day);
    }

    static int firstDayOfWeek(int year, int month) {
        return (6 + new Date(year - 1900, month - 1, 1).getDay()) % 7;
    }

    static int daysInMonth(int year, int month) {
        return new Date(year + (month == 12 ? 1 : 0) - 1900, (month == 12 ? 1 : month + 1) - 1, 0).getDate();
    }

    static int weekNumber(int year, int month) {
        Date d = new Date(year - 1900, month - 1, 1);
        while (d.getDay() != CalendarUtil.getStartingDayOfWeek()) {
            d.setDate(d.getDate() - 1);
        }
        while (d.getDay() != 4) {
            d.setDate(d.getDate() + 1);
        }
        int y = d.getYear();
        int week = 0;
        while (d.getYear() == y) {
            d.setDate(d.getDate() - 7);
            ++week;
        }
        return week;
    }

    static int dayOfYear(int year, int month, int day) {
        Date d = new Date(year - 1900, month - 1, day);
        int doy = 0;
        int y = d.getYear();
        while (d.getYear() == y) {
            d.setDate(d.getDate() - 1);
            ++doy;
        }
        return doy;
    }

    static Date dayOfYear(int year, int dayOfYear) {
        Date d = new Date(year - 1900, 0, 1);
        --dayOfYear;
        while (dayOfYear < 0) {
            d.setDate(d.getDate() - 1);
            ++dayOfYear;
        }
        while (dayOfYear > 0) {
            d.setDate(d.getDate() + 1);
            --dayOfYear;
        }
        return d;
    }

    static String monthName(int year, int month) {
        return DateTimeFormat.getFormat((String)"MMMM yyyy").format(SingleDateSelector.toDate(year, month, 1));
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Date getValue() {
        try {
            return this.iFormat.parse(this.iPicker.getText());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setValue(Date value) {
        this.setValue(value, false);
    }

    public void setValue(Date value, boolean fireEvents) {
        if (value == null) {
            this.iPicker.setText("");
            this.iMonth.setValue(null);
        } else {
            this.iPicker.setText(this.iFormat.format(value));
            this.iMonth.setValue(value);
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public void setValueInServerTimeZone(Date value) {
        this.setValue(ServerDateTimeFormat.toLocalDate(value));
    }

    public Date getValueInServerTimeZone() {
        return ServerDateTimeFormat.toServerDate(this.getValue());
    }

    @Override
    public void setText(String text) {
        if (text == null || text.isEmpty()) {
            this.setValue(null);
        } else {
            try {
                this.setValue(this.iFormat.parse(text));
            }
            catch (IllegalArgumentException e) {
                this.setValue(this.iDefaultFormat.parse(text));
            }
        }
    }

    @Override
    public String getText() {
        return this.iPicker.getText();
    }

    public Date today() {
        return this.iFormat.parse(this.iFormat.format(new Date()));
    }

    public static SingleDateSelector insert(RootPanel panel) {
        String format = panel.getElement().getAttribute("format");
        final String onchange = panel.getElement().getAttribute("onchange");
        String error = panel.getElement().getAttribute("error");
        String disabled = panel.getElement().getAttribute("disabled");
        AriaTextBox text = new AriaTextBox(panel.getElement().getFirstChildElement());
        SingleDateSelector selector = new SingleDateSelector(text, null, false);
        selector.iFormat = format != null && !format.isEmpty() ? DateTimeFormat.getFormat((String)format) : DateTimeFormat.getFormat((String)CONSTANTS.dateEntryFormat());
        if (onchange != null) {
            panel.getElement().removeAttribute("onchange");
            selector.addValueChangeHandler(new ValueChangeHandler<Date>(){

                public void onValueChange(ValueChangeEvent<Date> event) {
                    ToolBox.eval(onchange);
                }
            });
        }
        if (text.getText() != null && !text.getText().isEmpty()) {
            Date date = null;
            try {
                date = selector.iFormat.parse(text.getText());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (date != null) {
                selector.setValue(date);
            }
        }
        if (error != null && !error.isEmpty()) {
            selector.setErrorHint(error);
        }
        if (disabled != null && "true".equalsIgnoreCase(disabled)) {
            selector.setEnabled(false);
        }
        panel.add((Widget)selector);
        return selector;
    }

    public void setFormat(DateTimeFormat format) {
        this.iFormat = format;
        if (this.iHint) {
            this.setHint(this.iFormat.getPattern().toUpperCase());
        }
    }

    public String getFormat() {
        return this.iFormat.getPattern();
    }

    public boolean isEnabled() {
        return this.iPicker.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.iPicker.setEnabled(enabled);
    }

    public boolean isPopupShowing() {
        return this.iPopup.isShowing();
    }

    public static class SingleMonth
    extends AbsolutePanel
    implements HasValue<Date> {
        List<D> iDays = new ArrayList<D>();
        int iYear;
        int iMonth;
        int iDay;
        String iTitle = null;
        List<EventInterface.SessionMonth> iMonths = null;
        private boolean iAllowDeselect;
        private Date iFirstDate = null;
        private Date iLastDate = null;

        public SingleMonth() {
            this(null, Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(new Date())), Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(new Date())), 0);
        }

        public SingleMonth(String title) {
            this(title, Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(new Date())), Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(new Date())), 0);
        }

        public SingleMonth(Date date) {
            this(null, Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date)), Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date)), Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date)));
        }

        public SingleMonth(String title, int year, int month, int day) {
            this.iTitle = title;
            this.iYear = year;
            this.iMonth = month;
            this.iDay = day;
            this.init();
        }

        public boolean isAllowDeselect() {
            return this.iAllowDeselect;
        }

        public void setAllowDeselect(boolean allowDeselect) {
            this.iAllowDeselect = allowDeselect;
        }

        public void setMonths(List<EventInterface.SessionMonth> months) {
            this.iMonths = months;
            this.init();
        }

        public List<EventInterface.SessionMonth> getMonths() {
            return this.iMonths;
        }

        public void setFirstDate(Date firstDate) {
            this.iFirstDate = firstDate;
            this.init();
        }

        public void setLastDate(Date lastDate) {
            this.iLastDate = lastDate;
            this.init();
        }

        protected void init() {
            P box;
            this.clear();
            this.iDays.clear();
            EventInterface.SessionMonth sessionMonth = null;
            boolean hasPrev = false;
            boolean hasNext = false;
            if (this.iMonths != null && !this.iMonths.isEmpty()) {
                for (int i = 0; i < this.iMonths.size(); ++i) {
                    EventInterface.SessionMonth m = this.iMonths.get(i);
                    if (m.getMonth() + 1 != this.iMonth || m.getYear() != this.iYear) continue;
                    sessionMonth = m;
                    if (i > 0) {
                        hasPrev = true;
                    }
                    if (i + 1 >= this.iMonths.size()) continue;
                    hasNext = true;
                }
                if (sessionMonth == null) {
                    if (this.iYear < this.iMonths.get(0).getYear() || this.iYear == this.iMonths.get(0).getYear() && this.iMonth <= this.iMonths.get(0).getMonth()) {
                        sessionMonth = this.iMonths.get(0);
                        this.iYear = sessionMonth.getYear();
                        this.iMonth = sessionMonth.getMonth() + 1;
                        hasPrev = false;
                        boolean bl = hasNext = this.iMonths.size() > 1;
                        if (this.iDay > 0) {
                            this.iDay = 1;
                        }
                    } else {
                        sessionMonth = this.iMonths.get(this.iMonths.size() - 1);
                        this.iYear = sessionMonth.getYear();
                        this.iMonth = sessionMonth.getMonth() + 1;
                        hasPrev = this.iMonths.size() > 1;
                        hasNext = false;
                        if (this.iDay > 0) {
                            this.iDay = SingleDateSelector.daysInMonth(this.iYear, this.iMonth);
                        }
                    }
                }
            }
            if (sessionMonth != null && this.iDay >= 0) {
                while (this.iDay > 0 && sessionMonth.hasFlag(this.iDay - 1, EventInterface.SessionMonth.Flag.DISABLED)) {
                    --this.iDay;
                }
                if (this.iDay == 0) {
                    this.iDay = 1;
                    while (this.iDay <= SingleDateSelector.daysInMonth(this.iYear, this.iMonth) && sessionMonth.hasFlag(this.iDay - 1, EventInterface.SessionMonth.Flag.DISABLED)) {
                        ++this.iDay;
                    }
                    if (this.iDay > SingleDateSelector.daysInMonth(this.iYear, this.iMonth)) {
                        this.iDay = 0;
                    }
                }
            }
            int firstDayOfWeek = SingleDateSelector.firstDayOfWeek(this.iYear, this.iMonth);
            int nrDays = SingleDateSelector.daysInMonth(this.iYear, this.iMonth);
            int firstWeekNumber = SingleDateSelector.weekNumber(this.iYear, this.iMonth);
            this.addStyleName("month");
            if (this.iTitle != null) {
                box = new P(null, "box");
                this.add((Widget)box);
                P row = new P(null, "row");
                box.add((Widget)row);
                row.add((Widget)new P(this.iTitle, "command"));
            }
            box = new P(null, "box");
            this.add((Widget)box);
            P top = new P(null, "row");
            if (sessionMonth == null) {
                P py = new P("&laquo;", "cell", "left", "clickable");
                py.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        this.addMonths(-12);
                    }
                });
                top.add((Widget)py);
                P pm = new P("&lsaquo;", "cell", "left", "clickable");
                top.add((Widget)pm);
                pm.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        this.addMonths(-1);
                    }
                });
                P m = new P(SingleDateSelector.monthName(this.iYear, this.iMonth), "cell", "label", "middle", "clickable");
                m.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        this.setDate(new Date());
                    }
                });
                top.add((Widget)m);
                P nm = new P("&rsaquo;", "cell", "right", "clickable");
                nm.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        this.addMonths(1);
                    }
                });
                top.add((Widget)nm);
                P ny = new P("&raquo;", "cell", "right", "clickable");
                ny.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        this.addMonths(12);
                    }
                });
                top.add((Widget)ny);
            } else {
                top.add((Widget)new P(null, "cell", "left"));
                if (hasPrev) {
                    P pm = new P("&lsaquo;", "cell", "left", "clickable");
                    top.add((Widget)pm);
                    pm.addMouseDownHandler(new MouseDownHandler(){

                        public void onMouseDown(MouseDownEvent event) {
                            this.addMonths(-1);
                        }
                    });
                } else {
                    top.add((Widget)new P(null, "cell", "left"));
                }
                P m = new P(SingleDateSelector.monthName(this.iYear, this.iMonth), "cell", "label", "middle", "clickable");
                m.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        this.setDate(new Date());
                    }
                });
                top.add((Widget)m);
                if (hasNext) {
                    P nm = new P("&rsaquo;", "cell", "right", "clickable");
                    nm.addMouseDownHandler(new MouseDownHandler(){

                        public void onMouseDown(MouseDownEvent event) {
                            this.addMonths(1);
                        }
                    });
                    top.add((Widget)nm);
                } else {
                    top.add((Widget)new P(null, "cell", "right"));
                }
                top.add((Widget)new P(null, "cell", "right"));
            }
            box.add((Widget)top);
            box = new P(null, "box");
            this.add((Widget)box);
            P header = new P(null, "row");
            box.add((Widget)header);
            P corner = new P(null, "cell", "corner");
            header.add((Widget)corner);
            for (int i = 0; i < 7; ++i) {
                header.add((Widget)new P(CONSTANTS.days()[(i + SingleDateSelector.startingDayOfWeek()) % 7], "cell", "dow"));
            }
            int weekNumber = firstWeekNumber;
            P line = new P(null, "row");
            box.add((Widget)line);
            P week = new P(String.valueOf(weekNumber++), "cell", "week");
            line.add((Widget)week);
            int idx = 0;
            int blanks = (firstDayOfWeek + 7 - SingleDateSelector.startingDayOfWeek()) % 7;
            for (int i = 0; i < blanks; ++i) {
                line.add((Widget)new P(null, "cell", i + 1 == blanks ? "last-blank" : "blank"));
                ++idx;
            }
            MouseDownHandler onClick = new MouseDownHandler(){

                public void onMouseDown(MouseDownEvent event) {
                    if (iDay == ((D)((Object)event.getSource())).getNumber() && iAllowDeselect) {
                        D old;
                        D d = old = iDay <= 0 || iDay > iDays.size() ? null : iDays.get(iDay - 1);
                        if (old != null) {
                            old.removeStyleName("selected");
                        }
                        iDay = 0;
                        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
                    } else {
                        D old;
                        D d = old = iDay <= 0 || iDay > iDays.size() ? null : iDays.get(iDay - 1);
                        if (old != null) {
                            old.removeStyleName("selected");
                        }
                        iDay = ((D)((Object)event.getSource())).getNumber();
                        iDays.get(iDay - 1).addStyleName("selected");
                        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
                    }
                }
            };
            int today = -1;
            if (this.iYear == Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(new Date())) && this.iMonth == Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(new Date()))) {
                today = Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(new Date()));
            }
            for (int i = 1; i <= nrDays; ++i) {
                if (i > 1 && idx % 7 == 0) {
                    if (idx == 7 && this.iMonth == 1 && weekNumber > 50) {
                        weekNumber = 1;
                    }
                    line = new P(null, "row");
                    box.add((Widget)line);
                    week = new P(String.valueOf(weekNumber++), "cell", "week");
                    line.add((Widget)week);
                }
                D d = new D(i, "cell", SingleDateSelector.isWeekend((idx + SingleDateSelector.startingDayOfWeek()) % 7) ? "weekend" : "day", "clickable", this.iDay == i ? "selected" : null);
                line.add((Widget)d);
                this.iDays.add(d);
                ++idx;
                boolean enabled = true;
                if (i == today) {
                    d.addStyleName("today");
                }
                if (sessionMonth != null) {
                    if (sessionMonth.hasFlag(i - 1, EventInterface.SessionMonth.Flag.START)) {
                        d.addStyleName("start");
                    } else if (sessionMonth.hasFlag(i - 1, EventInterface.SessionMonth.Flag.END)) {
                        d.addStyleName("start");
                    } else if (sessionMonth.hasFlag(i - 1, EventInterface.SessionMonth.Flag.FINALS)) {
                        d.addStyleName("exam");
                    } else if (sessionMonth.hasFlag(i - 1, EventInterface.SessionMonth.Flag.MIDTERMS)) {
                        d.addStyleName("midterm");
                    } else if (sessionMonth.hasFlag(i - 1, EventInterface.SessionMonth.Flag.HOLIDAY)) {
                        d.addStyleName("holiday");
                    } else if (sessionMonth.hasFlag(i - 1, EventInterface.SessionMonth.Flag.BREAK)) {
                        d.addStyleName("break");
                    }
                    if (sessionMonth.hasFlag(i - 1, EventInterface.SessionMonth.Flag.DISABLED)) {
                        d.removeStyleName("clickable");
                        d.addStyleName("disabled");
                        enabled = false;
                    }
                }
                if (enabled && this.iFirstDate != null && DateTimeFormat.getFormat((String)"yyyy/MM/dd").parse(this.iYear + "/" + this.iMonth + "/" + i).before(this.iFirstDate)) {
                    d.removeStyleName("clickable");
                    d.addStyleName("disabled");
                    enabled = false;
                }
                if (enabled && this.iLastDate != null && DateTimeFormat.getFormat((String)"yyyy/MM/dd").parse(this.iYear + "/" + this.iMonth + "/" + i).after(this.iLastDate)) {
                    d.removeStyleName("clickable");
                    d.addStyleName("disabled");
                    enabled = false;
                }
                if (!enabled) continue;
                d.addMouseDownHandler(onClick);
            }
        }

        public void addMonths(int months) {
            this.iMonth += months;
            if (this.iMonth <= 0) {
                --this.iYear;
                this.iMonth += 12;
            }
            if (this.iMonth > 12) {
                ++this.iYear;
                this.iMonth -= 12;
            }
            this.init();
        }

        public void addDays(int days) {
            Date d = this.getValue();
            if (d == null) {
                this.setDate(new Date());
            } else {
                d.setDate(d.getDate() + days);
                this.setDate(d);
            }
        }

        public void clearSelection() {
            D old;
            D d = old = this.iDay <= 0 || this.iDay > this.iDays.size() ? null : this.iDays.get(this.iDay - 1);
            if (old != null) {
                old.removeStyleName("selected");
                this.iDay = 0;
            }
        }

        public void setDate(Date date) {
            this.iYear = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
            this.iMonth = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date));
            this.iDay = Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date));
            this.init();
        }

        public void setDate(int year, int month, int day) {
            this.iYear = year;
            this.iMonth = month;
            this.iDay = day;
            this.init();
        }

        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
            return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
        }

        public Date getValue() {
            if (this.iDay <= 0 || this.iDay > this.iDays.size()) {
                return null;
            }
            return DateTimeFormat.getFormat((String)"yyyy/MM/dd").parse(this.iYear + "/" + this.iMonth + "/" + this.iDay);
        }

        public void setValue(Date value) {
            this.setValue(value, false);
        }

        public void setValue(Date value, boolean fireEvents) {
            this.iYear = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(value == null ? new Date() : value));
            this.iMonth = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(value == null ? new Date() : value));
            this.iDay = value == null ? 0 : Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(value));
            this.init();
            if (fireEvents) {
                ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
            }
        }

        public String toString() {
            return this.getValue() == null ? "" : DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat()).format(this.getValue());
        }

        public String getCalendarTitle() {
            return this.iTitle;
        }
    }

    public static class D
    extends AbsolutePanel
    implements HasMouseDownHandlers {
        private int iNumber;

        private D(int number, String ... styles) {
            this.iNumber = number;
            this.getElement().setInnerHTML(String.valueOf(number));
            for (String style : styles) {
                if (style == null || style.isEmpty()) continue;
                this.addStyleName(style);
            }
            this.sinkEvents(4);
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 4: {
                    MouseDownEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this);
                    event.stopPropagation();
                    event.preventDefault();
                }
            }
        }

        public int getNumber() {
            return this.iNumber;
        }

        public String toString() {
            return String.valueOf(1 + this.getNumber());
        }

        public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)MouseDownEvent.getType());
        }
    }

    public static class P
    extends AbsolutePanel
    implements HasMouseDownHandlers {
        private String iCaption;

        private P(String caption, String ... styles) {
            this.iCaption = caption;
            if (caption != null) {
                this.getElement().setInnerHTML(caption);
            }
            for (String style : styles) {
                if (style == null || style.isEmpty()) continue;
                this.addStyleName(style);
            }
            this.sinkEvents(4);
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 4: {
                    MouseDownEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this);
                    event.stopPropagation();
                    event.preventDefault();
                }
            }
        }

        public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)MouseDownEvent.getType());
        }

        public String getCaption() {
            return this.iCaption;
        }
    }
}

