/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.ComboBoxLookup;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.timegrid.ExamGridTable;

public class ExamGridForm
implements UniTimeForm {
    private static final long serialVersionUID = 1429431006186003906L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private Long iSessionId;
    private Map<String, TreeSet> iPeriods = new HashMap<String, TreeSet>();
    private int iSessionBeginWeek;
    private Date iSessionBeginDate;
    private Date iExamBeginDate;
    private boolean iShowSections = false;
    private String iOp = null;
    private Long iExamType;
    private Map<String, Integer> iDate = new HashMap<String, Integer>();
    private Map<String, Integer> iStartTime = new HashMap<String, Integer>();
    private Map<String, Integer> iEndTime = new HashMap<String, Integer>();
    private int iResource = ExamGridTable.Resource.Room.ordinal();
    private int iBackground = ExamGridTable.Background.None.ordinal();
    private String iFilter = null;
    private int iDispMode = ExamGridTable.DispMode.PerWeekVertical.ordinal();
    private int iOrder = ExamGridTable.OrderBy.NameAsc.ordinal();
    private boolean iBgPreferences = false;

    public int getDate(String examType) {
        return this.iDate.get(examType);
    }

    public void setDate(String examType, int date) {
        this.iDate.put(examType, date);
    }

    public boolean isAllDates(String examType) {
        return this.iDate.get(examType) == Integer.MIN_VALUE;
    }

    public int getStartTime(String examType) {
        return this.iStartTime.get(examType);
    }

    public void setStartTime(String examType, int startTime) {
        this.iStartTime.put(examType, startTime);
    }

    public int getEndTime(String examType) {
        return this.iEndTime.get(examType);
    }

    public void setEndTime(String examType, int endTime) {
        this.iEndTime.put(examType, endTime);
    }

    public int getResource() {
        return this.iResource;
    }

    public void setResource(int resource) {
        this.iResource = resource;
    }

    public int getBackground() {
        return this.iBackground;
    }

    public void setBackground(int background) {
        this.iBackground = background;
    }

    public String getFilter() {
        return this.iFilter;
    }

    public void setFilter(String filter) {
        this.iFilter = filter;
    }

    public int getDispMode() {
        return this.iDispMode;
    }

    public void setDispMode(int dispMode) {
        this.iDispMode = dispMode;
    }

    public int getOrder() {
        return this.iOrder;
    }

    public void setOrder(int order) {
        this.iOrder = order;
    }

    public boolean getBgPreferences() {
        return this.iBgPreferences;
    }

    public void setBgPreferences(boolean bgPreferences) {
        this.iBgPreferences = bgPreferences;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    @Override
    public void reset() {
        this.iDate.clear();
        this.iStartTime.clear();
        this.iEndTime.clear();
        this.iResource = ExamGridTable.Resource.Room.ordinal();
        this.iBackground = ExamGridTable.Background.None.ordinal();
        this.iFilter = null;
        this.iDispMode = ExamGridTable.DispMode.PerWeekVertical.ordinal();
        this.iOrder = ExamGridTable.OrderBy.NameAsc.ordinal();
        this.iBgPreferences = false;
        this.iOp = null;
        this.iShowSections = false;
        this.iExamType = null;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public Date getExamBeginDate() {
        return this.iExamBeginDate;
    }

    public TreeSet getPeriods(String examType) {
        return this.iPeriods.get(examType);
    }

    public void load(SessionContext context) throws Exception {
        Session session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
        this.iSessionId = session.getUniqueId();
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(session.getSessionBeginDateTime());
        this.iSessionBeginWeek = cal.get(3);
        this.iSessionBeginDate = session.getSessionBeginDateTime();
        this.iExamBeginDate = session.getExamBeginDate();
        this.iPeriods.clear();
        for (ExamType type : ExamType.findAllUsedApplicable(context.getUser(), DepartmentStatusType.Status.ExamTimetable)) {
            this.iPeriods.put(type.getUniqueId().toString(), ExamPeriod.findAll(session.getUniqueId(), type.getUniqueId()));
            this.setDate(type.getUniqueId().toString(), Integer.parseInt(context.getUser().getProperty("ExamGrid.date." + type.getUniqueId(), String.valueOf(Integer.MIN_VALUE))));
            this.setStartTime(type.getUniqueId().toString(), Integer.parseInt(context.getUser().getProperty("ExamGrid.start." + type.getUniqueId(), String.valueOf(this.getFirstStart(type.getUniqueId().toString())))));
            this.setEndTime(type.getUniqueId().toString(), Integer.parseInt(context.getUser().getProperty("ExamGrid.end." + type.getUniqueId(), String.valueOf(this.getLastEnd(type.getUniqueId().toString())))));
        }
        this.setResource(Integer.parseInt(context.getUser().getProperty("ExamGrid.resource", String.valueOf(ExamGridTable.Resource.Room.ordinal()))));
        this.setBackground(Integer.parseInt(context.getUser().getProperty("ExamGrid.background", String.valueOf(ExamGridTable.Background.None.ordinal()))));
        this.setFilter(context.getUser().getProperty("ExamGrid.filter"));
        this.setDispMode(Integer.parseInt(context.getUser().getProperty("ExamGrid.dispMode", String.valueOf(ExamGridTable.DispMode.PerWeekVertical.ordinal()))));
        this.setOrder(Integer.parseInt(context.getUser().getProperty("ExamGrid.order", String.valueOf(ExamGridTable.OrderBy.NameAsc.ordinal()))));
        this.setBgPreferences("1".equals(context.getUser().getProperty("ExamGrid.bgPref", "0")));
        this.setExamType(context.getAttribute("Exam.Type") == null ? this.iExamType : (Long)context.getAttribute("Exam.Type"));
        this.setShowSections("1".equals(context.getUser().getProperty("ExamReport.showSections", "1")));
    }

    public void save(SessionContext context) throws Exception {
        for (ExamType type : ExamType.findAllUsedApplicable(context.getUser(), DepartmentStatusType.Status.ExamTimetable)) {
            context.getUser().setProperty("ExamGrid.date." + type.getUniqueId(), String.valueOf(this.getDate(type.getUniqueId().toString())));
            context.getUser().setProperty("ExamGrid.start." + type.getUniqueId(), String.valueOf(this.getStartTime(type.getUniqueId().toString())));
            context.getUser().setProperty("ExamGrid.end." + type.getUniqueId(), String.valueOf(this.getEndTime(type.getUniqueId().toString())));
        }
        context.getUser().setProperty("ExamGrid.resource", String.valueOf(this.getResource()));
        context.getUser().setProperty("ExamGrid.background", String.valueOf(this.getBackground()));
        context.getUser().setProperty("ExamGrid.filter", String.valueOf(this.getFilter()));
        context.getUser().setProperty("ExamGrid.dispMode", String.valueOf(this.getDispMode()));
        context.getUser().setProperty("ExamGrid.order", String.valueOf(this.getOrder()));
        context.getUser().setProperty("ExamGrid.bgPref", this.getBgPreferences() ? "1" : "0");
        context.setAttribute(SessionAttribute.ExamType, (Object)this.getExamType());
        context.getUser().setProperty("ExamReport.showSections", this.getShowSections() ? "1" : "0");
    }

    public Vector<ComboBoxLookup> getDates(String examType) {
        Vector<ComboBoxLookup> ret = new Vector<ComboBoxLookup>();
        ret.addElement(new ComboBoxLookup(MSG.itemAllDates(), String.valueOf(Integer.MIN_VALUE)));
        HashSet<Integer> added = new HashSet<Integer>();
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
        for (ExamPeriod period : this.iPeriods.get(examType)) {
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.setTime(period.getStartDate());
            int week = 1;
            while (cal.getTime().after(this.iSessionBeginDate) && cal.get(3) != this.iSessionBeginWeek) {
                cal.add(6, -7);
                ++week;
            }
            while (cal.getTime().before(this.iSessionBeginDate) && cal.get(3) != this.iSessionBeginWeek) {
                cal.add(7, 7);
                --week;
            }
            cal.setTime(period.getStartDate());
            if (!added.add(1000 + week)) continue;
            while (cal.get(7) != 1) {
                cal.add(6, -1);
            }
            String first = df.format(cal.getTime());
            while (cal.get(7) != 7) {
                cal.add(6, 1);
            }
            String end = df.format(cal.getTime());
            ret.addElement(new ComboBoxLookup(MSG.itemWeek(week, first, end), String.valueOf(1000 + week)));
        }
        for (ExamPeriod period : this.iPeriods.get(examType)) {
            if (!added.add(period.getDateOffset())) continue;
            ret.addElement(new ComboBoxLookup(ExamGridTable.sDF.format(period.getStartDate()), period.getDateOffset().toString()));
        }
        return ret;
    }

    public int getFirstDate(String examType) {
        int startDate = Integer.MAX_VALUE;
        for (ExamPeriod period : this.iPeriods.get(examType)) {
            startDate = Math.min(startDate, period.getDateOffset());
        }
        return startDate;
    }

    public int getLastDate(String examType) {
        int endDate = Integer.MIN_VALUE;
        for (ExamPeriod period : this.iPeriods.get(examType)) {
            endDate = Math.max(endDate, period.getDateOffset());
        }
        return endDate;
    }

    public int getFirstStart(String examType) {
        int startSlot = -1;
        for (ExamPeriod period : this.iPeriods.get(examType)) {
            if (startSlot < 0) {
                startSlot = period.getStartSlot();
                continue;
            }
            startSlot = Math.min(startSlot, period.getStartSlot());
        }
        return startSlot;
    }

    public int getLastEnd(String examType) {
        int endSlot = -1;
        for (ExamPeriod period : this.iPeriods.get(examType)) {
            if (endSlot < 0) {
                endSlot = period.getEndSlot();
                continue;
            }
            endSlot = Math.max(endSlot, period.getEndSlot());
        }
        return endSlot;
    }

    public Vector<ComboBoxLookup> getStartTimes(String examType) {
        Vector<ComboBoxLookup> ret = new Vector<ComboBoxLookup>();
        HashSet<Integer> added = new HashSet<Integer>();
        for (ExamPeriod period : this.iPeriods.get(examType)) {
            if (!added.add(period.getStartSlot())) continue;
            ret.addElement(new ComboBoxLookup(period.getStartTimeLabel(), period.getStartSlot().toString()));
        }
        return ret;
    }

    public Vector<ComboBoxLookup> getEndTimes(String examType) {
        Vector<ComboBoxLookup> ret = new Vector<ComboBoxLookup>();
        HashSet<Integer> added = new HashSet<Integer>();
        for (ExamPeriod period : this.iPeriods.get(examType)) {
            if (!added.add(period.getEndSlot())) continue;
            ret.addElement(new ComboBoxLookup(period.getEndTimeLabel(), String.valueOf(period.getEndSlot())));
        }
        return ret;
    }

    public Vector<ComboBoxLookup> getResources() {
        Vector<ComboBoxLookup> ret = new Vector<ComboBoxLookup>();
        for (ExamGridTable.Resource r : ExamGridTable.Resource.values()) {
            ret.addElement(new ComboBoxLookup(r.getLabel(), String.valueOf(r.ordinal())));
        }
        return ret;
    }

    public Vector<ComboBoxLookup> getBackgrounds() {
        Vector<ComboBoxLookup> ret = new Vector<ComboBoxLookup>();
        for (ExamGridTable.Background b : ExamGridTable.Background.values()) {
            ret.addElement(new ComboBoxLookup(b.getLabel(), String.valueOf(b.ordinal())));
        }
        return ret;
    }

    public Vector<ComboBoxLookup> getDispModes() {
        Vector<ComboBoxLookup> ret = new Vector<ComboBoxLookup>();
        for (ExamGridTable.DispMode m : ExamGridTable.DispMode.values()) {
            ret.addElement(new ComboBoxLookup(m.getLabel(), String.valueOf(m.ordinal())));
        }
        return ret;
    }

    public Vector<ComboBoxLookup> getOrders() {
        Vector<ComboBoxLookup> ret = new Vector<ComboBoxLookup>();
        for (ExamGridTable.OrderBy o : ExamGridTable.OrderBy.values()) {
            ret.addElement(new ComboBoxLookup(o.getLabel(), String.valueOf(o.ordinal())));
        }
        return ret;
    }

    public Long getExamType() {
        return this.iExamType;
    }

    public void setExamType(Long type) {
        this.iExamType = type;
    }

    public int getSessionBeginWeek() {
        return this.iSessionBeginWeek;
    }

    public Date getSessionBeginDate() {
        return this.iSessionBeginDate;
    }

    public boolean getShowSections() {
        return this.iShowSections;
    }

    public void setShowSections(boolean showSections) {
        this.iShowSections = showSections;
    }

    @Override
    public void validate(UniTimeAction action) {
    }
}

