/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;

public class SubjectAreaImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("subjectAreas")) {
            throw new Exception("Given XML file is not a SubjectArea load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            String created = root.attributeValue("created");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            if (created != null) {
                ChangeLog.addChange(this.getHibSession(), this.getManager(), session, session, created, ChangeLog.Source.DATA_IMPORT_SUBJECT_AREAS, ChangeLog.Operation.UPDATE, null, null);
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String externalId = element.attributeValue("externalId");
                SubjectArea subjectArea = null;
                if (externalId != null && externalId.length() > 0) {
                    subjectArea = this.findByExternalId(externalId, session.getSessionId());
                }
                if (subjectArea == null) {
                    subjectArea = new SubjectArea();
                    subjectArea.setSession(session);
                } else if ("T".equalsIgnoreCase(element.attributeValue("delete"))) {
                    this.getHibSession().remove((Object)subjectArea);
                    continue;
                }
                subjectArea.setSubjectAreaAbbreviation(element.attributeValue("abbreviation"));
                subjectArea.setTitle(element.attributeValue("title", element.attributeValue("longTitle")));
                subjectArea.setExternalUniqueId(externalId);
                String deptCode = element.attributeValue("department");
                Department department = this.findByDeptCode(deptCode, session.getSessionId());
                if (department == null) {
                    throw new Exception("No department found for " + deptCode);
                }
                subjectArea.setDepartment(department);
                String fundingDeptCode = element.attributeValue("fundingDepartment");
                if (fundingDeptCode != null) {
                    Department fundingDepartment = this.findByDeptCode(fundingDeptCode, session.getSessionId());
                    subjectArea.setFundingDept(fundingDepartment);
                } else {
                    subjectArea.setFundingDept(null);
                }
                if (subjectArea.getUniqueId() == null) {
                    this.getHibSession().persist((Object)subjectArea);
                } else {
                    this.getHibSession().merge((Object)subjectArea);
                }
                this.flushIfNeeded(false);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    private SubjectArea findByExternalId(String externalId, Long sessionId) {
        return (SubjectArea)this.getHibSession().createQuery("select distinct a from SubjectArea as a where a.externalUniqueId=:externalId and a.session.uniqueId=:sessionId", SubjectArea.class).setParameter("sessionId", (Object)sessionId).setParameter("externalId", (Object)externalId).setCacheable(true).uniqueResult();
    }

    private Department findByDeptCode(String deptCode, Long sessionId) {
        return (Department)this.getHibSession().createQuery("select distinct a from Department as a where a.deptCode=:deptCode and a.session.uniqueId=:sessionId", Department.class).setParameter("sessionId", (Object)sessionId).setParameter("deptCode", (Object)deptCode).setCacheable(true).uniqueResult();
    }
}

