/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.util.List;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.DB2LegacyDialect;
import org.hibernate.community.dialect.DB2zLegacySqlAstTranslator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.DB2390IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.FetchLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.DB2zSequenceSupport;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.AlterTableUniqueIndexDelegate;
import org.hibernate.dialect.unique.SkipNullableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2zLegacyDialect
extends DB2LegacyDialect {
    static final DatabaseVersion DB2_LUW_VERSION9 = DatabaseVersion.make((Integer)9, (Integer)0);
    private static final DatabaseVersion DEFAULT_VERSION = DatabaseVersion.make((Integer)7);

    public DB2zLegacyDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(DEFAULT_VERSION));
        this.registerKeywords(info);
    }

    public DB2zLegacyDialect() {
        this(DEFAULT_VERSION);
    }

    public DB2zLegacyDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        if (this.getVersion().isSameOrAfter(12)) {
            CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
            functionFactory.listagg(null);
            functionFactory.inverseDistributionOrderedSetAggregates();
            functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        }
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        if (this.getVersion().isAfter(10)) {
            switch (sqlTypeCode) {
                case 2013: 
                case 2014: {
                    return "timestamp with time zone";
                }
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    public DatabaseVersion getDB2Version() {
        return DB2_LUW_VERSION9;
    }

    @Override
    protected UniqueDelegate createUniqueDelegate() {
        return this.getVersion().isSameOrAfter(11) ? new AlterTableUniqueIndexDelegate((Dialect)this) : new SkipNullableUniqueDelegate((Dialect)this);
    }

    public String getCreateIndexString(boolean unique) {
        return unique ? "create unique where not null index" : "create index";
    }

    @Override
    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        return "";
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return this.getVersion().isAfter(10) ? TimeZoneSupport.NATIVE : TimeZoneSupport.NONE;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion().isBefore(8) ? NoSequenceSupport.INSTANCE : DB2zSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getVersion().isBefore(8) ? null : "select * from sysibm.syssequences";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.getVersion().isBefore(12) ? FetchLimitHandler.INSTANCE : OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return DB2390IdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsSkipLocked() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return this.getVersion().isSameOrAfter(11);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("add_");
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("second");
                break;
            }
            case WEEK: {
                pattern.append("day");
                break;
            }
            case QUARTER: {
                pattern.append("month");
                break;
            }
            default: {
                pattern.append("?1");
            }
        }
        pattern.append("s(");
        String timestampExpression = unit.isDateUnit() ? (temporalType == TemporalType.TIME ? "timestamp('1970-01-01',?3)" : "?3") : (temporalType == TemporalType.DATE ? "cast(?3 as timestamp)" : "?3");
        pattern.append(timestampExpression);
        pattern.append(",");
        switch (unit) {
            case NANOSECOND: {
                pattern.append("(?2)/1e9");
                break;
            }
            case WEEK: {
                pattern.append("(?2)*7");
                break;
            }
            case QUARTER: {
                pattern.append("(?2)*3");
                break;
            }
            default: {
                pattern.append("?2");
            }
        }
        pattern.append(")");
        return pattern.toString();
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DB2zLegacySqlAstTranslator(sessionFactory, statement, DB2zLegacyDialect.this.getVersion());
            }
        };
    }

    @Override
    public String rowId(String rowId) {
        return rowId == null || rowId.isEmpty() ? "rowid_" : rowId;
    }

    @Override
    public int rowIdSqlType() {
        return -8;
    }

    public String getRowIdColumnString(String rowId) {
        return this.rowId(rowId) + " rowid not null generated always";
    }
}

