/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.BiConsumer;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class EntityAssembler
implements DomainResultAssembler {
    private final JavaType javaType;
    private final EntityInitializer<InitializerData> initializer;

    public EntityAssembler(JavaType javaType, EntityInitializer<?> initializer) {
        this.javaType = javaType;
        this.initializer = initializer;
    }

    public JavaType getAssembledJavaType() {
        return this.javaType;
    }

    public Object assemble(RowProcessingState rowProcessingState) {
        Object data = this.initializer.getData(rowProcessingState);
        Initializer.State state = ((InitializerData)data).getState();
        if (state == Initializer.State.KEY_RESOLVED) {
            this.initializer.resolveInstance((InitializerData)data);
        }
        return this.initializer.getResolvedInstance((InitializerData)data);
    }

    @Override
    public void resolveState(RowProcessingState rowProcessingState) {
        this.initializer.resolveState(rowProcessingState);
    }

    public EntityInitializer<?> getInitializer() {
        return this.initializer;
    }

    public void forEachResultAssembler(BiConsumer consumer, Object arg) {
        if (this.initializer.isResultInitializer()) {
            consumer.accept(this.initializer, arg);
        }
    }
}

