/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.IdGenerator;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.base.BaseReservation;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;

public class StudentGroupCourseDemands
implements StudentCourseDemands,
StudentCourseDemands.NeedsStudentIdGenerator {
    protected org.hibernate.Session iHibSession;
    protected Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> iGroupDemands = new Hashtable();
    protected Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iGroupRequests = new Hashtable();
    protected Long iSessionId = null;
    protected IdGenerator iLastStudentId = null;
    protected boolean iIncludeRealStudents = true;

    public StudentGroupCourseDemands(DataProperties properties) {
    }

    @Override
    public boolean isMakingUpStudents() {
        return true;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return false;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        this.iHibSession = hibSession;
        this.iSessionId = session.getUniqueId();
    }

    protected Set<StudentCourseDemands.WeightedStudentId> load(StudentGroup g) {
        HashSet<StudentCourseDemands.WeightedStudentId> demands = new HashSet<StudentCourseDemands.WeightedStudentId>();
        this.iGroupDemands.put(g.getUniqueId(), demands);
        List reservations = this.iHibSession.createQuery("from StudentGroupReservation r where r.group.uniqueId = :groupId", StudentGroupReservation.class).setParameter("groupId", (Object)g.getUniqueId()).setCacheable(true).list();
        int realStudents = g.getStudents().size();
        int madeupStudents = 0;
        if (g.getExpectedSize() != null && 2 * realStudents < g.getExpectedSize()) {
            madeupStudents = g.getExpectedSize() - realStudents;
        }
        if (realStudents + madeupStudents == 0 && !reservations.isEmpty()) {
            for (Object r : reservations) {
                Integer cap;
                if (((BaseReservation)r).getLimit() != null && madeupStudents < ((BaseReservation)r).getLimit()) {
                    madeupStudents = ((BaseReservation)r).getLimit();
                    continue;
                }
                if (((BaseReservation)r).getLimit() != null || (cap = ((Reservation)r).getLimitCap()) == null || madeupStudents >= cap) continue;
                madeupStudents = cap;
            }
        }
        if (realStudents + madeupStudents > 0) {
            float weight = 1.0f;
            if (g.getExpectedSize() != null) {
                weight = g.getExpectedSize().floatValue() / (float)(realStudents + madeupStudents);
            }
            for (Student s : g.getStudents()) {
                StudentCourseDemands.WeightedStudentId ws = new StudentCourseDemands.WeightedStudentId(s);
                ws.setWeight(weight);
                demands.add(ws);
            }
            for (int i = 0; i < madeupStudents; ++i) {
                StudentCourseDemands.WeightedStudentId ws = new StudentCourseDemands.WeightedStudentId(-this.iLastStudentId.newId());
                ws.setWeight(weight);
                ws.getGroups().add(new StudentCourseDemands.Group(g.getUniqueId(), g.getGroupAbbreviation(), g.getType() == null || g.getType().isKeepTogether() != false));
                demands.add(ws);
            }
        }
        for (StudentGroupReservation r : reservations) {
            float weight = 1.0f;
            if (r.getLimit() != null) {
                weight = r.getLimit().floatValue() / (float)(realStudents + madeupStudents);
            } else {
                Integer cap = r.getLimitCap();
                if (cap != null) {
                    weight = cap.floatValue() / (float)(realStudents + madeupStudents);
                }
            }
            StudentCourseDemands.WeightedCourseOffering w = new StudentCourseDemands.WeightedCourseOffering(r.getInstructionalOffering().getControllingCourseOffering(), weight);
            for (StudentCourseDemands.WeightedStudentId s : demands) {
                Set<StudentCourseDemands.WeightedCourseOffering> offerings = this.iGroupRequests.get(s.getStudentId());
                if (offerings == null) {
                    offerings = new HashSet<StudentCourseDemands.WeightedCourseOffering>();
                    this.iGroupRequests.put(s.getStudentId(), offerings);
                }
                offerings.add(w);
            }
        }
        return demands;
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        if (!course.isIsControl().booleanValue()) {
            return null;
        }
        HashSet<StudentCourseDemands.WeightedStudentId> ret = new HashSet<StudentCourseDemands.WeightedStudentId>();
        for (Reservation r : course.getInstructionalOffering().getReservations()) {
            if (!(r instanceof StudentGroupReservation)) continue;
            StudentGroupReservation gr = (StudentGroupReservation)r;
            Set<StudentCourseDemands.WeightedStudentId> demands = this.iGroupDemands.get(gr.getGroup().getUniqueId());
            if (demands == null) {
                demands = this.load(gr.getGroup());
            }
            float weight = 1.0f;
            if (r.getLimit() != null) {
                weight = r.getLimit().floatValue() / (float)demands.size();
            } else {
                Integer cap = r.getLimitCap();
                if (cap != null) {
                    weight = cap.floatValue() / (float)demands.size();
                }
            }
            if (Math.abs(weight - 1.0f) > 0.001f) {
                for (StudentCourseDemands.WeightedStudentId student : demands) {
                    ret.add(new StudentCourseDemands.WeightedStudentId(student, weight));
                }
                continue;
            }
            ret.addAll(demands);
        }
        return ret;
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        return this.iGroupRequests.get(studentId);
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        return null;
    }

    @Override
    public void setStudentIdGenerator(IdGenerator generator) {
        this.iLastStudentId = generator;
    }
}

