/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.script.ScriptExecution;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.util.queue.QueueItem;

@GwtRpcImplements(value=ScriptInterface.GetQueueTableRpcRequest.class)
@GwtRpcLogging(value=GwtRpcLogging.Level.ON_EXCEPTION)
public class GetQueueTableBackend
implements GwtRpcImplementation<ScriptInterface.GetQueueTableRpcRequest, GwtRpcResponseList<ScriptInterface.QueueItemInterface>> {
    @Autowired
    SolverServerService solverServerService;

    @Override
    public GwtRpcResponseList<ScriptInterface.QueueItemInterface> execute(ScriptInterface.GetQueueTableRpcRequest request, SessionContext context) {
        context.checkPermission(Right.Scripts);
        if (request.getDeleteId() != null) {
            this.solverServerService.getQueueProcessor().remove(request.getDeleteId());
        }
        List<QueueItem> queue = this.solverServerService.getQueueProcessor().getItems(null, null, "Script");
        GwtRpcResponseList<ScriptInterface.QueueItemInterface> table = new GwtRpcResponseList<ScriptInterface.QueueItemInterface>();
        Date now = new Date();
        long timeToShow = 3600000L;
        for (QueueItem item : queue) {
            if (item.finished() != null && now.getTime() - item.finished().getTime() > timeToShow) continue;
            table.add(GetQueueTableBackend.convert(item, context));
        }
        return table;
    }

    public static ScriptInterface.QueueItemInterface convert(QueueItem item, SessionContext context) {
        ScriptInterface.QueueItemInterface q = new ScriptInterface.QueueItemInterface();
        q.setId(item.getId());
        q.setHost(item.getHost());
        q.setName(item.name());
        q.setStatus(item.status());
        q.setProgress((String)(item.progress() <= 0.0 || item.progress() >= 1.0 ? "" : String.valueOf(Math.round(100.0 * item.progress())) + "%"));
        q.setOwner(item.getOwnerName());
        q.setSession(item.getSession() == null ? "None" : item.getSession().getLabel());
        q.setCreated(item.created());
        q.setStarted(item.started());
        q.setFinished(item.finished());
        if (item.hasOutput()) {
            q.setOutput(item.getOutputName());
            q.setOutputLink(item.getOutputLink());
        }
        q.setLog(item.log());
        q.setCanDelete(context.hasPermissionAnyAuthority(item.getSessionId(), "Session", Right.Chameleon, new Qualifiable[0]) || context.getUser().getExternalUserId().equals(item.getOwnerId()));
        if (item instanceof ScriptExecution) {
            q.setExecutionRequest(((ScriptExecution)item).getRequest());
        }
        return q;
    }
}

