/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.security.rights.Right;

@Service(value="org.unitime.timetable.export.Exporter:buildings.pdf")
public class ExportBuildingsPDF
implements Exporter {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public String reference() {
        return "buildings.pdf";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        helper.getSessionContext().checkPermission(Right.BuildingExportPdf);
        PDFPrinter out = new PDFPrinter(helper.getOutputStream(), false);
        helper.setup(out.getContentType(), this.reference(), false);
        DecimalFormat df5 = new DecimalFormat("####0.######");
        out.printHeader(MESSAGES.colAbbreviation(), MESSAGES.colName(), MESSAGES.colExternalId(), MESSAGES.colCoordinateX(), MESSAGES.colCoordinateY());
        List<Building> buildings = Building.findAll(helper.getAcademicSessionId());
        String sort = helper.getParameter("sort");
        if (sort != null && !"0".equals(sort)) {
            int sortBy = Integer.valueOf(sort);
            BuildingComparator cmp = null;
            if (sortBy != 0) {
                cmp = sortBy > 0 ? new BuildingComparator(RoomInterface.BuildingsColumn.values()[sortBy - 1], true) : new BuildingComparator(RoomInterface.BuildingsColumn.values()[-1 - sortBy], false);
            }
            if (cmp != null) {
                Collections.sort(buildings, cmp);
            }
        }
        for (Building b : buildings) {
            out.printLine(b.getAbbreviation(), b.getName(), b.getExternalUniqueId() == null ? "" : b.getExternalUniqueId().toString(), b.getCoordinateX() == null ? "" : df5.format(b.getCoordinateX()), b.getCoordinateY() == null ? "" : df5.format(b.getCoordinateY()));
        }
        out.close();
    }

    public static class BuildingComparator
    implements Comparator<Building> {
        private RoomInterface.BuildingsColumn iColumn;
        private boolean iAsc;

        public BuildingComparator(RoomInterface.BuildingsColumn column, boolean asc) {
            this.iColumn = column;
            this.iAsc = asc;
        }

        public int compareById(Building r1, Building r2) {
            return this.compare(r1.getUniqueId(), r2.getUniqueId());
        }

        public int compareByName(Building r1, Building r2) {
            return this.compare(r1.getName(), r2.getName());
        }

        public int compareByAbbreviation(Building r1, Building r2) {
            return this.compare(r1.getAbbreviation(), r2.getAbbreviation());
        }

        public int compareByExternalId(Building r1, Building r2) {
            return this.compare(r1.getExternalUniqueId(), r2.getExternalUniqueId());
        }

        protected int compareByColumn(Building r1, Building r2) {
            switch (this.iColumn) {
                case NAME: {
                    return this.compareByName(r1, r2);
                }
                case ABBREVIATION: {
                    return this.compareByAbbreviation(r1, r2);
                }
                case EXTERNAL_ID: {
                    return this.compareByExternalId(r1, r2);
                }
            }
            return this.compareByAbbreviation(r1, r2);
        }

        public static boolean isApplicable(RoomInterface.BuildingsColumn column) {
            switch (column) {
                case NAME: 
                case ABBREVIATION: 
                case EXTERNAL_ID: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compare(Building r1, Building r2) {
            int cmp = this.compareByColumn(r1, r2);
            if (cmp == 0) {
                cmp = this.compareByAbbreviation(r1, r2);
            }
            if (cmp == 0) {
                cmp = this.compareById(r1, r2);
            }
            return this.iAsc ? cmp : -cmp;
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }
    }
}

