/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.departments;

import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.DepartmentInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=DepartmentInterface.DepartmentPropertiesRequest.class)
public class DepartmentPropertiesBackend
implements GwtRpcImplementation<DepartmentInterface.DepartmentPropertiesRequest, DepartmentInterface.DepartmentPropertiesInterface> {
    public List<DepartmentInterface.StatusOption> getStatusOptions() {
        ArrayList<DepartmentInterface.StatusOption> ret = new ArrayList<DepartmentInterface.StatusOption>();
        for (DepartmentStatusType status : DepartmentStatusType.findAllForDepartment()) {
            ret.add(new DepartmentInterface.StatusOption(status.getUniqueId(), status.getReference(), status.getLabel()));
        }
        return ret;
    }

    public List<DepartmentInterface.DepartmentOption> getAllDependentDepartments(SessionContext context) {
        ArrayList<DepartmentInterface.DepartmentOption> ret = new ArrayList<DepartmentInterface.DepartmentOption>();
        for (Department d : Department.findAllNonExternal(context.getUser().getCurrentAcademicSessionId())) {
            ret.add(new DepartmentInterface.DepartmentOption(d.getUniqueId(), d.getLabel()));
        }
        return ret;
    }

    @Override
    public DepartmentInterface.DepartmentPropertiesInterface execute(DepartmentInterface.DepartmentPropertiesRequest request, SessionContext context) {
        DepartmentInterface.DepartmentPropertiesInterface d = new DepartmentInterface.DepartmentPropertiesInterface();
        d.setStatusOptions(this.getStatusOptions());
        d.setExtDepartmentOptions(this.getAllDependentDepartments(context));
        d.setAcademicSessionName(context.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel());
        d.setCoursesFundingDepartmentsEnabled(ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue());
        Department dept = null;
        if (request.getDepartmentId() != null) {
            dept = (Department)DepartmentDAO.getInstance().get(request.getDepartmentId());
        }
        if (dept != null) {
            d.setCanDelete(context.hasPermission(dept, Right.DepartmentDelete));
            d.setCanChangeExtManager(context.hasPermission(dept, Right.DepartmentEditChangeExternalManager));
            d.setCanEdit(context.hasPermission(dept, Right.DepartmentEdit));
        } else {
            d.setCanDelete(false);
            d.setCanChangeExtManager(true);
            d.setCanEdit(true);
        }
        return d;
    }
}

