/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.TableBuilder;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class ExaminationsTableBuilder
extends TableBuilder {
    protected static ExaminationMessages XMSG = Localization.create(ExaminationMessages.class);

    public ExaminationsTableBuilder(SessionContext context, String backType, String backId) {
        super(context, backType, backId);
    }

    protected TableInterface.CellInterface cellForPeriodPrefs(Exam exam, Set prefs) {
        if (exam.getExamType().getType() == 1) {
            MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType());
            epx.load(exam);
            TableInterface.CellInterface cell = epx.toCellInterface();
            if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
                cell.setMouseOver("$wnd.showGwtTimeHint($wnd.lastMouseOverElement,'" + exam.getUniqueId() + ",-1');");
                cell.setMouseOut("$wnd.hideGwtTimeHint();");
            } else {
                cell.setMouseOver("$wnd.showGwtExamPeriodPreferencesHint($wnd.lastMouseOverElement, '" + exam.getUniqueId() + "',null);");
                cell.setMouseOut("$wnd.hideGwtPeriodPreferencesHint();");
            }
            return cell;
        }
        if (this.getGridAsText()) {
            TableInterface.CellInterface cell = new TableInterface.CellInterface();
            for (Object o : prefs) {
                ExamPeriodPref tp = (ExamPeriodPref)o;
                cell.add(tp.preferenceAbbv()).setColor(PreferenceLevel.prolog2color(tp.getPrefLevel().getPrefProlog())).setTitle(tp.getPrefLevel().getPrefName() + " " + tp.preferenceText()).setNoWrap(true).setInline(false).setAria(tp.getPrefLevel().getAbbreviation() + " " + tp.preferenceText());
            }
            if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
                cell.setMouseOver("$wnd.showGwtTimeHint($wnd.lastMouseOverElement,'" + exam.getUniqueId() + ",-1');");
                cell.setMouseOut("$wnd.hideGwtTimeHint();");
            } else {
                cell.setMouseOver("$wnd.showGwtExamPeriodPreferencesHint($wnd.lastMouseOverElement, '" + exam.getUniqueId() + "',null);");
                cell.setMouseOut("$wnd.hideGwtPeriodPreferencesHint();");
            }
            return cell;
        }
        final PeriodPreferenceModel px = new PeriodPreferenceModel(exam.getSession(), exam.getExamType().getUniqueId());
        final boolean timeVertical = this.getTimeVertival();
        px.load(exam);
        TableInterface.CellInterface c = new TableInterface.CellInterface();
        c.setImage(new TableInterface.ImageInterface().setSource("pattern?v=" + (timeVertical ? 1 : 0) + "&x=" + exam.getUniqueId()).setAlt(px.toString()).setGenerator(new TableInterface.ImageGenerator(){

            @Override
            public Object generate() {
                return new RequiredTimeTable(px).createBufferedImage(timeVertical);
            }
        }));
        c.addStyle("display: inline-block;");
        c.setAria(px.toString().replace(", ", "\n"));
        if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
            c.setMouseOver("$wnd.showGwtTimeHint($wnd.lastMouseOverElement,'" + exam.getUniqueId() + ".-1');");
            c.setMouseOut("$wnd.hideGwtTimeHint();");
        } else {
            c.setMouseOver("$wnd.showGwtExamPeriodPreferencesHint($wnd.lastMouseOverElement, '" + exam.getUniqueId() + "',null);");
            c.setMouseOut("$wnd.hideGwtPeriodPreferencesHint();");
        }
        return c;
    }

    public TableInterface createExamsTable(String type, Long id, ExamSolverProxy solver) {
        if (!this.getSessionContext().hasPermission(Right.Examinations) && !this.getSessionContext().hasPermission(Right.ExaminationSchedule)) {
            return null;
        }
        List<Exam> exams = Exam.findAllRelated(type, id);
        Iterator<Exam> i = exams.iterator();
        while (i.hasNext()) {
            if (this.getSessionContext().hasPermission(i.next(), Right.ExaminationView)) continue;
            i.remove();
        }
        TableInterface ret = new TableInterface();
        ret.setName(exams.size() == 1 ? MSG.sectionTitleExamination() : MSG.sectionTitleExaminations());
        boolean hasBack = false;
        Long solverType = solver == null ? null : solver.getExamTypeId();
        boolean hasSolution = false;
        for (Exam exam : exams) {
            ExamAssignment assignment = null;
            if (exam.getExamType().getUniqueId().equals(solverType)) {
                assignment = solver.getAssignment(exam.getUniqueId());
            } else if (exam.getAssignedPeriod() != null) {
                assignment = new ExamAssignment(exam);
            }
            if (assignment == null || assignment.getPeriodId() == null) continue;
            hasSolution = true;
            break;
        }
        if (this.getSessionContext().hasPermission(Right.Examinations)) {
            if (hasSolution) {
                header = ret.addHeader();
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamClassesCourses());
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamType());
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamLength()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamSeatingType()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamSize()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamMaxRooms()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamInstructor());
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamAssignedPeriod());
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamAssignedRoom());
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamStudentConflicts());
            } else {
                header = ret.addHeader();
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamClassesCourses());
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamType());
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamLength()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamSeatingType()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamSize()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamMaxRooms()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamInstructor());
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamPeriodPreferences());
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamRoomPreferences());
                ((TableInterface.LineInterface)header).addCell(MSG.columnExamDistributionPreferences());
            }
            for (Exam exam : new TreeSet<Exam>(exams)) {
                boolean view = this.getSessionContext().hasPermission(exam, Right.ExaminationDetail);
                objects = new TableInterface.CellInterface();
                objects.setInline(false);
                instructors = new TableInterface.CellInterface();
                instructors.setInline(false);
                perPref = new TableInterface.CellInterface();
                perPref.setInline(false);
                roomPref = new TableInterface.CellInterface();
                roomPref.setInline(false);
                TableInterface.CellInterface distPref = new TableInterface.CellInterface();
                distPref.setInline(false);
                ExamAssignmentInfo assignment = null;
                if (exam.getExamType().getUniqueId().equals(solverType)) {
                    assignment = solver.getAssignmentInfo(exam.getUniqueId());
                } else if (exam.getAssignedPeriod() != null) {
                    assignment = new ExamAssignmentInfo(exam);
                }
                Iterator e = exam.getOwnerObjects().elements();
                while (e.hasMoreElements()) {
                    Object object = e.nextElement();
                    if (object instanceof Class_) {
                        objects.add(((Class_)object).getClassLabel()).setInline(false);
                        continue;
                    }
                    if (object instanceof InstrOfferingConfig) {
                        objects.add(((InstrOfferingConfig)object).toString()).setInline(false);
                        continue;
                    }
                    if (object instanceof InstructionalOffering) {
                        objects.add(((InstructionalOffering)object).getCourseName()).setInline(false);
                        continue;
                    }
                    if (object instanceof CourseOffering) {
                        objects.add(((CourseOffering)object).getCourseName()).setInline(false);
                        continue;
                    }
                    objects.add(object.toString()).setInline(false);
                }
                if (!hasSolution || assignment == null || assignment.getPeriodId() == null) {
                    for (Object pref : exam.effectivePreferences(RoomPref.class)) {
                        roomPref.addItem(this.preferenceCell((Preference)pref));
                    }
                    for (Object pref : exam.effectivePreferences(BuildingPref.class)) {
                        roomPref.addItem(this.preferenceCell((Preference)pref));
                    }
                    for (Object pref : exam.effectivePreferences(RoomFeaturePref.class)) {
                        roomPref.addItem(this.preferenceCell((Preference)pref));
                    }
                    for (Object pref : exam.effectivePreferences(RoomGroupPref.class)) {
                        roomPref.addItem(this.preferenceCell((Preference)pref));
                    }
                    perPref.addItem(this.cellForPeriodPrefs(exam, exam.effectivePreferences(ExamPeriodPref.class)));
                    if (!hasSolution) {
                        for (Object pref : exam.effectivePreferences(DistributionPref.class)) {
                            distPref.addItem(this.preferenceCell((DistributionPref)pref));
                        }
                    } else {
                        distPref.add(MSG.notAssigned()).addStyle("font-style: italic;");
                    }
                } else {
                    if (view && assignment.getPeriodPref() != null) {
                        TableInterface.CellInterface cell = perPref.add(assignment.getPeriodAbbreviation()).setColor(PreferenceLevel.prolog2color(assignment.getPeriodPref()));
                        if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
                            cell.setMouseOver("$wnd.showGwtTimeHint($wnd.lastMouseOverElement,'" + exam.getUniqueId() + "," + assignment.getPeriodId() + "');");
                            cell.setMouseOut("$wnd.hideGwtTimeHint();");
                        } else {
                            cell.setMouseOver("$wnd.showGwtExamPeriodPreferencesHint($wnd.lastMouseOverElement, '" + exam.getUniqueId() + "','" + assignment.getPeriodId() + "');");
                            cell.setMouseOut("$wnd.hideGwtPeriodPreferencesHint();");
                        }
                    } else {
                        perPref.add(assignment.getPeriodAbbreviation());
                    }
                    if (assignment.getRooms() != null) {
                        for (ExamRoomInfo room : assignment.getRooms()) {
                            TableInterface.CellInterface cell = roomPref.add(room.getName());
                            cell.setInline(false);
                            if (!view) continue;
                            cell.setColor(PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(room.getPreference())));
                            cell.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + room.getLocationId() + "', '" + PreferenceLevel.int2string(room.getPreference()) + "');");
                            cell.setMouseOut("$wnd.hideGwtRoomHint();");
                        }
                    }
                    if (view) {
                        int dc = assignment.getNrDirectConflicts();
                        distPref.setInline(false);
                        if (dc <= 0) {
                            distPref.add("0").setColor("808080");
                        } else {
                            distPref.add(String.valueOf(dc)).setColor(PreferenceLevel.prolog2color("P"));
                        }
                        distPref.add(", ");
                        int m2d = assignment.getNrMoreThanTwoConflicts();
                        if (m2d <= 0) {
                            distPref.add("0").setColor("808080");
                        } else {
                            distPref.add(String.valueOf(m2d)).setColor(PreferenceLevel.prolog2color("2"));
                        }
                        distPref.add(", ");
                        int btb = assignment.getNrBackToBackConflicts();
                        int dbtb = assignment.getNrDistanceBackToBackConflicts();
                        if (btb <= 0 && dbtb <= 0) {
                            distPref.add("0").setColor("808080");
                        } else {
                            distPref.add(btb + (String)(dbtb > 0 ? " (d:" + dbtb + ")" : "")).setColor(PreferenceLevel.prolog2color("1"));
                        }
                    } else {
                        distPref.add(MSG.notApplicable()).addStyle("font-style: italic;");
                    }
                }
                for (DepartmentalInstructor instructor : new TreeSet<DepartmentalInstructor>(exam.getInstructors())) {
                    instructors.add(instructor.getName(this.getInstructorNameFormat())).setInline(false);
                }
                int nrStudents = exam.getSize();
                if (exam.getUniqueId().toString().equals(this.getBackId())) {
                    hasBack = true;
                    objects.addAnchor("back");
                }
                TableInterface.LineInterface line = ret.addLine();
                line.setURL("examDetail.action?examId=" + exam.getUniqueId());
                line.addCell(objects);
                line.addCell(exam.getExamType().getLabel());
                line.addCell(exam.getLength().toString()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                line.addCell(0 == exam.getSeatingType() ? MSG.examSeatingTypeNormal() : MSG.examSeatingTypeExam()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                line.addCell(String.valueOf(nrStudents)).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                line.addCell(exam.getMaxNbrRooms().toString()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                line.addCell(instructors);
                line.addCell(perPref);
                line.addCell(roomPref);
                line.addCell(distPref);
            }
        } else {
            if (!hasSolution) {
                return null;
            }
            header = ret.addHeader();
            ((TableInterface.LineInterface)header).addCell(MSG.columnExamClassesCourses());
            ((TableInterface.LineInterface)header).addCell(MSG.columnExamType());
            ((TableInterface.LineInterface)header).addCell(MSG.columnExamInstructor());
            ((TableInterface.LineInterface)header).addCell(MSG.columnExamPeriodPreferences());
            ((TableInterface.LineInterface)header).addCell(MSG.columnExamRoomPreferences());
            for (Exam exam : new TreeSet<Exam>(exams)) {
                objects = new TableInterface.CellInterface();
                objects.setInline(false);
                instructors = new TableInterface.CellInterface();
                instructors.setInline(false);
                perPref = new TableInterface.CellInterface();
                perPref.setInline(false);
                roomPref = new TableInterface.CellInterface();
                roomPref.setInline(false);
                ExamAssignmentInfo assignment = null;
                if (exam.getExamType().getUniqueId().equals(solverType)) {
                    assignment = solver.getAssignmentInfo(exam.getUniqueId());
                } else if (exam.getAssignedPeriod() != null) {
                    assignment = new ExamAssignmentInfo(exam);
                }
                Iterator<DepartmentalInstructor> e = exam.getOwnerObjects().elements();
                while (e.hasMoreElements()) {
                    Object object = e.nextElement();
                    if (object instanceof Class_) {
                        objects.add(((Class_)object).getClassLabel()).setInline(false);
                        continue;
                    }
                    if (object instanceof InstrOfferingConfig) {
                        objects.add(((InstrOfferingConfig)object).toString()).setInline(false);
                        continue;
                    }
                    if (object instanceof InstructionalOffering) {
                        objects.add(((InstructionalOffering)object).getCourseName()).setInline(false);
                        continue;
                    }
                    if (object instanceof CourseOffering) {
                        objects.add(((CourseOffering)object).getCourseName()).setInline(false);
                        continue;
                    }
                    objects.add(object.toString()).setInline(false);
                }
                if (assignment == null || assignment.getPeriodId() == null) continue;
                perPref.add(assignment.getPeriodName());
                if (assignment.getRooms() != null) {
                    for (ExamRoomInfo room : assignment.getRooms()) {
                        roomPref.add(room.getName());
                    }
                }
                for (DepartmentalInstructor instructor : new TreeSet<DepartmentalInstructor>(exam.getInstructors())) {
                    instructors.add(instructor.getName(this.getInstructorNameFormat())).setInline(false);
                }
                if (exam.getUniqueId().toString().equals(this.getBackId())) {
                    hasBack = true;
                    objects.addAnchor("back");
                }
                TableInterface.LineInterface line = ret.addLine();
                line.addCell(objects);
                line.addCell(exam.getExamType().getLabel());
                line.addCell(instructors);
                line.addCell(perPref);
                line.addCell(roomPref);
            }
        }
        if (!hasBack && "Exam".equals(this.getBackType())) {
            ret.addHeader().getCells().get(0).addAnchor("back");
        }
        for (TableInterface.LineInterface lineInterface : ret.getHeader()) {
            for (TableInterface.CellInterface cell : lineInterface.getCells()) {
                cell.setClassName("WebTableHeader");
                cell.setText(cell.getText().replace("<br>", "\n"));
                cell.addStyle("white-space: pre-wrap;");
            }
        }
        return ret;
    }

    public TableInterface generateTableForExams(ExamType examType, ExamAssignmentProxy examAssignment, TableInterface.FilterInterface filter, String[] subjectAreaIds) {
        String courseNbr = filter.getParameterValue("courseNbr");
        courseNbr = courseNbr == null || courseNbr.isEmpty() ? "%" : courseNbr.replace('*', '%');
        List exams = null;
        exams = subjectAreaIds.length > 0 && "-1".equals(subjectAreaIds[0]) ? ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o where x.session.uniqueId = :sessionId and x.examType.uniqueId = :examTypeId and o.course.courseNbr like :courseNbr", Exam.class).setParameter("sessionId", (Object)this.getSessionContext().getUser().getCurrentAcademicSessionId()).setParameter("examTypeId", (Object)examType.getUniqueId()).setParameter("courseNbr", (Object)courseNbr).setCacheable(true).list() : ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o where cast(o.course.subjectArea.uniqueId as string) in :subjectAreaIds and x.examType.uniqueId = :examTypeId and o.course.courseNbr like :courseNbr", Exam.class).setParameterList("subjectAreaIds", (Object[])subjectAreaIds).setParameter("examTypeId", (Object)examType.getUniqueId()).setParameter("courseNbr", (Object)courseNbr).setCacheable(true).list();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            if (this.getSessionContext().hasPermission(i.next(), Right.ExaminationView)) continue;
            i.remove();
        }
        TableInterface ret = new TableInterface();
        ret.setName(XMSG.tableExaminations(examType.getLabel()));
        ret.setId("Exams");
        Long solverType = examAssignment == null ? null : examAssignment.getExamTypeId();
        boolean hasBack = false;
        TableInterface.LineInterface header = ret.addHeader();
        header.addCell(MSG.columnExamClassesCourses());
        header.addCell(MSG.columnExamLength()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        header.addCell(MSG.columnExamSeatingType()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
        header.addCell(MSG.columnExamSize()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        header.addCell(MSG.columnExamMaxRooms()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        header.addCell(MSG.columnExamInstructor());
        header.addCell(MSG.columnExamPeriodPreferences());
        header.addCell(MSG.columnExamRoomPreferences());
        header.addCell(MSG.columnExamDistributionPreferences());
        header.addCell(MSG.columnExamAssignedPeriod());
        header.addCell(MSG.columnExamAssignedRoom());
        ArrayList<Long> examIds = new ArrayList<Long>();
        for (Exam exam : new TreeSet(exams)) {
            boolean view = this.getSessionContext().hasPermission(exam, Right.ExaminationDetail);
            TableInterface.CellInterface objects = new TableInterface.CellInterface();
            objects.setInline(false);
            TableInterface.CellInterface instructors = new TableInterface.CellInterface();
            instructors.setInline(false);
            TableInterface.CellInterface perPref = new TableInterface.CellInterface();
            perPref.setInline(false);
            TableInterface.CellInterface roomPref = new TableInterface.CellInterface();
            roomPref.setInline(false);
            TableInterface.CellInterface distPref = new TableInterface.CellInterface();
            distPref.setInline(false);
            TableInterface.CellInterface assPer = new TableInterface.CellInterface();
            assPer.setInline(false);
            TableInterface.CellInterface assRoom = new TableInterface.CellInterface();
            assRoom.setInline(false);
            ExamAssignment assignment = null;
            if (exam.getExamType().getUniqueId().equals(solverType)) {
                assignment = examAssignment.getAssignment(exam.getUniqueId());
            } else if (exam.getAssignedPeriod() != null) {
                assignment = new ExamAssignment(exam);
            }
            Iterator e = exam.getOwnerObjects().elements();
            while (e.hasMoreElements()) {
                Object object = e.nextElement();
                if (object instanceof Class_) {
                    objects.add(((Class_)object).getClassLabel()).setInline(false);
                    continue;
                }
                if (object instanceof InstrOfferingConfig) {
                    objects.add(((InstrOfferingConfig)object).toString()).setInline(false);
                    continue;
                }
                if (object instanceof InstructionalOffering) {
                    objects.add(((InstructionalOffering)object).getCourseName()).setInline(false);
                    continue;
                }
                if (object instanceof CourseOffering) {
                    objects.add(((CourseOffering)object).getCourseName()).setInline(false);
                    continue;
                }
                objects.add(object.toString()).setInline(false);
            }
            for (Object pref : exam.effectivePreferences(RoomPref.class)) {
                roomPref.addItem(this.preferenceCell((Preference)pref));
            }
            for (Object pref : exam.effectivePreferences(BuildingPref.class)) {
                roomPref.addItem(this.preferenceCell((Preference)pref));
            }
            for (Object pref : exam.effectivePreferences(RoomFeaturePref.class)) {
                roomPref.addItem(this.preferenceCell((Preference)pref));
            }
            for (Object pref : exam.effectivePreferences(RoomGroupPref.class)) {
                roomPref.addItem(this.preferenceCell((Preference)pref));
            }
            perPref.addItem(this.cellForPeriodPrefs(exam, exam.effectivePreferences(ExamPeriodPref.class)));
            for (Object pref : exam.effectivePreferences(DistributionPref.class)) {
                distPref.addItem(this.preferenceCell((DistributionPref)pref));
            }
            if (assignment != null) {
                if (assignment.getPeriodPref() != null) {
                    Iterator<ExamRoomInfo> cell = assPer.add(assignment.getPeriodAbbreviation()).setColor(PreferenceLevel.prolog2color(assignment.getPeriodPref()));
                    if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
                        ((TableInterface.CellInterface)((Object)cell)).setMouseOver("$wnd.showGwtTimeHint($wnd.lastMouseOverElement,'" + exam.getUniqueId() + "," + assignment.getPeriodId() + "');");
                        ((TableInterface.CellInterface)((Object)cell)).setMouseOut("$wnd.hideGwtTimeHint();");
                    } else {
                        ((TableInterface.CellInterface)((Object)cell)).setMouseOver("$wnd.showGwtExamPeriodPreferencesHint($wnd.lastMouseOverElement, '" + exam.getUniqueId() + "','" + assignment.getPeriodId() + "');");
                        ((TableInterface.CellInterface)((Object)cell)).setMouseOut("$wnd.hideGwtPeriodPreferencesHint();");
                    }
                } else {
                    assPer.add(assignment.getPeriodAbbreviation());
                }
                assPer.setComparable(assignment.getPeriod().getStartTime());
                if (assignment.getRooms() != null) {
                    for (ExamRoomInfo room : assignment.getRooms()) {
                        TableInterface.CellInterface cell = assRoom.add(room.getName());
                        cell.setInline(false);
                        cell.setColor(PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(room.getPreference())));
                        cell.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + room.getLocationId() + "', '" + PreferenceLevel.int2string(room.getPreference()) + "');");
                        cell.setMouseOut("$wnd.hideGwtRoomHint();");
                    }
                }
                assRoom.setComparable((Comparable<?>)((Object)assRoom.toString()));
            } else {
                assPer.setComparable(new Date(0L));
                assRoom.setComparable((Comparable<?>)((Object)""));
            }
            for (DepartmentalInstructor instructor : new TreeSet<DepartmentalInstructor>(exam.getInstructors())) {
                instructors.add(instructor.getName(this.getInstructorNameFormat())).setInline(false);
            }
            int nrStudents = exam.getSize();
            if (exam.getUniqueId().toString().equals(this.getBackId())) {
                hasBack = true;
                objects.addAnchor("back");
            }
            TableInterface.LineInterface line = ret.addLine();
            if (view) {
                line.setURL("examDetail.action?examId=" + exam.getUniqueId());
            }
            line.addCell(objects);
            line.addCell(exam.getLength().toString()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setComparable(exam.getLength());
            line.addCell(0 == exam.getSeatingType() ? MSG.examSeatingTypeNormal() : MSG.examSeatingTypeExam()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER).setComparable(exam.getSeatingType());
            line.addCell(String.valueOf(nrStudents)).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setComparable(Integer.valueOf(nrStudents));
            line.addCell(exam.getMaxNbrRooms().toString()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setComparable(exam.getMaxNbrRooms());
            line.addCell(instructors);
            line.addCell(perPref);
            line.addCell(roomPref);
            line.addCell(distPref);
            line.addCell(assPer);
            line.addCell(assRoom);
            examIds.add(exam.getUniqueId());
            line.setId(exam.getUniqueId());
        }
        if (!this.isSimple()) {
            Navigation.set(this.getSessionContext(), Navigation.sInstructionalOfferingLevel, examIds);
            ret.setNavigationLevel(Navigation.sInstructionalOfferingLevel);
        }
        if (!hasBack && "Exam".equals(this.getBackType())) {
            ret.addHeader().getCells().get(0).addAnchor("back");
        }
        for (TableInterface.CellInterface cell : header.getCells()) {
            cell.setClassName("WebTableHeader");
            cell.setText(cell.getText().replace("<br>", "\n"));
            cell.addStyle("white-space: pre-wrap;");
            cell.setSortable(true);
        }
        return ret;
    }
}

